/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			C.alpha/src/asm.ph
 > Purpose:			Include file for .s files
 > Author:			John Gibson, Sep 20 1994
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'registers.ph'

define :inline lconstant REGNAME(reg=item);
	REG_PREFIX sys_>< reg
enddefine;

define :inline lconstant FREGNAME(freg=item);
	FREG_PREFIX sys_>< freg
enddefine;

define :inline lconstant FIELD_lb(_offs);
	lblock
		lvars (b, l) = _pint(_offs) // 4;
		_int(l<<2), _int(b)
	endlblock
enddefine;

#_IF WORD_BITS==DOUBLE_BITS
lconstant macro (WORD_SUFFIX = 'q', \.WORD = '.quad');
#_ELSE
lconstant macro (WORD_SUFFIX = 'l', \.WORD = '.long');
#_ENDIF

#_IF DEF IEEE_FLOAT
lconstant macro (SFLOAT_SUFFIX = 's', DFLOAT_SUFFIX = 't');
#_ELSE
lconstant macro (SFLOAT_SUFFIX = 'f', DFLOAT_SUFFIX = 'g');
#_ENDIF


lconstant macro (
	rt0		= REGNAME(RGt0),
	rt1		= REGNAME(RGt1),
	rt2		= REGNAME(RGt2),
	rt3		= REGNAME(RGt3),
	rt4		= REGNAME(RGt4),
	rt5		= REGNAME(RGt5),
	rt6		= REGNAME(RGt6),

	rpl0	= REGNAME(RGpl0),
	rpl1	= REGNAME(RGpl1),
	rpl2	= REGNAME(RGpl2),
	rpl3	= REGNAME(RGpl3),
	rpl4	= REGNAME(RGpl4),
	rpl5	= REGNAME(RGpl5),
	rpl6	= REGNAME(RGpl6),
	rpl7	= REGNAME(RGpl7),
	rpl8	= REGNAME(RGpl8),
	rpl9	= REGNAME(RGpl9),
	rpl10	= REGNAME(RGpl10),

	rnpl0	= REGNAME(RGnpl0),
	rnpl1	= REGNAME(RGnpl1),
	rnpl2	= REGNAME(RGnpl2),
	rnpl3	= REGNAME(RGnpl3),
	rnpl4	= REGNAME(RGnpl4),

	rfalse	= REGNAME(RGfalse),
	rsvb	= REGNAME(RGsvb),
	rusp	= REGNAME(RGusp),
	rchain	= REGNAME(RGchain),
	rret	= REGNAME(RGret),
	rpb		= REGNAME(RGpb),
	rfp		= REGNAME(RGfp),
	rsp		= REGNAME(RGsp),
	rzero	= REGNAME(RGzero),

	ra0		= REGNAME(16),		;;; first 6 args to external calls
	ra1		= REGNAME(17),
	ra2		= REGNAME(18),
	ra3		= REGNAME(19),
	ra4		= REGNAME(20),
	ra5		= REGNAME(21),

	ft0		= FREGNAME(0),
	ft1		= FREGNAME(1),
	fzero	= FREGNAME(31),

	fa0		= FREGNAME(16),		;;; first 6 args to external calls
	fa1		= FREGNAME(17),
	fa2		= FREGNAME(18),
	fa3		= FREGNAME(19),
	fa4		= FREGNAME(20),
	fa5		= FREGNAME(21),

	_WOFFS			= @@(w)++,
	_TRUEOFFS		= @@(struct BOOLEAN)++,

	_KEY			= @@KEY,
	_K_APPLY		= @@K_APPLY,
	_RF_CONT		= @@RF_CONT,
	_PD_EXECUTE		= @@PD_EXECUTE,
	_PD_EXIT		= @@PD_EXIT,
	_PD_UPDATER		= @@PD_UPDATER,
	_P_BACK			= @@P_BACK,
	_P_FRONT		= @@P_FRONT,
	_SF_OWNER		= @@SF_OWNER,
	_SF_RETURN_ADDR	= @@SF_RETURN_ADDR,
	_V_BYTES		= @@V_BYTES,

	(_PD_FRAME_LEN_l, _PD_FRAME_LEN_b)
					= FIELD_lb(@@PD_FRAME_LEN),

	_svb_FALSE			= [_SVB_OFFS(false)(rsvb)],
	_svb_SAVED_SP		= [_SVB_OFFS(Sys$-Extern$- _saved_sp)(rsvb)],
	_svb_SAVED_USP		= [_SVB_OFFS(Sys$-Extern$- _saved_usp)(rsvb)],
	_svb_INVOC_FP		= [_SVB_OFFS(Sys$-Extern$- _invocation_fp)(rsvb)],
	_svb_IN_USER_EXTERN	= [_SVB_OFFS(Sys$- _in_user_extern)(rsvb)],

	ldW		= 'ld'  <> WORD_SUFFIX,
	stW		= 'st'  <> WORD_SUFFIX,
	sWaddq	= 's' <> _WOFFS <> 'addq',
	sWaddW	= 's' <> _WOFFS <> 'add' <> WORD_SUFFIX,

	ldSF	= 'ld' <> SFLOAT_SUFFIX,
	ldDF	= 'ld' <> DFLOAT_SUFFIX,
	stSF	= 'st' <> SFLOAT_SUFFIX,
	stDF	= 'st' <> DFLOAT_SUFFIX,
	cvtDFSF	= 'cvt' <> DFLOAT_SUFFIX <> SFLOAT_SUFFIX,
);

define lconstant macro INIT_POP_REGISTERS;
	lvars n;
	for n from 0 to 10 do
		[\t	mov \t	rfalse, %consword('rpl'><n)% \n ].dl
	endfor
enddefine;


#_IF DEF VMS

define lconstant macro ASM_START_FILE;
	'\t.title\t', sys_fname_nam(popfilename), '.o'	;;; must be the object file name
enddefine;

lconstant macro (
	ASM_END_FILE	= '\t.end',
	ASM_ALIGN_QUAD	= '\t.align\tquad',
);

	;;; Local labels
define lconstant macro !$ ;
	lvars num = readitem();
	if isalphacode(num(datalength(num))) then
		allbutlast(1, num) -> num		;;; remove `b` or `f`
	endif;
	num sys_>< '$'
enddefine;

#_ELSE

lconstant macro (
	ASM_START_FILE	= '\t.set noreorder; .set nomacro; .set noat; .set nomove',
	;;; dummy C procedure to stop the execrable linker warning message about
	;;; linking some objects with no exception information sections
	ASM_END_FILE	= #_IF DEF LINUX [] #_ELSE ['\t.text; .align 3\n'
					   '\t.ent $$dummy; $$dummy: .frame $sp,0,$26,0; .prologue 0;\n'
					   '\tret $31,($26),1; .end\n'] #_ENDIF,
	ASM_ALIGN_QUAD	= '\t.align\t3',
);

	;;; Local labels
define lconstant macro !$ ; readitem(); enddefine;


#_ENDIF
