/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.alpha/src/closure_cons.p
 > Purpose:         Constructing closures (Alpha version)
 > Author:          John Gibson, Aug 18 1994
 > Documentation:	REF *PROCEDURE
 > Related Files:   C.alpha/src/ass.p
 */

#_INCLUDE 'declare.ph'
#_INCLUDE 'drop_code.ph'

constant
		procedure (Sys$-Exec_closure)
	;


;;; ---------------------------------------------------------------------

section $-Sys$-Vm;

	/*	Construct a raw closure for _______nfroz frozvals
	*/
define $-Sys$-Cons_closure(_nfroz) -> _clos;
	lvars _clos, _drop_ptr, _size, _nfroz, _offs, _disp;

	;;; macro for dropping instructions
	lconstant macro _CODE = [_drop_ptr!(code)++ -> _drop_ptr];

	;;; calculate length of code to be planted in instructions
	if _nfroz _gr _16 then
		_6
	elseif _zero(_nfroz) then
		_3
	else
		_nfroz _mult _2 _add _4
	endif -> _size;

	;;; add header size and frozval size to get total
	@@PD_CLOS_FROZVALS[_nfroz] _add @@(w)[_size | code.r] _sub @@POPBASE
										-> _size;
	Get_store(_size) -> _clos;
	##(w){_size} ->> _size -> _clos!PD_LENGTH;
	unless _clos!PD_LENGTH == _size then
		_clos -> Get_store();		;;; junk it
		mishap(0, 'CLOSURE EXCEEDS MAXIMUM ALLOWABLE SIZE')
	endunless;

	;;; plant code
	_clos@PD_CLOS_FROZVALS[_nfroz] ->> _drop_ptr -> _clos!PD_EXECUTE;

	_0 -> _offs;
	if _nfroz _gr _16 then
		;;; just give closure address to Exec_closure (3 instrs)
		--@@(w) -> _offs;
		_MEMf_INST(_OP_stW, _:RGpb, _offs, _:RGusp)					-> _CODE;
		$-Sys$-Exec_closure _sub false -> _disp;
		if _disp _bitst _2:1e15 then _disp _add _2:1e16 -> _disp endif;
		_MEMf_INST(_OP_ldah, _:RGpb, _shift(_disp, _-16), _:RGfalse)-> _CODE;
		_MEMf_INST(_OP_lda, _:RGpb, _disp, _:RGpb)					-> _CODE

	elseif _zero(_nfroz) then
		_MEMf_INST(_OP_ldW, _:RGpb, @@PD_CLOS_PDPART, _:RGpb)		-> _CODE

	else
		;;; plant code to push them onto the stack (_nfroz*2 + 1 instrs)
		repeat
			_MEMf_INST(_OP_ldW, _:RGt0, @@PD_CLOS_FROZVALS-{_offs}, _:RGpb)
																	-> _CODE;
			--@@(w){_offs} -> _offs;
			if _nfroz == _1 then
				_MEMf_INST(_OP_ldW, _:RGpb, @@PD_CLOS_PDPART, _:RGpb) -> _CODE;
				_MEMf_INST(_OP_stW, _:RGt0, _offs, _:RGusp)			-> _CODE;
				quitloop
			endif;

			_MEMf_INST(_OP_ldW, _:RGt1, @@PD_CLOS_FROZVALS-{_offs}, _:RGpb)
																	-> _CODE;
			if _nfroz == _2 then
				_MEMf_INST(_OP_ldW, _:RGpb, @@PD_CLOS_PDPART, _:RGpb) -> _CODE;
			endif;
			_MEMf_INST(_OP_stW, _:RGt0, _offs, _:RGusp)				-> _CODE;
			--@@(w){_offs} -> _offs;
			_MEMf_INST(_OP_stW, _:RGt1, _offs, _:RGusp) 			-> _CODE;
			quitif(_zero(_nfroz _sub _2 ->> _nfroz))
		endrepeat
	endif;

	;;; enter procedure in RGpb (after decrementing stack) (3 instrs)
	_MEMf_INST(_OP_ldW, _:RGt0, @@PD_EXECUTE, _:RGpb)				-> _CODE;
	unless _zero(_offs) then
		_MEMf_INST(_OP_lda, _:RGusp, _offs, _:RGusp)				-> _CODE;
	endunless;
	_MEMf_JMP_INST(_HINT_jmp, _:RGzero, _:RGt0)						-> _CODE
enddefine;

endsection;		/* $-Sys$-Vm */
