/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:			S.axposf/src/registers.ph
 > Purpose:			Logical names for Alpha registers (OSF1)
 > Author:			John Gibson, Feb  8 1995
 */

lconstant macro (
	REG_PREFIX	= '$',
	FREG_PREFIX	= '$f',

	RGt0		= 0,		;;; temp 0
	RGt1		= 1,		;;; temp 1

	RGnpl0		= 2,		;;; nonpop locals 0 - 1 (not OSF locals)
	RGnpl1		= 3,

	RGpl0		= 4,		;;; pop locals 0 - 4  (not OSF locals)
	RGpl1		= 5,
	RGpl2		= 6,
	RGpl3		= 7,
	RGpl4		= 8,

	RGpl5		= 9,		;;; pop locals 5 - 10  (OSF locals too)
	RGpl6		= 10,
	RGpl7		= 11,
	RGpl8		= 12,
	RGpl9		= 13,
	RGpl10		= 14,

	RGfp		= 15,		;;; system frame pointer

	RGt3		= 16,		;;; temp 3 - 6
	RGt4		= 17,
	RGt5		= 18,
	RGt6		= 19,

	RGnpl3		= 20,		;;; nonpop locals 3 - 4 (not OSF locals)
	RGnpl4		= 21,

	RGfalse		= 22,		;;; <false>
	RGsvb		= 23,		;;; special var block pointer
	RGusp		= 24,		;;; user stack pointer
	RGchain		= 25,		;;; chain_reg / temp 7
	RGret		= 26,		;;; return address / temp 8
	RGpb		= 27,		;;; procedure base
	RGt2		= 28,		;;; temp 2
	RGnpl2		= 29,		;;; nonpop local 2 (OSF gp)
	RGsp		= 30,		;;; system stack pointer
	RGzero		= 31,		;;; zero / sink
);
