/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			S.vaxunix4.2/src/syscomp/asmout.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 */


/* -------------------------------------------------------------------------

				  OUTPUT CODE PROCEDURES
				(VAX/BERKELEY UNIX & ALPHA OSF1)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas;

constant macro $-WORD_SHIFT = integer_length(WORD_OFFS)-1;

	;;; popints are shifted left to accord with word scaling
define popint(n); lvars n; (n<<WORD_SHIFT) || 2:11 enddefine;
define mcint(n); lvars n; n >> WORD_SHIFT enddefine;


vars	nextlabel;

define nextlab();
	dlocal pop_pr_radix = 36;
	'L' >< nextlabel;
	nextlabel fi_+ 1 -> nextlabel
enddefine;

define lconstant asm_label(word, prefix_char);
	lvars n, len, string, q, r, prefix_char, word;
	lconstant SEP_CHAR = `.`;
	if isstring(word) then word else fast_word_string(word) endif -> string;
	datalength(string) -> len;
	cons_with consstring {%
		prefix_char, SEP_CHAR;
		fast_for n to len do
			go_on dup(fast_subscrs(n, string)) to
			;;; 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6
				c c c c c c c c c c c c c c c c		;;; Ctrl-A -- Ctrl-P
				c c c c c c c c c c c c c c c c		;;; Ctrl-Q -- SPACE
				s s s $ s s s s s s s s s s s d		;;;   !    --   0
				d d d d d d d d d s s s s s s s		;;;   1    --   @
				A A A A A A A A A A A A A A A A		;;;   A    --   P
				A A A A A A A A A A s s s s u s		;;;   Q    --   `
				a a a a a a a a a a a a a a a a		;;;   a    --   p
				a a a a a a a a a a s s s s c c		;;;   q    -- \(128)
			else c;

			A: a: d: u :		;;; alpha, digit, underscore
				nextloop;

			$ :
				if n /== len and fast_subscrs(n fi_+ 1, string) == `-`
				and (n /== 1 or len fi_> 2) then
					;;; replace section separator $- with SEP_CHAR
					-> ;			;;; erase $
					unless n == 1 then SEP_CHAR endunless;
					n fi_+ 1 -> n;	;;; skip -
					nextloop
				;;; else drop thru to "s"
				endif;

			s: c:				;;; other sign, control etc
				;;; represent as 3 decimal digits
				() fi_// 100 -> q -> r;
				q fi_+ `0`;
				r fi_// 10 -> q -> r;
				q fi_+ `0`, r fi_+ `0`;

		endfast_for
	%}
enddefine;

constant procedure (
	asm_symlabel	= asm_label(%`c`%),
	asm_identlabel	= asm_label(%`i`%),
	asm_wordlabel	= asm_label(%`w`%),
	asm_wordidlabel	= asm_label(%`z`%),
	asm_pdpropslabel= asm_label(%`p`%),
	asm_testdeflabel= asm_label(%`t`%),
	);


	;;; list of pop symbol prefixes for use by -Extern_make_base-
	;;; see unixextern.p
constant macro (
	$- POP_SYMBOL_PREFIXES =
		[['c.' 'xc.' 'uc.' 'xuc.' 'i.' 'w.' 'z.' 'p.' 't.' '_end\^@']],

	$- ASM_TEXT_STR		= '\t.text',
	$- ASM_DATA_STR		= '\t.data',
	$- ASM_BYTE_STR		= '\t.byte\t',
	$- ASM_SHORT_STR	= '\t.word\t',
	$- ASM_INT_STR		= '\t.long\t',
	$- ASM_DOUBLE_STR	= '\t.quad\t',

	$- ASM_WORD_STR = #_IF WORD_BITS == DOUBLE_BITS ASM_DOUBLE_STR
					  #_ELSE						ASM_INT_STR
					  #_ENDIF
	);

#_IF DEF ALPHA

constant macro (
	$- ASM_CODE_PSECT	= '\t.text\n',
	$- ASM_NWRIT_PSECT	= #_IF DEF LINUX '\t.section .rodata\n' #_ELSE '\t.rdata\n' #_ENDIF,
	$- ASM_DATA_PSECT	= '\t.data\n',
	);

	define lconstant has_instructions =
		newproperty([], 4, false, "tmparg")
	enddefine;

  #_IF DEF POPC
	vars 	current_asm_segment, asm_seg_offsets,
			procedure (asm_label_offsets, pdr_literal_label);

	define asm_label_diff(lab1, lab2);
		lvars lab1, lab2, offs1, offs2, diff;
			(asm_label_offsets(lab1) ->> offs1)
		and (asm_label_offsets(lab2) ->> offs2)
		and (offs1 - offs2 ->> diff) && 3 == 0		;;; i.e same aeg
		and diff >> 2
	enddefine;
  #_ENDIF

#_ELSE

constant macro (
	$- ASM_NWRIT_PSECT	= '\t.text\n',
	$- ASM_DATA_PSECT	= '\t.data\n',
	);

vars file_total_bytecount;

#_ENDIF


define asm_startfile(a_name);
	lvars a_name;
#_IF DEF ALPHA
	asmf_printf('\t.ugen; .set noreorder; .set nomacro; .set noat; .set nomove\n');
	false -> has_instructions(asmf_charout);
  #_IF DEF POPC
	{% 0, 0, 0 %} -> asm_seg_offsets;
	newproperty([], 64, false, "perm") -> asm_label_offsets;
	newmapping([], 32, false, false) -> pdr_literal_label;
  #_ENDIF
#_ELSEIF DEF POPC
	0 -> file_total_bytecount;
#_ENDIF
enddefine;

define asm_endfile();
#_IF DEF ALPHA and not(DEF LINUX)
	returnunless(has_instructions(asmf_charout));
	;;; dummy C procedure to stop the execrable linker warning message about
	;;; linking some objects with no exception information sections
	asmf_printf('\t.text; .ent $$dummy; $$dummy: .frame $sp,0,$26,0; .prologue 0;\n');
	asmf_printf('\tret $31,($26),1; .end\n');
#_ENDIF
enddefine;

define asm_startcode = outcode(%'\n'<>ASM_NWRIT_PSECT%) enddefine;
define asm_startdata = outcode(%'\n'<>ASM_DATA_PSECT%) enddefine;
#_IF DEF ALPHA
define asm_startinstr();
	outcode(#_< '\n'<>ASM_CODE_PSECT >_#);
	true -> has_instructions(asmf_charout);
enddefine;
#_ENDIF


define lconstant output_lab(lab, globl);
	lvars lab, globl;
	if globl then
		asmf_charout('.globl '), asmf_charout(lab), asmf_charout(`\n`)
	endif;
	asmf_charout(lab), asmf_charout(`:`), asmf_charout(`\n`);

#_IF DEF POPC and DEF ALPHA
	returnunless(current_asm_segment);		;;; i.e. if doing .s file
	(subscrv(current_asm_segment,asm_seg_offsets) << 2) || current_asm_segment
				-> asm_label_offsets(lab)
#_ENDIF
enddefine;
;;;
define asm_outlab  = output_lab(% false %) enddefine;
define asm_outglab = output_lab(% true %) enddefine;

define lconstant pr_item(item);
	lvars item, tmp;
#_IF DEF ALPHA
	if isstring(item) and datalength(item) fi_> 18
	and isnumbercode(fast_subscrs(1,item)) and (strnumber(item) ->> tmp)
	then
		tmp -> item
	endif;
	if isbiginteger(item) and integer_length(item)==64 then
		dlocal pop_pr_radix = 16;
		asmf_printf(item, '0x%p');
	else
		asmf_pr(item)
	endif;
#_ELSE
	asmf_pr(item)
#_ENDIF
enddefine;

define lconstant labset(lab, val, globl);
	lvars lab, val, globl, offs;
	if globl then
		asmf_charout('.globl '), asmf_charout(lab), asmf_charout(`\n`)
	endif;
#_IF DEF OSF1 or DEF LINUX
	asmf_printf(lab, '%p = ');
#_ELSE
	asmf_printf(lab, '.set %p, ');
#_ENDIF
	pr_item(val);
	asmf_charout(`\n`);

#_IF DEF POPC and DEF ALPHA
	returnunless(current_asm_segment);		;;; i.e. if doing .s file
	if asm_label_offsets(val) ->> offs then
		offs -> asm_label_offsets(lab)
	endif
#_ENDIF
enddefine;
;;;
define asm_outlabset  = labset(% false %) enddefine;
define asm_outglabset = labset(% true %) enddefine;


define lconstant outdatum(n, string, offs);
	lvars m, n, string, offs;

	returnif(n == 0);
	asmf_charout(string);
	fast_for m from n by -1 to 2 do
		pr_item(subscr_stack(m)), asmf_charout(`,`)
	endfast_for;
	pr_item();
	erasenum(n-1);
	asmf_charout(`\n`);

#_IF DEF POPC and DEF ALPHA
	subscrv(current_asm_segment,asm_seg_offsets) fi_+ (n fi_* offs)
				-> subscrv(current_asm_segment,asm_seg_offsets)
#_ENDIF
enddefine;
;;;
define asm_outbyte	= outdatum(% ASM_BYTE_STR,  BYTE_OFFS %) enddefine;
define asm_outshort	= outdatum(% ASM_SHORT_STR, SHORT_OFFS %) enddefine;
define asm_outint	= outdatum(% ASM_INT_STR,   INT_OFFS %) enddefine;
define asm_outword	= outdatum(% ASM_WORD_STR,  WORD_OFFS %) enddefine;
#_IF DEF ALPHA
define asm_outdouble = outdatum(% ASM_DOUBLE_STR, DOUBLE_OFFS %) enddefine;
#_ENDIF


#_IF DEF ALPHA

define lconstant do_align(aoffs);
	lvars aoffs;
  #_IF DEF POPC
	;;; can't use .align because the disgusting assembler will relocate an
	;;; immediately preceding label to after the .align
	lvars pad = (aoffs - subscrv(current_asm_segment,asm_seg_offsets))
						mod aoffs;
	returnif(pad == 0);
	if testbit(pad, 0) then asm_outbyte(0, 1) endif;
	if testbit(pad, 1) then asm_outshort(0, 1) endif;
	if testbit(pad, 2) then asm_outint(0, 1) endif;
  #_ELSE
	outcode(integer_length(aoffs)-1, '.align %p');
  #_ENDIF
enddefine;

	;;; asm_align_word() -- output alignment for word
define asm_align_word = do_align(% WORD_OFFS %) enddefine;

	;;; asm_align_double() -- output alignment for double (e.g. double float)
define asm_align_double = do_align(% DOUBLE_OFFS %) enddefine;

#_ELSE

define asm_align_double(); enddefine;

#_ENDIF


	;;; asm_out_dfloat(_______hi_part, _______lo_part) -- output double float
define asm_out_dfloat	= asm_outint(% 2 %) enddefine;

	;;; asm_align_file() -- output end-of-file alignment
	;;; (don't define if no alignment necessary)
;;; define asm_align_file(); enddefine;


#_IF DEF ALPHA and DEF POPC
	/*	This is needed because the abysmal assembler produces a corrupt
		object file for .long _____label where _____label is later defined as
		absolute (ie set to an integer)
	*/
define asm_struct_wrap(keylab, code_p_list);
	lvars	keylab, code_p_list, code_p, save_charout = asmf_charout,
			init_offset = subscrv(current_asm_segment,asm_seg_offsets),
			size;
	dlocal	asmf_charout = erase;

	;;; dummy run to get size
	asm_outword(0, 0, 2);
	fast_for code_p in code_p_list do code_p() endfor;

	subscrv(current_asm_segment,asm_seg_offsets) - init_offset -> size;
	init_offset -> subscrv(current_asm_segment,asm_seg_offsets);
	save_charout -> asmf_charout;

	;;; do it for real
	asm_outword(size, keylab, 2);		;;; RAW_SIZE, KEY
	fast_for code_p in code_p_list do code_p() endfor;
enddefine;
#_ENDIF


	/*	asm_addbits is used to accumulate a sequence of bitfields into
		a (big)integer which asm_outbits is then called to output when the
		total number of bits accumulated occupies an exact number of bytes.
			___val is the currently accumulated (big)integer, containing
		_____nbits bits so far; _______new_val is the field to be added, containing
		_________new_nbits bits.
			The value returned will be the ___val input for the next field
		(with _____nbits incremented by _________new_nbits), and so on. Other than
		initialising ___val to 0 at the start, nothing is assumed about how
		the fields are added to it, so it is the responsibility of this
		procedure and asm_outbits to output the bitfields correctly.
	*/

	;;; VAX/ALPHA version ('little endian'), adds the fields at the
	;;; top and outputs the bytes from the bottom up
define asm_addbits(new_val, new_nbits, val, nbits);
	lvars new_val, new_nbits, val, nbits;
	val || (new_val << nbits) 	;;; add the new field at the top
enddefine;

	/*	In this, _____nbits is a multiple of BYTE_BITS, and ___val has been
		produced by repeated calls of asm_addbits
	*/
define asm_outbits(val, nbits);
	lvars val, nbits, count = 0;
	lconstant BYTE_MASK = (1<<BYTE_BITS)-1;
	until nbits == 0 do
		val && BYTE_MASK;			;;; output bytes from the bottom up
		val >> BYTE_BITS -> val;
		nbits-BYTE_BITS -> nbits;
		;;; this just saves putting each byte on a separate line
		if (count+1 ->> count) == 12 then asm_outbyte(count), 0 -> count endif;
	enduntil;
	if count /== 0 then asm_outbyte(count) endif
enddefine;


	/*	Optional procedure used (if present) by Poplink
		to do more compact generation of strings using ".ascii"
	*/
define asm_quick_genstring(string);
	lvars c, n = 1, l = datalength(string), string;
	until n fi_> l do
		f_subs(n, string) -> c;
		returnif(c fi_< `\s` or c fi_> `~` or c == `\\` or c == `"`) (false);
		n fi_+ 1 -> n
	enduntil;
	asmf_charout('\t.ascii "');
	asmf_charout(string);
	if (l fi_&& (WORD_BYTES-1) ->> l) /== 0 then
		repeat WORD_BYTES-l times
			asmf_charout(`\\`);
#_IF DEF OSF1
			asmf_charout(`X`), asmf_charout(`0`);
#_ENDIF
			asmf_charout(`0`)
		endrepeat;
	endif;
	asmf_charout(`"`), asmf_charout(`\n`);
	true
enddefine;

	/*	For closures generated by Poplink for undef procedures
	*/
define asm_gen_poplink_code(outlabs, nfroz, jmplab);
	lvars offs, outlabs, nfroz, jmplab;
#_IF DEF ALPHA
  #_IF WORD_BITS==DOUBLE_BITS
	lconstant macro (ldW = 'ldq', stW = 'stq');
  #_ELSE
	lconstant macro (ldW = 'ldl', stW = 'stl');
  #_ENDIF
	lconstant macro (PD_CLOS_PDPART = WORD_OFFS*2 + INT_OFFS*2,
					 PD_CLOS_FROZVALS = PD_CLOS_PDPART + WORD_OFFS);
	asm_startinstr();
	outlabs();						;;; plant exec labels
	0 -> offs;
	fast_repeat nfroz times
		outcode(PD_CLOS_FROZVALS+offs, ldW, '%p\t$0, %p($27)');
		offs+WORD_OFFS -> offs;
		outcode(offs, stW, '%p\t$0, -%p($24)')
	endrepeat;
	outcode(PD_CLOS_PDPART, ldW, '%p\t$27, %p($27)');
	outcode(offs, 'lda\t$24, -%p($24)');
	outcode(ldW, '%p\t$0, 0($27)');
	outcode('jmp\t$31, ($0)');
	asm_startcode();				;;; back to nonwriteable data
	0			;;; nothing planted in closure header
#_ELSE
	;;; plant exec labels
	outlabs();
	;;; code to push _____nfroz frozvals (last _____nfroz longwords planted)
	nfroz*4+3 -> offs;
	fast_repeat nfroz times
		;;; offs stays the same each time (+4 for next froz, -4 for instr)
		asmf_printf(offs, '\tmovl\t-%p(pc),-(ap)\n')	;;; 4 bytes
	endrepeat;
	;;; jmp to ______jmplab
	asmf_printf(jmplab, '\tjmp\t%p\n');			;;; 6 bytes
	;;; align to longword boundary
	asmf_printf('\t.align\t2\n');				;;; 2 bytes
	;;; return number of longwords of code planted
	nfroz+2
#_ENDIF
enddefine;

/*
 *	Exfunc closure code -- jump to subroutine _exfunc_clos_action (aextern.s)
 *	with exfunc_closure record address in a reg, etc. This procedure is
 *	passed the label of _exfunc_clos_action. The code generated must be
 *	padded to exactly 16 bytes.
 */

define asm_gen_exfunc_clos_code(action_lab);
	lvars action_lab;
#_IF DEF ALPHA
	;;; assembler won't allow code in data seg, so use hex for m/c code
	;;; (besides, must use asm_ procedures to output to count the offset)
	;;; rpb ($27) = addr of first instruction
	;;; load _exfunc_clos_action addr and jump to it
  #_IF WORD_BITS==DOUBLE_BITS
	asm_outdouble(
		'0x6BE00000A41B0008',		;;; ldq $0, 8($27); jmp ($0)
		action_lab,
		2);
  #_ELSE
	asm_outint(
		'0xA01B0008',				;;; ldl $0, 8($27)
		'0x6BE00000',				;;; jmp ($0)
		action_lab,
		0,							;;; pad to 16 bytes
		4);
  #_ENDIF
#_ELSE
	;;; passes (exfunc_clos address)+8 on stack
	asmf_printf('\t.word\t0\n');			;;; entry mask and jsb -- 8 bytes
	asmf_printf(action_lab, '\tjsb\t*$%p\n');	;;; must be absolute
	asmf_printf('\t.long\t0\n');			;;; pad to 16 bytes
	asmf_printf('\t.long\t0\n');
#_ENDIF
enddefine;


/*
 *	extern_name_translate:
 *		translate an external symbol, using the same conventions as the
 *		C compiler and linker (e.g. add a leading '_', truncate to N
 *		characters, etc.)
 */

define extern_name_translate(lang, symbol, type) -> symbol;
	lvars lang, symbol, type;
	returnif(lang = 'ASM');
#_IF not(DEF COFF or DEF LINUX_ELF)
	'_' <> symbol -> symbol;
#_ENDIF
	if lang = 'FORTRAN' then uppertolower(symbol) <> '_' -> symbol endif
enddefine;


	/* Stuff used in os_comms.p
	*/
#_IF DEF LINUX

	;;; Use C compiler to link
constant
	cc_link_command_header = '$POP__cc -Wl,-x,-export-dynamic -o $IM \\\n'
;

#_ELSE

constant

	;;; location of crt*.o files for linking
	unix_ld_crt_objects =
		#_IF DEF OSF1	'/usr/lib/cmplrs/cc/crt0.o'
		#_ELSE			'/lib/crt0.o'
		#_ENDIF,

	;;; String for first line of Unix "ld" command
	;;; (Image name is in the variable "IM")
	unix_ld_command_header =
		#_IF DEF OSF
		  #_IF WORD_BITS==DOUBLE_BITS
				;;; the -T/D values here default to 120000000/140000000
				;;; (god knows why). Using 20000000/40000000 enables ass.p
				;;; to store a system procedure's execute & header addresses
				;;; as 32-bit values
				'/bin/ld -x -o $IM -call_shared -T 20000000 -D 40000000 \\\n'
		  #_ELSE
				'/bin/ld -x -o $IM -call_shared -taso \\\n'
		  #_ENDIF
		#_ELSE
				'/bin/ld -x -o $IM -e start \\\n'
		#_ENDIF,

	;;; Assembler command line arguments
	unix_as_options = #_IF DEF OSF1 ['-O0'] #_ELSE ['-d4'] #_ENDIF,
;

#_ENDIF

endsection;		/* $-Popas */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 15 1996
		New version of extern_name_translate.
--- John Gibson, Aug  2 1995
		Made labset use the same printing procedure for the value item
		as outdatum
--- John Gibson, Feb  3 1995
		Changes for Alpha OSF
--- Robert John Duncan, Mar 22 1994
		Changed asm_gen_poplink_code to plant the execute labels
--- Robert John Duncan, Mar 21 1994
		Added unix_as_options
--- John Gibson, May 19 1993
		Added asm_gen_exfunc_clos_code
--- Robert John Duncan, Jul 27 1992
		Added -extern_name_translate-
--- John Gibson, Jul 17 1989
		OS command procedures commoned in C.unix/src/syscomp/os_comms.p
		(but this file still defines the "ld" command string since this
		is different for nearly every system).
--- John Gibson, Jun  7 1989
		Included common.ph
--- John Gibson, Mar 23 1989
		Added -asm_addbits- and -asm_outbits-
--- John Gibson, Feb  2 1989
		Changed -asm_gen_poplink_code- to allow any number of frozvals to
		be pushed.
--- John Gibson, Nov 16 1988
		Added procedure -unix_archive- (used by poplibr)
--- John Gibson, Jun 24 1988
		Added assembling and linking procedures.
--- John Gibson, Jan 17 1988
		Revised label formats to cope with sections, etc, and
		added new label procedures -asm_wordidlabel-, -asm_pdpropslabel-
		-asm_testdeflabel-.
			Also new procedures -asm_align_double-, -asm_out_dfloat-,
		-asm_gen_poplink_code-.
--- John Gibson, Aug 16 1987
		Replaced -vars- with -dlocal-
 */
