/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            C.alpha/src/syscomp/genproc.p
 > Purpose:
 > Author:          John Gibson, Aug 24 1994 (see revisions)
 */

/* -------------------------------------------------------------------------

				GENERATE PROCEDURE CODE -- ALPHA SYSTEMS

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas$-M_trans;

constant
		procedure (auto_operand, reg_in_operand, immediate_operand,
		commute_test, negate_test, perm_const_opnd, perm_constp_opnd,
		perm_var_opnd, cons_access_opnd)
	;

vars
		current_pdr_label, current_pdr_exec_label,
		false_immediate, true_immediate, nil_immediate
	;

	/****************************************************************
	* This file is contained entirely in section Genproc, and must  *
	*   define all the exports to section M_trans listed below.     *
	****************************************************************/

section Genproc =>

		/*	M-opcode Procedures */
		M_ADD,
		M_ASH,
		M_BIC,
		M_BIM,
		M_BIS,
		M_BIT,
		M_BRANCH,
		M_BRANCH_std,
		M_BRANCH_ON,
		M_BRANCH_ON_INT,
		M_CALL,
		M_CALL_WITH_RETURN,
		M_CALLSUB,
		M_CHAIN,
		M_CHAINSUB,
		M_CLOSURE,
		M_CMP,
		M_CMPKEY,
		M_CREATE_SF,
		M_END,
		M_ERASE,
		M_LABEL,
		M_LOGCOM,
		M_MOVE,
		M_MOVEbit,
		M_MOVEsbit,
		M_MULT,
		M_NEG,
		M_PADD,
		M_PADD_TEST,
		M_PCMP,
		M_PLOG_IFNOT_ATOM,
		M_PLOG_TERM_SWITCH,
		M_PSUB,
		M_PSUB_TEST,
		M_PTR_ADD_OFFS,
		M_PTR_CMP,
		M_PTR_SUB,
		M_PTR_SUB_OFFS,
		M_RETURN,
		M_SETSTKLEN,
		M_SUB,
		M_TEST,
		M_UNWIND_SF,
		M_UPDbit,

		/*	Registers */
		SP,
		USP,
		USP_+,
		-_USP,
		i_USP,
;;;		i_USP_+,			;;; these two are optional
;;;		ii_USP,
		WK_ADDR_REG_1,
		WK_ADDR_REG_2,
		WK_REG,
		CHAIN_REG,
		SPECIAL_VAR_BLOCK_REG,
		PROCEDURE_BASE_REG,

		/*	Register Lists */
		nonpop_registers,
		pop_registers,

		/*	Register Procedures */
		reglabel,
		regnumber,
		autoidreg,

		/*	M-code Mapping of Subroutines */
		mc_inline_conditions_list,
		mc_inline_procs_list,

		/*	Procedures Needed by m_optimise */
		cvt_pop_subscript,
		can_defer_opnd,
		pdr_index_opnd,

		/*	Procedure to Generate Code */
		mc_code_generator,

		/* Booleans */
		USE_NEW_M_OPERANDS,
		UNWIND_FRAME_SAVES_PB,
		BRANCH_ON_ALLOWS_BASE,
	;


;;; --- REGISTERS ---------------------------------------------------------

#_INCLUDE '../registers.ph'		;;; maps RG_ names to numbers

	/* set up regnumber and reglabel properties */
define regnumber	= newassoc([]) enddefine;
define reglabel		= newassoc([]) enddefine;

procedure;
	lvars n, l;
	for n from 0 to 31 do
		consword(REG_PREFIX sys_>< n) -> l;
		n -> regnumber(l);
		l -> reglabel(n)
	endfor
endprocedure();


	;;; assign negative reg numbers to dummy registers
-1	 -> regnumber("WK_REG");
-2	 -> regnumber("WK_ADDR_REG_1");
-3	 -> regnumber("WK_ADDR_REG_2");

lconstant
	RT0		= reglabel(RGt0),
	RT1		= reglabel(RGt1),
	RT2		= reglabel(RGt2),
	RT3		= reglabel(RGt3),
	RT4		= reglabel(RGt4),
	RT5		= reglabel(RGt5),
	RT6		= reglabel(RGt6),
	RRET	= reglabel(RGret),
	RCHAIN	= reglabel(RGchain),
	RFALSE	= reglabel(RGfalse),
	RZERO	= reglabel(RGzero),
	SVB		= reglabel(RGsvb),
	PB		= reglabel(RGpb),
	;


;;;-------- DEFINITIONS FOR TRANSLATING VM CODE TO MODEL ASSEMBLER --------

	/*	m_trans.p requires the definition of
			SP, USP, USP_+, -_USP and i_USP.
	*/

constant
	SP		= reglabel(RGsp),	;;; system stack pointer
	USP		= reglabel(RGusp),	;;; user stack pointer
	i_USP	= {^USP 0},			;;; top of user stack
	-_USP	= {^USP ^false},	;;; user stack autodecrement
	USP_+	= {^USP ^true},		;;; user stack autoincrement

	macro UNWIND_FRAME_SAVES_PB = true,
	;;; required when UNWIND_FRAME_SAVES_PB is true
	PROCEDURE_BASE_REG = PB,
	;


	/*	WK_REG is used by m_optimise for eliminating stack pushes and pops
		between successive instructions
	*/
constant
	WK_REG = "WK_REG";


	/*	WK_ADDR_REG_1 and 2 are used by m_optimise for building field
		access operands (ie of the the form {^reg ^offset} ) when an existing
		operand cannot be deferred directly (can_defer_operand having
		returned false for it). 1 is used for source operands, 2 for
		destination operands
	*/
constant
	WK_ADDR_REG_1 = "WK_ADDR_REG_1",
	WK_ADDR_REG_2 = "WK_ADDR_REG_2";


	/*	CHAIN_REG is the register used to save procedure operands for in-line
		chaining, and must not be corrupted by M_UNWIND_SF (ideally it should
		be an address register). It is also used to save return addresses for
		out-of-line chaining thru the subroutines _syschain and _sysncchain.
	*/
constant
	CHAIN_REG	= reglabel(RGchain);


	/*	SPECIAL_VAR_BLOCK_REG is optional; if defined, it's assumed to
		hold the address of _special_var_block.
	*/
constant
	SPECIAL_VAR_BLOCK_REG	= SVB;


	/*	m_optimise needs lists of pop and nonpop registers,
		in order of allocation; these lists start with a list of
		registers that should be local to every procedure.
		It also needs the properties regnumber and reglabel.
	*/
constant
	pop_registers		= [[] ^RGpl0 ^RGpl1 ^RGpl2 ^RGpl3 ^RGpl4 ^RGpl5
							  ^RGpl6 ^RGpl7 ^RGpl8 ^RGpl9 ^RGpl10],
	nonpop_registers	= [[] ^RGnpl0 ^RGnpl1 ^RGnpl2 ^RGnpl3 ^RGnpl4];


	/*	The procedure autoidreg is used by m_optimise in deciding
		whether a register can be used for autoincrement/decrement operands,
		ie of the form {^reg ^boolean}.
	*/
identof("regnumber") -> identof("autoidreg");


	/*	Setting this true means generate typed M-code vector operands for
		short and and byte memory access/updates (instead of the old
		M_MOVE(s)b/s and M_UPDb/s instructions). The operands have the form

			{____base ______offset ____type}

		where ____type is T_BYTE, T_SGN_BYTE, T_SHORT or T_SGN_SHORT (word access
		operands are always length 2). As well as a register, ____base may a
		string (i.e. absolute address), in which case any offset is
		concatenated onto the string and ______offset is 0.
	*/
constant macro USE_NEW_M_OPERANDS = true;

	/*	Setting this true means M_BRANCH_ON(_INT) instructions allow
		an optional extra element to specify the base integer (defaults to 1).
	*/
constant macro BRANCH_ON_ALLOWS_BASE = true;


	/*	can_defer_operand is used by m_optimise to create a field access
		operand from an existing operand, ie accessing/updating the datum
		of type _______acctype at offset ____offs from the pointer held in the operand.
		(Takes 4 args with USE_NEW_M_OPERANDS true.)
	*/
define can_defer_opnd(opnd, offs, acctype, upd);
	lvars opnd, acctype, offs, upd;
	if isref(opnd) then
		;;; immediate label
		fast_cont(opnd) -> opnd
	elseunless regnumber(opnd) then
		return(false)
	endif;
	chain(opnd, offs, acctype, cons_access_opnd)
enddefine;

define lconstant wof = nonop fi_*(% WORD_OFFS %) enddefine;

	/*	pdr_index_opnd is used by m_trans.p for creating operands to
		push/call values from procedure headers (not used in closures).
	*/
define pdr_index_opnd(fld_index);
	lvars fld_index;
	cons_access_opnd(PB, fld_index.wof, T_WORD)
enddefine;



;;; --- M-CODE TRANSLATION PROCEDURES ----------------------------------------

define lconstant cmp_opcode = newassoc([
	[UGT {cmpule [blbc]}]	 [UGEQ {cmpult [blbc]}]
	[ULT {cmpult [blbs]}]	 [ULEQ {cmpule [blbs]}]

	[GT  {cmple  [blbc]}]	 [GEQ  {cmplt [blbc]}]
	[LT  {cmplt  [blbs]}]	 [LEQ  {cmple [blbs]}]

	[EQ  {cmpeq  [blbs]}]	 [NEQ  {cmpeq [blbc]}]
])
enddefine;

define lconstant tst_opcode = newassoc([%
	[LT  [blt]],	[LEQ  [ble]],
	[GT  [bgt]],	[GEQ  [bge]],
	[EQ  [beq]],	[NEQ  [bne]],
	[NEG [blt]],	[POS  [bge]],
	[LBC [blbc]],	[LBS  [blbs]],
#_IF WORD_BITS==DOUBLE_BITS
	[OVF [blt]],	[NOVF [bge]],	;;; on result of logical expr on sign bit
#_ELSE
	[OVF [blbc]],	[NOVF [blbs]],	;;; on result of compare
#_ENDIF
%])
enddefine;


lconstant macro POPINT0 = popint(0);
lconstant macro NO_OFFSET = 1e6;

lvars
		m_codelist, m_instr, last_ipair, instr_list, new_literals,
		closure_frozlist,
		unique_labels = false, procedure test_opcode = tst_opcode,
	;


define lconstant placei() with_nargs 1;
	() :: [] ->> f_tl(last_ipair) -> last_ipair
enddefine;

	;;; for non-nil instruction list
define lconstant placel(list);
	lvars list;
	list -> f_tl(last_ipair);
	until f_tl(list) == [] do f_tl(list) -> list enduntil;
	list -> last_ipair
enddefine;

define lconstant place1();
	placei(consvector(1))
enddefine;

define lconstant place2();
	placei(consvector(2))
enddefine;

define lconstant place3();
	placei(consvector(3))
enddefine;

define lconstant place4();
	placei(consvector(4))
enddefine;


lconstant
	;;; what dummy registers with -ve numbers are actually allocated to
	dummy_reg_alloc = writeable initv(3),

	OP_label	= [label],
	OP_ldl		= [ldl],
	OP_stl		= [stl],
	OP_ldq		= [ldq],
	OP_stq		= [stq],
	OP_ldq_u	= [ldq_u],
	OP_stq_u	= [stq_u],
	OP_jsr		= [jsr],
	OP_jmp		= [jmp],
	OP_ret		= [ret],
	OP_br		= [br],
	OP_bsr		= [bsr],
	;

#_IF WORD_BITS==DOUBLE_BITS
lconstant
	OP_ldW		= OP_ldq,
	OP_stW		= OP_stq,
	OP_addW		= "addq",
	OP_subW		= "subq",
	OP_negW		= "negq",
	OP_mulW		= "mulq",
;
#_ELSE
lconstant
	OP_ldW		= OP_ldl,
	OP_stW		= OP_stl,
	OP_addW		= "addl",
	OP_subW		= "subl",
	OP_negW		= "negl",
	OP_mulW		= "mull",
;
#_ENDIF

lvars
	;;; temp register queue
	tmpreg_list = [],

	;;; literal register queue
	litreg_list = [],

	;;; running userstack difference
	curr_stack_diff,
	;

define lconstant init_reg();
	sys_grbg_list(tmpreg_list);
	[^RT0 ^RT3 ^RT4 ^RT5 ^RT6 ^RRET] -> tmpreg_list;
	false, false, false -> explode(dummy_reg_alloc);
	sys_grbg_list(litreg_list);
	[] -> litreg_list
enddefine;

define lconstant free_reg(reg);
	lvars reg, pair;
	returnunless(reg);
	if fast_lmember(reg, tmpreg_list) then
		mishap(0, 'SYSTEM ERROR IN free_reg')
	endif;
	tmpreg_list nc_<> (reg :: []) -> tmpreg_list
enddefine;

define lconstant get_free_litreg();
	lvars l = litreg_list, lst = false, lp;
	until l == [] do
		f_tl(f_tl(l)) -> lp;
		unless f_hd(lp) then
			f_tl(lp) -> if lst then f_tl(lst) else litreg_list endif;
			return(f_hd(l))
		endunless;
		lp -> lst;
		f_tl(lp) -> l
	enduntil;
	false
enddefine;

define lconstant alloc_reg() -> reg;
	lvars reg;
	if tmpreg_list /== [] then
		sys_grbg_destpair(tmpreg_list) -> (reg, tmpreg_list)
	elseunless get_free_litreg() ->> reg then
		mishap(0, 'SYSTEM ERROR IN alloc_reg')
	endif
enddefine;

define lconstant trans_reg(opnd, isdst) -> opnd;
	lvars opnd, isdst, i, reg;
	returnunless((regnumber(opnd) ->> i) and i fi_< 0);
	-i -> i;
	f_subv(i,dummy_reg_alloc) -> reg;
	if isdst == true or isdst and not(reg) then
		free_reg(reg);
		alloc_reg() ->> opnd -> f_subv(i,dummy_reg_alloc)
	elseunless reg ->> opnd then
		mishap(0, 'SYSTEM ERROR IN trans_reg')
	endif
enddefine;

define lconstant exclude_reg(reg);
	lvars reg;
	unless fast_lmember(reg, tmpreg_list) then
		mishap(0, 'SYSTEM ERROR IN exclude_reg')
	endunless;
	fast_ncdelete(reg, tmpreg_list) -> tmpreg_list
enddefine;

define lconstant dealloc_dummy_reg();
	lvars i, v = dummy_reg_alloc;
	fast_for i to 3 do
		free_reg(f_subv(i,v));
		false -> f_subv(i,v)
	endfor;
	litreg_list -> i;
	until i == [] do
		free_reg(f_dest(i) -> i);
		f_tl(f_tl(i)) -> i
	enduntil;
	sys_grbg_list(litreg_list);
	[] -> litreg_list
enddefine;

define lconstant fast_=_lmember(item, list);
	lvars list, item;
	until list == [] do
		returnif(fast_front(list) = item) (list);
		fast_back(list) -> list
	enduntil;
	false
enddefine;

define lconstant fast_nmember(item, list);
	lvars list, item, n = 1;
	until list == [] do
		returnif(fast_front(list) = item) (n);
		fast_back(list) -> list;
		n fi_+ 1 -> n
	enduntil;
	false
enddefine;

define lconstant consregacc(reg, offs) -> opnd;
	lvars reg, offs, opnd, procedure prop;

	define lconstant USP_prop = newproperty([], 4, false, false) enddefine;
	define lconstant SP_prop = newproperty([], 4, false, false) enddefine;
	define lconstant PB_prop = newproperty([], 4, false, false) enddefine;

	if     reg == USP then USP_prop -> prop
	elseif reg == SP then  SP_prop -> prop
	elseif reg == PB then  PB_prop -> prop
	else
		return(consvector(reg, offs, 2) -> opnd)
	endif;
	unless prop(offs) ->> opnd then
		consvector(reg, offs, 2) ->> opnd -> prop(offs)
	endunless
enddefine;

define lconstant load_literal(reg, lit);
	lvars reg, lit, lab, n;


	define lconstant ld_pb_opnd(/*op, reg, lab*/);
#_IF not(DEF VMS)
		consref(/*lab*/);
#_ENDIF
		place3()
	enddefine;

	define lconstant within_range(lab);
		lvars lab, offs;
#_IF DEF VMS
		(nwdata_lab_offset(lab) ->> offs)
		and offs-asm_nwdata_offset >= -16:8000
#_ELSE
		(asm_label_offsets(lab) ->> offs)
		and (offs>>2)-subscrv(ASMSEG_NONWRITEABLE,asm_seg_offsets) >= -16:8000
		and offs&&3 == ASMSEG_NONWRITEABLE
#_ENDIF
	enddefine;

	if isref(lit) then fast_cont(lit) -> lit endif;
	if lit == current_pdr_label then
		unless reg == PB then ld_pb_opnd("lda", reg, lit) endunless
	elseif within_range(lit) then
		ld_pb_opnd("lda", reg, lit)
	else
		if closure_frozlist and fast_nmember(lit, closure_frozlist) ->> n then
			place3(OP_ldW, reg,
					consregacc(PB, wof(field_##("PD_CLOS_FROZVALS")+n-1) ));
			return
		elseunless (pdr_literal_label(lit) ->> lab)
		and (within_range(lab) or fast_=_lmember(lit,new_literals)) then
			new_literals nc_<> (lit :: []) -> new_literals;
			nextlab() ->> lab -> pdr_literal_label(lit)
		endif;
		ld_pb_opnd(OP_ldW, reg, lab)
	endif
enddefine;

	;;; Get a register to cache a literal in
define lconstant get_litreg(lit, alloc);
	lvars l = litreg_list, lp, lit, reg, alloc;
	until l == [] do
		if (f_dest(f_tl(l)) -> lp) = lit then
			true -> f_hd(lp);
			return(f_hd(l))
		endif;
		f_tl(lp) -> l
	enduntil;
	returnunless(alloc) (false);

	alloc_reg() -> reg;
	load_literal(reg, lit);
	litreg_list nc_<> [^reg ^lit ^true] -> litreg_list;
	reg
enddefine;

define lconstant set_litreg_unused();
	lvars l = litreg_list, lp, n = -2;
	until l == [] do
		f_tl(f_tl(l)) -> lp;
		false -> f_hd(lp);
		f_tl(lp) -> l;
		n fi_+ 1 -> n
	enduntil;
	fast_repeat n times free_reg(get_free_litreg()) endrepeat
enddefine;

define lconstant normalise_int(i) -> i;
	lvars i, ilen = integer_length(i);
	if ilen >= WORD_BITS then
		if ilen == WORD_BITS and i > 0 then
			;;; allow 'unsigned' WORD_BITS value as -ve
			i || #_< -1<<WORD_BITS >_# -> i
		else
			mishap(i, 1, 'INTEGER OPERAND TOO LARGE')
		endif
	endif
enddefine;

define lconstant place_mf(Op, Rval, Disp, Raddr);
	lvars Op, Rval, Disp, Raddr, Rtmp, sgn, hi, store;
	lconstant HIMASK = -1 << 16;

	define lconstant mf_inst(/*Op, Rval,*/ Disp, Raddr);
		lvars Disp, Raddr;
		chain((), consregacc(Raddr, Disp), place3)
	enddefine;

	if isintegral(Disp) then
		normalise_int(Disp) -> Disp;
#_IF WORD_BITS==DOUBLE_BITS
		unless integer_length(Disp) < INT_BITS then
			mishap(Disp, 1, 'INTEGER DISPLACEMENT TOO LARGE')
		endunless
#_ENDIF
	endif;

	if isintegral(Disp) and (Disp >> 15 ->> sgn) /== 0 and sgn /== -1 then
		;;; hi part is not simple sign-extension of lo part
		sgn >> 1 -> hi;
		if Op == "lda" and Disp &&=_0 16:FFFF then
			hi -> Disp;
			"ldah" -> Op
		else
			Op==OP_stl or Op==OP_stq -> store;
			if store then alloc_reg() else Rval endif -> Rtmp;
			if sgn &&/=_0 1 then
				;;; lo will be sign-extended to negative, effectively
				;;; subtracting 1 from hi -- add 1 to compensate
				if hi /== 16:7FFF then
					hi+1 -> hi
				else
					;;; adding 1 would overflow, so need a 3rd instruction
					mf_inst("ldah", Rtmp, 1, Raddr);
					Rtmp -> Raddr
				endif;
				Disp || HIMASK
			else
				Disp &&~~ HIMASK
			endif -> Disp;
			mf_inst("ldah", Rtmp, hi, Raddr);
			Rtmp -> Raddr;
			if store then free_reg(Rtmp) endif
		endif
	endif;

	mf_inst(Op, Rval, Disp, Raddr)
enddefine;

define lconstant stack_adjust();
	if curr_stack_diff /== 0 then
		place_mf("lda", USP, curr_stack_diff, USP);
		0 -> curr_stack_diff
	endif
enddefine;

define lconstant place_label(lab);
	lvars lab;
	place2(OP_label, lab)
enddefine;

lconstant procedure (
	isreg		= isword,
	isaccess	= isvector,
	);

define lconstant mem_access_type(opnd);
	lvars opnd;
	if isstring(opnd) then
		T_WORD
	elseif isaccess(opnd) then
		if datalength(opnd) == 2 then T_WORD else f_subv(3, opnd) endif
	else
		false
	endif
enddefine;

define lconstant isabs(opnd);
	lvars opnd, hi, lo;
	(isstring(opnd) or isaccess(opnd) and isstring(f_subv(1,opnd) ->> opnd))
	and opnd
enddefine;

	;;; get an already-cached address operand
define lconstant get_cached_opnd(opnd);
	lvars opnd, lab, reg;
	if isabs(opnd) ->> lab then
		if get_litreg(lab, false) ->> reg then
			cons_access_opnd(reg, 0, mem_access_type(opnd))
		else
			opnd
		endif
	else
		get_litreg(opnd, false) or opnd
	endif
enddefine;

define lconstant get_us_offset(opnd) -> offs;
	lvars offs, opnd;
	unless f_subv(2, opnd) ->> offs then
		;;; false = -_USP
		curr_stack_diff fi_- WORD_OFFS ->> offs -> curr_stack_diff
	elseif offs == true then
		;;; true = USP_+
		curr_stack_diff -> offs;
		offs fi_+ WORD_OFFS -> curr_stack_diff
	else
		curr_stack_diff fi_+ offs -> offs
	endunless
enddefine;

define lconstant place_test(test, reg, lab);
	lvars test, reg, lab, op;
	stack_adjust();
	if isvector(test_opcode(test) ->> op) then f_subv(2,op) -> op endif;
	place3(op, reg, lab)
enddefine;


;;; --- LOAD AND STORE OPERANDS -------------------------------------------

define lconstant type_opcodes = newassoc([%
	[^T_BYTE		{extbl	insbl mskbl}],
	[^T_SGN_BYTE	{^false	insbl mskbl}],
	[^T_SHORT		{extwl	inswl mskwl}],
	[^T_SGN_SHORT	{^false	inswl mskwl}],
#_IF WORD_BITS==DOUBLE_BITS
	[^T_INT			{^OP_ldl	^OP_stl}],
	[^T_SGN_INT		{^OP_ldl	^OP_stl}],
	[^T_DOUBLE		{^OP_ldq	^OP_stq}],
#_ELSE
	[^T_INT			{^OP_ldl	^OP_stl}],
	[^T_INT_DOUBLE	{^OP_ldl	^OP_stq}],
#_ENDIF
%])
enddefine;


define lconstant load_src(dst_reg, opnd, int_imm) -> (dst_reg, dst_tmp);
	lvars opnd, reg, offs, int_imm, inc, lab, type;
	dlvars dst_reg, dst_tmp = false;

	define lconstant do_load(type, dst, offs, reg);
		lvars	type, dst, offs, reg, size, tmp = false,
				opcodes = type_opcodes(type), extop = subscrv(1,opcodes);
		if datalength(opcodes) == 2 then
			place_mf(extop, dst, offs, reg);
#_IF WORD_BITS==DOUBLE_BITS
			if type == T_INT then place4("extll", dst, 0, dst) endif
#_ENDIF
		else
			t_offset(type, false) -> size;
			if dst == reg then
				place3("mov", reg, alloc_reg() ->> tmp ->> reg)
			endif;
			place_mf(OP_ldq_u, dst, offs, reg);
			unless extop then offs+size -> offs endunless;
			if offs /== 0 then
				place_mf("lda", tmp or alloc_reg() ->> tmp, offs, reg);
				tmp -> reg
			endif;
			if extop then
				;;; unsigned
				place4(extop, dst, reg, dst)
			else
				;;; signed
				place4("extqh", dst, reg, dst);
				place4("sra", dst, 64-(size*8), dst)
			endif;
			free_reg(tmp)
		endif
	enddefine;

	define lconstant get_dst();
		if dst_reg then
			trans_reg(dst_reg, true)
		else
			alloc_reg() ->> dst_tmp
		endif -> dst_reg
	enddefine;


	if isreg(opnd) then
		if opnd == USP then stack_adjust() endif;
		trans_reg(opnd, false) -> dst_reg

	elseif isintegral(opnd) then
		if opnd == 0 then
			RZERO -> dst_reg
		elseif opnd &&=_0 -16:100 then
			returnif(int_imm) (opnd -> dst_reg);
			get_dst();
			place3("mov", opnd, dst_reg)
#_IF WORD_BITS==DOUBLE_BITS
		elseif integer_length(normalise_int(opnd) ->> opnd) >= INT_BITS then
			get_dst();
			load_literal(dst_reg, opnd)
#_ENDIF
		else
			get_dst();
			place_mf("lda", dst_reg, opnd, RZERO)
		endif
	elseif opnd = false_immediate then
		RFALSE -> dst_reg
	elseif opnd = true_immediate or opnd = nil_immediate then
		wof(datasize(false)) -> inc;
		if opnd = nil_immediate then inc fi_+ inc -> inc endif;
		get_dst();
		place_mf("lda", dst_reg, inc, RFALSE)
	elseif isref(opnd) then
		;;; address constant
		if get_litreg(opnd, int_imm/==dst_reg) ->> reg then
			reg -> dst_reg
		else
			get_dst();
			load_literal(dst_reg, opnd)
		endif
	elseif mem_access_type(opnd) ->> type then
		false -> inc;
		if isabs(opnd) ->> lab then
			;;; absolute address
			0 -> offs;
			get_litreg(lab, true) -> reg
		else
			f_subv(2,opnd) -> offs;
			if (trans_reg(f_subv(1,opnd), false) ->> reg) == USP then
				;;; userstack access
				get_us_offset(opnd) -> offs
			elseif isboolean(offs) then
				;;; predecr/postincr
				t_offset(type, false) -> inc;		;;; data size
				if offs then 0 else -inc ->> inc endif -> offs
			endif
		endif;
		get_dst();
		do_load(type, dst_reg, offs, reg);
		if inc then place_mf("lda", reg, inc, reg) endif
	else
		mishap(opnd, 1, 'INVALID SOURCE OPERAND IN M-INSTRUCTION')
	endif
enddefine;

define lconstant store_dst(src_reg, opnd, src_istmp);
	lvars	opnd, reg, src_reg, offs, lab, type, inc, save, src_istmp,
			used_tmp = false;

	define lconstant do_store(type, src, offs, reg, src_istmp);
		lvars	type, src, offs, reg, src_istmp, tmp1, tmp2 = false, i,
				insop, mskop, opcodes = type_opcodes(type);
		if datalength(opcodes) == 2 then
			place_mf(subscrv(2,opcodes), src, offs, reg)
		else
			explode(opcodes) -> (, insop, mskop);
			alloc_reg() -> tmp1;
			place_mf(OP_ldq_u, tmp1, offs, reg);
			if offs /== 0 then
				alloc_reg() ->> tmp2 -> i;
				place_mf("lda", i, offs, reg);
				place4(mskop, tmp1, i, tmp1);
				place4(insop, src, i, i)
			else
				if src_istmp then src else alloc_reg() ->> tmp2 endif -> i;
				place4(insop, src, reg, i);
				place4(mskop, tmp1, reg, tmp1)
			endif;

			place4("or", tmp1, i, tmp1);
			free_reg(tmp2);
			place_mf(OP_stq_u, tmp1, offs, reg);
			free_reg(tmp1)
		endif
	enddefine;

	if isreg(opnd) then
		trans_reg(opnd, true) -> opnd;
		if opnd == USP then
			0 -> curr_stack_diff
		elseif opnd == RZERO then
			;;; dummy output means want tmp
			(src_istmp and src_reg) or (alloc_reg() ->> used_tmp) -> opnd
		endif;
		return(false, opnd, used_tmp)
	elseunless mem_access_type(opnd) ->> type then
		mishap(opnd, 1, 'INVALID DESTINATION OPERAND IN M-INSTRUCTION')
	endif;

	last_ipair -> save;
	if isabs(opnd) ->> lab then
		;;; absolute address
		0 -> offs;
		get_litreg(lab, true) -> reg
	else
		f_subv(2,opnd) -> offs;
		if (trans_reg(f_subv(1,opnd), false) ->> reg) == USP then
			;;; userstack access
			get_us_offset(opnd) -> offs
		elseif isboolean(offs) then
			;;; predecr/postincr
			t_offset(type, false) -> inc;		;;; data size
			if offs then -inc else -inc -> inc, 0 endif -> offs;
			place_mf("lda", reg, inc, reg)
		endif
	endif;
	unless src_reg then
		alloc_reg() ->> src_reg ->> src_istmp -> used_tmp
	endunless;
	do_store(type, src_reg, offs, reg, src_istmp);
	(f_tl(save), src_reg, used_tmp);
	[] -> f_tl(save);
	save -> last_ipair
enddefine;


;;; --- MOVE INSTRUCTIONS --------------------------------------------------

define lconstant do_move(src, dst);
	lvars src, reg, dst, tmp;
	returnif(src = dst or (src == USP_+ and dst == -_USP));
	if isreg(dst) then
		load_src(dst, src, dst) -> (reg, );
		trans_reg(dst, "undef") -> dst;
		if reg /== dst then place3("mov", reg, dst) endif;
		if dst == USP then 0 -> curr_stack_diff endif
	else
		if isreg(src) then
			trans_reg(src, false), false
		else
			get_cached_opnd(dst) -> dst;
			load_src(false, src, false)
		endif -> (src, tmp);
		placel(store_dst(src, dst, tmp) -> (,));
		free_reg(tmp)
	endif
enddefine;

define M_MOVE();
	do_move(f_subv(2, m_instr), f_subv(3, m_instr))
enddefine;

define lconstant move_rt0_result(dst);
	lvars dst;
	exclude_reg(RT0);
	if isreg(dst) then
		RT0 :: tmpreg_list -> tmpreg_list;
		do_move(RT0, dst)
	else
		do_move(RT0, dst);
		free_reg(RT0)
	endif
enddefine;

define lconstant call_or_chain_reg(reg, iscall);
	lvars reg = consregacc(reg, NO_OFFSET), iscall;
	stack_adjust();
	if iscall then place3(OP_jsr, RRET, reg) 
	else place3(OP_jmp, RZERO, reg) 
	endif;
	dealloc_dummy_reg()
enddefine;

	;;; {M_MOVE(s)bit _________fieldsize _______bitoffs ___ptr ___dst}
define lconstant get_bitfield(routine);
	lvars routine, (, fieldsize, bitoffs, ptr, dst) = explode(m_instr);
	load_literal(RCHAIN, symlabel(routine));
	do_move(fieldsize, RT2);
	do_move(bitoffs, RT1);
	do_move(ptr, RT0);
	call_or_chain_reg(RCHAIN, true);
	move_rt0_result(dst)
enddefine;

define M_MOVEbit	= get_bitfield(%"\^_bfield"%)  enddefine;
define M_MOVEsbit	= get_bitfield(%"\^_sbfield"%) enddefine;

	;;; {M_UPDbit _________fieldsize _______bitoffs ___ptr ___src}
define M_UPDbit();
	lvars (, fieldsize, bitoffs, ptr, src) = explode(m_instr);
	load_literal(RCHAIN, symlabel("\^_ubfield"));
	do_move(fieldsize, RT2);
	do_move(bitoffs, RT1);
	if src /== USP_+ then do_move(src, -_USP) endif;
	do_move(ptr, RT0);
	call_or_chain_reg(RCHAIN, true)
enddefine;

define M_ERASE();
	lvars src = f_subv(2, m_instr), tmp;
	if auto_operand(src) then
		;;; NB: RZERO would be the obvious thing to use here, but it causes
		;;; problems with stack underflow in OSF.
		do_move(src, alloc_reg() ->> tmp);
		free_reg(tmp)
	endif
enddefine;


;;; --- ARITH INSTRUCTIONS ---------------------------------------------

lvars
	arith3_dst,
	arith3_use_lda = true,
	arith3_do_stkadjust = false,
;

define lconstant do_arith3(src2, src1, dst, op);
	lvars src2, src1, dst, storel, op, tmp, tmp1, tmp2, tmp3;

	define lconstant lda_add(src1, int2, dst);
		lvars src1, int2, dst;
		place_mf("lda", dst, int2, src1)
	enddefine;

	;;; first replace any cached address operand in ____src1
	;;; or ___dst so it's not overwritten by loading ____src2, etc
	get_cached_opnd(src1) -> src1;
	get_cached_opnd(dst) -> dst;

	;;; load src operands into registers

	if isintegral(src2) and src2 &&/=_0 -16:100
	and (op == OP_addW or op == OP_subW)
#_IF WORD_BITS==DOUBLE_BITS
	and integer_length(normalise_int(src2) ->> src2) < INT_BITS
	and (op /== OP_subW or integer_length(-src2) < INT_BITS)
#_ELSE
	and arith3_use_lda
#_ENDIF
	then
		(if op == OP_subW then -src2 else src2 endif, false);
		lda_add -> op		;;; N.B. "lda" is equivalent to "addq" not "addl"
	else
		load_src(false, src2, true)
	endif -> (src2, tmp2);

	load_src(false, src1, false) -> (src1, tmp1);

	if arith3_do_stkadjust then stack_adjust() endif;

	;;; get destination reg and possible store instruction
	tmp1 or tmp2 -> tmp;
	store_dst(tmp, dst, tmp) -> (storel, dst, tmp3);

	;;; place operation
	if isprocedure(op) then
		op(src1, src2, dst)
	else
		;;; __op is opcode
#_IF DEF OSF1
		if op == OP_mulW and isinteger(src2) then
			;;; pathetic assembler will not leave this instruction alone, so
			;;; plant it in binary

			define lconstant place_OPfL(op, func, src, lit, dst);
				lvars op, func, src, lit, dst, hex;
				(op<<26) || (regnumber(src)<<21) || (lit<<13) || 16:1000
						 || (func<<5) || regnumber(dst);
				radix_apply((), '0x%p', sprintf, 16) -> hex;
				place2([\.long], hex)
			enddefine;
			lconstant FUNC_mulW = #_IF WORD_BITS==DOUBLE_BITS 16:20
								  #_ELSE 16:00
								  #_ENDIF;
			place_OPfL(16:13, FUNC_mulW, src1, src2, dst)	;;; OP_MUL, FUNC_mulW
		else
			place4(op, src1, src2, dst)
		endif;
#_ELSE
		place4(op, src1, src2, dst)
#_ENDIF
	endif;

	;;; and store if necesary
	if storel then placel(storel) endif;

	dst -> arith3_dst;
	free_reg(tmp1); free_reg(tmp2); free_reg(tmp3);
enddefine;

define lconstant arith3_instr(op);
	lvars op;
	do_arith3(explode(m_instr), op) ->	/*Mpdr*/
enddefine;

define M_ADD	= arith3_instr(% OP_addW %)  enddefine;
define M_SUB	= arith3_instr(% OP_subW %)  enddefine;
define M_MULT	= arith3_instr(% OP_mulW %)  enddefine;
define M_BIS	= arith3_instr(% "bis" %)   enddefine;

define lconstant do_and(isbic);
	lvars isbic, (/*Mpdr*/, src2, src1, dst) = explode(m_instr), tmp;
	if isintegral(src2) then
		normalise_int(src2) -> src2;
		if integer_length(src2) <= 8 then
			if src2 < 0 then
				not(isbic) -> isbic;
				~~src2 -> src2
			endif
		else
			lvars b, bmask = 0, bit = 1;
			src2 -> tmp;
			repeat 8 times
				tmp && 16:FF -> b;
				if b == 16:FF then
					bmask || bit -> bmask
				elseif b /== 0 then
					false -> bmask;
					quitloop
				endif;
				tmp >> 8 -> tmp;
				bit << 1 -> bit
			endrepeat;
			if bmask then
				do_arith3(bmask, src1, dst, if isbic then "zap"
											else "zapnot"
											endif);
				return
			endif;
			if integer_length(src2) >= 16
			and integer_leastbit(~~src2 ->> tmp) >= 16 then
				not(isbic) -> isbic;
				tmp -> src2
			endif
		endif
	endif;
	do_arith3(src2, src1, dst, if isbic then "bic" else "and" endif)
enddefine;

define M_BIM	= do_and(% false %)  enddefine;
define M_BIC	= do_and(% true %) enddefine;

define M_NEG();
	lvars (, src, dst) = explode(m_instr);
	do_arith3(src, RZERO, dst, OP_subW)
enddefine;

define M_LOGCOM();
	lvars (, src, dst) = explode(m_instr);
	do_arith3(src, RZERO, dst, "ornot")
enddefine;

define lconstant ptr_arith_instr(op);
	lvars op;
	do_arith3(explode(m_instr), op) -> (/*Mpdr*/, /*type*/)
enddefine;

define M_PTR_ADD_OFFS	= ptr_arith_instr(% OP_addW %) enddefine;
define M_PTR_SUB_OFFS 	= ptr_arith_instr(% OP_subW %) enddefine;
define M_PTR_SUB		= ptr_arith_instr(% OP_subW %) enddefine;


define M_ASH();
	lvars (, shift, src, dst) = explode(m_instr), op, pre;

	define lconstant get_next_arith(src, dst);
		lvars	src, dst,
				nexti = f_hd(f_tl(m_codelist)), nextp = f_subv(1,nexti),
				nextppt = pdpart(nextp), op, nsrc1, nsrc2;
		if nextppt == ptr_arith_instr then
			explode(nexti);
			if (frozval(1,nextp) ->> op) == OP_addW then M_ADD else M_SUB endif
					-> subscr_stack(4);
			consvector(4) ->> nexti -> f_hd(f_tl(m_codelist));
			() ->
		elseunless nextppt == arith3_instr
		and (frozval(1,nextp) ->> op) == OP_addW or op == OP_subW then
			return(false)
		endif;
		returnunless(
			fast_lmember(dst, #_< [^WK_REG ^WK_ADDR_REG_1 ^WK_ADDR_REG_2] >_#)
			or f_subv(4,nexti) = dst
			) (false);
		f_subv(2,nexti) -> nsrc2;
		f_subv(3,nexti) -> nsrc1;
		if nsrc1 == dst then
			nsrc2
		elseif (op == OP_addW and nsrc2 == dst) then
			nsrc1
		else
			return(false)
		endif -> nsrc1;
		returnif(auto_operand(nsrc1) and auto_operand(src)
					and reg_in_operand(nsrc1) == reg_in_operand(src)) (false);
		nsrc1, f_subv(4,nexti), op;
		f_tl(f_tl(m_codelist)) -> f_tl(m_codelist);
		true
	enddefine;

	define lconstant varshift(src, shift_src, dst);
		lvars src, shift_src, dst, tmp1 = alloc_reg(), tmp2 = alloc_reg();
		place3(OP_negW, shift_src, tmp1);
		place4("sra", src, tmp1, tmp2);
		place4("sll", src, shift_src, dst);
		place4("cmovgt", tmp1, tmp2, dst);
		free_reg(tmp1);
		free_reg(tmp2);
	enddefine;

	if isinteger(shift) then
		if (shift == 2 or shift == 3) and get_next_arith(src, dst) then
			if shift == 2 then "s4" else "s8" endif -> pre;
			-> (shift, dst, op);
			pre <> op
		elseif shift fi_< 0 then
			-shift -> shift;
			"sra"
		else
			"sll"
		endif
	else
		varshift
	endif -> op;
	do_arith3(shift, src, dst, op)
enddefine;


;;; --- POP ARITHMETIC ------------------------------------------------

define lconstant do_parith3(src2, src1, dst, op, ovf_test, lab);
	lvars n, src2, src1, dst, op, ovf_test, lab, general = false, treg;

	define lconstant parith(src1, src2, dst);
		lvars src1, src2, dst, tmp1 = false;
		if general then
			place4("bic", src2, POPINT0, alloc_reg()->>tmp1->>src2)
		endif;
		if ovf_test then
			alloc_reg() -> treg;				;;; overflow test result
#_IF WORD_BITS==DOUBLE_BITS
			lvars tmp2 = false;
			if src1 == dst then
				place3("mov", src1, alloc_reg()->>tmp2->>src1)
			endif;
			;;; Result overflowed if
			;;; 	(signbit(____src1) LOGICAL EQUIV/DIFF signbit(____src2))
			;;; 	AND (signbit(____src1) LOGICAL DIFF signbit(______result))
			;;; is 1, i.e. negative
			if isinteger(src2) then
				;;; optimise for ____src2 a +ve integer
				place4(op, src1, src2, dst);		;;; the result
				;;; overflow if this is neg
				place4("bic", if op==OP_addW then dst, src1
							  else src1, dst
							  endif, treg);
			else
				place4(if op==OP_addW then "xornot" else "xor" endif,
												src1, src2, treg);
				place4(op, src1, src2, dst);		;;; the result
				place4("xor", src1, dst, tmp1 or (alloc_reg()->>tmp1));
				place4("and", treg, tmp1, treg);	;;; overflow if this is neg
			endif;
			free_reg(tmp2)
#_ELSE
			place4(if op==OP_addW then "addq" else "subq" endif, src1, src2,
												treg);
			place4(op, src1, src2, dst);
			place4("cmpeq", dst, treg, treg)
#_ENDIF
		else
			place4(op, src1, src2, dst)
		endif;
		free_reg(tmp1)
	enddefine;

	if isintegral(src2) then
		src2 - POPINT0 -> src2
	elseif isintegral(src1) then
		if op == OP_subW then
			;;; subtracting
			src1 + POPINT0 -> n;
			if src1 > 0 and integer_length(n) fi_>= WORD_BITS then
				;;; adding tags to it overflows
				true -> general
			else
				n -> src1
			endif
		else
			;;; adding
			src1 - POPINT0 -> src1
		endif
	else
		true -> general
	endif;

	if ovf_test or general then
		do_arith3(src2, src1, dst, parith)
	else
#_IF WORD_BITS /== DOUBLE_BITS
		;;; "lda" is equivalent to "addq" -- dangerous if ___dst a register
		;;; since it could produce an unnormalised long result
		if isreg(dst) then dlocal arith3_use_lda = false; endif;
#_ENDIF
		do_arith3(src2, src1, dst, op)
	endif;

	if ovf_test then
		place_test(ovf_test, treg, lab);
		free_reg(treg)
	endif
enddefine;

define lconstant parith3_instr(op);
	lvars op;
	do_parith3(explode(m_instr), op, false, false) -> /*Mpdr*/
enddefine;

define M_PADD	= parith3_instr(% OP_addW %) enddefine;
define M_PSUB	= parith3_instr(% OP_subW %) enddefine;

define lconstant parith_test_instr(op);
	lvars test, lab, op;
	do_parith3(explode(m_instr) -> (test, lab), -_USP, op, test, lab)
											-> /*Mpdr*/
enddefine;

define M_PADD_TEST	= parith_test_instr(% OP_addW %) enddefine;
define M_PSUB_TEST	= parith_test_instr(% OP_subW %) enddefine;


;;; --- COMPARE INSTRUCTIONS --------------------------------------------

define lconstant do_test(src, test, lab);
	lvars src, test, lab, tmp;
	load_src(false, src, false) -> (src, tmp);
	place_test(test, src, lab);
	free_reg(tmp)
enddefine;

define M_TEST();
	do_test(explode(m_instr)) -> /*Mpdr*/
enddefine;

define lconstant do_arith_test(src2, src1, test, lab, op);
	lvars src2, src1, test, lab, op, unsigned;
	if op == "cmp" then
		if isintegral(src1) then
			(src1, src2) -> (src2, src1)
		else
			commute_test(test) -> test
		endif;
		test(1) == `U` -> unsigned;
		if not(unsigned) and isintegral(src2) and src2 &&/=_0 -16:100
#_IF WORD_BITS==DOUBLE_BITS
		and (test=="EQ" or test=="NEQ")		;;; only for these with quad words
#_ELSE
		and normalise_int(-src2) /= normalise_int(src2)
#_ENDIF
		then
			;;; signed comparison with large int -- use "lda" subtract
			;;; (which is quad and can't overflow with int words)
			OP_subW
		elseif src2 == 0 and not(unsigned) then
			chain(src1, test, lab, do_test)
		else
			dlocal test_opcode = cmp_opcode;
			f_subv(1,cmp_opcode(test))
		endif -> op
	elseif src2 == 1 and op == "and" then
		chain(src1, if test=="EQ" then "LBC" else "LBS" endif, lab, do_test)
	endif;

	if mem_access_type(src1) or mem_access_type(src2) then
		dlocal arith3_do_stkadjust = true;
	endif;
	do_arith3(src2, src1, RZERO, op);
	place_test(test, arith3_dst, lab)
enddefine;

define M_CMP();
	do_arith_test(explode(m_instr), "cmp") -> /*Mpdr*/
enddefine;

define M_PCMP	= M_CMP enddefine;		;;; compare popints is the same

define lconstant do_bit_test(src2, src1, test, lab);
	lvars src2, src1, test, lab, shift, n, op = "and", acctype;

	define lconstant shiftest(src1, src2, dst);
		lvars src1, src2, dst;
		place4("sra", src1, shift, dst);
		place4("and", dst, src2, dst)
	enddefine;

	if isintegral(src2) then
		mem_access_type(src1) -> acctype;
		if acctype == T_SHORT and src2 &&=_0 16:FF then
			src2 >> 8 -> src2;
			cons_access_opnd((explode(src1) ->)+1, T_BYTE) -> src1
#_IF WORD_BITS==DOUBLE_BITS
		elseif acctype == T_INT then
			src2 &&~~ #_< -1<<INT_BITS >_# -> src2;
			cons_access_opnd((explode(src1) ->), T_SGN_INT) -> src1
#_ENDIF
		endif
	endif;

	if isintegral(src2) and src2 > 16:FF
	and (integer_leastbit(src2) -> shift, (src2 >> shift ->> n) <= 16:FF)
	then
		if n == 1 then
			if test=="EQ" then "LBC" else "LBS" endif -> test;
			"sra", shift
		else
			shiftest, n
		endif -> (op, src2)
	endif;
	do_arith_test(src2, src1, test, lab, op)
enddefine;

define M_BIT();
	do_bit_test(explode(m_instr)) -> /*Mpdr*/
enddefine;

	;;; compare pointers -- same as integers for all types
define M_PTR_CMP();
	M_CMP() -> /* Mpdr, type already erased */
enddefine;

define M_CMPKEY();
	lvars	(, key, src, test, lab) = explode(m_instr), tlab, key_opnd,
			tmp1, tmp2, wasmem;

	if test == "EQ" then genlab() else lab endif -> tlab;
	unless isintegral(key) then get_cached_opnd(key) -> key endunless;
	mem_access_type(src) -> wasmem;
	load_src(false, src, false) -> (src, tmp1);
	if wasmem then stack_adjust() endif;
	do_arith_test(1, src, "NEQ", tlab, "and");

	cons_access_opnd(src, field_##("KEY").wof, T_WORD) -> key_opnd;

	if isintegral(key) then
		;;; testing flag(s) nonzero in K_FLAGS field
		load_src(tmp1, key_opnd, false) -> (src, tmp2);
		do_bit_test(key,
			cons_access_opnd(src, field_##("K_FLAGS")*INT_OFFS, T_INT),
											negate_test(test), lab);
		free_reg(tmp2)
	else
		;;; test for specific key
		do_arith_test(key, key_opnd, test, lab, "cmp")
	endif;
	free_reg(tmp1);
	if test == "EQ" then place_label(tlab) endif
enddefine;


;;; --- OTHER BRANCH INSTRUCTIONS -------------------------------------

define M_BRANCH();
	stack_adjust();
	place2(OP_br, f_subv(2, m_instr))
enddefine;

	;;; Branch instruction of standard size
define M_BRANCH_std();
	place2(OP_br, f_subv(2, m_instr))
enddefine;

define lconstant do_branch_on(isint);
	lvars	isint, lim, src, srctmp, tmp1 = alloc_reg(), tmp2 = alloc_reg(),
			afterlab = genlab(), pclab = genlab(), lab, base_subscr, base,
			lablist = f_subv(3,m_instr), org_src;

	if isint then 4 else 5 endif -> base_subscr;
	if datalength(m_instr) == base_subscr then
		f_subv(base_subscr,m_instr)
	else
		1
	endif -> base;

	load_src(false, f_subv(2,m_instr), false) -> (src, srctmp);
	src -> org_src;
	stack_adjust();
	unless 0 <= base and base <= 4 then
		do_arith3(if isint then base else base<<WORD_SHIFT endif, src,
								tmp1 ->> src, OP_subW);
		0 -> base
	endunless;

	listlength(lablist)+base-1 -> lim;
	unless isint then popint(lim) -> lim endunless;
	do_arith3(lim, src, RZERO, "cmpule");

#_IF DEF VMS
	place1([\.begin_exact]);
#_ENDIF
	place3(OP_br, tmp2, pclab);					;;; addr of pclab in tmp2
	place_label(pclab);

	;;; 4-5 instructions after pclab
#_IF WORD_BITS==DOUBLE_BITS
	if isint then
		place4("s4addq", src, 4*4, tmp1)
	else
		place4("sra", src, 1, tmp1);
		place4("addq", tmp1, 5*4, tmp1)
	endif;
#_ELSE		;;; 2
	place4(if isint then "s4addq" else "addq" endif, src, 4*4, tmp1);
#_ENDIF
	place3([blbc], arith3_dst, afterlab);		;;; br if out of range
	place4("addq", tmp1, tmp2, tmp1);
	place3(OP_jmp, RZERO, consregacc(tmp1, NO_OFFSET));		;;; ignores bits 0,1

	;;; first the branches for trapping arg values < ____base
	until base == 0 do
		place2(OP_br, afterlab);
		base-1 -> base
	enduntil;
	;;; now the ones for the allowable values
	for lab in lablist do place2(OP_br, lab) endfor;

#_IF DEF VMS
	place1([\.end_exact]);
#_ENDIF

	place_label(afterlab);

	unless isint or f_subv(4,m_instr) then
		;;; if popint with no "else" label, push arg back onto stack
		;;; (as argument to error procedure)
		do_move(org_src, -_USP)
	endunless;
	free_reg(srctmp); free_reg(tmp1); free_reg(tmp2);
enddefine;

define M_BRANCH_ON		= do_branch_on(% false %) enddefine;
define M_BRANCH_ON_INT	= do_branch_on(% true %) enddefine;


;;; --- CALL INSTRUCTIONS ------------------------------------------------

define lconstant pop_call_or_chain(iscall);
	lvars src = f_subv(2,m_instr), iscall, lab, tmp, xoffs;
	if isref(src) then
		;;; constant
		fast_cont(src) -> src;
		execlabof(src, true) -> lab;
		if islabel(src) &&/=_0 LAB_OF_STRUCT then
			;;; defined in current file
			load_literal(PB, src);
			stack_adjust();
			if iscall then place3(OP_bsr, RRET, lab)
			else place2(OP_br, lab)
			endif;
			dealloc_dummy_reg();
			return
		endif;

		load_literal(alloc_reg()->>tmp, lab);
		load_literal(PB, src);

	else
		alloc_reg() -> tmp;
		field_##("PD_EXECUTE").wof -> xoffs;
		if isreg(src) then
			place_mf(OP_ldW, tmp, xoffs, trans_reg(src,false));
			do_move(src, PB)
		else
			do_move(src, PB);
			place_mf(OP_ldW, tmp, xoffs, PB)
		endif
	endif;
	call_or_chain_reg(tmp, iscall);
	free_reg(tmp)
enddefine;

define M_CALL	= pop_call_or_chain(% true %)  enddefine;

define M_CHAIN();
	;;; musn't use rret as a temporary (if closure_frozlist is a list then
	;;; rret is already excluded)
	unless closure_frozlist then
		dealloc_dummy_reg(); exclude_reg(RRET)
	endunless;
	pop_call_or_chain(false);
	unless closure_frozlist then free_reg(RRET) endunless
enddefine;

	;;; {M_CALL_WITH_RETURN ________pdr-opnd ___________return-addr}
define M_CALL_WITH_RETURN();
	do_move(f_subv(3,m_instr), RRET);		;;; set return address in rret
	M_CHAIN()								;;; chain to procedure
enddefine;

define lconstant subroutine_call(src, excl_rt0);
	lvars src, excl_rt0, tmp;
	if excl_rt0 then
		;;; has an arg in rt0
		dealloc_dummy_reg(); exclude_reg(RT0)
	endif;
	load_src(false, src, false) -> (src, tmp);
	call_or_chain_reg(src, true);
	free_reg(tmp);
	if excl_rt0 then free_reg(RT0) endif
enddefine;

	;;; {M_CALLSUB  _______________subroutine_opnd  _________________________upto-3-args-to-go-in-regs}
	;;; (subroutine is always a constant when reg args present, but
	;;; may be an SVB operand)
define M_CALLSUB();
	lvars l = datalength(m_instr);
	if l == 5 then
		do_move(f_subv(3,m_instr), RT2)							;;; arg_reg_2
	endif;
	if l fi_>= 4 then do_move(f_subv(l-1,m_instr), RT1) endif;	;;; arg_reg_1
	if l fi_>= 3 then do_move(f_subv(l,  m_instr), RT0) endif;	;;; arg_reg_0
	subroutine_call(f_subv(2,m_instr), l fi_>= 3)
enddefine;

define M_CHAINSUB();
	lvars src, tmp;
	;;; musn't use rret as a temporary
	dealloc_dummy_reg(); exclude_reg(RRET);

	load_src(false, f_subv(2,m_instr), false) -> (src, tmp);
	;;; restore caller's pb from SF_OWNER
	place_mf(OP_ldW, PB, field_##("SF_OWNER").wof, SP);
	call_or_chain_reg(src, false);
	free_reg(tmp);
	free_reg(RRET)
enddefine;

define M_LABEL();
	stack_adjust();
	dealloc_dummy_reg();
	OP_label -> f_subv(1,m_instr);
	placei(m_instr)
enddefine;


;;; --- SPECIAL INSTRUCTIONS --------------------------------------------

	;;; {M_CLOSURE ________frozvals ___________pdpart-opnd}
define M_CLOSURE();
	lvars	f, l, offs, (, frozvals, pdpart_opnd) = explode(m_instr),
			nfroz = listlength(frozvals);

	;;; M-code to push frozvals and call pdpart.
	;;; If closure is non-writeable, ___________pdpart_opnd
	;;; is an immediate operand for the pdpart procedure.

	[%	if nfroz fi_> 16 then
			;;; just give clos to Exec_closure
			{% M_MOVE, PB, -_USP %};
			perm_constp_opnd([Sys Exec_closure], false) -> pdpart_opnd
		elseif pdpart_opnd then
			;;; closure non-writeable, can bypass stored frozvals
			exclude_reg(RRET);		;;; MUSTN'T use rret in the moves
			frozvals -> closure_frozlist;
			fast_for f in frozvals do
				unless isintegral(f) then
					if fast_=_lmember(f, unique_labels) ->> l then
						f_hd(f_tl(l))
					else
						consref(f)
					endif -> f
				endunless;
				{% M_MOVE, f, -_USP %}
			endfor
		else
			;;; must use stored frozvals
			field_##("PD_CLOS_FROZVALS").wof -> offs;
			fast_repeat nfroz times
				{% M_MOVE, consregacc(PB, offs), -_USP %};
				offs+WORD_OFFS -> offs
			endrepeat;
			consregacc(PB, field_##("PD_CLOS_PDPART").wof) -> pdpart_opnd
		endif;
		{% M_CHAIN, pdpart_opnd %}
	%] -> l;
	f_hd(l) ->> m_instr -> f_hd(m_codelist);
	f_tl(l) nc_<> f_tl(m_codelist) -> f_tl(m_codelist);
	chain(f_subv(1, m_instr))
enddefine;

	;;; {M_SETSTKLEN  ________________________offset-of-stack-increase  ___________________popint-saved-stklen}
	;;; ______offset is always a constant integer
define M_SETSTKLEN();
	lvars (, offs, sl_opnd) = explode(m_instr), lab;
	dlocal arith3_do_stkadjust = true;

	;;; _userhi - ___________________popint-saved-stklen -> rt0
	do_arith3(sl_opnd, perm_var_opnd([\^_userhi]), RT0, OP_subW);
	;;; rt0 - (______offset-POPINT0) -> rt0 = desired value of USP
	;;; (-POPINT0 accounts for the popint bits in _______sl_opnd)
	do_arith3(offs-POPINT0, RT0, RT0, OP_subW);
	do_arith3(USP, RT0, RT1, OP_subW);		;;; rt0 - USP -> rt1 = diff
	;;; branch around call if rt1 zero
	place_test("EQ", RT1, genlab()->>lab);
	;;; else call _setstklen_diff with args in rt0, rt1
	subroutine_call(perm_const_opnd([\^_setstklen_diff]), true);
	place_label(lab)
enddefine;

	;;; {M_CALL_PAL _______op-name}
define M_CALL_PAL();
	place2([call_pal], f_subv(2,m_instr))
enddefine;


;;; --- PROLOG INSTRUCTIONS ----------------------------------------------

	;;; {M_PLOG_IFNOT_ATOM _________ifnot-lab}
	;;; (follows a call of _prolog_unify_atom)
define M_PLOG_IFNOT_ATOM();
	place_test("LBC", RT1, f_subv(2,m_instr))
enddefine;

	;;; {M_PLOG_TERM_SWITCH  ________fail-lab  _______var-lab  ______________________dst-for-drop-thru-case}
	;;; (follows a call of _prolog_pair_switch/ _prolog_term_switch)
define M_PLOG_TERM_SWITCH();
	place_test("NEG", RT1, f_subv(3,m_instr));	;;; _______var-lab if negative
	place_test("LBC", RT1, f_subv(2,m_instr));	;;; ________fail-lab if bit0 zero
	;;; else deref'ed pair/term in arg_reg_0 (rt0)
	move_rt0_result(f_subv(4,m_instr))
enddefine;


;;; --- ENTRY/EXIT CODE --------------------------------------------------

lblock

lvars
	Ndlocal, Nreg, Npopreg, Nstkvar, Npopstkvar, dlocal_labs, frame_offs
	;

define lconstant sr_reg_code(op, spoffs) -> spoffs;
	lvars op, spoffs;

	define lconstant sr_regs(n, rlist, spoffs) -> spoffs;
		lvars rlist = fast_back(rlist), n, spoffs;
		while n > 0 do
			place_mf(op, reglabel(fast_subscrl(n,rlist)), spoffs, SP);
			n-1 -> n;
			spoffs+WORD_OFFS -> spoffs
		endwhile
	enddefine;

	;;; pop regs
	sr_regs(Npopreg, pop_registers, spoffs) -> spoffs;
	;;; nonpop regs
	sr_regs(Nreg-Npopreg, nonpop_registers, spoffs) -> spoffs
enddefine;

	;;; {M_CREATE_SF __________reg-locals  _______Npopreg  ________Nstkvars  ___________Npopstkvars
	;;;								___________dlocal-labs  ______________ident-reg_spec }
	;;; Generate code to construct stack frame -- this sets up values
	;;; to be used by later M_UNWIND_SF.
define M_CREATE_SF();
	lvars	n, spoffs, pboffs, reg_locals, reg_spec_id;

	explode(m_instr) -> (, reg_locals, Npopreg, Nstkvar, Npopstkvar,
							dlocal_labs, reg_spec_id);

	listlength(reg_locals) -> Nreg;
	listlength(dlocal_labs) -> Ndlocal;

	;;; register spec in PD_REGMASK is switch offset to within TNP+1 blocks
	;;; of cascaded instructions which store/load the pop registers and then
	;;; branch to store/load the corresponding nonpop registers. Each block is
	;;; TP*2+1 instructions. (See aprocess.s)
	lconstant
		TNP		= listlength(nonpop_registers)-1,
		TP		= listlength(pop_registers)-1,
		PBLKLEN = TP*2 + 1;

	( (TNP-(Nreg-Npopreg))*PBLKLEN + (TP-Npopreg)*2
			+ 3			;;; 3 instrs from pc label to regcode
	) * 4 -> idval(reg_spec_id);


	wof(field_##("SF_LOCALS")) -> spoffs;
	spoffs fi_+ wof(Nstkvar fi_+ Ndlocal fi_+ Nreg
						fi_- field_##("SF_RETURN_ADDR")) -> frame_offs;

	;;; decrement sp for stack frame
	place_mf("lda", SP, -frame_offs, SP);

	;;; save my address
	place_mf(OP_stW, PB, 0, SP);

	;;; skip nonpop stack lvars
	spoffs + wof(Nstkvar-Npopstkvar) -> spoffs;

	;;; initialise pop stack lvars to popint 0
	if Npopstkvar /== 0 then
		place3("mov", popint(0), RT0);
		repeat Npopstkvar times
			place_mf(OP_stW, RT0, spoffs, SP);
			spoffs+WORD_OFFS -> spoffs
		endrepeat
	endif;

	;;; save dynamic local identifiers
	Ndlocal -> n;
	wof(field_##("PD_TABLE")+n) -> pboffs;
	while n > 0 do
		pboffs-WORD_OFFS -> pboffs;
		place_mf(OP_ldW, RT0, pboffs, PB);
		if n == 1 then
			place_mf(OP_ldW, RT0, 0, RT0);		;;; ID_VALOF
			place_mf(OP_stW, RT0, spoffs, SP);
			n-1 -> n
		else
			pboffs-WORD_OFFS -> pboffs;
			place_mf(OP_ldW, RT1, pboffs, PB);
			place_mf(OP_ldW, RT0, 0, RT0);		;;; ID_VALOF
			place_mf(OP_ldW, RT1, 0, RT1);		;;; ID_VALOF
			place_mf(OP_stW, RT0, spoffs, SP);
			spoffs+WORD_OFFS -> spoffs;
			place_mf(OP_stW, RT1, spoffs, SP);
			n-2 -> n
		endif;
		spoffs+WORD_OFFS -> spoffs
	endwhile;

	;;; save registers
	sr_reg_code(OP_stW, spoffs) -> spoffs;

	;;; save caller's return
	place_mf(OP_stW, RRET, spoffs, SP);
enddefine;

	;;; {M_UNWIND_SF}
	;;; generate code to unwind stack frame (musn't use CHAIN_REG = g1)
	;;; Uses lvar dlocal_labs set up by previous M_CREATE_SF
define M_UNWIND_SF();
	lvars	n, spoffs = wof(field_##("SF_LOCALS")+Nstkvar), pboffs;

	;;; restore dynamic local identifiers
	Ndlocal -> n;
	wof(field_##("PD_TABLE")+n) -> pboffs;
	while n > 0 do
		pboffs-WORD_OFFS -> pboffs;
		place_mf(OP_ldW, RT0, pboffs, PB);
		place_mf(OP_ldW, RT1, spoffs, SP);
		spoffs+WORD_OFFS -> spoffs;
		if n == 1 then
			place_mf(OP_stW, RT1, 0, RT0);		;;; ID_VALOF
			n-1 -> n
		else
			pboffs-WORD_OFFS -> pboffs;
			place_mf(OP_ldW, RT2, pboffs, PB);
			place_mf(OP_ldW, RT3, spoffs, SP);
			spoffs+WORD_OFFS -> spoffs;
			place_mf(OP_stW, RT1, 0, RT0);		;;; ID_VALOF
			place_mf(OP_stW, RT3, 0, RT2);		;;; ID_VALOF
			n-2 -> n
		endif
	endwhile;

	;;; restore registers
	sr_reg_code(OP_ldW, spoffs) -> spoffs;

	;;; restore caller's return
	place_mf(OP_ldW, RRET, spoffs, SP);

	;;; increment sp to erase stack frame
	place_mf("lda", SP, frame_offs, SP)
enddefine;

endlblock;


	;;; return from procedure
define M_RETURN();
	;;; restore caller's pb from SF_OWNER
	place_mf(OP_ldW, PB, field_##("SF_OWNER").wof, SP);
	stack_adjust();
	;;; return to rret
	place3(OP_ret, RZERO, consregacc(RRET, NO_OFFSET));
	dealloc_dummy_reg()
enddefine;

	;;; end of code
define M_END = identfn(%%) enddefine;


	;;; translate M-code to Alpha assembler
define lconstant code_trans(m_clist) -> (instr_list, new_literals);
	lvars	opcode, m_clist;
	dlocal	m_codelist, m_instr, instr_list, last_ipair,
			curr_stack_diff	= 0, new_literals = [], closure_frozlist = false;

	;;; start of code label
	[{^OP_label ^current_pdr_exec_label}] ->> instr_list -> last_ipair;
#_IF DEF VMS
	place3([\.base], PB, current_pdr_label);
#_ENDIF
	init_reg();
	for m_codelist on m_clist do
		f_hd(m_codelist) -> m_instr;
		if isprocedure(f_subv(1,m_instr) ->> opcode) then
			set_litreg_unused();
			opcode()
		else
			mishap(opcode, 1, 'UNKNOWN M-OPCODE')
		endif
	endfor;
enddefine;

;;; ------------------------------------------------------------------------

define lconstant code_optimise(codelist) -> codelist;
	lvars	codelist, lastl, lastop = false, l, instr, op, lsrc1, lsrc2, ldst,
			raddr, rval;

	define lconstant operands(i) -> (src1, src2, dst);
		lvars i, src1, src2 = false, dst, op = f_subv(1,i);
		if fast_lmember(op, #_< [^OP_ldl ^OP_ldq ^OP_stl ^OP_stq lda ldah] >_#)
		then
			explode(i) -> (, dst, src1);
			if isvector(src1) then f_subv(1,src1) else PB endif -> src1
		elseif datalength(i) == 3 then
			explode(i) -> (, src1, dst);
			unless isword(src1) then false -> src1 endunless
		else
			explode(i) -> (, src1, src2, dst);
			unless isword(src2) then false -> src2 endunless
		endif
	enddefine;

	fast_for l on codelist do
		f_hd(l) -> instr;
		f_subv(1,instr) -> op;
		;;; try to move a preceding arith instruction or store to after
		;;; a load (move a store only if load is off PB)
		if (op==OP_ldl or op==OP_ldq)
		and (isword(lastop) or lastop==OP_stl or lastop==OP_stq)
		then
			operands(f_hd(lastl)) -> (lsrc1, lsrc2, ldst);
			operands(instr) -> (raddr, , rval);
			if (isword(lastop) or raddr == PB)
			and ldst /== raddr and ldst /== rval
			and lsrc1 /== rval and lsrc2 /== rval
			then
				;;; move
				f_hd(lastl), instr -> (f_hd(l), f_hd(lastl));
				false -> lastop;
				nextloop
			endif
		endif;
		l -> lastl; op -> lastop
	endfor
enddefine;

;;; --- GENERATE OUTPUT CODE -----------------------------------------------

define lconstant outopnd(opnd, opcode, comment) -> comment;
	lvars opnd, reg, dis, opcode, comment;
	if isintegral(opnd) then
		opnd, '%p'
	elseif isaccess(opnd) then
		f_subv(1,opnd) -> reg;
		f_subv(2,opnd) -> dis;
		if dis == NO_OFFSET then reg, '(%p)' else reg, dis, '%p(%p)' endif
#_IF not(DEF VMS)
	elseif isref(opnd) then
		fast_cont(opnd) -> comment;
		PB, asm_label_diff(comment, current_pdr_label), '%p(%p)'
#_ENDIF
	else
		opnd, '%p'
;;;		mishap(opnd, 1, 'INVALID OPERAND FOR outopnd')
	endif;
	asmf_printf()
enddefine;

define lconstant outinst(inst);
	lvars n, l, op, inst, comment = false;
	f_subv(1,inst) -> op;
	if op == OP_label then outlab(f_subv(2,inst)); return endif;
	if ispair(op) then f_hd(op) -> op endif;
	asmf_printf(op, '\t%p\t');
	datalength(inst) -> l;
	fast_for n from 2 to l fi_- 1 do
		outopnd(f_subv(n, inst), op, comment) -> comment;
		asmf_charout(`,`), asmf_charout(`\s`)
	endfor;
	unless l == 1 then
		outopnd(f_subv(l, inst), op, comment) -> comment
	endunless;
#_IF DEF VMS
	asmf_charout(`\n`);
#_ELSE
	if comment then asmf_printf(comment, '\t# %p') endif;
	asmf_charout(`\n`);
	subscrv(current_asm_segment,asm_seg_offsets) fi_+ 4
				-> subscrv(current_asm_segment,asm_seg_offsets)
#_ENDIF
enddefine;


;;; --- GENERATING CODE ------------------------------------------------

	/*	Generate assembler code for a procedure -- called by m_trans
		The global variables

			current_pdr_label, current_pdr_exec_label

		contain the current procedure's label and start-of-code label
		_______hdr_len is the length in words preceding the code.
	*/
define mc_code_generator(codelist, hdr_len) -> (gencode, pdr_len);
	lvars codelist, hdr_len, pdr_len, new_lits;
	lconstant procedure gencode;

	unless unique_labels then
		[%	symlabel("false"), false_immediate,
			symlabel("true"), true_immediate,
			symlabel("nil"), nil_immediate
		%] -> unique_labels
	endunless;

	;;; process codelist
	code_trans(codelist) -> (codelist, new_lits);	;;; translate to assembler
	code_optimise(codelist) -> codelist;

	;;; expression for procedure header length in words
	hdr_len + listlength(new_lits) -> pdr_len;

	;;; code generator
	define lconstant gencode();
		lvars lit, lab;
		fast_for lit in new_lits do
			asm_outlab(pdr_literal_label(lit));
			asm_outword(lit, 1)
		endfor;

		ASMSEG_CODE -> current_asm_segment;
		asm_startinstr();
		applist(codelist, outinst);			;;; produce output code
		asm_align_double()
	enddefine
enddefine;


;;; --- OTHER DEFINITIONS NEEDED BY m_trans.p ---------------------------


	/*	M-code tables for machine-dependent in-line subroutines.
		These are added to the corresponding properties in m_trans.p
	*/
constant

	mc_inline_procs_list = [
	[ \^_ptr_to_offs	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_offs_to_ptr	[{^M_ERASE ^USP_+}]]		;;; erases type, leaves ptr
	[ \^_int			[{^M_ASH ^(-WORD_SHIFT) ^USP_+ ^ -_USP}]]
	[ \^_pint			[{^M_ASH ^WORD_SHIFT ^USP_+ ^ -_USP}
						 {^M_ADD 2:11 ^USP_+ ^ -_USP}]]
	[ \^_por			[{^M_BIS ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_pand			[{^M_BIM ^USP_+ ^USP_+ ^ -_USP}]]
	[ \^_mksimple		[{^M_ADD 2:01 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound		[{^M_SUB 2:01 ^USP_+ ^ -_USP}]]
	[ \^_mksimple2		[{^M_ADD 2:11 ^USP_+ ^ -_USP}]]
	[ \^_mkcompound2	[{^M_SUB 2:11 ^USP_+ ^ -_USP}]]

	[ %"ident $-Sys$- \^_cache_flush"%
						[{^M_CALL_PAL
							%#_IF DEF VMS "imb" #_ELSE 16:86 #_ENDIF%}]]

	],

	mc_inline_conditions_list = [
	[ \^_iscompound		{^M_BIT  2:01   ^USP_+ EQ  ?}	]
	[ \^_issimple		{^M_BIT  2:01   ^USP_+ NEQ ?}	]
	[ \^_issimple2		{^M_BIT	 2:10	^USP_+ NEQ ?}	]
	[ \^_isinteger		{^M_BIT  2:10   ^USP_+ NEQ ?}	]
	[ \^_isaddress		{^M_BIT  ^(WORD_OFFS-1) ^USP_+ EQ  ?}	]
	],
;


	/*	Procedure to convert a pop integer subscript to an appropriate offset
		for the data type being accessed, used by OP_SUBV in m_trans.p to
		compile code for fast_subscrv, vectorclass field accesses, etc.
			_____scale is the scale for the data type involved; the results are
		the M-code instructions (if any) necessary to convert the subscript
		on top of the stack to an offset, plus a constant correction to be
		added.
	*/
define cvt_pop_subscript(scale);
	lvars pow, scale;
	if is_power2(scale) ->> pow then
		;;; pow-WORD_SHIFT accounts for popint being shifted left by WORD_SHIFT
		unless (pow-WORD_SHIFT ->> pow) == 0 then
			{^M_ASH ^pow ^USP_+ ^ -_USP}
		endunless,
		-(POPINT0 << pow)	;;; additive correction to remove popint bits
	else
		;;; just convert to sysint and multiply
		{^M_ASH ^(-WORD_SHIFT) ^USP_+ ^ -_USP},		;;; _int()
		{^M_MULT ^scale ^USP_+ ^ -_USP},
		0 						;;; no correction necessary
	endif
enddefine;


endsection;		/* Genproc */

endsection;		/* $-Popas$-M_trans */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 24 1996
		Changed M_BRANCH_ON(_INT) to work with BRANCH_ON_ALLOWS_BASE true.
--- John Gibson, Oct 11 1996
		Changed M_ERASE to use a temp reg instead of RZERO (see comment).
		Also fixed stupid bug in code_optimise.
--- John Gibson, Aug 11 1995
		_cache_flush into section $-Sys
--- John Gibson, Aug  3 1995
		Fixed nasty problem where M_CLOSURE instructions to push (>= 6)
		frozvals as literals could use rret as a temporary
--- John Gibson, Apr  3 1995
		Lots of changes for Alpha OSF 64-bit system
--- John Gibson, Mar  3 1995
		Allows for T_INT_DOUBLE operand type
--- John Gibson, Feb  6 1995
		Changes for OSF
 */
