/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 > File:		S.axposf/src/syscomp/sysdefs_linux_elf.p
 > Purpose:		Definitions for machine & operating system (Alpha/Linux ELF)
 > Author:		John Gibson, Jan 16 1999
 */


section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; === SYSTEM NAME ====================================================


	MACHINE			= [[alpha]],

	ALPHA_LINUX		= true,


;;; === PROCESSOR  =====================================================


	PROCESSOR		= [[alpha]],
	ALPHA           = true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary
	WORD_BITS       = 64,



;;; === OPERATING SYSTEM (UNIX BSD) ==================================


	UNIX			= true,
	BERKELEY		= 4.3,
	LINUX			= 2.0,
	LINUX_ELF		= true,
	POSIX1			= 199309,
	OPERATING_SYSTEM = [[unix linux ^LINUX elf posix {^POSIX1}]],

	BSD_MMAP        = true,         ;;; has mmap and mprotect facilities
	BSD_MPROTECT    = true,

	SHARED_LIBRARIES = true,

	;;; Size of a virtual page (from "pagesize(1)")
	VPAGE_OFFS      = 16:2000,

	;;; Lowest address for pop system code (high limit is assumed to be etext)
	LOWEST_CODE_ADDRESS = 16:120000000,

	;;; Top of stack segment
	UNIX_USRSTACK	= 16:20000000,

	;;; Procedures to get and set the memory break and return the REAL end of
	;;; memory. (We always need the real end to ensure that the end of the
	;;; user stack is always at the true end of memory, so that user stack
	;;; underflow produces a memory access violation.)

	GET_REAL_BREAK =
		[procedure(); _extern sbrk(_0)@(b.r->vpage) endprocedure],

	SET_REAL_BREAK =
		[procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif
		endprocedure],


;;; === OTHER =========================================================

	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar	0 1 _prolog_newvar]
			[datakey		1 1 _datakey]
			[prolog_deref	1 1 _prolog_deref]
			[conspair		2 1 _conspair]
		]],

	 ;;; if GEN_SVB_CONSTANTS is true, constants in _special_var_block will be
	 ;;; generated by Poplink, and recognised in the production of M-code
	 ;;; operands by Popc (providing genproc.p defines SPECIAL_VAR_BLOCK_REG).

	 GEN_SVB_CONSTANTS   = true,

);

define :inline CACHEFLUSH(_ptr, _nbytes);
	$-Sys$- _cache_flush()		;;; compiles to 'call_pal imb'
enddefine;

endsection;		/* $- */
