/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.axposf/src/syscomp/sysdefs_osf.p
 > Purpose:
 > Author:          John Gibson, Feb  3 1995 (see revisions)
 */
compile_mode :pop11 +strict;

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM

--------------------------------------------------------------------------*/

section;

constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; -- SYSTEM NAME --------------------------------------------------------

	MACHINE			= [[alpha]],
	ALPHA_OSF1		= true,


;;; --- PROCESSOR = ALPHA -------------------------------------------------

	PROCESSOR		= [[alpha]],	;;; type of cpu
	ALPHA			= true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	WORD_BITS		= 64,


;;; -- OPERATING SYSTEM (OSF1) ------------------------------------------

	UNIX			= true,
	OSF1			= 3.0,
	POSIX1			= 199009,
	POSIX2			= 199209,
	OPERATING_SYSTEM = [[unix osf1 ^OSF1 posix {^POSIX1 ^POSIX2}]],

	;;; Feature list
	BERKELEY		= 4.3,
	BSD_MMAP		= true,			;;; has mmap and mprotect facilities
	BSD_MPROTECT	= true,
	SHARED_LIBRARIES = true,	;;; dynamically linked against shared libraries
	COFF			= true,

	;;; Size of a virtual page (from "pagesize(1)")
	VPAGE_OFFS		= 16:2000,

	;;; Lowest address for pop structure
	LOWEST_ADDRESS = 16:40000000,

	;;; Lowest address for pop system code (high limit is assumed to be etext)
	LOWEST_CODE_ADDRESS = 16:20000000,

	;;; Top of stack segment
	UNIX_USRSTACK = 16:20000000,

	;;; Get and set the memory break and return the REAL end of memory:
	;;; this is to ensure that the end of the user stack is at the end
	;;; of memory so that a user stack underflow causes a memory access
	;;; violation.
	;;; Break values are rounded up to the next page boundary.
	GET_REAL_BREAK = [
		procedure();
			_extern sbrk(_0)@(b.r->vpage);
		endprocedure
	],

	SET_REAL_BREAK = [
		procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif;
		endprocedure
	],


;;; -- OTHER --------------------------------------------------------------


	;;; List of procedures to be optimised as subroutine calls:
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]
	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; if GEN_SVB_CONSTANTS is true, constants in _special_var_block will be
	;;; generated by Poplink, and recognised in the production of M-code
	;;; operands by Popc (providing genproc.p defines SPECIAL_VAR_BLOCK_REG).

	GEN_SVB_CONSTANTS	= true,

);

define :inline CACHEFLUSH(_ptr, _nbytes);
	$-Sys$- _cache_flush()		;;; compiles to 'call_pal imb'
enddefine;


endsection;


/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Removed is* procedures from SUBROUTINE_OPTIMISE_LIST (no longer
		required).
--- John Gibson, Aug 11 1995
		_cache_flush into section $-Sys (for consistency with Sun4 one)
 */
