$! --- University of Sussex POPLOG file -----------------------------------
$! File:            $usepop/master/C.vms/com/multivers.com
$! Purpose:         find out about multiple version of files in a directory
$! Author:          Alan Richomme, July 1982 (see revisions)
$! Documentation:
$! Related Files:

$ ! Parameters:
$ !     P1 = directory, defaults to current directory
$ !     P2 = "Y" or "N" or name of output file.
$ !         If "Y" output to terminal, if "N" then to MULTIVERS.LIS
$ !
$ !
$ ! get directory specification.
$   if p1 .eqs. "[]" then goto thisdir
$   if p1 .nes. "" then goto dirfound
$ thisdir:
$   p1 := 'f$directory()
$ !
$ dirfound:
$ ! Add [...] to directory name if necessary
$ if 'f$locate("[",p1).ge.'f$length(p1) then p1 := "[''p1']"
$ !
$ output:
$ ! inquire form of output - screen or file.
$   if p2 .eqs. "N" then goto fileoutput
$   if p2 .eqs. "Y" then goto screenoutput
$   if p2 .nes. ""  then goto diroutput
$   inquire p2 "Output on screen? (y/n)"
$   goto output
$ !
$ fileoutput:
$   write sys$output ""
$   write sys$output "Information will be written to Multivers.lis."
$   write sys$output ""
$   open/write outfile multivers.lis
$   goto getdir
$ !
$ screenoutput:
$   assign sys$output outfile:
$ goto getdir
$ !
$ diroutput:
$   open/write outfile 'p2'
$ !
$ getdir:
$ ! get directory and do initialization of variables, etc.
$ !
$ ! on interruption or error deassign outfile (if assigned)
$ ! and delete temporary directory file.
$ on control_y then goto tidy_up
$ on warning then goto tidy_up
$ !
$   directory/notrailing/nodate/size/output=temp.lis 'p1'
$   open/read infile temp.lis
$   write outfile ""
$   write outfile "Superfluous Files on Directories ''p1'."
$   write outfile ""
$   records = 0
$   versions = 0
$   currentfile := ""
$   filext := ""
$   sizetotal = 0
$   verstotal = 0
$ !
$ read_record:
$ ! read record and find if directory header.
$   read/end_of_file=end infile record
$ ! presence of "[" signifies directory header.
$   x1 = 'f$locate("[",record)'
$   x2 = 'f$length(record)'
$   if x1 .eq. x2 then goto notdirline
$ !
$ newdir:
$ ! record is directory header, so print information if previous
$ ! file had more than 1 version or was .DIF or .JOU file.
$   if versions .le. 1 then -
       if filext .nes. "DIF" .and. -
          filext .nes. "JOU" then goto dirline
$   label := dirline
$   goto write_record
$ !
$ dirline:
$ ! find new directory and initialize variables.
$   x3 = 'f$locate("]",record)' + 1
$   defdir := 'f$extract(x1,x3,record)'
$   versions = 0
$   currentfile := ""
$   totalsize = 0
$   goto read_record
$ !
$ notdirline:
$ ! record not a directory header:
$ ! only alternatives are 1. blank line 2. file line.
$ ! presence of ";" indicates file line.
$ ! if file line, isolate name and size, and compare with previous.
$   x1 = 'f$locate(";",record)
$   if x1 .eq. x2 then goto read_record
$   filename := 'f$extract(0,x1,record)'
$   filesize := 'f$extract(19,x2,record)'
$   if filename .nes. currentfile then goto newfile
$   versions = versions + 1
$   totalsize = totalsize + filesize
$   goto read_record
$ !
$ newfile:
$ ! if necessary print info on previous file.
$   if versions .le. 1 then -
       if filext .nes. "DIF" .and. -
          filext .nes. "JOU" then goto initialize
$   label := initialize
$   goto write_record
$ !
$ initialize:
$   x3 = 'f$locate(".",filename)'+1
$   filext := 'f$extract(x3,3,filename)'
$   currentfile := 'filename'
$   versions = 1
$   totalsize = 0
$ ! normally filesize of highest version is ignored.
$ ! but if file is a .JOU or MAP.DIF file, this is not so.
$   if filext .eqs. "JOU" .or. -
       filext .eqs. "DIF" then -
       totalsize = filesize
$   goto read_record
$ !
$ !
$ write_record:
$ ! write information to output device.
$ !
$ write_rec_part1:
$ ! normal multiversioned file.
$   if filext .eqs. "DIF" .or. -
       filext .eqs. "JOU" then goto special_write
$   versions = versions - 1
$   write outfile "''versions' extra version(s) of ''currentfile' on", -
                " ''defdir' occupying ''totalsize' block(s)."
$ !
$ write_rec_part2:
$ ! update variables.
$   records = records + 1
$   sizetotal = sizetotal + totalsize
$   verstotal = verstotal + versions
$   goto 'label'
$ !
$ special_write:
$ ! write info concerning .JOU or MAP.DIF file.
$   write outfile "''versions' version(s) of ''currentfile' on", -
                  " ''defdir' occupying ''totalsize' block(s)."
$   goto write_rec_part2
$ !
$ !
$ end:
$ ! end_of_file reached.
$ !
$ end_part1:
$   if versions .le. 1 then -
       if filext .nes. "DIF" .and. -
          filext .nes. "JOU" then goto end_part2
$   label := end_part2
$   goto write_record
$ !
$ end_part2:
$ ! print summing up information.
$   if records .eq. 0 then write outfile "There are no ", -
     "superfluous files on ''p1'."
$   write outfile ""
$   if records .gt. 0 then goto other_end_part2
$   goto tidy_up
$ !
$ other_end_part2:
$ ! print summing-up information.
$   write outfile "Total of ''verstotal' superfluous file(s) ", -
    "occupying ''sizetotal' block(s)."
$   write outfile ""
$   goto tidy_up
$ !
$ tidy_up:
$ ! deassign outfile if assigned and delete temp.lis
$ ! this section is called if error encountered or program interrupted.
$   close outfile
$   if "''f$logical("OUTFILE")'" .nes. "" then deassign outfile
$   close infile
$   delete temp.lis;
$   exit
$ !
$ !

$! --- Revision History ---------------------------------------------------
$! --- Aaron Sloman, July 1982 - modified.
