/*  --- Copyright University of Sussex 1989. All rights reserved. ----------
 *  File:           C.vms/lib/auto/sysfileparse.p
 *  Purpose:        parse filename into parts *** VMS VERSION **
 *  Author:         Aaron Sloman, October 1982 (see revisions)
 *  Documentation:  HELP * SYSFILEPARSE
 *  Related Files:  sysfilefield, and sysfile<component> for each component
 *                  also UNIX version in C.unix
 */
compile_mode:pop11 +strict;

#_TERMIN_IF DEF POPC_COMPILING

;;; given a string represeting a file name, return a vector of strings, with
;;; host, disk, directory, name, type, version

section;

define global sysfileparse(string);
	lvars x, y, n, host, disk, dir, name, type, version, size, string;
	sysfileok(string) -> string;
	/* --- LOOK FOR HOST NAME --- */
	if issubstring('::', 1, string) ->> x then
		substring(1, x + 1, string);
		x + 2
	else
		nullstring;
		1
	endif -> x -> host;
	/* --- LOOK FOR DISK NAME --- */
	if locchar(`:`, x, string) ->> y then
		substring(x, y - x + 1, string);
		y + 1 -> x;
	else
		nullstring
	endif -> disk;
	/* --- LOOK FOR DIR NAME --- */
	if locchar(`]`, x, string) ->> y then
		substring(x, y - x + 1, string);
		y + 1 -> x
	else
		nullstring
	endif  -> dir;

	datalength(string) -> size;
	false ->> name ->> type -> version;
	/* --- FIND END OF NAME --- */
	if locchar(`.`, x, string) ->> y then
		true -> type
	elseif locchar(`;`, x, string) ->> y then
		nullstring -> type
	else
		size + 1 -> y;
		nullstring ->> type -> version;
	endif;

	substring(x, y - x, string) -> name;

	unless type and version do
		y + 1 -> x;
		if type == true then
			if (locchar(`.`, x, string) ->> y)
			or (locchar(`;`, x, string) ->> y) then
				substring(x, y - x, string);
				substring(y + 1, size - y, string)
			else
				substring(x, size - x + 1, string);
				nullstring
			endif -> version -> type;
		else
			substring(x + 1, size - x, string) -> version;
		endif
	endunless;

	{% host, disk, dir, name, type, version %}
enddefine;

define global sysfilefield(string, n);
	lvars string, n;
	subscrv(n, sysfileparse(string))
enddefine;

endsection;


/*  --- Revision History ---------------------------------------------------
--- John Gibson, Jul  1 1989
		Added +strict etc.
--- Mark Rubinstein, Jan 16 1986 - desectionised.
--- Mark Rubinstein, Jun 13 1985 - split into separate UNIX and VMS versions.
--- Mark Rubinstein, Jun 12 1985 - fixed minor bug in UNIX version relating to
	directories containing `.` character and names with `!`.
--- Mark Rubinstein, May 22 1985 - altered to use SYS_OS_TYPE
--- John Williams, March 22 1985 - made to work on UNIX machines.
	Also lvarsed.
 */
