/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_point.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 7th May 1993
;;; File: go_point.p
;;; Author: B L Rabau

compile_mode :pop11 +strict;

uses go_screen_object;

;;;--------------------------------------------------------------

;;; INTRO: A go_point is a location on the screen which is represented as dot
;;; INTRO: The go_point objects can be moved over the screen in go_edit_mode.

define :class go_point;
	isa go_screen_object;
	slot go_border == 4;
;;; REF: Sensitivety to the mouse in pixels around the point.
enddefine;

;;;--------------------------------------------------------------

;;; does not count on stored go_bounding_width to be correct! (see go_located)
define :method go_bounding_width( pnt :go_point );
lvars pnt;
;;; REF: go_bounding_width( POINT ) -> INTEGER;
;;; REF: Gets the horizontal dimension in world coordinates of the point
;;; REF: including the sensitive go_border (see also REF * GO_LOCATED).
;;; REF: POINT is an instance of the go_point class (REF * GO_POINT).
	if ( pnt.go_linewidth and (pnt.go_linewidth > 1) ) then pnt.go_linewidth
	else 1
	endif + go_border(pnt) ->> pnt.stored_go_bounding_width;
							 ;;; should be an attribute of go_screen_object
enddefine;

define :method go_bounding_height( pnt :go_point );
lvars pnt;
;;; REF: go_bounding_height( POINT ) -> INTEGER;
;;; REF: Gets the vertical dimension in world coordinates of the point
;;; REF: including the sensitive go_border (see also REF * GO_LOCATED).
;;; REF: POINT is an instance of the go_point class (REF * GO_POINT).
	go_bounding_width(pnt)->> pnt.stored_go_bounding_height;
enddefine;

;;;--------------------------------------------------------------
;;; DRAW POINT


define :method go_fgdraw( pane :go_window_pane, pnt :go_point );
lvars pane, pnt;
;;; REF: go_fgdraw( PANE, POINT );
;;; REF: Draws the square representation of the edit point in the given pane
;;; REF: and in its foreground colour (see also REF * GO_COLOURABLE).
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
;;; REF: POINT is an instance of the go_point class (REF * GO_POINT).
lvars window, x, y, size, oldforeground;

	go_transxyout(pnt.go_xcentre, pnt.go_ycentre, pane) -> (x, y);
	go_draw_line( pane, x, y, x, y  );
enddefine;

;;;--------------------------------------------------------------

define :method go_contains( x, y, pnt :go_point );
lvars x, y, pnt;
;;; REF: go_contains( X, Y, POINT ) -> POINT_OR_FALSE;
;;; REF: Checks whether the world coordinate falls inside the point. It
;;; REF: returns the point if true, else it returns false.
;;; REF: X and Y are the world coordinates of the test location.
;;; REF: POINT is an instance of the go_point class (REF * GO_POINT).
	if ((pnt.go_xcentre - x)**2 + (pnt.go_ycentre - y)**2)
	   < (pnt.go_border + (pnt.go_linewidth or 0) )**2
	then pnt else false endif;
enddefine;


;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_point = true;


/* --- Revision History --------------------------------------------
 * BR 27/08/93
 *     Changed calls to go_x/yloc into go_x/ycentre(). Made the area which
 *     contains a point include the linewidth. Removed the special cases
 *     for go_overlaps()
 * BR 07/05/93
 *     Changed go_transxyout() to no longer include the screen object (see
 *     LIB * GO_PANE).
 *     Added the go_border() to the width and height of the point.
 *     Added comments.
 * BR 08/04/93
 *     Removed direct call to XpwDrawLine[s]() by go_draw_line[s]();
 *     Removed direct call to XpwDrawArcs() by go_draw_arcs();
 *     Removed direct call to XpwFillArcs() by go_draw_filled_arcs();
 *     Removed direct call to XpwDrawRectangle() by go_draw_rectangle();
 *     Removed direct call to XpwClearArea() by go_clear_rectangle()
 * BR 06/04/93
 *     Renamed the mixin go_editable to go_editor
 * BR 21/12/92
 *     Changed go_draw() into go_fgdraw() and adapted for CapProjecting capStyle.
 * BR 26/11/92
 *     Global Name changes and code cleanup
 * BR 16/11/92
 *     Adapted for OC 5.01; removed the go_editable definitions to separate file.
 * BR 05/11/92
 *     Declaration of mixin go_edited_object defined in mixin go_editable go_(point.p)
 * BR 03/11/92
 *     Changed go_contains to return the object rather than true or false...
 * BR 16/10/92
 *     Added argument to go_draw() to indicate pane (removed rc_window)...
 *     Added argument to go_safe_region() (IDEM)
 * BR 05/10/92
 *     Removed isa go_located because of new definition of go_screen_object.
 * BR 07/09/92
 *     replaced go_drag_and_drop() method to use the LIB * RC_DRAG library (counts
 *     on the new version of go_internal_redraw() defined in the go_screen_object class
 *     (see go_objects.p).
 *     added go_safe_region for go_edit_point to overwrite the go_point's region with
 *     the edit_obj's region.
 */
;;; eof
