/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_xaction.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 23rd June 1993
;;; File: go_xaction.p
;;; Author: J L Cunningham (rewritten by B L E Rabau)

compile_mode :pop11 +strict;

;;; This file is contains excerpts of multiple files made by
;;; J L Cunningham for the UIDE project (Sketch).
;;;     sketch_decs.p
;;;     sketch_basics.p
;;;     sketch_edit.p

;;; see also MajorChanges and MajorChanges.p

uses go_key_sensitive;
uses go_mouse_sensitive;

;;;---------------------------------------------------------------------
;;;  EXTRA TOP LEVEL:



define :method go_edit_left_action( event_data, locObj :go_located );
lvars event_data, locObj;
;;; REF: go_edit_left_action( EVENT_DATA, LOCATED );
;;; REF: Hook for user who want an action to happen in edit mode when the
;;; REF: LEFT mouse button is clicked. Some data of the event is available.
;;; REF: By default the object under the mouse is picked up and can be dragged
;;; REF: around with REF * GO_SCREEN_OBJECT/GO_DRAG_AND_DROP
;;; REF: Default action: go_drag_and_drop
;;; REF: EVENT_DATA is the vector from REF * GO_XACTION/go_expand_event_data
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
	go_drag_and_drop( locObj );
enddefine;

define :method go_edit_drag_action( event_data, locObj :go_located );
lvars event_data, locObj;
;;; REF: go_edit_drag_action( EVENT_DATA, LOCATED );
;;; REF: Hook for user who want an action to happen in edit mode when the
;;; REF: mouse is moved with the LEFT mouse button down (= drag). Some data
;;; REF: of the event is available.
;;; REF: Default action: no action
;;; REF: EVENT_DATA is the vector from REF * GO_XACTION/go_expand_event_data
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
enddefine;

define :method go_edit_middle_action( event_data, locObj :go_located );
lvars event_data, locObj;
;;; REF: go_edit_middle_action( EVENT_DATA, LOCATED );
;;; REF: Hook for user who want an action to happen in edit mode when the
;;; REF: MIDDLE mouse button is clicked. Some data of the event is available.
;;; REF: Default action: no action
;;; REF: EVENT_DATA is the vector from REF * GO_XACTION/go_expand_event_data
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
enddefine;

define :method go_edit_right_action( event_data, locObj :go_located );
lvars event_data, locObj;
;;; REF: go_edit_right_action( EVENT_DATA, LOCATED );
;;; REF: Hook for user who want an action to happen in edit mode when the
;;; REF: RIGHT mouse button is clicked. Some data of the event is available.
;;; REF: Default action: no action
;;; REF: EVENT_DATA is the vector from REF * GO_XACTION/go_expand_event_data
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
enddefine;

define :method go_edit_key_action( char, event_data, locObj :go_located );
lvars char, event_data, locObj;
;;; REF: go_edit_right_action( EVENT_DATA, LOCATED );
;;; REF: Hook for user who want an action to happen in edit mode when a
;;; REF: keyboard key is pressed. Some data of the event is available.
;;; REF: Default action: no action
;;; REF: EVENT_DATA is the vector from REF * GO_XACTION/go_expand_event_data
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
	;;; printf('KEY: %p is hit on object %p\n',[% char, datakey(locObj) %])
enddefine;


;;;---------------------------------------------------------------------
;;; LOCAL VARIABLES

/* BEGIN - FROM SKETCH DECS */
vars go_last_clicked_object = false; ;;; REF: Global var:
;;; REF: Global var: List of last object(s) to run a mouse action. This
;;; REF: Global var: enables to send actions from the drag and up events
;;; REF: Global var: to the same object as the down event.
;;; REF: Global var: This excludes programmatical edit actions.

vars go_last_typed_object = false;   ;;; REF: Global var:
;;; REF: Global var: List of last object(s) to receive key strokes. This
;;; REF: Global var: enables to send actions from the key up events to the
;;; REF: Global var: same object as the down event.
;;; REF: Global var: This excludes programmatical edit actions.

/* END - FROM SKETCH DECS */

uses go_located;

;;;---------------------------------------------------------------------
;;; MOUSE EVENT HANDLERS

define :method go_expand_event_data( raw_event_data, obj :go_located ) -> new_event_data;
lvars new_event_data, raw_event_data, obj;
;;; REF: go_expand_event_data( RAW_EVENT_DATA, LOCATED ) -> EVENT_DATA;
;;; REF: Low level method to expand the available system event data into a
;;; REF: more useable set of data for the given object.
;;; REF: Default expansion: Analyse button or key status and return the
;;; REF: x and the y location (in world coordinates), the button number or
;;; REF: key symbol, the "up"/"down" state of the latter and the pane in
;;; REF: which the event occurred.
;;; REF: RAW_EVENT_DATA is a vector = {x  y (= location in world coordinates)
;;; REF: data (= the raw event data) pane (= in which the event occurred) }.
;;; REF: EVENT_DATA is a vector containing useful data of the event.
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
lvars x = raw_event_data(1),         y = raw_event_data(2),
	  butt = abs(raw_event_data(3)), butt_updown,
	  pane = raw_event_data(4);
	;;; raw_event_data should be copied and not passed on directly!
	;;; butt is normally a number from 1-3 indicating the clicked button
	;;; butt_updown is down or up indicating the state of the button

	if (raw_event_data(3) > 0) then "down" else "up" endif -> butt_updown;
	{% x, y, butt, butt_updown, pane %} -> new_event_data;

	/* ---- BEGIN POSSIBLE EXTENSION: MODIFIER KEYS ---- *
	lvars modifs = XptValue( the_go_window(pane), XtN modifiers );
	{% x, y, butt, butt_updown, buttmodifs, pane, obj %} -> new_event_data;
	 * ----  END  POSSIBLE EXTENSION: MODIFIER KEYS ---- */
enddefine;


define :method go_handle_mouse_action(raw_event_data, obj :go_located);
lvars raw_event_data, obj;
;;; REF: go_handle_mouse_action( RAW_EVENT_DATA, LOCATED );
;;; REF: Low level method for handling all mouse button down and up events.
;;; REF: For live objects (or a pane in live mode) the corresponding actions
;;; REF: from the sensitive library (REF * GO_MOUSE_SENSITIVE) are called.
;;; REF: In edit mode the go_edit_left_action, go_edit_middle_action and
;;; REF: go_edit_right_action action will be called for each of the down events
;;; REF: on the buttons. Some data of the event is available (see also
;;; REF: REF * GO_XACTION/go_expand_event_data).
;;; REF: RAW_EVENT_DATA is a vector = {x  y (= location in world coordinates)
;;; REF: data (= the raw event data) pane (= in which the event occurred) }.
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
lvars event_data = go_expand_event_data( raw_event_data, obj );
lvars butt = event_data(3), butt_updown = event_data(4), pane = event_data(5);
lvars pane_grabs = go_edit_mode(pane), object_grabs = go_live_object(obj);
	;;; check whether edit or live:
	if   ( butt_updown == "down" )
	and  ( pane_grabs and  not( object_grabs == true ) )
	then
		if butt == 1 then
			go_edit_left_action( event_data, obj );
		elseif butt == 2 then
			go_edit_middle_action( event_data, obj );
		elseif butt == 3 then
			go_edit_right_action( event_data, obj );
		endif
	elseif ( go_accepts_events("mouse", raw_event_data, obj) )
		and    ( not( pane_grabs ) or ( object_grabs == true ) )
		then
		;;; butt is normally a number from 1-3 indicating the clicked button
		;;; butt_updown is down or up indicating the state of the button
		if (butt_updown == "down") then
			go_mouse_down_action( butt, obj )( event_data, obj );
		elseif (butt_updown == "up") then  ;;; Deferred needed?
			XptDeferApply( go_mouse_up_action( butt, obj )(%event_data, obj%) );
			XptSetXtWakeup();
		endif;
	endif;
enddefine;

define :method go_handle_mouse_drag(raw_event_data, obj :go_located);
lvars raw_event_data, obj;
;;; REF: go_handle_mouse_drag( RAW_EVENT_DATA, LOCATED );
;;; REF: Low level method for handling all mouse drag (=move while down) events.
;;; REF: For live objects (or a pane in live mode) the corresponding actions
;;; REF: from the sensitive library (REF * GO_MOUSE_SENSITIVE) are called.
;;; REF: In edit mode the go_edit_drag_action action will be called only for the
;;; REF: LEFT button. Some data of the event is available (see also
;;; REF: REF * GO_XACTION/go_expand_event_data).
;;; REF: RAW_EVENT_DATA is a vector = {x  y (= location in world coordinates)
;;; REF: data (= the raw event data) pane (= in which the event occurred) }.
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
lvars event_data = go_expand_event_data( raw_event_data, obj );
lvars butt = event_data(3), butt_updown = event_data(4), pane = event_data(5);
lvars pane_grabs = go_edit_mode(pane), object_grabs = go_live_object(obj);

	if ( butt_updown == "up" ) then return; endif;

	;;; check whether edit or live:
	if   ( pane_grabs and  not( object_grabs == true ) )
	then
			go_edit_drag_action( event_data, obj );
	elseif ( isgo_mouse_sensitive(obj) )
	and    ( not( pane_grabs ) or ( object_grabs == true ) )
	then
			go_mouse_drag_action( butt, obj )( event_data, obj );
	endif;
enddefine;



define go_notice_button(window, pane, call);
/* ------------------------------------------------------- */
/* ---- see event handlers in ~jonm/hip/src/overlay.p ---- */
/* ------------------------------------------------------- */
lvars window, pane, call;
;;; REF: go_notice_button( WINDOW, PANE, CALL_DATA );
;;; REF: A real callback procedure attached to the window of the pane.
;;; REF: This callback is attached to the pane with go_add_notice_button and
;;; REF: removed with go_remove_notice_button. It will call the appropriate
;;; REF: handler (REF * GO_XACTION/go_handle_mouse_action) on the object under
;;; REF: the mouse pointer. The up event is always sent to the same object.
;;; REF: WINDOW is a pointer to a physical XpwGraphic widget (REF * GO_PANE).
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
;;; REF: CALL_DATA is an  external pointer containing useful data of the event.
lvars x, y, obj, raw_event_data;
lconstant go_event_data = writeable initv(4);  ;;; should not be stored by user

	exacc ^int call -> call;
	if (call == 0) then
		 mishap('Zero button press', [% window, pane %]);
		 return;
	elseif (call < 0) then
		if go_object_dragable then
			false -> go_object_dragable;
		else
			;;; The drag routine has been aborted by another process; this
			;;; invalidates the drop and the down event.
			return
		endif;
	endif;
	go_mouse_coords( window, pane ) -> (x, y);
	fill(x, y, call, pane, go_event_data) -> raw_event_data;
	if (call > 0) then
		;;; Initialise the global variables for this event:
		[] -> go_forward_event_to;
		false -> go_transparent_to_events;
		pane -> go_default_pane;
		go_find_ui_object(x, y, "mouse", raw_event_data, pane) -> /* flag */;
		go_forward_event_to ->> go_last_clicked_object -> go_object_dragable;
	endif;
	for obj in go_forward_event_to do
		go_handle_mouse_action( raw_event_data, obj );
	endfor;
enddefine;

;;; The following routine should only be called when a motion with
;;; a mouse-button down happens. Unfortunately it is also called upon
;;; a window entry....
;;; Note that the go_object_dragable is set between mouse down and up;
;;; it can also be the go_window_pane of course !!!
include xpt_xevent.ph;

define go_notice_drag(window, pane, call);
lvars window, pane, call;
;;; REF: go_notice_drag( WINDOW, PANE, CALL_DATA );
;;; REF: A real callback procedure attached to the window of the pane.
;;; REF: This callback is attached to the pane with go_add_notice_button and
;;; REF: removed with go_remove_notice_button. It will call the appropriate
;;; REF: handler (REF * GO_XACTION/go_handle_mouse_drag) on the object of the
;;; REF: last down event. The drag event is always sent to the same object.
;;; REF: WINDOW is a pointer to a physical XpwGraphic widget (REF * GO_PANE).
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
;;; REF: CALL_DATA is an  external pointer containing useful data of the event.
lvars x, y, obj, obj_list = go_object_dragable, raw_event_data;
lconstant go_event_data = writeable initv(4);  ;;; should not be stored by user
	unless obj_list or call == 0 then return endunless;

	exacc ^uint call -> call;
	if (call == 0) then return;
	elseif (call &&/=_0 Button1Mask) then 1
	elseif (call &&/=_0 Button2Mask) then 2
	elseif (call &&/=_0 Button3Mask) then 3
	endif -> call;

	go_mouse_coords( window, pane ) -> (x, y);
	fill(x, y, call, pane, go_event_data) -> raw_event_data;
	for obj in obj_list do
		go_handle_mouse_drag( raw_event_data, obj );
	endfor;
enddefine;


define :method go_add_notice_button( pane :go_window_pane );
lvars pane;
;;; REF: go_add_notice_button( PANE );
;;; REF: Adds the callbacks for mouse actions to the window in the pane.
;;; REF: This makes the pane active for mouse clicks and movements.
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
lvars window = the_go_window( pane );
	if ( window ) then
		XtAddCallback( window, XtN buttonEvent, go_notice_button, pane );
		XtAddCallback( window, XtN motionEvent, go_notice_drag, pane );
	endif;
enddefine;

define :method go_remove_notice_button( pane :go_window_pane );
lvars pane;
;;; REF: go_remove_notice_button( PANE );
;;; REF: Removes the callbacks for mouse actions from the window in the pane.
;;; REF: This makes the pane inactive for mouse clicks and movements.
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
lvars window = the_go_window( pane );
	if ( window ) then
		XtRemoveAllCallbacks( window, XtN buttonEvent );
		XtRemoveAllCallbacks( window, XtN motionEvent );
	endif;
enddefine;

;;;---------------------------------------------------------------------
;;; KEYBOARD EVENTS

define :method go_handle_key_action(raw_event_data, obj :go_located);
lvars raw_event_data, obj;
;;; REF: go_handle_mouse_drag( RAW_EVENT_DATA, LOCATED );
;;; REF: Low level method for handling all keyboard (=key down & up) events.
;;; REF: For live objects (or a pane in live mode) the corresponding actions
;;; REF: from the sensitive library (REF * GO_KEY_SENSITIVE) are called.
;;; REF: In edit mode the go_edit_key_action action will be called only for the
;;; REF: key down event. Some data of the event is available (see also
;;; REF: REF * GO_XACTION/go_expand_event_data).
;;; REF: RAW_EVENT_DATA is a vector = {x  y (= location in world coordinates)
;;; REF: data (= the raw event data) pane (= in which the event occurred) }.
;;; REF: LOCATED is an instance of the go_located class (REF * GO_LOCATED).
lvars event_data = go_expand_event_data( raw_event_data, obj );
lvars char = event_data(3), key_updown = event_data(4), pane = event_data(5);
	if  ( not(go_default_pane.go_edit_mode)        ;;; added test for live mode
		  or (obj.go_live_object == true) )
	and obj.isgo_key_sensitive then
		if (key_updown == "down") then
			go_key_down_action(obj)(char, obj );
		elseif (key_updown == "up") then
			go_key_up_action(obj)(char, obj );
		endif;
	elseif (key_updown == "down") then
		go_edit_key_action( char, event_data, obj );
	endif;
enddefine;

define go_notice_key(window, pane, call);
lvars window, pane, call;
;;; REF: go_notice_key( WINDOW, PANE, CALL_DATA );
;;; REF: A real callback procedure attached to the window of the pane.
;;; REF: This callback is attached to the pane with go_add_notice_button and
;;; REF: removed with go_remove_notice_button. It will call the appropriate
;;; REF: handler (REF * GO_XACTION/go_handle_key_action) on the object of the
;;; REF: last key down event. The key up event is always sent to the same object
;;; REF: WINDOW is a pointer to a physical XpwGraphic widget (REF * GO_PANE).
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
;;; REF: CALL_DATA is an  external pointer containing useful data of the event.
lvars x, y obj, raw_event_data, new_event_data;
lconstant go_key_data = writeable initv(4);  ;;; should not be stored by user
	exacc ^int call -> call;
	if (call == 0) then
		 mishap('Zero key pressed', [% window, pane %]);
		 return;
	endif;
	go_mouse_coords( window, pane ) -> (x, y);
	pane -> go_default_pane;
	fill(x, y, call, pane, go_key_data) -> raw_event_data;
	if (call > 0) then
		;;; Initialise the global variables for this event:
		[] -> go_forward_event_to;
		false -> go_transparent_to_events;
		go_find_ui_object(x, y, "keyboard", raw_event_data, pane) -> /* flag */;
		go_forward_event_to -> go_last_typed_object;
	endif;
	for obj in go_forward_event_to do
		go_handle_key_action( raw_event_data, obj );
	endfor;
enddefine;

define :method go_add_notice_key( pane :go_window_pane );
lvars pane;
;;; REF: go_add_notice_key( PANE );
;;; REF: Adds the callbacks for keyboard actions in the window in the pane.
;;; REF: This makes the pane inactive for keyboard key strokes.
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
lvars window = the_go_window( pane );
	if ( window ) then
		XtAddCallback( window, XtN keyboardEvent, go_notice_key, pane );
	endif;
enddefine;

define :method go_remove_notice_key( pane :go_window_pane );
lvars pane;
;;; REF: go_remove_notice_key( PANE );
;;; REF: Removes the callbacks for keyboard actions from the window in the pane.
;;; REF: This makes the pane inactive for keyboard key strokes.
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
lvars window = the_go_window( pane );
	if ( window ) then
		XtRemoveAllCallbacks( window, XtN keyboardEvent);
	endif;
enddefine;


;;;---------------------------------------------------------------------
;;; Variable for "uses"
vars go_xaction = true;

/* --- Revision History --------------------------------------------
 * BR 06/07/93
 *     Allowed go_find_ui_object() to return a LIST of objects in a global
 *     variable go_forward_event_to !! REF * GO_PANE/go_forward_event_to.
 *     Changed the event_data parameter of the go_handle_[mouse/key]_action()
 *     methods to be the raw_event_data. Therefore needing the call to the
 *     go_expand_event_data() method explicitely in those methods!!!
 *     This simplifies the passing of raw_event_data to go_find_ui_object() and
 *     go_accepts_events(), The latter shows the importance of avoinding to
 *     do the expansion too early: avoid expansion for each and every object
 *     during the search.
 * BR 23/06/93
 *     Major redesign of go_find_ui_object() to include event types.
 * BR 03/06/93
 *     Added extra event_data parameter to the go_edit_key_action() to
 *     correspond to the documentation in help go_live.
 * BR 26/05/93
 *     Renamed global vars last_clicked_object & last_typed_object with go_<>
 *     Added comments.
 * BR 13/05/93
 *     Optimised callbacks away when using go_drag() by setting the global
 *     variable go_object_dragable to false when dragging starts.
 * BR 30/03/93
 *     ???
 * BR 03/02/93
 *     Added notice_drag() and go_edit_drag_action() and go_handle_mouse_drag()
 *     also calling go_mouse_drag_action()
 * BR 01/02/93
 *     Removed all links to "hilitable" mixin.
 *     COMPLETELY NEW EVENT HANDLING ROUTINES!!!
 *     - notice_button() with go_expand_event_data() method & go_handle_mouse_action()
 *       method. All new edit_<button>_action() methods
 *     - notice_key() with go_expand_event_data() method & go_handle_key_action()
 *       method. All new  key_<state>_action() methods
 *     See alse HELP * GO_LIVE and  LIB * GO_MOUSE_SENSITIVE and LIB * GO_KEY_SENSITIVE
 * BR 26/11/92
 *     Global Name changes and code cleanup
 * BR 12/11/92
 *     added go_add_notice_button() to replace rc_mouse_setup
 *     removed rc_window
 * BR 05/11/92
 *     Removed go_internal_redraw call after a go_hilite(); this should be done automatically
 *     by the go_hilite definitions.
 */
;;; eof
