/*  --- Copyright University of Sussex 1993. All rights reserved. ----------
 >  File:           C.vms/lib/ved/ved_grep.p
 >  Purpose:        get result of a search into a temporary file and edit it
 >  Author:         Aaron Sloman, Dec 1983 (see revisions)
 >  Documentation:  HELP * VEDCOMMS
 >  Related Files:  Unix version.
 */
compile_mode :pop11 +strict;

section;

lvars tmpname = false;

define vars ved_grep;
	unless tmpname then
		systmpfile(false, 'vedgrep', '.tmp') -> tmpname
	endunless;
	;;; if the file exists then get rid of it
	if vedpresent(tmpname) then edit(tmpname); ved_q() endif;
	sysobey('search ' >< vedargument >< ' /out:' >< tmpname);
	vedscr_flush_output();
	vedrestorescreen();
	tmpname -> vedargument;
	ved_ved();                      ;;; read in temporary file
	false -> vedwriteable;			;;; make it non-writeable
	sysdelete(vedargument) -> ;		;;; delete it
enddefine;

endsection;

/*  --- Revision History ---------------------------------------------------
--- Mark Rubinstein, Nov 11 1985 - sectionised and lvarsed, added call of
	systmpfile and use of vedpresent.
 */
