/*  --- Copyright University of Sussex 1993. All rights reserved. ----------
 *  File:           C.vms/lib/ved/ved_pasrun.p
 *  Purpose:        crude utility to run pascal programs from ved
 *  Author:         Roger Evans, Jan 1983
 *  Documentation:
 *  Related Files:  LIB * VED_PASCOMP
 */

#_TERMIN_IF DEF POPC_COMPILING

define sysved_pas(comfile);
	vars l fname inname outname x;
	length(vedcurrent)-3 -> l;
	unless substring(l,4,vedcurrent) = '.pas' then
		vederror('Not a PASCAL file');
	endunless;

	;;; see if there are any io specifications

	if (issubstring('in=',1,vedargument) ->> x) then
		x+3 -> x;
		unless (locchar(`;`,x,vedargument) ->> inname) then
			vederror('No semicolon after input specification');
		endunless;
		substring(x,inname-x,vedargument) -> inname;
	else
		'tt' -> inname;
	endif;

	if (issubstring('out=',1,vedargument) ->> x) then
		x+4 -> x;
		unless (locchar(`;`,x,vedargument) ->> outname) then
			vederror('No semicolon after output specification');
		endunless;
		substring(x,outname-x,vedargument) -> outname;
	else
		'tt' -> outname;
	endif;


	ved_w1();
	substring(1,l-1,vedcurrent) -> fname;
		vedscreengraphoff();            ;;; tidy up screen
		vedscreenclear();
		rawoutflush();
	sysobey('@' >< comfile >< ' ' >< fname >< ' ' >< inname >< ' ' >< outname);
	true -> vedprintingdone;
enddefine;

vars ved_pascomp ved_pasexec ved_pasrun;

;;; three options - compile, execute or run (compile and execute)
sysved_pas(%'$usepop:[pop.com]pascomp'%) -> ved_pascomp;
sysved_pas(%'$usepop:[pop.com]pasexe'%) -> ved_pasexec;
sysved_pas(%'$usepop:[pop.com]pasrun'%) -> ved_pasrun;
