/* --- Copyright University of Sussex 1994.  All rights reserved. ---------
 > File:           C.vms/lib/ved/ved_print.p
 > Purpose:        to print files from within ved
 > Author:         Mark Rubinstein, Sep 17 1985 (see revisions)
 > Documentation:  HELP * VED_PRINT
 > Related Files:  BSD and SystemV versions.
 */
compile_mode :pop11 +strict;

section;

lconstant
	default_printer = systranslate('popprinter') or nullstring;

lvars
	files                                       ;;; files to be printed
	printer                                     ;;; printer to use
	copies                                      ;;; no. of copies to print
	flags                                       ;;; other flags to pass.
	;

define lconstant translate_flags();
	if printer = nullstring then printer else '/queue=' sys_>< printer endif;
	if copies > 1 then <> '/copies=' sys_>< copies endif;
	if strmember(`m, flags) then <> '/notify' endif;
	if strmember(`f, flags) then <> '/noflag' endif;
	if strmember(`l, flags) then <> '/nofeed' endif;
	if strmember(`d, flags) then <> '/space' endif;
	if strmember(`h, flags) then <> '/header' endif;
	-> flags;
enddefine;

/* --- DOVEDPRINTMR handles the actual printing of the range --------- */
define lconstant dovedprintmr(lo, hi);
	lvars lo, hi, file, each, eat, spew;
	dlocal vednotabs = true;	;;; to give correct spacing

	;;; WRITE THE MARKED RANGE INTO A TEMPORARY FILE
	systmpfile('SYS$LOGIN:', 'print', '.lis') -> file;
	vedwriterange(file, lo, hi);

	;;; THEN PRINT AND DELETE IT
	'print/delete/noidentif/name=' <> sys_fname_name(vedcurrent) <> flags
		<> ' ' <> file -> flags;
	sys_spawn(flags, false, false, false, false) ->
enddefine;

define lconstant dosysfileok(f);
	lvars f;
	sysfileok(f) -> f;
	;;; add a . otherwise silly VMS adds .LIS
	if locchar(`.`, strmember(`]`, f) or 1, f) then f else f <> '.' endif;
enddefine;

define lconstant parseargument;
	lvars item, char, tempcopies, i, procedure items;
	lconstant okflags = 'lmfdh', modchars = '-#.$[]:';

	;;; SET UP THE DEFAULTS
	nullstring -> flags;
	default_printer -> printer;
	1 -> copies;
	[] -> files;
	;;; SET UP THE (MODIFIED) ITEM REPEATER
	appdata(modchars,
			procedure(c, rep);
				lvars c, rep;
				1 -> item_chartype(c, rep)
			endprocedure(% incharitem(stringin(vedargument)) ->> items %));

	;;; NOW DO THE PARSE
	until (items() ->> item) == termin do
		if isinteger(item) then item -> copies
		elseif isstring(item) then                      ;;; quoted file name
			dosysfileok(item) :: files -> files
		elseif subscrw(1, item) == `-` then             ;;; parse flags
			0 -> tempcopies;
			for i from 2 to datalength(item) do
				subscrw(i, item) -> char;
				if strmember(char, okflags) then
					flags sys_>< consstring(char, 1) -> flags;
				elseif char == `#` then                 ;;; ignore redundant #
				elseif isnumbercode(char) then          ;;; read a number
					(tempcopies * 10) + (subscrw(i, item) - `0`) -> tempcopies;
				elseif char == `p` then                 ;;; read new printer
					if (items() ->> printer) == termin then
						vederror('print: name of a printer expected after -p flag')
					endif;
				else vederror(sprintf('print: unrecognized flag - %c', [^char]));
				endif;
			endfor;
			unless tempcopies == 0 then tempcopies -> copies endunless;
		elseif item == "(" then                     ;;; read a pipe command
			vederror('print: piped commands don\'t work on VMS')
		else                                        ;;; read a file name
			dosysfileok(item) :: files -> files
		endif;
	enduntil;
	translate_flags();
enddefine;

define vars ved_printmr;
	dlocal	files, printer, copies, flags,
			pop_spawn_flags = 2:10;		;;; makes spawning faster

	vedputmessage('printmr: giving print command');
	parseargument();
	unless null(files) then
		vederror('printmr: only operative on current file (' >< files >< ')')
	endunless;
	dovedprintmr(vvedmarklo, vvedmarkhi);
	vedputmessage('printmr: print command queued');
enddefine;

define vars ved_print;
	lvars each;
	dlocal	files, printer, copies, flags,
			pop_spawn_flags = 2:10;		;;; makes spawning faster

	vedputmessage('print: giving print command');
	parseargument();
	if null(files) then
		dovedprintmr(1, vvedbuffersize);
	else
		'print/noidentif' <> flags <> ' ' -> flags;
		for each in files do
			sys_spawn(flags <> each, false, false, false, false) ->
		endfor;
	endif;
	vedputmessage('print: print command queued');
enddefine;

endsection;

/*  --- Revision History ---------------------------------------------------
--- John Gibson, Apr 21 1994
		Changed to use new sys_spawn
--- John Gibson, Jul 22 1992
		Made vednotabs true inside dovedprintmr so printing is done with
		correct spacing.
--- John Gibson, Mar 10 1992
		Made to use vedwriterange to write marked range to tmpfile.
		Cleaned up.
--- Mark Rubinstein, May  7 1986 - fixed specifing a printer queue where a
	printer might be a word instead a string.
--- Mark Rubinstein, Oct 23 1985 - altered to set up the job name in
	dovedprintmr to be from vedcurrent.
 */
