/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 * File:            C.alpha/src/alisp.s
 * Purpose:
 * Author:          John Gibson, Sep 19 1994
 */

;;; ---------------------- LISP ROUTINES ---------------------------------

#_<

#_INCLUDE 'asm.ph'

constant	_setstklen_diff
	;

>_#


ASM_START_FILE


ASM_CODE_PSECT


	;;; _setstklen(____________saved_stklen, ________nresults)

ASM_ALIGN_QUAD
DEF_C_LAB (_setstklen)
	ldW	rt0, _SVB_OFFS(_userhi)(rsvb)	;;; stack base
	ldW	rt1, 0(rusp)		;;; ________nresults (popint)
	ldW	rt2, _WOFFS(rusp)	;;; ____________saved_stklen (popint)
	lda	rusp, _WOFFS*2(rusp)
	addq	rt1, rt2, rt1		;;; ________nresults + ____________saved_stklen
	subq	rt1, 6, rt1		;;; -6 (popint bits) = desired stacklen
	subq	rt0, rt1, rt0		;;; _userhi - that = desired usp
	subq	rt0, rusp, rt1		;;; same as current usp?
	bne	rt1, C_LAB(_setstklen_diff) ;;; do _setstklen_diff if not
	ret	rzero, (rret)


	;;; _setstklen_diff()
	;;; required usp in rt0, (rt0 - rusp) in rt1

ASM_ALIGN_QUAD
DEF_C_LAB (_setstklen_diff)
	blt	rt1, !$1f		;;; br if stack not long enough
	mov	rt0, rusp		;;; else set us to desired len
	ret	rzero, (rret)

	;;; extend stack by pushing [] sufficient times
!$1:	ldW	rt1, _SVB_OFFS(nil)(rsvb)
!$2:	lda	rusp, -_WOFFS(rusp)
	stW	rt1, 0(rusp)		;;; push []
	cmpeq	rt0, rusp, rt2
	blbc	rt2, !$2b
	ret	rzero, (rret)


ASM_END_FILE
