/* --- Copyright University of Sussex 1998. All rights reserved. ----------
 * File:	    C.alpha/src/amain.s
 * Purpose:	    Entry routine for Pop
 * Author:	    John Gibson, Oct 21 1994 (see revisions)
 */

#_<

#_INCLUDE 'asm.ph'

vars $-Sys$- _init_args, Sys$-Extern$- _invocation_fp;

>_#

ASM_START_FILE


	;;; entry point for the poplog system

#_IF DEF VMS


$ROUTINE pop$entry_point, -
	KIND = stack, -
	SAVED_REGS = <r2,r3,r4,r5,r6,r7,r8,r9,r10,r11,r12,r13,r14,r15,fp>, -
	HANDLER = _pop_errsig_handler

	$LINKAGE_SECTION
svbadr: .WORD	C_LAB(_special_var_block)
stpadr:	.WORD	C_LAB(setpop)

	$CODE_SECTION
	.base	rpb, $LS
	;;; set up _special_var_block in rsvp
	ldW	rsvb, svbadr
	;;; save fp in _invocation_fp for unwinding after an error signal
	stW	fp, _svb_INVOC_FP

	ldW	rfalse, _svb_FALSE	;;; set rfalse to false
	INIT_POP_REGISTERS		;;; set pop lvar registers to false
	stW	rzero, _svb_IN_USER_EXTERN  ;;; clear _in_user_extern
	ldW	rusp, _svb_SAVED_USP	;;; temp user stack pointer in rusp
	ldW	rpb, stpadr		;;; get setpop
	ldW	rt0, _PD_EXECUTE(rpb)	;;; exec addr
	jsr	rret, 0(rt0)		;;; call setpop
	mov	#1, rt0			;;; normal exit status

	$RETURN				;;; return
$END_ROUTINE


SET_C_LAB(Sys$- _entry_point) = pop\$entry_point

	.end	pop$entry_point		;;; entry point


#_ELSE

	.set macro

	.section .rodata
adrtab:
	.WORD	I_LAB(Sys$- _init_args)		;;; _WOFFS*0
	.WORD	C_LAB(_special_var_block)	;;; _WOFFS*1
	.WORD	C_LAB(setpop)			;;; _WOFFS*2

	.text
	.align  4
DEF_C_LAB(Sys$- _entry_point)
	.globl  main
	.ent    main
main:
	ldgp    $29, 0(rpb)
	lda     rsp, -64(rsp)
	stq     rret, 0*8(rsp)
	stq     $9,   1*8(rsp)
	stq     $10,  2*8(rsp)
	stq     $11,  3*8(rsp)
	stq     $12,  4*8(rsp)
	stq     $13,  5*8(rsp)
	stq     $14,  6*8(rsp)
	stq     rfp,  7*8(rsp)		;;; $15
	mov	rsp, rfp
	.mask   0x0400FE00, -64		;;; saves regs 26, 9-15
	.frame  rfp, 64, rret, 0
	.prologue 1

	lda	rpb, adrtab		;;; don't know what work regs this uses

	;;; 2nd arg (ra1) is the address of arg string vec
	ldW	rt0, _WOFFS*0(rpb)
	stW	ra1, 0(rt0)

	ldW	rsvb, _WOFFS*1(rpb)	;;; set up _special_var_block in rsvp

	;;; save fp in _invocation_fp for unwinding after an error signal
	stW	rfp, _svb_INVOC_FP

	ldW	rfalse, _svb_FALSE	;;; set rfalse to false
	INIT_POP_REGISTERS		;;; set pop lvar registers to false
	stW	rzero, _svb_IN_USER_EXTERN  ;;; clear _in_user_extern
	ldW	rusp, _svb_SAVED_USP	;;; temp user stack pointer in rusp
	ldW	rpb, _WOFFS*2(rpb)	;;; get setpop
	ldW	rt0, _PD_EXECUTE(rpb)	;;; exec addr
	jsr	rret, (rt0)		;;; call setpop

	ldgp    $29, 0(rret)		;;; restore gp
	mov	0, rt0			;;; normal exit status

	ldq     rret, 0*8(rsp)
	ldq     $9,   1*8(rsp)
	ldq     $10,  2*8(rsp)
	ldq     $11,  3*8(rsp)
	ldq     $12,  4*8(rsp)
	ldq     $13,  5*8(rsp)
	ldq     $14,  6*8(rsp)
	ldq     rfp,  7*8(rsp)		;;; restore fp
	lda     rsp, 64(rsp)
	ret     rzero, (rret), 1	;;; special hint
	.end    main


#_ENDIF



/* --- Revision History ---------------------------------------------------
--- John Gibson, Mar 17 1998
	Changed __pop*_invocation_fp to pop variable _invocation_fp
 */
