/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:            C.vms/src/descriptor.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *EXTERNAL
 */


;;; ------------------- VMS DATA DESCRIPTORS -------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'
#_INCLUDE 'gctypes.ph'

constant
		procedure Sys$-Key_hash
	;

vms_use_macdefs DSC;		;;; For DSC$ constants

;;; ----------------------------------------------------------------------

section $-Sys => consdescriptor;

constant
	descriptor_key = struct KEY_R =>> {%
		_NULL,					;;; K_GC_RELOC
		key_key,				;;; KEY
		_:M_K_SPECIAL_RECORD _biset _:M_K_NONWRITEABLE,
								;;; K_FLAGS
		_:GCTYPE_DESCRIPTOR,	;;; K_GC_TYPE
		Record_getsize,			;;; K_GET_SIZE

		"descriptor",			;;; K_DATAWORD
		false,					;;; K_SPEC
		procedure() with_nargs 1;
			datakey() == descriptor_key
		endprocedure,			;;; K_RECOGNISER
		WREF Exec_nonpd,		;;; K_APPLY
		nonop ==,				;;; K_SYS_EQUALS
		WREF nonop ==,			;;; K_EQUALS
		Minimal_print,			;;; K_SYS_PRINT
		WREF Minimal_print,		;;; K_PRINT
		WREF Key_hash,			;;; K_HASH

		_:NUMTYPE_NON_NUMBER,	;;; K_NUMBER_TYPE
		_:PROLOG_TYPE_OTHER,	;;; K_PLOG_TYPE
		_:EXTERN_TYPE_NORMAL,	;;; K_EXTERN_TYPE
		_0,						;;; K_SPARE_BYTE

		@@(struct DESCRIPTOR)++,	;;; K_RECSIZE_R
		false,					;;; K_CONS_R
		false,					;;; K_DEST_R
		false,					;;; K_ACCESS_R
		%},

	_sysstring_desc = struct DESCRIPTOR =>>
						{% sysstring, descriptor_key,
						   =>> {% _:SYSSTRING_LENGTH,
								  _:'DSC$K_DTYPE_T',
								  _:'DSC$K_CLASS_S',
								  sysstring@V_BYTES
							   %}
						%}@DSC_SPEC;


define consdescriptor(item) -> desc;
	lvars item, desc, _spec;
	Check_bytevec(item);
	Get_record(descriptor_key) -> desc;
	item -> desc!DSC_ITEM;
	desc@DSC_SPEC -> _spec;
	item!V_LENGTH		-> _spec!DSPEC_LENGTH;
	_:'DSC$K_DTYPE_T'	-> _spec!DSPEC_DTYPE;
	_:'DSC$K_CLASS_S'	-> _spec!DSPEC_CLASS;
	item@V_BYTES		-> _spec!DSPEC_PTR
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr  7 1995
		Revised key layout
--- John Gibson, Mar 14 1990
		Change to key layout.
--- John Gibson, Dec  4 1989
		Changes for new pop pointers
--- John Gibson, Apr 15 1988
		Moved out of sysutil.p
 */
