/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:			C.alpha/src/drop_code.ph
 > Purpose:			Code-planting macros
 > Author:			John Gibson, Aug 18 1994
 */

#_INCLUDE 'registers.ph'

lconstant macro (

	;;; simple opcodes
	_OP_lda		= _16:08,
	_OP_ldah	= _16:09,
	_OP_ldl		= _16:28,
	_OP_ldq		= _16:29,
	_OP_stl		= _16:2C,
	_OP_stq		= _16:2D,
	_OP_ldq_u	= _16:0B,
	_OP_stq_u	= _16:0F,

	_OP_br		= _16:30,
	_OP_bsr		= _16:34,
	_OP_blbc	= _16:38,
	_OP_beq		= _16:39,
	_OP_blt		= _16:3A,
	_OP_ble		= _16:3B,
	_OP_blbs	= _16:3C,
	_OP_bne		= _16:3D,
	_OP_bge		= _16:3E,
	_OP_bgt		= _16:3F,

	_OP_ARITH	= _16:10,
	_OP_LOGIC	= _16:11,
	_OP_SHIFT	= _16:12,
	_OP_MUL		= _16:13,
	_OP_JMP		= _16:1A,

	;;; Arith/logical function codes
	_FUNC_addl	= _16:00,
	_FUNC_addq	= _16:20,
	_FUNC_subl	= _16:09,
	_FUNC_subq	= _16:29,
	_FUNC_s4addl= _16:02,
	_FUNC_s8addq= _16:32,
	_FUNC_cmpeq	= _16:2D,
	_FUNC_cmpult= _16:1D,
	_FUNC_cmpule= _16:3D,
	_FUNC_cmplt	= _16:4D,
	_FUNC_cmple	= _16:6D,
	_FUNC_mulq	= _16:20,
	_FUNC_and	= _16:00,
	_FUNC_or	= _16:20,
	_FUNC_sll	= _16:39,
	_FUNC_sra	= _16:3C,
	_FUNC_mskbl	= _16:02,
	_FUNC_mskwl	= _16:12,
	_FUNC_extbl	= _16:06,
	_FUNC_extwl	= _16:16,
	_FUNC_extll	= _16:26,
	_FUNC_insbl	= _16:0B,
	_FUNC_inswl	= _16:1B,
	_FUNC_extqh	= _16:7A,

	;;; Jump 'hints'
	_HINT_jmp		= _0,
	_HINT_jsr		= _1,
	_HINT_ret		= _2,
	_HINT_jsr_coroutine = _3,

	;;; 'compound' opcodes

	;;; Operate format arith/logical instructions
	_OP_addl	= [_OP_ARITH,	_FUNC_addl],
	_OP_addq	= [_OP_ARITH,	_FUNC_addq],
	_OP_subl	= [_OP_ARITH,	_FUNC_subl],
	_OP_subq	= [_OP_ARITH,	_FUNC_subq],
	_OP_s4addl	= [_OP_ARITH,	_FUNC_s4addl],
	_OP_s8addq	= [_OP_ARITH,	_FUNC_s8addq],
	_OP_cmpeq	= [_OP_ARITH,	_FUNC_cmpeq],
	_OP_cmpult	= [_OP_ARITH,	_FUNC_cmpult],
	_OP_cmpule	= [_OP_ARITH,	_FUNC_cmpule],
	_OP_cmplt	= [_OP_ARITH,	_FUNC_cmplt],
	_OP_cmple	= [_OP_ARITH,	_FUNC_cmple],
	_OP_mulq	= [_OP_MUL,		_FUNC_mulq],
	_OP_and		= [_OP_LOGIC,	_FUNC_and],
	_OP_or		= [_OP_LOGIC,	_FUNC_or],
	_OP_sll		= [_OP_SHIFT,	_FUNC_sll],
	_OP_sra		= [_OP_SHIFT,	_FUNC_sra],
	_OP_mskbl	= [_OP_SHIFT,	_FUNC_mskbl],
	_OP_mskwl	= [_OP_SHIFT,	_FUNC_mskwl],
	_OP_extbl	= [_OP_SHIFT,	_FUNC_extbl],
	_OP_extwl	= [_OP_SHIFT,	_FUNC_extwl],
	_OP_insbl	= [_OP_SHIFT,	_FUNC_insbl],
	_OP_inswl	= [_OP_SHIFT,	_FUNC_inswl],
	_OP_extqh	= [_OP_SHIFT,	_FUNC_extqh],

	;;; popints are shifted left to accord with word scaling
	WORD_SHIFT	= integer_length(_pint(@@(w)++)) - 1,	;;; = 2 or 3
);

#_IF ##(w)[_1|d] = _1

lconstant macro (
	_OP_ldW		= _OP_ldq,
	_OP_stW		= _OP_stq,
	_OP_addW	= nonmac _OP_addq,
	_OP_subW	= nonmac _OP_subq,
	_OP_sWaddW	= nonmac _OP_s8addq,
);

#_ELSE

lconstant macro (
	_OP_ldW		= _OP_ldl,
	_OP_stW		= _OP_stl,
	_OP_addW	= nonmac _OP_addl,
	_OP_subW	= nonmac _OP_subl,
	_OP_sWaddW	= nonmac _OP_s4addl,
);

#_ENDIF


define :inline lconstant _MEMf_INST(_Op, _Rval, _Disp, _Raddr);
	_shift(_Op, _26) _biset _shift(_Rval, _21) _biset _shift(_Raddr, _16)
			_biset (_Disp _bimask _:16:FFFF)
enddefine;

define :inline lconstant _MEMf_JMP_INST(_Hint, _Rval, _Raddr);
	_MEMf_INST(_OP_JMP, _Rval, _shift(_Hint, _:14), _Raddr)
enddefine;

define :inline lconstant _BRAf_INST(_Op, _Rval, _Disp);
	_shift(_Op, _26) _biset _shift(_Rval, _21)
			_biset (_shift(_Disp, _:-2) _bimask _:16:1FFFFF)
enddefine;

define :inline lconstant _OPfL_INST(_Op, _Func, _Rsrc, _Lit, _Rdst);
	_shift(_Op, _26) _biset _shift(_Rsrc, _21) _biset _shift(_Lit, _13)
			_biset _:16:1000 _biset _shift(_Func, _5) _biset _Rdst
enddefine;

define :inline lconstant _OPfR_INST(_Op, _Func, _Rsrc, _Rsrc2, _Rdst);
	_shift(_Op, _26) _biset _shift(_Rsrc, _21) _biset _shift(_Rsrc2, _16)
			_biset _shift(_Func, _5) _biset _Rdst
enddefine;
