/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.vms/src/sys_file_match.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:   REF *SYSUTIL
 */

;;; ------------------ MATCHING FILENAMES -------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'

section $-Sys$-Io;

constant
		procedure (File_stat, Rms_parse, Rms_search,
		Rms_display_search_open)
	;

endsection;

;;; --------------------------------------------------------------------

section $-Sys$-Io => sys_file_match;

define sys_file_match(fname, dfname, statbuff, stripdir);
	lvars   result, string, currdir = '[]', first = true,
			fname, dfname, search, statbuff, stripdir, state = 1
		;

	/* For consistency with Unix version */
	if isinteger(stripdir) then
		stripdir &&/=_0 2:1 -> stripdir;
	endif;


	define lconstant Next_filename();
		lvars len, pathlen, ctrl_blk;

		go_on state to LAB_1 LAB_2 LAB_3 LAB_4 LAB_5;

		LAB_1:
			Rms_search(search) -> result;
			if result == termin then
				5 -> state;
				return(termin)
			elseunless result then
				if first then
					return(false)
				else
					Syserr_mishap(0, 'ERROR IN FILENAME SEARCH')
				endif
			else
				;;; name in sysstring
				-> pathlen              ;;; length of path
				-> result               ;;; false if file can't be opened
			endif;

			if stripdir then
				;;; must make sure everything is extracted from sysstring
				;;; before returning (else could get reused)
				_pint(_sysstring_len) -> len;
				substring(pathlen fi_+ 1, len fi_- pathlen, sysstring) -> string;
				unless isstartstring(currdir, sysstring) then
					;;; directory has changed
					substring(1, pathlen, sysstring) -> currdir;
					if first then
						false -> first, 2 -> state;
						return(true)
					endif;
		LAB_2:
					3 -> state;
					return(currdir, false)
				endunless
			else
				Copy_sysstring() -> string
			endif;
		LAB_3:
			if first then
				false -> first, 4 -> state;
				return(true)
			endif;
		LAB_4:
			if result and statbuff then
				if Rms_display_search_open(search) ->> ctrl_blk then
					File_stat(ctrl_blk, statbuff)
				else
					false
				endif
			elseif statbuff then
				false
			endif;
			1 -> state;
			return((), string);

		LAB_5:
			return(termin)
	enddefine;

	if Rms_parse(fname, dfname) ->> search then
		;;; run it once - this checks that all of the filespec is valid
		if Next_filename() then Next_filename else false endif
	else
		false
	endif
enddefine;

endsection;     /* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Williams, Jul  5 1993
		________stripdir argument can now be a set of integer flags (for
		consistency with Unix version).
--- John Gibson, Aug  8 1989
		Rewritten so that no host/disk/dir or version returned in filenames
		unless present in the original name (or default name).
--- John Gibson, Apr 26 1988
		Moved out of sysio.p
 */
