/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:            C.vax/src/syscomp/genfloat.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				  FLOATING-POINT GENERATION (VAX FORMATS)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas;

#_IF DEF ALPHA
	;;; Alpha uses G format rather than D format for doubles
lconstant macro VAX_G = true;
#_ENDIF

lconstant macro (
	S_EXP_BITS	= 8,
	S_EXCESS	= 128,
	S_SIG_BITS	= 24,
	D_EXP_BITS	= #_IF DEF VAX_G  11  #_ELSE  8  #_ENDIF,
	D_EXCESS	= 1 << (D_EXP_BITS-1),		;;; 128 or 1024
	D_SIG_BITS	= 64 - D_EXP_BITS,			;;; 56 or 53
);


	/*	Generate word value for a machine single-float = signif * 2**expo
		(VAX 'F' format)
	*/
define s_float_val(signif, expo);
	lvars signif, expo, signbit, len, lo16, hi7;
	returnif(signif == 0) (syspop\:_int(0));
	if signif < 0 then 1 else 0 endif -> signbit;
	abs(signif) -> signif;
	integer_length(signif) -> len;
	expo + len + S_EXCESS -> expo;
	(signif << (S_SIG_BITS-len)) -> signif;
#_IF DEF VAX or DEF ALPHA
	signif && 16:FFFF -> lo16;
	signif >> 16 -> signif;
	signif && 16:7F -> hi7;
	syspop\:_int( (lo16 << 16) || (signbit << 15) || (expo << 7) || hi7 )
#_ELSE
	syspop\:_int( (signbit << 31) || (expo << 23) || (signif && 16:7FFFFF) )
#_ENDIF
enddefine;


	/*	Generate int values for a machine double-float = signif * 2**expo
		(VAX 'D' or 'G' format)
	*/

define lconstant d_float_ints(signif, expo, memorder);
	lvars signif, expo, memorder, signbit, lo32_lo, lo32_hi, mid16, hi, len;
	returnif(signif == 0) (dup(0));
	if signif < 0 then 1 else 0 endif -> signbit;
	abs(signif) -> signif;
	integer_length(signif) -> len;
	expo + len + D_EXCESS -> expo;			;;; excess-128/1024 exponent
	signif << (D_SIG_BITS-len) -> signif;	;;; total precision = 56/53 bits

#_IF DEF VAX or DEF ALPHA
	if memorder then
		signif && 16:FFFF -> lo32_lo;
		signif >> 16 -> signif;
		signif && 16:FFFF -> lo32_hi;
		signif >> 16 -> signif;
		signif && 16:FFFF -> mid16;
		signif >> 16 -> signif;
		lconstant macro wHI_BITS = 15-D_EXP_BITS;
		signif && (1<<wHI_BITS - 1) -> hi;
		(mid16<<16) || (signbit<<15) || (expo<<wHI_BITS) || hi,
				(lo32_lo << 16) || lo32_hi;
		return
	endif;
#_ENDIF

	signif && 16:FFFFFFFF -> lo32_lo;
	signif >> 32 -> signif;
	lconstant macro HI_BITS = 31-D_EXP_BITS;
	signif && (1<<HI_BITS - 1) -> hi;
	(signbit<<31) || (expo<<HI_BITS) || hi, lo32_lo
enddefine;

define d_float_vals(/*signif, expo*/) /* -> (lo_addr_int, hi_addr_int) */;
	lvars (lo_addr, hi_addr) = d_float_ints(true);
	syspop\:_int(lo_addr), syspop\:_int(hi_addr)
enddefine;

	/*	Generate word value for a pop decimal = signif * 2**expo
	*/
define pd_float_val(signif, expo);
	lvars signif, expo;
#_IF WORD_BITS==DOUBLE_BITS
	;;; encode decimal in T format on Alpha
	lvars (hi32, lo32) = d_float_ints(false);
	(hi32 << 32) || lo32 &&~~ 2:100 -> signif;
#_ELSE
	syspop\:_pint(s_float_val(signif, expo)) -> signif;
  #_IF DEF VAX or DEF ALPHA
	;;; swap hi and low 16 bits
	((signif && 16:FFFF) << 16) || (signif >> 16) -> signif;
  #_ENDIF
#_ENDIF
	;;; set pop decimal in tag bits
	syspop\:_int( signif &&~~ 2:11 || 2:01 )
enddefine;


;;; --- PARAMETERS -----------------------------------------------------

constant macro (
	;;; number of sig bits in pop decimal
	$- DECIMAL_SIG_BITS	= #_IF WORD_BITS==DOUBLE_BITS	D_SIG_BITS-3
						  #_ELSE						S_SIG_BITS-2
						  #_ENDIF,
	;;; number of sig bits in pop ddecimal
	$- DDECIMAL_SIG_BITS = D_SIG_BITS,
	;;; number of sig bits in a double float
	$- DFLOAT_SIG_BITS	= D_SIG_BITS,
	);

define lconstant param_vec(SB, EX, pd);
	lvars SB, EX, procedure pd;
	{%	SB,						;;; number of sig bits
		pd(1<<SB-1, EX-1-SB), 	;;; most +ve
		pd(1, -EX),				;;; least +ve
		pd(-1, -EX),			;;; least -ve
		pd(-1<<SB+1, EX-1-SB),	;;; most  -ve
		pd(1, -SB),				;;; plus epsilon
		pd(1, -SB),				;;; minus epsilon
	%}
enddefine;


	/*	Used in float_params.p to generate pop_float_parameters
	*/
define macro $- GEN_DEC_PARAM_VEC;
	perm_const_lab([decimal_key]) -> ;	;;; mark this used
	param_vec(DECIMAL_SIG_BITS,	#_IF WORD_BITS==DOUBLE_BITS	D_EXCESS
								#_ELSE 						S_EXCESS
								#_ENDIF, pd_float_val)
enddefine;


	/*	Used in float_params.p to generate pop_float_parameters
	*/
define macro $- GEN_DDEC_PARAM_VEC;

	define lconstant pdd(signif, expo);
		lvars signif, expo, v;
#_IF WORD_BITS==DOUBLE_BITS
		lvars (loaddr, hiaddr) = d_float_ints(signif, expo, true);
		{% syspop\:_int( (hiaddr << 32) || loaddr ), ddecimal_key %} -> v;
#_ELSE
		lvars (_loaddr, _hiaddr) = d_float_vals(signif, expo);
		{% _loaddr, ddecimal_key, _hiaddr %} -> v;
#_ENDIF
		cons_free_struct("DDECIMAL", v)
	enddefine;

	param_vec(DDECIMAL_SIG_BITS, D_EXCESS, pdd);
enddefine;


endsection;		/* $-Popas */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug  4 1995
		Fixed problems in d_float_ints and GEN_DDEC_PARAM_VEC and gave
		the macros the correct names!
--- John Gibson, May 10 1995
		Changes for 64-bit decimals
--- John Gibson, Oct 12 1994
		Changed to generate 'G' format doubles for Alpha
--- John Gibson, Jun  7 1989
		Included common.ph and changed _int to syspop\:_int
--- John Gibson, Mar 23 1989
		keys to top level
--- John Gibson, Feb 11 1988
		Revised macros for generating float parameters
 */
