/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.axpvms/src/syscomp/sysdefs.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */
compile_mode :pop11 +strict;

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM

--------------------------------------------------------------------------*/

section;


constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; --- SYSTEM NAME ---------------------------------------------------------

	MACHINE			= [[alpha]],
	ALPHA_VMS		= true,


;;; --- MACHINE = ALPHA ------------------------------------------------------

	PROCESSOR		= [[alpha]],		;;; type of cpu
	ALPHA			= true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	STACK_ALIGN_BITS= 64,			;;; alignment in bits for stack frames


;;; --- OPERATING SYSTEM = VMS --------------------------------------------

	VMS					= 6.1,
	OPERATING_SYSTEM	= [[vms ^VMS]],		;;; type of os

	VPAGE_OFFS			= 16:2000,	;;; word address offset of a virtual page
	LOWEST_ADDRESS		= 0,		;;; lowest pop structure address
	SHARED_LIBRARIES	= true,
	EXTERN_CALLBACK_UNWIND = true,	;;; see extern_callback.p


;;; --- OTHER ------------------------------------------------------------

	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],


	;;; if GEN_SVB_CONSTANTS is true, constants in _special_var_block will be
	;;; generated by Poplink, and recognised in the production of M-code
	;;; operands by Popc (providing genproc.p defines SPECIAL_VAR_BLOCK_REG).

	GEN_SVB_CONSTANTS	= true,
);

define :inline CACHEFLUSH(_ptr, _nbytes);
	$-Sys$- _cache_flush()		;;; compiles to 'call_pal imb'
enddefine;

endsection;		/* $- */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Removed is* procedures from SUBROUTINE_OPTIMISE_LIST (no longer
		required).
--- John Gibson, Aug 11 1995
		_cache_flush into section $-Sys (for consistency with Sun4 one)
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
 */
