/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 > File:            C.vms/src/sysdate.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 > Documentation:	REF *TIMES
 */

;;;----------------------- DATE PROCEDURES -----------------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmsdefs.ph'

section $-Sys;

constant
		procedure (Pint_unix_time, Check_integral)
	;

endsection;

;;; ---------------------------------------------------------------------

section $-Sys => sys_convert_date, sysdaytime;

	;;; get ascii day and time string from quadword at given address
define lconstant Ascii_time(_quadp);
	lvars _quadp;
	_extern sys\$asctim(
					/* timlen */ ident _sysstring_len,
					/* timbuf */ _sysstring_desc,
					/* timadr */ _quadp,
					/* cvtflg */ )		;;; default means full date and time
		-> ;
	_sysstring_len _sub _3 -> _sysstring_len;	;;; don't want 1/100ths sec
	Copy_sysstring()
enddefine;

	;;; convert a Unix time in seconds to a string
	;;; (_____local arg isn't used)
define sys_convert_date(seconds, local);
	lvars seconds, local;
	lstackmem long[2] _quadp;
	Check_integral(seconds);
	seconds -> Pint_unix_time(_quadp);
	Ascii_time(_quadp)
enddefine;

	;;; get date and time as a string
define sysdaytime();
	Ascii_time(_0)		;;; _0 address means current time
enddefine;

endsection;		/* $-Sys */



/* --- Revision History ---------------------------------------------------
 */
