/* --- Copyright University of Sussex 1992. All rights reserved. ----------
 > File:			C.vms/src/vmsio.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 */

;;; ----------------- VAX/VMS SYSTEM SERVICE I/O ---------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'io.ph'
#_INCLUDE 'vmsdefs.ph'

weak constant
		procedure $-Sys$-Xt$-Xpt_read_wait
	;


;;; ----------------------------------------------------------------------

section $-Sys;

vars
	_read_wait_status	= _0,
	;

	;;; C name for _read_wait_status
define_extern_name _pop_read_wait_status = ident _read_wait_status;


lvars
	_io_stat_buf		= _INIT_NONPOP_STRUCT(struct IO_STAT_BUF),
	;


define lconstant QioW(_chan, _func, _statbuf, _p1, _p2, _p3, _p4, _p5, _p6);
	lvars _waiting, _chan, _func, _statbuf, _p1, _p2, _p3, _p4, _p5, _p6;
	_extern sys\$qiow(
				/* efn	  */	,
				/* chan	  */	_chan,
				/* func	  */	_func,
				/* iosb	  */	_statbuf,
				/* astadr */	,
				/* astprm */	,
				/*	p1	  */	_p1,
				/*	p2	  */	_p2,
				/*	p3	  */	_p3,
				/*	p4	  */	_p4,
				/*	p5	  */	_p5,
				/*	p6	  */	_p6) ->
enddefine;


;;; --- ENABLE/DISABLE ASTS ----------------------------------------------


	/*	_ast_routine is routine to enable, zero to disable
	*/
define Vms_set_chan_AST(_chan, _func, _ast_routine, _ast_param);
	lvars _chan, _func, _ast_routine, _ast_param;
	_func _biset _:'IO$_SETMODE' -> _func;
	;;; disable first to ensure not enabled more than once
	QioW(_chan, _func, _io_stat_buf, _0, _0, _0, _0, _0, _0);
	if _ast_routine /== _NULL then
		QioW(_chan, _func, _io_stat_buf, _ast_routine, _ast_param,
														_0, _0, _0, _0)
	endif
enddefine;

	/*	For Control-C on terminals
	*/
define Vms_set_Ctrl_C(dev, _enable);
	lvars unit = dev!D_UNIT_N, dev, _chan, _enable;
	returnunless(unit!UNT_DEVCHAR _bitst _:'DEV$M_TRM');
	unit!UNT_TRM_CHANNEL -> _chan;
	chain(_chan, _:'IO$M_CTRLCAST',
						if _enable then
							_extern _pop_ctrlc_ast, _chan
						else
							_NULL, _0
						endif, Vms_set_chan_AST)
enddefine;

endsection;		/* $-Sys */


;;; -----------------------------------------------------------------------

section $-Sys$-Io;


;;; --- ASYNC READING -----------------------------------------------------

define lconstant Qio(_waiting, ctrl_blk, _func, buf, _p4, _p5, _p6);
	lvars	ctrl_blk, buf, _func, _p4, _p5, _p6, _chan = ctrl_blk!ICB_CHANNEL,
			_waiting;

	if _waiting then
		ctrl_blk!ICB_FLAGS _biset _M_ICB_ASYNC_LIVE -> ctrl_blk!ICB_FLAGS;
		;;; start async read
		_extern sys\$qio(
				/* efn    */	ctrl_blk!ICB_ASYNC_EFN,
				/* chan   */    _chan,
				/* func   */    _func,
				/* iosb   */    buf@BUF_IOSB,
				/* astadr */    ,
				/* astprm */    ,
				/*  p1    */    buf@BUF_START,
				/*  p2    */    buf!BUF_SIZE,
				/*  p3    */    _0,
				/*  p4    */    _p4,
				/*  p5    */    _p5,
				/*  p6    */    _p6) ->
	else
		QioW(_chan, _func, buf@BUF_IOSB, buf@BUF_START, buf!BUF_SIZE,
														_0, _p4, _p5, _p6)
	endif
enddefine;

define lconstant Wait(ctrl_blk);
	lvars ctrl_blk, _res, _flags, _efn = ctrl_blk!ICB_ASYNC_EFN;

	(testdef $-Sys$-Xt$-Xpt_read_wait
		and weakref $-Sys$-Xt$-Xpt_read_wait(_efn))
	or _pint(_extern _pop_read_wait(_efn))
	-> _res;

	if _res fi_> 0
	and (ctrl_blk!ICB_FLAGS ->> _flags) _bitst _M_ICB_ASYNC_LIVE then
		;;; iosb valid -- clear outstanding async
		_flags _biclear _M_ICB_ASYNC_LIVE -> ctrl_blk!ICB_FLAGS;
		true
	else
		_:'SS$_CANCEL' -> _syserror;
		false
	endif
enddefine;


;;; --- TERMINAL I/O ------------------------------------------------------

lconstant
	_no_break_chars		= initv(8)@V_BYTES,
	break_chars			= consstring(#| repeat 32 times 16:FF endrepeat |#),
	_break_chars_desc	= _DESCRIPTOR break_chars,
	;

define Trm_test_input(_chan);
	lvars _chan, _n;
	QioW(_chan, _:'IO$_SENSEMODE!IO$M_TYPEAHDCNT', _io_stat_buf,
										sysstring, _8, _0, _0, _0, _0);
	if _zero(sysstring!(short) ->> _n) then
		false
	else
		;;; number of chars in typeahead buffer
		_pint(_n)
	endif
enddefine;

	/*	Read terminal -- called from Rms_get
	*/
define Trm_read(dev, prompt);
	lvars	ctrl_blk = dev!D_CTRL_BLK, dev, prompt, _buf, _func = _0,
			_p4, _p5, _p6, _flags, _count, _trmbyte, _iosb, _raw,
			_chan = ctrl_blk!ICB_CHANNEL, _waiting = true;

	ctrl_blk!ICB_FLAGS -> _flags;
	ctrl_blk@ICB_FAB!FAB$B_FAC _bitst _:'FAB$M_BIO' -> _raw;

	unless _flags _bitst _M_ICB_ASYNC_LIVE then
		if _raw then
			;;; 'raw' mode
			_func _biset _:'IO$M_NOECHO!IO$M_NOFILTR' -> _func;
			if not(_flags _bitst _M_ICB_PURGE) and Trm_test_input(_chan) then
				_flags _biset _M_ICB_READ_NOW -> _flags;
				_no_break_chars
			else
				_break_chars_desc
			endif -> _p4
		else
			;;; normal line mode
			_0 -> _p4
		endif;

		if _flags _bitst _M_ICB_PURGE then
			;;; purge type-ahead (one-shot)
			_func _biset _:'IO$M_PURGE' -> _func;
			_flags _biclear _M_ICB_PURGE -> _flags
		endif;
		if _flags _bitst _M_ICB_READ_NOW then
			;;; no wait on read (one shot)
			_func _biset _:'IO$M_TIMED' -> _func;	;;; with 0 timeout
			_flags _biclear _M_ICB_READ_NOW -> _flags;
			false -> _waiting	;;; no wait
		endif;
		_flags -> ctrl_blk!ICB_FLAGS;

		if prompt then
			_func _biset _:'IO$_READPROMPT' -> _func;
			prompt!V_LENGTH -> _p6;
			if prompt >=@(w) _system_end then
				;;; put it in the buffer
				dev!D_IN_BUFFER@BUF_START -> _p5;
				_bmove(@@(b)[_p6], prompt@V_BYTES, _p5) ->
			else
				prompt@V_BYTES -> _p5
			endif
		else
			;;; no prompt
			_func _biset _:'IO$_READVBLK' -> _func;
			_0 ->> _p5 -> _p6
		endif;

		Qio(_waiting, ctrl_blk, _func, dev!D_IN_BUFFER, _p4, _p5, _p6)

	;;; else async read already outstanding
	elseif prompt then
		;;; refresh it by doing an empty write with IO$M_REFRESH
		QioW(_chan, _:'IO$_WRITEVBLK!IO$M_BREAKTHRU!IO$M_REFRESH',
						_io_stat_buf, nullstring, _0, _0, _0, _0, _0)
	endunless;

	if _waiting then returnunless(Wait(ctrl_blk)) (false) endif;

	dev!D_IN_BUFFER -> _buf;
	_buf@BUF_IOSB -> _iosb;

	_iosb!IOSB_STATUS -> _func;
	if _func == _:'SS$_NORMAL' or _func == _:'SS$_TIMEOUT' then
		_iosb!IOSB_COUNT -> _count;
		unless _raw or _func == _:'SS$_TIMEOUT' then
			_buf!BUF_START[_count] -> _trmbyte;
			if _trmbyte == _:`\r` then
				_:`\n` -> _buf!BUF_START[_count]
			elseif _trmbyte == _:`\^Z` then
				_:'SS$_TIMEOUT' -> _func
			endif
		endunless;
		unless _func == _:'SS$_TIMEOUT' then
			_iosb!IOSB_TERMIN_LEN _add _count -> _count
		endunless;
		_count -> _buf!BUF_COUNT;
		true
	else
		if _func == _:'SS$_ABORT' or _func == _:'SS$_CONTROLC' then
			_:'SS$_CANCEL' -> _func
		endif;
		_func -> _syserror;
		false
	endif
enddefine;

	/*	Write terminal -- called from Rms_put
	*/
define Trm_write(dev);
	lvars	ctrl_blk = dev!D_CTRL_BLK, dev, _buf = dev!D_OUT_BUFFER, _func,
			_count, _carriage_ctrl = _0;

	returnif(_zero(_buf!BUF_POSITION ->> _count)) (true);

	if ctrl_blk@ICB_FAB!FAB$B_FAC _bitst _:'FAB$M_BIO' then
		;;; 'raw' mode
		_:'IO$_WRITEVBLK!IO$M_BREAKTHRU!IO$M_NOFORMAT' -> _func
	else
		;;; normal line mode
		_:'IO$_WRITEVBLK!IO$M_BREAKTHRU' -> _func;
		if _buf!BUF_START[_count _sub _1] == _:`\n` then
			;;; ends with newline
			_16:01000000 -> _carriage_ctrl;			;;; 1 CR/LF after line
			if _zero(_count _sub _1 ->> _count) then
				;;; output a blank line as a space, because otherwise VMS
				;;; ignores it after an input RETURN
				_:`\s` -> _buf!BUF_START[_0];
				_1 -> _count
			endif
		endif
	endif;

	QioW(ctrl_blk!ICB_CHANNEL, _func, _buf@BUF_IOSB, _buf@BUF_START,
									_count, _0, _carriage_ctrl, _0, _0);
	_0 -> _buf!BUF_POSITION;
	true
enddefine;


;;; --- MAILBOX I/O ------------------------------------------------------

define Mbx_test_input(_chan);
	lvars _chan, _n;
	_extern sys\$getchn(
				/* chan   */	_chan,
				/* prilen */	,
				/* pribuf */	_sysstring_desc,
				/* scdlen */	,
				/* scdbuf */	) -> ;
	if _zero(sysstring@DIB\$L_DEVDEPEND!(short) ->> _n) then
		false
	else
		;;; number of messages in mailbox
		_pint(_n)
	endif
enddefine;

	/*	Read mailbox -- called from Rms_get
	*/
define Mbx_read(dev);
	lvars	ctrl_blk = dev!D_CTRL_BLK, dev, _buf, _func, _chan, _flags,
			_iosb, _unit, _waiting = true;

	ctrl_blk!ICB_FLAGS -> _flags;
	unless _flags _bitst _M_ICB_ASYNC_LIVE then
		_:'IO$_READVBLK' -> _func;
		if _flags _bitst _M_ICB_READ_NOW then
			;;; no wait on read (one shot)
			_func _biset _:'IO$M_NOW' -> _func;
			_flags _biclear _M_ICB_READ_NOW -> ctrl_blk!ICB_FLAGS;
			false -> _waiting	;;; no wait
		endif;

		Qio(_waiting, ctrl_blk, _func, dev!D_IN_BUFFER, _0, _0, _0)

	;;; else async read already outstanding
	endunless;

	if _waiting then returnunless(Wait(ctrl_blk)) (false) endif;

	dev!D_IN_BUFFER -> _buf;
	_buf@BUF_IOSB -> _iosb;

	_iosb!IOSB_STATUS -> _func;
	if _func == _:'SS$_NORMAL' then
		_iosb!IOSB_COUNT -> _buf!BUF_COUNT;
		true
	elseif _func == _:'SS$_ENDOFFILE' then
		0
	else
		if _func == _:'SS$_ABORT' then _:'SS$_CANCEL' -> _func endif;
		_func -> _syserror;
		return(false)
	endif;

	if dev!D_UNIT_P!UNT_INPUT_TRAP then
		;;; re-enable AST on mailbox after successful read
		dev!D_UNIT_N -> _unit;
		Vms_set_chan_AST(_unit!UNT_MBX_CHANNEL, _:'IO$M_WRTATTN',
						_extern _pop_wrtattn_ast, _unit!UNT_UNIT_NUM)
	endif
enddefine;

	/*	Write mailbox -- called from Rms_put
	*/
define Mbx_write(dev, _eof);
	lvars	ctrl_blk = dev!D_CTRL_BLK, dev, _buf, _func, _eof,
			_chan = ctrl_blk!ICB_CHANNEL;
	dlocal _read_wait_status;

	if _eof then
		;;; write eof
		_:'IO$_WRITEOF!IO$M_NOW' -> _func
	else
		_:'IO$_WRITEVBLK' -> _func;
		if ctrl_blk!ICB_FLAGS _bitst _M_ICB_MBX_OUTWAIT then
			_CHECKINTERRUPT;
			_chan -> _read_wait_status ;;; so the qiow can be cancelled
		else
			_func _biset _:'IO$M_NOW' -> _func
		endif
	endif;

	dev!D_OUT_BUFFER -> _buf;
	QioW(_chan, _func, _buf@BUF_IOSB, _buf@BUF_START, _buf!BUF_POSITION,
														_0, _0, _0, _0);

	_buf@BUF_IOSB!IOSB_STATUS -> _func;
	if _func == _:'SS$_NORMAL' then
		true
	elseif _func == _:'SS$_ABORT' or _func == _:'SS$_CANCEL' then
		chain(dev, _eof, Mbx_write)
	else
		false
	endif
enddefine;


;;; --- AED I/O (SPECIAL TO SUSSEX) ---------------------------------------

define Vms_aed_read(_bptr, _nbytes, ctrl_blk, _dma);
	lvars ctrl_blk, _dma, _bptr, _nbytes;
	QioW(ctrl_blk!ICB_CHANNEL,
			if _dma then _:'IO$_READVBLK' else _:'IO$_READVBLK!IO$M_WORD' endif,
			_io_stat_buf, _bptr, _nbytes, _0,
			if _dma then _47 else _0 endif, _0, _0);
	_io_stat_buf!IOSB_COUNT	;;; bytes read
enddefine;

define Vms_aed_write(_bptr, _nbytes, ctrl_blk, _dma);
	lvars ctrl_blk, _dma, _bptr, _nbytes;
	QioW(ctrl_blk!ICB_CHANNEL,
			if _dma then _:'IO$_WRITEVBLK' else _:'IO$_WRITEVBLK!IO$M_WORD' endif,
			_io_stat_buf, _bptr, _nbytes, _0,
			if _dma then _46 else _0 endif, _0, _0)
enddefine;

endsection;		/* $-Sys$-Io */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Dec  5 1992
		Changes to make async reads work without cancellation on
		interrupts
--- John Gibson, Dec  1 1991
		Changed to use array of stat buffers instead of a single one
--- John Gibson, Feb  3 1991
		Added X wait for reads
--- John Gibson, Dec  5 1990
		Many changes
--- John Gibson, Nov 22 1990
		Now uses _extern _pop_ctrlc_ast
--- John Gibson, Feb 20 1989
		Made -Vms_set_dev_AST- a separate procedure
--- John Gibson, Feb 19 1989
		Included io.ph
--- John Gibson, Aug 14 1987
		Changed for segmented system
 */
