/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:			C.all/lib/proto/go.p
 > Purpose:			GO library loader
 > Author:			Ben Rabau 1993 (see revisions)
 > Documentation:   HELP * GO
 */

/*
	_______WARNING: This  is  the  first  version of  a  class  library  of
	graphical objects and is distributed with this release of Poplog
	for evaluation and comment. As a  result of feedback and in  the
	interests of  better  integration with  Poplog,  the  facilities
	described may be modified. While all reasonable endeavours  will
	be made to limit incompatible changes, programs which use  these
	facilities may require modification to run on later versions.
*/

section;

global constant go_version = 1000;

lconstant
	godir = '$usepop/pop/lib/proto/go/';

lconstant goauto =    godir dir_>< 'auto/';
lconstant golib =     godir dir_>< 'lib/';
lconstant goinclude = godir dir_>< 'include/';

;;; Load and show from go directory
extend_searchlist(goauto, popautolist) -> popautolist;
extend_searchlist(golib, popuseslist) -> popuseslist;
extend_searchlist(goinclude, popuseslist) -> popuseslist;

;;; And extend ved's teach and help and ref lists
;;; do doc and ref, but at present teach and help suffice
lconstant
	goteach = [% godir dir_>< 'teach/' % teach],
	gohelp = [% godir dir_>< 'help/' % help],
	goref = [% godir dir_>< 'ref/' % help],
	goteachlist = [^goteach ^gohelp ^goref],
	gohelplist = [^gohelp ^goteach ^goref],
	goreflist = [^goref ^gohelp ^goteach];

extend_searchlist(ident gohelplist, vedhelplist) -> vedhelplist;
extend_searchlist(ident goteachlist, vedteachlist) -> vedteachlist;
extend_searchlist(ident goreflist, vedreflist) -> vedreflist;


endsection;

;;;----------------------------------------------------------------
;;; MEMORY
;;; Try to get the minimum space required for running GO
if popmemlim then
	max( popmemlim-popmemused, 400000 ) + popmemused -> popmemlim;
endif;

;;;----------------------------------------------------------------
;;; OBJECTCLASS AND X
;;; Load the ObjectClass & X libraries: requires at least OC 5.03
uses go_load_require;

;;;----------------------------------------------------------------
;;; MIXIN GO_SHORT_PRINT
;;;    Overwrites print_object() method to avoid endless loops at
;;;    print-time:
;;;
define :mixin go_short_print;
enddefine;

define :method print_object( item :go_short_print );
lvars item;
dlocal 1 % pop_oc_print_level % = 0;
dlocal 1 % pop_oc_print_loop_check % = true;
	call_next_method( item );
enddefine;

;;;----------------------------------------------------------------
;;; LOAD GRAPHIC OBJECT LIBRARY FILES
;;;----------------------------------------------------------------

exload_batch;

   ;;; add X libraries onto the search paths
   uses popxlib;

   ;;; force the graphics widget to be loaded
   XptWidgetSet("Poplog")("GraphicWidget")->;

   ;;; load Poplog/GO basics
   uses go_screen_object;
   uses go_pane;
   ;;; load Poplog/GO X-interface
   uses go_xdraw;
   uses go_xdrag;
   ;;; load Poplog/GO builtin objects
   uses go_window_pane;
   ;;; The following now is autoloadable
   ;;; uses go_rc_window;
   uses go_sensitive;
   uses go_key_sensitive;
   uses go_mouse_sensitive;
   uses go_xaction;
   uses go_shell;

   uses go_point;
	   uses go_editor;
	   uses go_edit_point;
   uses go_polygon;
   ;;; The following now is autoloadable
   ;;; uses go_polyline;
   ;;; uses go_polyarrow;
   ;;; uses go_rectangle;
   ;;; uses go_oblong;
   uses go_arc;
   ;;; The following now is autoloadable
   ;;; uses go_circle;
   uses go_labelled;
   ;;; The following now is autoloadable
   ;;; uses go_text;
   ;;; uses go_text_input;
   uses go_bitmap;

   uses go_group;

endexload_batch;


define go_init();
lvars shell;
	newgo_shell() -> shell;
	go_show( shell );
enddefine;

define go_init_rc();
lvars pane;
	;;; Avoid autoloading the go_rc_window library unless used...
	apply( valof("newgo_rc_window") ) -> pane;

	;;; switch motionhints on to optimise the dragging of larger objects...
	true -> go_motionhint( pane );
enddefine;

define go_refresh();
lvars pane;
	for pane in rev(go_panes) do;
		go_redraw( pane );
	endfor;
enddefine;

define go_destroy();
lvars pane, shell, all_shells = go_shells, all_panes;
	for shell in all_shells do
		go_destroy_object( shell );
	endfor;
	go_panes -> all_panes;   ;;; Some are already destroyed above
	for pane in all_panes do;
		go_destroy_object( pane );
	endfor;
	sysgarbage();
enddefine;

define go_reinit();
lvars pane, widget;
	for pane in go_panes do;
	;;; the_go_window(pane) -> widget;
	;;; if xt_islivewindow( widget ) then
			go_remove_notice_button( pane );
			go_remove_notice_key( pane );
	;;; endif;
	endfor;
	for pane in go_panes do;
	;;; the_go_window(pane) -> widget;
	;;; if xt_islivewindow( widget ) then
			go_add_notice_button( pane );
			go_add_notice_key( pane );
	;;; endif;
	endfor;
	go_refresh();
enddefine;

;;; Compile all the methods now:
global vars execute_optimise_objectclass;
if execute_optimise_objectclass then optimise_objectclass( "all" ); endif;

;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go = true;

/* --- Revision History ---------------------------------------------------
--- Simon Nichols, Oct 19 1993
		Moved from C.all/lib/lib to C.all/lib/proto and added warning.
 * JJC 06/10/93
 * 		Renamed version identifier from goversion to go_version and
 *	    set to be 1000.
 *      Removed printing of warning message if $DISPLAY not set.
 *		Made godir an lconstant.
 * BR 14/06/93
 *     Corrected comment from go_rcwindow to go_rc_window
 * BR 09/05/93
 *     Replaced the go_label file name into go_text to make it auto-loadable
 *     Replaced calls to go_refresh_pane() with go_redraw().
 * BR 28/04/93
 *     Renamed most file names to reflect go_<class name>
 *     Made some files autoloadable and no longer loaded by default.
 * BR 15/04/93
 *     Removed global var oblong_radius from go.p and go_oblong class.
 * BR,AR 14/04/93
 *     Removed go_prut() and replaced by a new MIXIN go_short_print
 *     which overwrites the standard print_object() method of OC to
 *     avoid printing out objects which refer to themselves. This is
 *     only necessarry until OC has a objectclass_print_limit vars.
 * BR 15/02/93
 *     Removed link to OLD.p (edit_stroke)
 *     Removed colours for sketch ...
 *     Renamed prut go_prut
 * IR 26/01/93
 *     corrected prut() to use safer argument passing into printf.
 */
