/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_edit_point.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 5th Aug 1993
;;; File: go_edit_point.p
;;; Author: Ben L.E. Rabau

compile_mode :pop11 +strict;

include XpwPixmap.ph;
uses go_point;
uses go_fillable;
uses go_editor;

;;; INTRO: The go_edit_point CLASS is a special case of the editor class:
;;; INTRO: It is used to edit specific location of another object.

;;;--------------------------------------------------------------
;;; EDIT_POINT CLASS

define :class go_edit_point;
	isa go_editor go_fillable go_point go_short_print;

	slot stored_go_filled == true;
;;; REF: An edit point always draws something in a background colour.
;;; REF: See also REF * GO_COLOURABLE/go_bgcolour.

enddefine;


;;;--------------------------------------------------------------
;;; LOCATABLE METHODS
;;;
;;; WARNING:
;;;         THE FOLLOWING NEEDS OBJECTS FROM THE LOCATED CLASS !!
;;;--------------------------------------------------------------

define :method go_xcentre( pnt :go_edit_point ) -> x;
lvars x, y, pnt;
;;; REF: go_xcentre( EDIT_POINT ) -> INTEGER;
	;;; THE FOLLOWING SHOULD CALL THE OBJECT'S LOCATION !!!
	if (pnt.go_edited_object) then
		stored_go_get_absolute(pnt)(pnt.go_edited_object) -> (x, y) ;
	endif;
enddefine;

define :method updaterof go_xcentre( x, pnt :go_edit_point );
lvars x, pnt;
;;; REF: INTEGER -> go_xcentre( EDIT_POINT );
;;; REF: The horizontal location in world coordinates of the point edited
;;; REF: by the edit point (see also REF * GO_LOCATED).
;;; REF: EDIT_POINT is a go_edit_point instance (REF * GO_EDIT_POINT).
	;;; THE FOLLOWING SHOULD CALL THE OBJECT'S UPDATER METHOD !!!
	if (pnt.go_edited_object) then
		stored_go_move_absolute(pnt)(x, pnt.go_ycentre, pnt.go_edited_object);
	endif;
	call_next_method( x, pnt );
enddefine;

define :method go_ycentre( pnt :go_edit_point ) -> y;
lvars x, y, pnt;
;;; REF: go_ycentre( EDIT_POINT ) -> INTEGER;
	;;; THE FOLLOWING SHOULD CALL THE OBJECT'S LOCATION !!!
	if (pnt.go_edited_object) then
		stored_go_get_absolute(pnt)(pnt.go_edited_object) -> (x, y) ;
	endif;
enddefine;

define :method updaterof go_ycentre( y, pnt :go_edit_point );
lvars y, pnt;
;;; REF: INTEGER -> go_yloc( EDIT_POINT );
;;; REF: The vertical location in world coordinates of the point edited
;;; REF: by the edit point (see also REF * GO_LOCATED).
;;; REF: EDIT_POINT is a go_edit_point instance (REF * GO_EDIT_POINT).
	;;; THE FOLLOWING SHOULD CALL THE OBJECT'S UPDATER METHOD !!!
	if (pnt.go_edited_object) then
		stored_go_move_absolute(pnt)(pnt.go_xcentre, y, pnt.go_edited_object);
	endif;
	call_next_method( y, pnt );
enddefine;

;;;--------------------------------------------------------------
;;; DRAW EDIT POINT

define :method go_fgdraw( pane :go_pane, pnt :go_edit_point );
lvars pane, pnt;
;;; REF: go_fgdraw( PANE, EDIT_POINT );
;;; REF: Draws the triangular representation of the edit point on top of all
;;; REF: other objects in the pane and in its foreground colour (see also
;;; REF: REF * GO_COLOURABLE and REF * GO_PANE/go_add_editor_to_pane).
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
;;; REF: EDIT_POINT is a go_edit_point instance (REF * GO_EDIT_POINT).
lvars bord = (pnt.go_border - 1),
	  x = pnt.go_xcentre - (bord div 2),
	  y = pnt.go_ycentre - (bord div 2);
	go_transxyout( x , y, pane ) -> (x, y);
	go_draw_lines( pane, [% x,        y,     0, bord,
							bord, -bord, -bord,    0  %], CoordModePrevious );
enddefine;

define :method go_bgdraw( pane :go_pane, pnt :go_edit_point );
lvars pane, pnt;
;;; REF: go_bgdraw( PANE, EDIT_POINT );
;;; REF: Draws a square area under the edit point on top of all other objects
;;; REF: in the pane and in its background colour to create contrast (see also
;;; REF: REF * GO_COLOURABLE and REF * GO_PANE/go_add_editor_to_pane).
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
;;; REF: EDIT_POINT is a go_edit_point instance (REF * GO_EDIT_POINT).
lvars bord = pnt.go_border, bord2 = ((bord-1) div 2),
	  x = pnt.go_xcentre - bord2,
	  y = pnt.go_ycentre - bord2;
	go_transxyout( x, y, pane ) -> (x, y);
	go_draw_filled_polygon( pane, [% x,     y, 0,  bord,
									 bord,  0, 0, -bord,
									-bord,  0  %], Convex, CoordModePrevious );
enddefine;



;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_edit_point = true;

/* --- Revision History --------------------------------------------
 * BR 05/08/93
 *     Changed go_internal_redraw into go_redraw for cleaner dragging. This
 *     clears the underlying object before redrawing it. Still a problem
 *     with the extra spce of a bounding box...
 * BR 13/07/93
 *     Adapted go_check_drag_limits() to use the centre point!
 * BR 08/05/93
 *     Changed go_check_drag_limits because it no longer sets the go_[x/y]loc.
 *     Removed the method go_draw_pointer() and simplified go_fgdraw().
 * BR 07/05/93
 *     Changed go_transxyout() to no longer include the screen object (see
 *     LIB * GO_PANE)
 * BR 30/04/93
 *     Moved go_edit_point class into separate file
 */
;;; eof
