/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:        C.mips/src/amain.s
 * Purpose:     Main assembler routines for MIPS R2000/R3000
 * Author:      Robert Duncan and Simon Nichols, Jan 10 1990 (see revisions)
 */


#_<

#_INCLUDE 'declare.ph'

section $-Sys;

vars
	_init_args,
	;

endsection;

>_#

#_INCLUDE 'pop_regdef.h'


/************************* wrapping structures ************************/

	.data
	.word	Ldata_size
	.word	C_LAB(Sys$-objmod_pad_key)
Ldata_start:

/**********************************************************************/


	.text

;;; _MAIN:
;;;	Entry point to POPLOG; called from _START in /lib/crt0.

;;; Call:
;;;	main(argc, argv, envp)

DEF_C_LAB (Sys$- _entry_point)

	.globl	main
	.ent	main
main:
	.set	noreorder
	CPLOAD	t9
	.set	reorder

	;;; Create stack frame

	.frame	sp, 24, ra
	.mask	0x90000000, -4
	subu	sp, 24
	sw	ra, 20(sp)
	CPRESTORE 16

	;;; Clear __pop_in_user_extern

	sw	zero, EXTERN_NAME(__pop_in_user_extern)

	;;; Save pointer to argument vector (argv) which is passed in a1

	sw	a1, I_LAB(Sys$- _init_args)

	;;; Set up a temporary user stack pointer

	lw	usp, I_LAB(Sys$-Extern$- _saved_usp)

	;;; Set registers

	jal	reset_pop_reg_environ

	;;; Start the system

	jal	XC_LAB(setpop)

	;;; Exit with 0

	move	a0, zero
	jal	EXTERN_NAME(_exit)

	;;; Standard exit for completeness (not reached)

	lw	ra, 20(sp)
	addu	sp, 24

	j	ra

	.end	main


/***************** end labels for wrapping structures *****************/

	.data
Ldata_end:
Ldata_size = 0 ##PATCH## Ldata_size Ldata_end Ldata_start

/**********************************************************************/


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Mar 22 1994
	Removed procedure assignments to a0 (again).
--- Robert John Duncan, Mar 15 1994
	Removed the wrapping structure from the text section
--- Robert John Duncan, Mar 15 1994
	Pop calls must now set a0 to the procedure address
--- Robert John Duncan, Mar  9 1994
	Made position-independent.
 */
