/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.mips/src/array_cons.p
 > Purpose:         Constructing array procedures for MIPS R2000/R3000
 > Author:          Rob Duncan, May 29 1990 (see revisions)
 > Related Files:   C.mips/src/ass.p, C.all/src/arrays.p, C.mips/src/aarith.s
 */

#_INCLUDE 'declare.ph'

global constant
	_array_sub,
;

constant procedure (
	$-Sys$-Vm$-hi16,
	$-Sys$-Vm$-lo16,
);


;;; -----------------------------------------------------------------------

section $-Sys;

	/*	Construct a raw array procedure. _________tabsize is the word offset size
		of the array params starting at PD_ARRAY_TABLE.
	*/
define Array$-Cons(_tabsize) -> _arrayp;
	lvars _tabsize _arrayp, _drop_ptr, _size;

	;;; Macro for dropping words
	lconstant macro WORD = [_drop_ptr!(w)++ -> _drop_ptr];

	;;; Get procedure record -- 11 words of code
	@@PD_ARRAY_TABLE{_tabsize} _add @@(w)[_11] _sub @@POPBASE -> _size;
	Get_store(_size) -> _arrayp;

	;;; Initialise some of procedure header
	##(w){_size} -> _arrayp!PD_LENGTH;
	_0	->> _arrayp!PD_REGMASK
		->> _arrayp!PD_NUM_PSTK_VARS
		->> _arrayp!PD_NLOCALS
		->  _arrayp!PD_GC_SCAN_LEN;
#_IF DEF PIC
	;;; 1 non-pop on-stack lvar and one non-pop register
	_1 -> _arrayp!PD_NUM_STK_VARS;
	##SF_LOCALS _add _1 -> _arrayp!PD_GC_OFFSET_LEN;
#_ELSE
	;;; 2 non-pop on-stack lvars
	_2 -> _arrayp!PD_NUM_STK_VARS;
	##SF_LOCALS _add _2 -> _arrayp!PD_GC_OFFSET_LEN;
#_ENDIF
	##SF_LOCALS _add _2 _sub ##SF_RETURN_ADDR  -> _arrayp!PD_FRAME_LEN;

	;;; Start of code
	_arrayp@PD_ARRAY_TABLE{_tabsize} ->> _drop_ptr -> _arrayp!PD_EXECUTE;

	;;; Create stack frame
	;;; Drop_arithi(_ADDIU, _PB, _CALL_REG, lo16(-@@PD_ARRAY_TABLE{_tabsize}));
	_16:27370000 _biset Vm$-lo16(##(b){_arrayp, _drop_ptr}) -> WORD;
	;;; Drop_arithi(_ADDIU, _SP, _SP, Vm$-lo16(_-16));
	_16:27BDFFF0 -> WORD;
	;;; Drop_store(_SW, _RA, _SP, _12);
	_16:AFBF000C -> WORD;

	;;; Call the array subscript routine
	;;; (picks up parameters from PD_ARRAY_TABLE, stacks computed
	;;; subscript and PD_ARRAY_VECTOR, and then chains PD_ARRAY_SUBSCR_PDR)
	;;; Drop_lui(_CALL_REG, Vm$-hi16(_array_sub))
	_16:3C190000 _biset Vm$-hi16(_array_sub) -> WORD;
	;;; Drop_arithi(_ADDIU, _CALL_REG, _CALL_REG, Vm$-lo16(_array_sub))
	_16:27390000 _biset Vm$-lo16(_array_sub) -> WORD;
	;;; Drop_jr(_JALR, _CALL_REG)
	_16:0320F809 -> WORD;
	;;; Drop_store(_SW, _PB, _SP, _0);
	_16:AFB70000 -> WORD;

	;;; Unwind stack frame and return
	_drop_ptr -> _arrayp!PD_EXIT;
	;;; Drop_load(_LW, _RA, _SP, _12)
	_16:8FBF000C -> WORD;
	;;; Drop_load(_LW, _PB, _SP, _16)
	_16:8FB70010 -> WORD;
	;;; Drop_jr(_JR, _RA)
	_16:03E00008 -> WORD;
	;;; Drop_arithi(_ADDIU, _SP, _SP, _16)
	_16:27BD0010 -> WORD;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Aug 31 1994
		Added two more words to the stack frame: one non-pop register slot
		as a placeholder for the global pointer in position-independent code
		(even though it's never used, it's needed to make the stack frame
		layout consistent) and one non-pop on-stack lvar to realign the
		frame on a double-word boundary.
--- Robert John Duncan, Aug 31 1994
		Simplified so that this machine-specific file now only has to
		construct a procedure with a stack frame and a call to _array_sub
		(_array_sub  picks up the parameters from PD_ARRAY_TABLE; these are
		planted by the machine-independent Get in arrays.p)
--- Robert John Duncan, Mar  7 1994
		Changed for new pop calling convention: instead of the procedure
		address being passed in $a0, the execute address is passed in $t9.
		Also, subroutine calls now go through $t9.
 */
