/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            C.mips/src/pdr_compose.p
 > Purpose:         Procedure composition for MIPS
 > Author:          Robert Duncan, Feb  8 1990 (see revisions)
 > Related Files:   C.mips/src/ass.p
 */


#_INCLUDE 'declare.ph'

constant
	procedure ( $-Sys$-Vm$-lo16 );

;;; -----------------------------------------------------------------------


section $-Sys;

lconstant macro WORD = [_drop_ptr!(w)++ -> _drop_ptr];

define Cons_pcomposite() -> _comp;
	lvars _drop_ptr, _size, _comp;

	;;; get procedure record (code size = 17 words)
	@@PD_COMPOSITE_TABLE[_17] _sub @@POPBASE -> _size;
	Get_store(_size) -> _comp;

	;;; fill in header
	##(w){_size} -> _comp!PD_LENGTH;
	_0	->> _comp!PD_REGMASK
		->> _comp!PD_NLOCALS
		->> _comp!PD_NUM_PSTK_VARS
		->  _comp!PD_GC_SCAN_LEN;
#_IF DEF PIC
	;;; 1 non-pop on-stack lvar and one non-pop register
	_1	->	_comp!PD_NUM_STK_VARS;
	##SF_LOCALS _add _1 -> _comp!PD_GC_OFFSET_LEN;
#_ELSE
	;;; 2 non-pop on-stack lvars
	_2	->	_comp!PD_NUM_STK_VARS;
	##SF_LOCALS _add _2 -> _comp!PD_GC_OFFSET_LEN;
#_ENDIF
	##SF_LOCALS _add _2 _sub ##SF_RETURN_ADDR  -> _comp!PD_FRAME_LEN;

	;;; start of instructions
	_comp@PD_COMPOSITE_TABLE ->> _drop_ptr -> _comp!PD_EXECUTE;

	;;; get our address in PB:
	;;; Drop_arithi(_ADDIU, _PB, _CALL_REG, lo16(-@@PD_COMPOSITE_TABLE))
	_16:27370000 _biset Vm$-lo16(##(b){_comp, _drop_ptr}) -> WORD;

	;;; create stack frame and do first call:
	;;; Drop_load(_LW, _ARG_REG_0, _PB, @@PD_COMPOSITE_P1);
	_16:8EE40000 _biset @@PD_COMPOSITE_P1 -> WORD;
	;;; Drop_arithi(_ADDIU, _SP, _SP, lo16(_-16));
	_16:27BDFFF0 -> WORD;
	;;; Drop_load(_LW, _CALL_REG, _ARG_REG_0, @@PD_EXECUTE);
	_16:8C990000 _biset @@PD_EXECUTE -> WORD;
	;;; Drop_store(_SW, _RA, _SP, _12);
	_16:AFBF000C -> WORD;
	;;; Drop_jr(_JALR, _CALL_REG);
	_16:0320F809 -> WORD;
	;;; Drop_store(_SW, _PB, _SP, _0);
	_16:AFB70000 -> WORD;

	;;; do second call
	;;; Drop_load(_LW, _ARG_REG_0, _PB, @@PD_COMPOSITE_P2);
	_16:8EE40000 _biset @@PD_COMPOSITE_P2 -> WORD;
	_16:00000000 -> WORD;
	;;; Drop_load(_LW, _CALL_REG, _ARG_REG_0, @@PD_EXECUTE);
	_16:8C990000 _biset @@PD_EXECUTE -> WORD;
	_16:00000000 -> WORD;
	;;; Drop_jr(_JALR, _CALL_REG);
	_16:0320F809 -> WORD;
	_16:00000000 -> WORD;

	;;; pointer to exit code
	_drop_ptr -> _comp!PD_EXIT;

	;;; unwind stack frame and return
	;;; Drop_load(_LW, _RA, _SP, _12);
	_16:8FBF000C -> WORD;
	;;; Drop_load(_LW, _PB, _SP, _16);
	_16:8FB70010 -> WORD;
	;;; Drop_jr(_JR, _RA);
	_16:03E00008 -> WORD;
	;;; Drop_arithi(_ADDIU, _SP, _SP, _16);
	_16:27BD0010 -> WORD;
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Aug 31 1994
		Added two more words to the stack frame: one non-pop register slot
		as a placeholder for the global pointer in position-independent code
		(even though it's never used, it's needed to make the stack frame
		layout consistent) and one non-pop on-stack lvar to realign the
		frame on a double-word boundary.
--- Robert John Duncan, Mar  7 1994
		Changed for new pop calling convention: instead of the procedure
		address being passed in ARG_REG_0, the execute address is passed
		in CALL_REG ($t9).
 */
