/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:            C.mips/src/pop_regdef.h
 * Purpose:         POP register names for MIPS assembler files
 * Author:          Rob Duncan, Oct 31 1989 (see revisions)
 */

/*
 *  POP register names
 */

#define zero	$0		/* zero */
#define at		$1		/* assembler temporary */
#define v0		$2		/* subroutine results */
#define v1		$3
#define a0		$4		/* subroutine arguments */
#define a1		$5
#define a2		$6
#define a3		$7
#define t0		$8		/* temporaries */
#define t1		$9
#define t2		$10
#define t3		$11
#define t4		$12
#define t5		$13
#define t6		$14
#define t7		$15
#define p0		$16		/* pop registers */
#define p1		$17
#define np0		$18		/* nonpop registers */
#define np1		$19
#define np2		$20
#define np3		$21
#define false	$22		/* false */
#define pb		$23		/* procedure base */
#define svb		$24		/* special var block (caller save) */
#define t9		$25		/* call reg */

#define gp		$28		/* global pointer */
#define sp		$29		/* stack pointer */
#define usp		$30		/* user stack pointer */
#define ra		$31		/* return address */

#define cr		t7		/* chain reg = t7 */

/*
 *	Directives for Position-Independent Code:
 *	these aren't supported in earlier versions of the assembler, so we
 *	activate them only if PIC is explicitly selected
 */

#_IF DEF PIC

#define CPLOAD		.cpload
#define CPRESTORE	.cprestore
#define CPADD		.cpadd
#define GPWORD		.gpword

#_ELSE

#define CPLOAD		# .cpload
#define CPRESTORE	# .cprestore
#define CPADD		# .cpadd
#define GPWORD		.word

#_ENDIF

/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Mar  9 1994
		Reassigned t8 to hold the special var block
--- Robert John Duncan, Mar  8 1994
		Added #defines for PIC macros
--- Robert John Duncan, Mar  6 1991
		No longer dependent on system <regdef.h>
 */
