/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.decstation/src/syscomp/sysdefs.p
 > Purpose:         DECstation 3100: macros for machine and operating system
 > Author:          Rob Duncan, Nov 29 1989 (see revisions)
 */


section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; -- SYSTEM NAME --------------------------------------------------------

	MACHINE = [[decstation]],
	DECSTATION = true,


;;; -- PROCESSOR (MIPS R2000) ---------------------------------------------

	PROCESSOR = [[mips]],
	MIPS = true,

	;;; Byte orientation
	LITTLE_ENDIAN = true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	DOUBLE_ALIGN_BITS = 32,
	STRUCT_DOUBLE_ALIGN_BITS = 64,

	;;; Type of pointer to machine code
	CODE_POINTER_TYPE = "int",

	;;; Type of pointer for bitfield access
	BIT_POINTER_TYPE  = "byte",


;;; -- OPERATING SYSTEM (ULTRIX) ------------------------------------------

	ULTRIX = 4.3,
	POSIX1 = 198808,
	OPERATING_SYSTEM = [[unix ultrix ^ULTRIX posix {^POSIX1}]],
	UNIX = true,
	BERKELEY = 4.3,

	;;; Feature list
	BSD_MPROTECT = true,
	BSD_VFORK = true,
	COFF = true,

	;;; Size of a virtual page (from "pagesize(1)")
	VPAGE_OFFS = 16:1000,

	;;; Lowest executable address (see N_TXTOFF in <a.out.h>)
	LOWEST_ADDRESS = 16:400170,

	;;; Top of stack segment (from <machine/vmparam.h>)
	UNIX_USRSTACK = 16:80000000 - 4*VPAGE_OFFS,

	;;; Get and set the memory break and return the REAL end of memory:
	;;; this is to ensure that the end of the user stack is at the end
	;;; of memory so that a user stack underflow causes a memory access
	;;; violation.
	;;; Break values are rounded up to the next page boundary.
	GET_REAL_BREAK = [
		procedure();
			_extern sbrk(_0)@(b.r->vpage);
		endprocedure
	],

	SET_REAL_BREAK = [
		procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif;
		endprocedure
	],

	;;; Flush the instruction cache after a garbage collection
	CACHEFLUSH = [
		procedure(_ptr, _nbytes);
			lvars _ptr, _nbytes;
			_extern cacheflush(_ptr, _nbytes, _1) -> ;
		endprocedure
	],


;;; -- OTHER --------------------------------------------------------------

	;;; MIPS C compiler returns "float" results as single, not double
	C_FLOAT_RESULT_SINGLE = true,

	;;; List of procedures to be optimised as subroutine calls:
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]
	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

	;;; Enable listing of M-code in POPC assembler output
	M_DEBUG = false,

	;;; Enable dump of run-time code in ICODE.LOG
	I_DEBUG = false,

);

endsection;


/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Feb 28 1995
		Added POSIX1 and "posix" entry in OPERATING_SYSTEM, removed H*ERTZ
--- Robert John Duncan, Feb 24 1993
		Ultrix 4.3
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
--- Robert John Duncan, Jun 22 1992
		Added BSD_VFORK; changed to Ultrix 4.2
--- Robert John Duncan, Jun 10 1991
		Added C_FLOAT_RESULT_SINGLE
--- Robert John Duncan, Apr 17 1991
		Turned off M-code debugging output; changed to Ultrix 4.1
--- Robert John Duncan, Sep 10 1990
		Revised USRSTACK value for Ultrix 4.0.
--- Rob Duncan, Jun 22 1990
		Changed CACHEFLUSH to use the proper -cacheflush- system call now
		available in Ultrix 4.0.
		Changed ULTRIX version number accordingly.
 */
