/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_text_input.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 3rd June 1993
;;; File: go_text_input.p
;;; Author: Ben L.E. Rabau

compile_mode :pop11 +strict;

uses go_rectangle;
uses go_labelled;
uses go_key_sensitive;

;;;----------------------------------------------------------------
;;; CLASS TEXT_INPUT

;;; INTRO: The CLASS go_text_input is the a go_label but go_key_sensitive!
;;; INTRO: The go_text_input will accept input from the keyboard if the
;;; INTRO: mouse is positioned over the object (see REF * GO_KEY_SENSITIVE).
;;; INTRO: This object also has a certain width which does not always
;;; INTRO: correspond the the width of the object (see TEACH * GO_LABELLED).
;;; INTRO: This object currently does not show the bounding box on the screen
;;; INTRO: nor does it show a line on which to type.

define :class go_text_input;
	isa go_key_sensitive go_labelled go_rectangle;
	slot go_key_down_action == go_label_editing;
;;; REF: The object is keyboard active when in live mode.
	slot stored_go_label    == 'go_text_input';
;;; REF: The text input initial label contents.
	slot stored_go_width    == 150;
;;; REF: The fixed maximum length of the rectangle (clips the label).
enddefine;


;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_text_input = true;

/* --- Revision History --------------------------------------------
 * BR 03/06/93
 *     Changed to be a go_rectangle (no longer a label, but a labelled obj).
 * BR 18/05/93
 *     Updated to use go_text rather than go_label class.
 * BR 30/04/93
 *     Moved go_text_input class into separate file
 */
;;; eof
