/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:			C.hppa/src/array_cons.p
 > Purpose:			Constructing array procedures for HP PA-RISC 1.1
 > Author:			Robert Duncan and Simon Nichols, Apr 19 1993 (see revisions)
 > Related Files:   C.all/src/arrays.p, C.hppa/src/aarith.s
 */


#_INCLUDE 'declare.ph'

section $-Sys;

constant _array_sub_template;

	/*	Construct a raw array procedure. _________tabsize is the word offset size
		of the array params starting at PD_ARRAY_TABLE.
	*/
define Array$-Cons(_tabsize) -> _arrayp;
	lvars _tabsize, _arrayp, _drop_ptr, _size;

	;;; Macro for planting code at __________drop_ptr
	lconstant macro DROP = [_drop_ptr!(w)++ -> _drop_ptr];

	;;; Get procedure record -- 11 words of code
	@@PD_ARRAY_TABLE{_tabsize} _add @@(w)[_11] _sub @@POPBASE -> _size;
	Get_store(_size) -> _arrayp;

	;;; Initialise some of procedure header
	##(w){_size} -> _arrayp!PD_LENGTH;
	_0	->> _arrayp!PD_NUM_STK_VARS
		->> _arrayp!PD_NUM_PSTK_VARS
		->> _arrayp!PD_NLOCALS
		->  _arrayp!PD_GC_SCAN_LEN;
	erase!PD_REGMASK -> _arrayp!PD_REGMASK;
	##SF_LOCALS -> _arrayp!PD_GC_OFFSET_LEN;
	##SF_LOCALS _sub ##SF_RETURN_ADDR -> _arrayp!PD_FRAME_LEN;

	;;; Start of code
	_arrayp@PD_ARRAY_TABLE{_tabsize} ->> _drop_ptr -> _arrayp!PD_EXECUTE;

	;;; Create stack frame
	_16:EA200000 -> DROP;		;;; bl		.+8, %pb
	_16:36313FEB _sub _shift(@@PD_ARRAY_TABLE{_tabsize}, _1) -> DROP;
								;;; ldo		-[________hdr_size+8+3](%pb), %pb
	_16:6FDF0010 -> DROP;		;;; stwm	%r31, 8(%sp)

	;;; Call the array subscript routine (picks up parameters from
	;;; PD_ARRAY_TABLE, stacks computed subscript and PD_ARRAY_VECTOR,
	;;; and then chains PD_ARRAY_SUBSCR_PDR); template for the call is
	;;; in "aarith.s"
	_array_sub_template!(w)[_0] -> DROP;
	_array_sub_template!(w)[_1] -> DROP;
	_16:6BD13FF9 -> DROP;		;;; stw		%pb, -4(%sp)

	;;; Unwind stack frame and return
	_drop_ptr -> _arrayp!PD_EXIT;
	_16:4FDF3FF1 -> DROP;		;;; ldwm	-8(%sp), %r31
	_16:03E010B6 -> DROP;		;;; ldsid	(%r31), %t1
	_16:00161820 -> DROP;		;;; mtsp	%t1, %sr0
	_16:E3E00000 -> DROP;		;;; be		(%sr0, %r31)
	_16:4BD13FF9 -> DROP;		;;; ldw		-4(%sp), %pb
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Dec  1 1995
		Temporary patch to setting of register mask: was still wrong,
		because identfn is compiled specially and doesn't have the right
		mask value itself.
--- Robert John Duncan, Sep  1 1994
		Fixed procedure register mask: some curious non-zero value copied
		from identfn
--- Robert John Duncan, Sep  1 1994
		Simplified so that this machine-specific file now only has to
		construct a procedure with a stack frame and a call to _array_sub
		(_array_sub  picks up the parameters from PD_ARRAY_TABLE; these are
		planted by the machine-independent Get in arrays.p)
 */
