/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:			C.hppa/src/closure_cons.p
 > Purpose:			Closure construction for HP PA-RISC 1.1
 > Author:			Robert Duncan and Simon Nichols, Mar  1 1993
 > Related Files:   C.hppa/src/amain.s
 */


#_INCLUDE 'declare.ph'

section $-Sys;

constant _exec_clos_code_template;

lconstant macro DROP = [_drop_ptr!(w)++ -> _drop_ptr];

define Cons_closure(_nfroz) -> _clos;
	lvars _nfroz, _clos, _size, _drop_ptr;
	lconstant errmsg = 'CLOSURE EXCEEDS MAXIMUM ALLOWABLE SIZE';

	;;; compute code size in words
	if _zero(_nfroz) then
		_7 -> _size;
	elseif _nfroz _slteq _16 then
		_6 _add (_2 _mult _nfroz) -> _size;
	else
		_5 -> _size;
	endif;

	;;; get the closure record
	@@PD_CLOS_FROZVALS[_nfroz _add _size]@~POPBASE -> _size;
	Get_store(_size) -> _clos;
	##(w){_size} ->> _size -> _clos!PD_LENGTH;
	unless _clos!PD_LENGTH == _size then
		_clos -> Get_store(); ;;; junk it
		mishap(0, errmsg)
	endunless;

	;;; plant code
	_clos@PD_CLOS_FROZVALS[_nfroz] ->> _drop_ptr -> _clos!PD_EXECUTE;
	if _zero(_nfroz) then
		_16:EAC00000 -> DROP;			;;; bl		.+8, t1
		_16:4AD53FE3 -> DROP;			;;; ldw		-15(t1), t2
		_16:4AB60000 -> DROP;			;;; ldw		(t2), t1
		_16:02A010B5 -> DROP;			;;; ldsid	(t2), t2
		_16:00151820 -> DROP;			;;; mtsp	t2, sr0
		_16:E2C00000 -> DROP;			;;; be		(sr0, t1)
		_16:08000240 -> DROP;			;;; nop
	elseif _nfroz _slteq _16 then
		_16:EAC00000 -> DROP;			;;; bl		.+8, t1
		_16:4ED53FE3 _sub (_8 _mult _nfroz) -> DROP;
										;;; ldwm	-(4*nfroz+15)(t1),t2
		if _nfroz _bitst _1 then
			until _nfroz == _1 do
				_nfroz _sub _2 -> _nfroz;
				_16:0EC830B4 -> DROP;	;;; ldws,mb 4(t1), t3
				_16:0EC830B3 -> DROP;	;;; ldws,mb 4(t1), t4
				_16:6E543FF9 -> DROP;	;;; stwm	t3, -4(usp)
				_16:6E533FF9 -> DROP;	;;; stwm	t4, -4(usp)
			enduntil;
			_16:0EC830B4 -> DROP;		;;; ldws,mb	4(t1), t3
		else
			repeat
				_nfroz _sub _2 -> _nfroz;
				_16:0EC830B3 -> DROP;	;;; ldws,mb 4(t1), t4
				_16:0EC830B4 -> DROP;	;;; ldws,mb 4(t1), t3
				_16:6E533FF9 -> DROP;	;;; stwm	t4, -4(usp)
			quitif(_zero(_nfroz));
				_16:6E543FF9 -> DROP;	;;; stwm 	t3, -4(usp)
			endrepeat;
		endif;
		_16:4AB60000 -> DROP;			;;; ldw		(t2), t1
		_16:02A010B5 -> DROP;			;;; ldsid	(t2), t2
		_16:00151820 -> DROP;			;;; mtsp	t2, sr0
		_16:E2C00000 -> DROP;			;;; be		(sr0, t1)
		_16:6E543FF9 -> DROP;			;;; stwm 	t3, -4(usp)
	else
		;;; Call via Exec_closure:
		_16:EAC00000 -> DROP;			;;; bl 		.+8, t1
		lvars _offs = @@PD_CLOS_FROZVALS[_nfroz _add _2];
		if _offs _sgreq _8190 then
			mishap(0, errmsg);
		endif;
		_16:36D63FFB _sub (_offs _mult _2) -> DROP;
										;;; ldo 	-@@PD_CLOS_FROZVALS[_nfroz+2]-3(t1),t1
		;;; get code to call Exec_closure from template in "amain.s"
		_exec_clos_code_template!(w)[_0] -> DROP;
		_exec_clos_code_template!(w)[_1] -> DROP;
		_16:6E563FF9 -> DROP;			;;; stwm 	t1, -4(usp)
	endif;
enddefine;

endsection;		/* $-Sys */
