/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 > File:			C.hppa/src/pdr_compose.p
 > Purpose:			Procedure composition for HP PA-RISC 1.1
 > Author:			Robert Duncan & Simon Nichols, Mar  1 1993 (see revisions)
 */


#_INCLUDE 'declare.ph'

section $-Sys;

lconstant macro DROP = [_drop_ptr!(w)++ -> _drop_ptr];

define Cons_pcomposite() -> _comp;
	lvars _drop_ptr, _size, _comp;

	;;; get procedure record (code size = 20 words)
	@@PD_COMPOSITE_TABLE[_20] _sub @@POPBASE -> _size;
	Get_store(_size) -> _comp;

	;;; fill in header
	##(w){_size} -> _comp!PD_LENGTH;
	_0	->> _comp!PD_NLOCALS
		->> _comp!PD_NUM_STK_VARS
		->> _comp!PD_NUM_PSTK_VARS
		->  _comp!PD_GC_SCAN_LEN;
	erase!PD_REGMASK -> _comp!PD_REGMASK;
	##SF_LOCALS -> _comp!PD_GC_OFFSET_LEN;
	##SF_LOCALS _sub ##SF_RETURN_ADDR  -> _comp!PD_FRAME_LEN;

	;;; start of instructions
	_comp@PD_COMPOSITE_TABLE ->> _drop_ptr -> _comp!PD_EXECUTE;

	;;; create stack frame
	_16:EA200000 -> DROP;	;;; bl		.+8, %pb
	#_< _16:36313FEB _sub _shift(@@PD_COMPOSITE_TABLE, _1) >_# -> DROP;
							;;; ldo		-@@PD_COMPOSITE_TABLE[_8](%pb), %pb
	_16:6FDF0010 -> DROP;	;;; stwm	%r31, 8(%sp)

	;;; first call
	#_< _16:4A360000 _add _shift(@@PD_COMPOSITE_P1, _1) >_# -> DROP;
							;;; ldw		@@PD_COMPOSITE_P1(%pb), %t1
	_16:4AD50000 -> DROP;	;;; ldw		(%t1), %t2
	_16:02C010B6 -> DROP;	;;; ldsid	(%t1), %t1
	_16:00161820 -> DROP;	;;; mtsp	%t1, %sr0
	_16:E6A00000 -> DROP;	;;; ble		(%sr0, %t2)
	_16:6BD13FF9 -> DROP;	;;; stw		%pb, -4(%sp)

	;;; second call
	#_< _16:4A360000 _add _shift(@@PD_COMPOSITE_P2, _1) >_# -> DROP;
							;;; ldw		@@PD_COMPOSITE_P2(%pb), %t1
	_16:4AD50000 -> DROP;	;;; ldw		(%t1), %t2
	_16:02C010B6 -> DROP;	;;; ldsid	(%t1), %t1
	_16:00161820 -> DROP;	;;; mtsp	%t1, %sr0
	_16:E6A00000 -> DROP;	;;; ble		(%sr0, %t2)
	_16:08000240 -> DROP;	;;; nop

	;;; pointer to exit code
	_drop_ptr -> _comp!PD_EXIT;

	;;; unwind stack frame and return
	_16:4FDF3FF1 -> DROP;	;;; ldwm	-8(%sp), %r31
	_16:03E010B6 -> DROP;	;;; ldsid	(%r31), %t1
	_16:00161820 -> DROP;	;;; mtsp	%t1, %sr0
	_16:E3E00000 -> DROP;	;;; be		(%sr0, %r31)
	_16:4BD13FF9 -> DROP;	;;; ldw		-4(%sp), %pb
enddefine;

endsection;		/* $-Sys */


/* --- Revision History ---------------------------------------------------
--- Robert John Duncan, Dec  1 1995
		Temporary patch to setting of register mask: was still wrong,
		because identfn is compiled specially and doesn't have the right
		mask value itself.
--- Robert John Duncan, Sep  1 1994
		Fixed procedure register mask: some curious non-zero value copied
		from identfn
 */
