/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.hp9000_700/src/syscomp/sysdefs.p
 > Purpose:         HP 9000/700: definitions for machine and operating system
 > Author:          Robert Duncan, Dec 18 1992 (see revisions)
 */


section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,


;;; --- SYSTEM NAME ------------------------------------------------

	MACHINE			= [[hp9000 700]],
	HP9000			= true,
	HP9000_700		= true,


;;; -- MACHINE = HP PA-RISC -----------------------------------------------

	PROCESSOR		= [[hppa]],		;;; type of cpu
	HPPA			= true,

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	CODE_POINTER_TYPE = "int",		;;; type of pointer to machine code
	BIT_POINTER_TYPE  = "byte",		;;; type of pointer for bitfield access

	BIG_ENDIAN		= true,
	STACK_GROWS_UP	= true,


;;; --- OPERATING SYSTEM = HP-UX --------------------------------------

	HPUX			= 9.01,
	POSIX1			= 199009,
	POSIX2			= 199209,
	OPERATING_SYSTEM = [[unix hpux ^HPUX posix {^POSIX1 ^POSIX2}]],
	UNIX			= true,
	BERKELEY		= 4.2,			;;; in quite a lot of respects ...
	SHARED_LIBRARIES = true,		;;; dynamically linked against shared libraries

	VPAGE_OFFS		= 4096,			;;; word address offset of a virtual page
	LOWEST_ADDRESS	= 0,			;;; lowest pop structure address
	UNIX_USRSTACK	= 16:7B033000,	;;; end of stack (USRSTACK in <sys/param.h>)
	UNIX_USRSTACK_SIZE = 16:800000,	;;; max size (kernel parameter maxssiz, from SAM)

	;;; Procedures to get and set the memory break and return the REAL end of
	;;; memory. (We always need the real end to ensure that the end of the
	;;; user stack is always at the true end of memory, so that user stack
	;;; underflow produces a memory access violation.)

	GET_REAL_BREAK =
		[procedure(); _extern sbrk(_0)@(b.r->vpage) endprocedure],

	SET_REAL_BREAK =
		[procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif
		endprocedure],

	;;; Flush the instruction cache after a garbage collection
	CACHEFLUSH = [
		procedure(_ptr, _nbytes);
			lvars _ptr, _nbytes;
			;;; cacheflush is defined in "amain.s"
			_extern cacheflush(_ptr, _nbytes) -> ;
		endprocedure
	],


;;; --- OTHER ------------------------------------------------------------

	;;; Says single float results from C functions are returned as
	;;; singles not doubles.
	C_FLOAT_RESULT_SINGLE = true,

	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

	;;; Enable listing of M-code in POPC assembler output
	M_DEBUG = false,

	;;; Enable dump of run-time machine code in ICODE.LOG
	I_DEBUG = false,

);

endsection;		/* $- */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- Robert John Duncan, May 22 1995
		Updated POSIX definitions (from HP-UX 9.0 release notes)
--- John Gibson, Mar 30 1995
		Added BIG_ENDIAN
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Feb 28 1995
		Added POSIX1 and "posix" entry in OPERATING_SYSTEM
 */
