/*  --- Copyright University of Sussex 1986.  All rights reserved. ---------
 >  File:           C.all/lib/lib/tree_identify.p
 >  Purpose:        Simple expert system
 >  Author:         Chris Mellish
 >  Documentation:  HELP * TREE_IDENTIFY
 >  Related Files:
 */

#_TERMIN_IF DEF POPC_COMPILING

compile_mode :pop11 +oldvar;

vars root, findtree askquestion print_list_nice;

[question [Are the leaves either needle like or scale like]
 [question [Are the leaves needle like]
  [question [Are the leaves long in bundles of 2 or 5]
   [question [Are there 2 needles in each bundle]
	[question [Are cones and side branches only at the tip of a years long shoot]
	 [question [Do the cones have stalks]
	  [object a Scots Pine]
	  [question [Are the needles prickly]
	   [object an Austrian Pine]
	   [object a Mountain Pine]
	   ]
	  ]
	 [question [Do the cones have prickles on their scales]
	  [object a Lodgepole Pine]
	  [object a Jack Pine]
	  ]
	 ]
	[question [Are the cones 3 - 8 in]
	 [object a Weymouth Pine]
	 [object a Cembran Pine]
	 ]
	]
   [question [Are the leaves about 1 in , some clustered , some single]
	[question [Are the long shoots reddish violet]
	 [object a Japanese Larch]
	 [object a European Larch]
	 ]
	[question [Are the leaves in whorls of 3]
	 [object a Juniper]
	 [question [Are there cones]
	  [question [Are the leaf scars level with the surface of the branches]
	   [question [Do the leaves have 2 whitish stripes on the upper side]
		[question [Are the needles evenly parted]
		 [question [Does it have yellowish brown bark]
		  [object a Giant Fir]
		  [object a Silver Fir]
		  ]
		 [object a Caucasian Fir]
		 ]
		[object a Noble Fir]
		]
	   [question [do needles have evenly tapered stalks]
		[object a Douglas Fir]
		[question [Do the needles have stalks that fall with the needles]
		 [object a Western Hemlock]
		 [question [Do the cones have wavy - edged scales]
		  [object a Sitka Spruce]
		  [question [Are the cones about 2 in long]
		   [object a White Spruce]
		   [object a Norway Spruce]
		   ]
		  ]
		 ]
		]
	   ]
	  [object a Yew]
	  ]
	 ]
	]
   ]
  [question [Are the cones globular]
   [object a Lawson Cyprus]
   [question [Do the leaves have prominent glands]
	[object a White Cedar]
	[object a Western Red Cedar]
	]
   ]
  ]
 [question [Are the leaves opposite]
  [question [Are the leaves compound]
   [question [Are the leaves palmate]
	[object a Horse Chestnut]
	[question [Are the terminal buds black]
	 [object an Ash]
	 [question [Is the pith white]
	  [object a Common Elder]
	  [object a Red - berried Elder]
	  ]
	 ]
	]
   [question [Are the leaves palmately lobed]
	[question [Is each leaf stalk up to 1 in with glands]
	 [object a Guelder Rose]
	 [question [Are the leaf undersides bluish green]
	  [object a Sycamore]
	  [question [Are the under surfaces of the leaves glabrous]
	   [object a Norway Maple]
	   [object a Field Maple]
	   ]
	  ]
	 ]
	[question [Are the leaves heart shaped]
	 [object a Lilac]
	 [question [Are the leaves lance shaped]
	  [object a Privet]
	  [question [Are the leaves narrowly tongue - shaped and leathery]
	   [object a Mistletoe]
	   [question [Do the leaves have finely - serrated edges]
		[question [Do the leaves have 3 pairs of curved lateral veins]
		 [object a Purging Buckthorn]
		 [object a Spindle Tree]
		 ]
		[question [Do the leaves have 3 -5 pairs of curved lateral veins]
		 [object a Dogwood]
		 [question [Are the plants twining or creeping along the ground]
		  [object a Honeysuckle]
		  [question [Are the leaves and young shoots glabrous]
		   [object a Snowberry]
		   [question [Is the stem bark ash - grey]
			[object a Woody Honeysuckle]
			[object a Blue - berried Honeysuckle]
			]
		   ]
		  ]
		 ]
		]
	   ]
	  ]
	 ]
	]
   ]
  [question [Are the leaves compound]
   [question [Are the leaves palmate]
	[question [Do the leaves have 3 leaflets ( possibly somtimes single )]
	 [question [Are the leaflets ovate , the shoots and fruits glaucous]
	  [object a Dewberry]
	  [question [Are the plants upright with slightly prickly bristles]
	   [object a Raspberry]
	   [question [Are the leaflets lance - shaped , the branches twig - like]
		[object a Broom]
		[object a Gorse]
		]
	   ]
	  ]
	 [object a Blackberry]
	 ]
	[question [Are the leaves serrated]
	 [question [Do the branches have weak bristles]
	  [object a Raspberry]
	  [question [Do the branches have prickles]
	   [question [Are the prickles sickle - shaped]
		[question [Do the leaves smell of apples or grapes]
		 [object a Sweet Briar]
		 [object a Dog Rose]
		 ]
		[question [Are the leaflets glabrous]
		 [object a Burnet Rose]
		 [object a Ramanas Rose]
		 ]
		]
	   [question [Are the leaflets oblong - lanceolate]
		[object a Sorbaria]
		[object a Rowan]
		]
	   ]
	  ]
	 [object a Robinia]
	 ]
	]
   [question [Are the leaves lobed]
	[question [Are the leaves palmately veined]
	 [question [Do the plants have creeping or climbing shoots]
	  [object an Ivy]
	  [question [Do the leaf under - surfaces have snow - white felt]
	   [object a White Poplar]
	   [question [Do the branches have thorns]
		[object a Gooseberry]
		[question [Do the leaf under - surfaces have small yellow glands]
		 [object a Black Currant]
		 [question [Are the flower clusters upright]
		  [object an Alpine Currant]
		  [object a Red Currant]
		  ]
		 ]
		]
	   ]
	  ]
	 [question [Do the leaf under - surfaces have dense hairs]
	  [question [Are the leaf under - surfaces chalk - white felted]
	   [object a White Poplar]
	   [question [Are the leaves pinnately lobed]
		[object a Swedish Whitebeam]
		[object a Finnish Whitebeam]
		]
	   ]
	  [question [Are the leaves less than 2 in long]
	   [question [Are the leaf lowest lateral veins curving forward]
		[object a Midland Hawthorn]
		[object a Common Hawthorn]
		]
	   [question [Do the leaves have pointed lobes and a wedge - shaped base]
		[object a Red Oak]
		[question [Do the leaves have rounded lobes]
		 [question [Are the leaves short - stalked]
		  [object a Pedunculate Oak]
		  [object a Sessile Oak]
		  ]
		 [object a Wild Service Tree]
		 ]
		]
	   ]
	  ]
	 ]
	[question [Does each bud have only one hood - like scale]
	 [question [Are the branches bluish - green in places]
	  [object a Caspian Willow]
	  [question [Are the leaves smooth , or only slightly hairy]
	   [question [Do the leaf upper surfaces have stomata visible with a lens]
		[object a Crack Willow]
		[object a Bay - leaved Willow]
		]
	   [question [Are the leaves at least 1 1 / 2 in wide]
		[object a Goal Willow]
		[question [Are the leaves 4 - 10 in long]
		 [object a Common Osier]
		 [question [Do the leaves have stomata on the upper surface ( visible with a lens )]
		  [object a White Willow]
		  [question [Are there dense hairs on the buds and shoots]
		   [question [Are the leaves slightly serrated]
			[object a Grey Willow]
			[object a Creeping Willow]
			]
		   [object a Eared Willow]
		   ]
		  ]
		 ]
		]
	   ]
	  ]
	 [question [Is the length of the leaf more than 3 times the width]
	  [question [Are the branches and leaf under surfaces silver glistening]
	   [object a Sea Buckthorn]
	   [question [Do the leaves have rust - red felt on the under - surfaces]
		[object a Wild Rosemary]
		[question [Are the leaf edges entire]
		 [question [Is it a tall bush with long slender branches and spines]
		  [object a Tea Tree]
		  [object a Daphne]
		  ]
		 [question [Does the bush have spines]
		  [object a Blackthorn]
		  [question [Are the leaves scented when rubbed]
		   [object a Sweet Gale]
		   [object a Willow - leaved Spiraea]
		   ]
		  ]
		 ]
		]
	   ]
	  [question [Are the leaves grey - or white - felted on the under surfaces]
	   [question [Are the leaves entire]
		[question [Are the leaf upper surfaces smooth]
		 [object a Cotoneaster]
		 [object a Cotoneaster Melanocarpa]
		 ]
		[question [Are the leaves doubly serrated with dense white felt underneath]
		 [object a Whitebeam]
		 [question [Are the leaves doubly serrated]
		  [object a Grey Alder]
		  [question [Are the leaf under surfaces felted snow - white]
		   [object a White Poplar]
		   [object a Grey Poplar]
		   ]
		  ]
		 ]
		]
	   [question [Are the leaves thick , leathery , shiny dark green]
		[object a Holly]
		[question [Are the leaves entire edged]
		 [question [Are the leaves regularly pinnately veined]
		  [question [Are the buds slender , pointed with many scales]
		   [object a Beech]
		   [object an Alder Buckthorn]
		   ]
		  [object an Ivy]
		  ]
		 [question [Are the leaf stalks strongly compressed]
		  [question [Are the leaves almost circular]
		   [object an Aspen]
		   [question [Does each leaf have 1 or 2 glands at its base]
			[object a Black Italian Poplar]
			[object a Lombardy Poplar]
			]
		   ]
		  [question [Are the leaf under - surfaces whitish]
		   [question [Are the leaf stalks hairy]
			[object an Ontario Poplar]
			[object an Oregon Balsam Poplar]
			]
		   [question [Are the leaf bases oblique]
			[question [Are the leaf upper surfaces smooth]
			 [question [Are the leaf upper sides curly - haired]
			  [object a Fluttering Elm]
			  [object a Smooth - leaved Elm]
			  ]
			 [object a Wych Elm]
			 ]
			[question [Are the leaves shaped like a heart]
			 [question [Are the leaf upper surfaces bluish - green]
			  [object a Small - leaved Lime]
			  [question [Are the leaves and leaf stalks downy]
			   [object a Large - leaved Lime]
			   [object a Common Lime]
			   ]
			  ]
			 [question [Does the tree or bush have thorns]
			  [question [Are the thorns in groups of 3]
			   [object a Barberry]
			   [question [Are the leaf stalks at least half the length of the blades]
				[question [Is the leaf blade nearly circular , with a very short point]
				 [object a Wild Pear]
				 [object a Crab Apple]
				 ]
				[question [Are the young shoots hairless]
				 [object a Cherry Plum]
				 [object a Bullace]
				 ]
				]
			   ]
			  [question [Are the leaves approximately as long as broad]
			   [question [Are the leaves up to 1 / 2 in long]
				[object a Dwarf Birch]
				[question [Are the leaves up to 2 in long]
				 [object a St Lucie Cherry]
				 [question [Are the leaves hairless]
				  [object a Common Alder]
				  [object a Hazel]
				  ]
				 ]
				]
			   [question [Do the leaf stalks or bases have glands]
				[question [Are the flowers and fruits in long clusters]
				 [question [Are the leaves shiny and finely serrated]
				  [object a Rum Cherry]
				  [object a Bird Cherry]
				  ]
				 [question [Are the under surfaces of the leaves downy]
				  [object a Wild Cherry]
				  [object a Dwarf Cherry]
				  ]
				 ]
				[question [Are the lateral veins on the leaves very distinct]
				 [question [Are the leaf edges wavy]
				  [object a Beech]
				  [question [Are the leaf under - surfaces grey to bluish - grey]
				   [object a Grey Alder]
				   [question [Are the leaves finely and doubly serrated]
					[object a Hornbeam]
					[question [Are the young shoots hairy and the leaves singly serrated]
					 [object a Hairy Birch]
					 [object a Warty Birch]
					 ]
					]
				   ]
				  ]
				 [question [Are the leaf indentations pointed]
				  [object a Snowy Mespilus]
				  [object a Berlin Poplar]
				  ]
				 ]
				]
			   ]
			  ]
			 ]
			]
		   ]
		  ]
		 ]
		]
	   ]
	  ]
	 ]
	]
   ]
  ]
 ] -> root;

define macro go();
	findtree(root);
	print_list_nice([Please type "go" if you have another tree]); nl(2)
enddefine;

define findtree(net);
	vars question,yestree,notree,treename,e;
	if net matches [object ??treename] then
		nl(2);
		print_list_nice([The tree is ^^treename]);
		nl(2)
	elseif net matches [question ?question ?yestree ?notree] then
		if askquestion(question) then
			findtree(yestree)
		else
			findtree(notree)
		endif
	else
		mishap('Malformed discrimination net',[^net])
	endif
enddefine;

define print_list_nice(list);
	vars x;
	for x in list do
		pr(x); sp(1)
	endfor
enddefine;

define askquestion(question);
	vars e, input;
	print_list_nice(question);
	readline() -> input;
	if input = [yes] then
		return(true)
	elseif input = [no] then
		return(false)
	else
		print_list_nice([please answer "yes" or "no"]);
		nl(1);
		askquestion(question)
	endif
enddefine;

nl(2);
ppr([TREE IDENTIFICATION PROGRAM]);
nl(1); ppr([===========================]);nl(3);
ppr([I will try to identify your tree by asking questions]);
nl(1); ppr([Please type "go" when you are ready]); nl(3);
