/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_class_attributes.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
															  ;;;04 Jun 93
;;; LIB go_class_attributes

compile_mode :pop11 +strict;

;;;                    SLOT/VALUE PAIRS FOR GO OBJECTS
;;;                    ------------------------------
;;; File:   go_class_attributes
;;; Date:   04 Jun 93
;;; Author: benr
;;;
;;; This library enables to find all relevant slots and their values
;;; for each of the objects in the GO system.
;;;

;;; WARNING:
;;; --------
;;; This file is generated with: com/go_mk_class_attributes
;;; Unfortunately this needs to be filtered to avoid circularity and internal
;;; references like properties; This was done by eliminating the "cached_go"
;;; slots from the classes because they are session dependent, and by flagging
;;; the slots with prefix "the_go" which normally refers to other pop internal
;;; items such as other objects or Xlib-widgets. Note that the other slots
;;; might need attention too!
;;; In the file below you can search on: "the_go" and if necessarry reinstate
;;; or change the mechanism for those slots.
;;; They are flagged as follows:
/* THE FOLLOWING NEEDS MANUAL ATTENTION: *
;;;    "the_go_components"; obj.the_go_components;
 *                                       */
;;; Example Change:
/* THE FOLLOWING NEEDS MANUAL ATTENTION: *
;;;    "the_go_components"; maplist(obj.the_go_components, go_get_class_attributes);
 *                                       */

;;; PLEASE ALSO REMOVE THE call_next_method( obj ); LINE FOR GO_LOCATED CLASS.

;;; --------------------------------------------------------------------------
														;;; 30th Nov 1992
;;; File: go_class_attributes.p
;;; Author: Ben Rabau (partly generated with com/go_mk_class_attributes)

;;; REF: Contents you can see for each file which classes and slots are
;;; REF: defined in it. See also REF * GO.
;;; REF: Some slots have been filtered out (see com/go_mk_class_attributes)
;;; REF: to avoid circularity and internal references like properties
;;; REF: used to cache temporary values.
;;; REF: The slot/value combinations can be assembled with:
;;; REF:            go_get_class_attributes()

;;; --------------------------------------------------------------------------
vars procedure go_class_attributes;     ;;; defined below

;;; TOPLEVEL COMMAND
;;; -------------------------
define :method go_get_class_attributes( obj :go_screen_object );
lvars obj;
;;; REF: go_get_class_attributes( SCREEN_OBJECT ) -> LIST;
;;; REF: Returns the list of slot/value pairs for the atributes of this
;;; REF: screen object in the Graphical Object library (GO).
;;; REF: SCREEN_OBJECT is a go_screen_object (see REF * GO_SCREEN_OBJECT).
	 [% datakey( obj ); go_class_attributes( obj ); %];
enddefine;

define go_print_attribute_value( val );
lvars val;
	define bool_pr(); if then sys_syspr('true'); else sys_syspr('false'); endif;
	enddefine;
	define word_pr(); sys_syspr('"'); sys_syspr();  sys_syspr('"'); enddefine;
	define stri_pr(); sys_syspr('\''); sys_syspr();  sys_syspr('\''); enddefine;
	define proc_pr(); sys_syspr( pdprops() ); enddefine;
	dlocal 1 % class_print( boolean_key ) % = bool_pr ;
	dlocal 1 % class_print( word_key ) % = word_pr ;
	dlocal 1 % class_print( string_key ) % = stri_pr ;
	dlocal 1 % class_print( procedure_key ) % = proc_pr ;

	printf('%p;\n', [% val %]);
enddefine;

define :method go_print_class_attributes( obj :go_screen_object );
lvars obj;
;;; REF: go_print_class_attributes( SCREEN_OBJECT );
;;; REF: Prints the list of slot/value pairs for the atributes of this
;;; REF: screen object in the Graphical Object library (GO).
;;; REF: SCREEN_OBJECT is a go_screen_object (see REF * GO_SCREEN_OBJECT).
lvars slotlist, s, v;

	pr(';;; This definition is automatically generated and might be incorrect!\n');
	printf('instance %p;\n', [% dataword( obj ) %]);
	[% go_class_attributes( obj ) %] -> slotlist;
	while not(slotlist == []) do
		fast_destpair( slotlist ) -> (s, slotlist);
		fast_destpair( slotlist ) -> (v, slotlist);
		printf('    %p = ', [% s %]);
		go_print_attribute_value( v );
	endwhile;
	printf('endinstance /* %p */;\n', [% dataword( obj ) %]);
enddefine;

uses go.p;
;;; -------------------------

define :method go_class_attributes( obj :go_short_print );
 lvars obj;
	call_next_method( obj );
enddefine;

uses go_arc.p;
;;; -------------------------

define :method go_class_attributes( obj :go_arc );
 lvars obj;
	call_next_method( obj );
	"stored_go_radius";	obj.stored_go_radius;
	"stored_go_angle";	obj.stored_go_angle;
	"stored_go_arc";	obj.stored_go_arc;
enddefine;

uses go_area.p;
;;; -------------------------

define :method go_class_attributes( obj :go_area );
 lvars obj;
	call_next_method( obj );
enddefine;

uses go_bitmap.p;
;;; -------------------------

define :method go_class_attributes( obj :go_bitmap );
 lvars obj;
	call_next_method( obj );
	"stored_go_bounding_width";	obj.stored_go_bounding_width;
	"stored_go_bounding_height";	obj.stored_go_bounding_height;
	"stored_go_iconname";	obj.stored_go_iconname;
enddefine;

uses go_circle.p;
;;; -------------------------

define :method go_class_attributes( obj :go_circle );
 lvars obj;
	call_next_method( obj );
	"stored_go_arc";	obj.stored_go_arc;
enddefine;

uses go_colourable.p;
;;; -------------------------

define :method go_class_attributes( obj :go_colourable );
 lvars obj;
	call_next_method( obj );
	"stored_go_fgcolour";	obj.stored_go_fgcolour;
	"stored_go_bgcolour";	obj.stored_go_bgcolour;
enddefine;

uses go_composite.p;
;;; -------------------------

define :method go_class_attributes( obj :go_composite );
 lvars obj;
	call_next_method( obj );
	"go_is_editable";	obj.go_is_editable;
enddefine;

uses go_edit_point.p;
;;; -------------------------

define :method go_class_attributes( obj :go_edit_point );
 lvars obj;
	call_next_method( obj );
	"stored_go_filled";	obj.stored_go_filled;
enddefine;

uses go_editor.p;
;;; -------------------------

define :method go_class_attributes( obj :go_editor );
 lvars obj;
	call_next_method( obj );
	"go_edited_object";	obj.go_edited_object;
	"stored_go_get_absolute";	obj.stored_go_get_absolute;
	"stored_go_move_absolute";	obj.stored_go_move_absolute;
enddefine;

uses go_fillable.p;
;;; -------------------------

define :method go_class_attributes( obj :go_fillable );
 lvars obj;
	call_next_method( obj );
	"stored_go_filled";	obj.stored_go_filled;
enddefine;

uses go_group.p;
;;; -------------------------

define :method go_class_attributes( obj :go_group );
 lvars obj;
	call_next_method( obj );
	"go_components";	obj.go_components;
/* THE FOLLOWING NEEDS MANUAL ATTENTION: */
	"the_go_components"; maplist(obj.the_go_components, go_get_class_attributes);
/*                                       */
	"go_xoffsets";	obj.go_xoffsets;
	"go_yoffsets";	obj.go_yoffsets;
/* THE FOLLOWING HAS BEEN REMOVED MANUALLY *
	"stored_go_visible_in_panes";	obj.stored_go_visible_in_panes;
 *                                         */
	"stored_go_live_object";	obj.stored_go_live_object;
enddefine;

uses go_key_sensitive.p;
;;; -------------------------

define :method go_class_attributes( obj :go_key_sensitive );
 lvars obj;
	call_next_method( obj );
	"go_key_down_action";	obj.go_key_down_action;
	"go_key_up_action";	obj.go_key_up_action;
enddefine;

uses go_labelled.p;
;;; -------------------------

define :method go_class_attributes( obj :go_labelled );
 lvars obj;
	call_next_method( obj );
	"stored_go_label";	obj.stored_go_label;
	"stored_go_label_font";	obj.stored_go_label_font;
	"stored_go_label_x_offset";	obj.stored_go_label_x_offset;
	"stored_go_label_y_offset";	obj.stored_go_label_y_offset;
enddefine;

uses go_load_require.p;
;;; -------------------------

uses go_located.p;
;;; -------------------------

define :method go_class_attributes( obj :go_located );
 lvars obj;
	"stored_go_xcentre";	obj.stored_go_xcentre;
	"stored_go_ycentre";	obj.stored_go_ycentre;
	"stored_go_bounding_width";	obj.stored_go_bounding_width;
	"stored_go_bounding_height";	obj.stored_go_bounding_height;
	"stored_go_xscale";	obj.stored_go_xscale;
	"stored_go_yscale";	obj.stored_go_yscale;
enddefine;

uses go_mouse_sensitive.p;
;;; -------------------------

define :method go_class_attributes( obj :go_mouse_sensitive );
 lvars obj;
	call_next_method( obj );
	"stored_go_mouse_down_action";	obj.stored_go_mouse_down_action;
	"stored_go_mouse_drag_action";	obj.stored_go_mouse_drag_action;
	"stored_go_mouse_up_action";	obj.stored_go_mouse_up_action;
enddefine;

uses go_ncremove.p;
;;; -------------------------

uses go_oblong.p;
;;; -------------------------

define :method go_class_attributes( obj :go_oblong );
 lvars obj;
	call_next_method( obj );
	"stored_go_rounding";	obj.stored_go_rounding;
enddefine;

uses go_pane.p;
;;; -------------------------

define :method go_class_attributes( obj :go_pane );
 lvars obj;
	call_next_method( obj );
	"stored_go_window";	obj.stored_go_window;
	"go_edit_mode";	obj.go_edit_mode;
	"go_visible_objects";	obj.go_visible_objects;
	"go_editors";	obj.go_editors;
	"stored_go_xscale";	obj.stored_go_xscale;
	"stored_go_yscale";	obj.stored_go_yscale;
	"stored_go_xorigin";	obj.stored_go_xorigin;
	"stored_go_yorigin";	obj.stored_go_yorigin;
	"go_grab_mouse_object";	obj.go_grab_mouse_object;
enddefine;

uses go_pane_area.p;
;;; -------------------------

define :method go_class_attributes( obj :go_pane_area );
 lvars obj;
	call_next_method( obj );
	"stored_go_bounding_width";	obj.stored_go_bounding_width;
	"stored_go_bounding_height";	obj.stored_go_bounding_height;
	"go_is_editable";	obj.go_is_editable;
	"stored_go_batch_mode";	obj.stored_go_batch_mode;
enddefine;

uses go_point.p;
;;; -------------------------

define :method go_class_attributes( obj :go_point );
 lvars obj;
	call_next_method( obj );
	"go_border";	obj.go_border;
enddefine;

uses go_polyarrow.p;
;;; -------------------------

define :method go_class_attributes( obj :go_polyarrow );
 lvars obj;
	call_next_method( obj );
	"go_from_arrow";	obj.go_from_arrow;
	"go_to_arrow";	obj.go_to_arrow;
	"go_border";	obj.go_border;
enddefine;

uses go_polygon.p;
;;; -------------------------

define :method go_class_attributes( obj :go_polygon );
 lvars obj;
	call_next_method( obj );
	"stored_go_npoints";	obj.stored_go_npoints;
	"stored_go_radius";	obj.stored_go_radius;
	"stored_go_angle";	obj.stored_go_angle;
	"stored_go_points";	obj.stored_go_points;
	"stored_go_rounding";	obj.stored_go_rounding;
	"stored_go_closed";	obj.stored_go_closed;
	"stored_go_regular";	obj.stored_go_regular;
enddefine;

uses go_polyline.p;
;;; -------------------------

define :method go_class_attributes( obj :go_polyline );
 lvars obj;
	call_next_method( obj );
	"stored_go_regular";	obj.stored_go_regular;
	"stored_go_closed";	obj.stored_go_closed;
	"stored_go_npoints";	obj.stored_go_npoints;
	"go_border";	obj.go_border;
enddefine;

uses go_rc_window.p;
;;; -------------------------

define :method go_class_attributes( obj :go_rc_window_pane );
 lvars obj;
	call_next_method( obj );
enddefine;

define :method go_class_attributes( obj :go_rc_window );
 lvars obj;
	call_next_method( obj );
enddefine;

uses go_rectangle.p;
;;; -------------------------

define :method go_class_attributes( obj :go_rectangle );
 lvars obj;
	call_next_method( obj );
	"stored_go_regular";	obj.stored_go_regular;
	"stored_go_closed";	obj.stored_go_closed;
	"stored_go_npoints";	obj.stored_go_npoints;
	"stored_go_width";	obj.stored_go_width;
	"stored_go_height";	obj.stored_go_height;
enddefine;

uses go_roundlines.p;
;;; -------------------------

uses go_screen_object.p;
;;; -------------------------

define :method go_class_attributes( obj :go_screen_object );
 lvars obj;
	call_next_method( obj );
/* THE FOLLOWING HAS BEEN REMOVED MANUALLY *
	"go_visible_in_panes";	obj.go_visible_in_panes;
 *                                         */
	"go_visible_now";	obj.go_visible_now;
	"go_fixed_image";	obj.go_fixed_image;
	"stored_go_linewidth";	obj.stored_go_linewidth;
	"go_live_object";	obj.go_live_object;
enddefine;

uses go_sensitive.p;
;;; -------------------------

uses go_shell.p;
;;; -------------------------

define :method go_class_attributes( obj :go_shell );
 lvars obj;
	call_next_method( obj );
/* THE FOLLOWING NEEDS MANUAL ATTENTION: */
	"the_go_panes"; maplist(obj.the_go_panes, go_get_class_attributes);
/*                                       */
/* THE FOLLOWING NEEDS MANUAL ATTENTION: *
	"the_go_shell";	obj.the_go_shell;
 *                                       */
/* THE FOLLOWING NEEDS MANUAL ATTENTION: *
	"the_go_board";	obj.the_go_board;
 *                                       */
	"stored_go_bounding_width";	obj.stored_go_bounding_width;
	"stored_go_bounding_height";	obj.stored_go_bounding_height;
enddefine;

uses go_square.p;
;;; -------------------------

define :method go_class_attributes( obj :go_square );
 lvars obj;
	call_next_method( obj );
	"stored_go_regular";	obj.stored_go_regular;
	"stored_go_closed";	obj.stored_go_closed;
	"stored_go_npoints";	obj.stored_go_npoints;
	"stored_go_angle";	obj.stored_go_angle;
enddefine;

uses go_text.p;
;;; -------------------------

define :method go_class_attributes( obj :go_text );
 lvars obj;
	call_next_method( obj );
enddefine;

uses go_text_input.p;
;;; -------------------------

define :method go_class_attributes( obj :go_text_input );
 lvars obj;
	call_next_method( obj );
	"go_key_down_action";	obj.go_key_down_action;
	"stored_go_label";	obj.stored_go_label;
	"stored_go_width";	obj.stored_go_width;
enddefine;

uses go_window_pane.p;
;;; -------------------------

define :method go_class_attributes( obj :go_window_pane );
 lvars obj;
	call_next_method( obj );
	"go_live_object";	obj.go_live_object;
	"stored_go_xscale";	obj.stored_go_xscale;
	"stored_go_yscale";	obj.stored_go_yscale;
	"stored_go_fgcolour";	obj.stored_go_fgcolour;
	"stored_go_bgcolour";	obj.stored_go_bgcolour;
	"go_auto_resize";	obj.go_auto_resize;
	"stored_go_batch_mode";	obj.stored_go_batch_mode;
enddefine;

uses go_xaction.p;
;;; -------------------------

uses go_xdefaults.p;
;;; -------------------------

uses go_xdrag.p;
;;; -------------------------

uses go_xdraw.p;
;;; -------------------------

uses go_xregions.p;
;;; -------------------------

uses go_xresize.p;
;;; -------------------------

/* --- Revision History --------------------------------------------
 * JJC 8/9/93
 *     Changed 'object ... endobject ' to 'instance ... endinstance'.
 */
