/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_square.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 30th Apr 1993
;;; File: go_square.p
;;; Author: Ben L.E. Rabau

compile_mode :pop11 +strict;

uses go_polygon;

;;; INTRO: The go_square CLASS is a special case of the polygon class:
;;; INTRO: it is a regular 4-angled (see slot "go_npoints") polygon. All
;;; INTRO: other features are explained in HELP * GO_POLYGON.
;;; INTRO: Note that this is not a go_rectangle !!!

;;; --------------------------------------------------------------------

define :class go_square;
	isa go_polygon;
	slot stored_go_regular == true;
;;; REF: A square is a regular polygon.
	slot stored_go_closed  == true;
;;; REF: A square is a closed polygon.
	slot stored_go_npoints ==    4;
;;; REF: A square is a polygon with 4 sides.
	slot stored_go_angle   ==   45;
;;; REF: A square is a polygon but under a 45 degree angle (first point).
enddefine;

define :method updaterof go_npoints( n, sq :go_square );
lvars n, sq;
;;; REF: INTEGER -> go_npoints( SQUARE );
;;; REF: Prevent changing the number of point in the regular polygon.
;;; REF: A square always has four angles (go_npoints=4) and cannot be
;;; REF: changed to anything else.
;;; REF: SQUARE is an instance of the go_square class (see REF * GO_SQUARE).
	unless ( n = 4 ) then
		mishap('cannot update number of sides of a go_square to', [^n]);
	endunless;
enddefine;

;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_square = true;

/* --- Revision History --------------------------------------------
 * BR 30/04/93
 *     Moved go_square class and go_oblong class into separate file
 */
;;; eof
