/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:            S.hpbob/src/aarith.s
 * Purpose:
 * Author:          John Gibson & Sak Wathanasin (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */

#_<

#_INCLUDE 'declare.ph'

constant
	procedure Sys$-Array$-Sub_error
	;

lconstant macro (
	_PD_ARRAY_TABLE		= @@PD_ARRAY_TABLE,
	_PD_ARRAY_VECTOR	= @@PD_ARRAY_VECTOR,
	_PD_ARRAY_SUBSCR_PDR	= @@PD_ARRAY_SUBSCR_PDR,
	);

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/

	text

;;; --- LOGICAL BIT ROUTINES --------------------------------------------

DEF_C_LAB 4 (_biset)
	mov.l	(%a6)+,%d0
	or.l	%d0,(%a6)
	rts

DEF_C_LAB 4 (_biclear)
	mov.l	(%a6)+,%d0
	not.l	%d0
	and.l	%d0,(%a6)
	rts

DEF_C_LAB 4 (_bimask)
	mov.l	(%a6)+,%d0
	and.l	%d0,(%a6)
	rts

DEF_C_LAB 4 (_bixor)
	mov.l	(%a6)+,%d0
	eor.l	%d0,(%a6)
	rts


;;; ------------------------------------------------------------------------

DEF_C_LAB 4 (_mult)
	mov.l	(%a6)+, %d0		;;; integer 2
	muls.l	(%a6), %d0		;;; times integer 1 into %d0
	mov.l	%d0, (%a6)		;;; return result
	rts

;;; ------------------------------------------------------------------------

	;;; integer divide
DEF_C_LAB 4 (_div)
	mov.l	(%a6)+, %d0		;;; divisor
	mov.l	(%a6), %d1		;;; dividend
	divsl.l	%d0, %d2:%d1		;;; quot -> %d1, rem -> %d2
	mov.l	%d2, (%a6)		;;; return remainder
	mov.l	%d1, -(%a6)		;;; and quotient
	rts

	;;; integer divide, quotient only
DEF_C_LAB 2 (_divq)
	mov.l	(%a6)+, %d0		;;; divisor
	mov.l	(%a6), %d1		;;; dividend
	divsl.l	%d0, %d2:%d1		;;; quot -> %d1, rem -> %d2
	mov.l	%d1, (%a6)		;;; return quotient
	rts

;;; ------------------------------------------------------------------------

	;;; pop integer multiply
DEF_C_LAB 4 (_pmult)
	mov.l	(%a6)+,%d0		;;; popint 2
	asr.l	&2, %d0			;;; make machine int
	mov.l	(%a6), %d1		;;; popint 1
	subq.l	&3, %d1			;;; clear popint bits
	muls.l	%d1, %d0
	addq.l	&3, %d0			;;; restore result to popint
	mov.l	%d0, (%a6)		;;; return it
	rts

	;;; and with overflow test
DEF_C_LAB (_pmult_testovf)
	mov.l	(%a6)+,%d0		;;; popint 2
	asr.l	&2, %d0			;;; make machine int
	mov.l	(%a6), %d1		;;; popint 1
	subq.l	&3, %d1			;;; clear popint bits
	muls.l	%d1, %d0			;;; product -> %d0
	bvs.b	La1			;;; return false if overflow
	addq.l	&3, %d0			;;; restore result to popint
	mov.l	%d0, (%a6)		;;; return it
	mov.l	&C_LAB(true), -(%a6)	;;; and true
	rts
La1:	addq.l	&3, %d0			;;; restore result to popint
	mov.l	%d0, (%a6)		;;; return it
	mov.l	%d4, -(%a6)		;;; return false
	rts

;;; ------------------------------------------------------------------------

	;;; pop integer divide
DEF_C_LAB 4 (_pdiv)
	mov.l	(%a6)+, %d0		;;; divisor
	asr.l	&2, %d0			;;; convert to sysint
	mov.l	(%a6), %d1		;;; dividend
	asr.l	&2, %d1			;;; convert to sysint
	divsl.l	%d0, %d2:%d1		;;; quot -> %d1, rem -> %d2
	asl.l	&2, %d2			;;; convert remainder to popint
	addq.l	&3, %d2
	mov.l	%d2, (%a6)
	asl.l	&2, %d1			;;; convert quotient to popint
	addq.l	&3, %d1
	mov.l	%d1, -(%a6)
	rts

;;; ------------------------------------------------------------------------

	;;; replace tos with false and return
false2:	mov.l	%d4, (%a6)
	rts


;;; ------------------------------------------------------------------------

	;;; convert int to popint, with overflow test
DEF_C_LAB (_pint_testovf)
	mov.l	(%a6), %d0
	asl.l	&2, %d0
	bvs.b	false2			;;; false for overflow
	addq.l	&3, %d0
	mov.l	%d0, (%a6)
	mov.l	&C_LAB(true), -(%a6)
	rts

;;; ------------------------------------------------------------------------

	;;; shift popint left, with overflow test
DEF_C_LAB (_pshift_testovf)
	mov.l	(%a6)+, %d0		;;; +ve shift amount
	mov.l	(%a6), %d1		;;; the pop integer
	eor.l	&3, %d1			;;; clear popint bits
	beq.b	Lb1			;;; no overflow if 0
	cmp.l	%d0, &30		;;; shift >= 30 bits?
	bge.b	false2			;;; overflow if so
	asl.l	%d0, %d1		;;; else do the shift
	bvs.b	false2			;;; false for overflow
	or.b	&3, %d1			;;; reset popint bits
	mov.l	%d1, (%a6)		;;; return it
Lb1:	mov.l	&C_LAB(true), -(%a6)	;;; and true
	rts


;;; --- BIGINTEGER ARITHMETIC --------------------------------------------

	;;; multiply two long slices to get double length result
	;;; _emul(multiplicand, multiplier) -> high -> low
DEF_C_LAB (_emul)
DEF_C_LAB (_posword_emul)
	mov.l	(%a6)+, %d0		;;; multiplier
	muls.l	(%a6), %d1:%d0		;;; * multiplicand, lo->d0, hi->d1
	asl.l	&1, %d1			;;; shift up hi part
	bclr	&31, %d0		;;; clear bit 31 in lo part
	beq.b	Lc1			;;; branch if wasn't set
	addq.l	&1, %d1			;;; else transfer up to hi part
Lc1:	mov.l	%d0, (%a6)		;;; return lo part
	mov.l	%d1, -(%a6)		;;; and hi part
	rts


	;;; divide double dividend by single longword slice
	;;; _ediv(high, low, divisor) -> quotient -> remainder
DEF_C_LAB (_ediv)
	mov.l	(%a6)+, %d0		;;; signed divisor
	mov.l	(%a6)+, %d1		;;; dividend lo
	mov.l	(%a6), %d2		;;; dividend hi
	asr.l	&1, %d2			;;; shift down hi
	bcc.b	Ld1			;;; branch if bit 0 wasn't 1
	bset	&31, %d1		;;; transfer bit 0 down to lo bit 31
Ld1:	divs.l	%d0, %d2:%d1		;;; divide, rem->d2, quot->d1
	mov.l	%d2, (%a6)		;;; return remainder
	mov.l	%d1, -(%a6)		;;; and quoitent
	rts


	;;; multiply a biginteger by a signed value into a destination bigint
	;;; _bgi_mult(multiplier, saddr, slim, daddr) -> nextdest -> carry
DEF_C_LAB (_bgi_mult)
	mov.l	(%a6)+, %a1		;;; dest addr
	mov.l	(%a6)+, %d4		;;; source limit
	mov.l	(%a6)+, %a0		;;; source addr
	movq	&0, %d2			;;; clear last carry slice
	movq	&0, %d3			;;; use d3 as zero data reg

Le1:	mov.l	(%a0)+, %d0		;;; next source slice -> d0
	muls.l	(%a6), %d1:%d0		;;; * multiplier, lo -> d0, hi -> d1
	;;; add in carry
	tst.l	%d2			;;; carry negative?
	bpl.b	Le2			;;; branch if not
	subq.l	&1, %d1			;;; else subtract 1 to account for sign
Le2:	add.l	%d2, %d0		;;; add last carry slice to lo
	addx.l	%d3, %d1		;;; add extend bit to result hi

	asl.l	&1, %d1			;;; shift up hi
	bclr	&31, %d0		;;; clear bit 31 in lo part
	beq.b	Le3			;;; branch if wasn't set
	addq.l	&1, %d1			;;; else transfer up to hi part

Le3:	mov.l	%d0, (%a1)+		;;; store lo at next destination
	mov.l	%d1, %d2		;;; hi becomes next carry
	cmp.l	%a0, %d4		;;; reached source limit?
	bcs.b	Le1			;;; next if not

	mov.l	%d2, (%a6)		;;; return carry slice
	mov.l	%a1, -(%a6)		;;; and next destination
	mov.l	&C_LAB(false), %d4	;;; restore d4 to false
	rts

	;;; multiply a biginteger by a signed value and add
	;;; into a destination bigint
	;;; _bgi_mult_add(value, saddr, slim, sdaddr) -> nextdest -> carry
DEF_C_LAB (_bgi_mult_add)
	mov.l	(%a6)+, %a1		;;; dest addr
	mov.l	(%a6)+, %d4		;;; source limit
	mov.l	(%a6)+, %a0		;;; source addr
	movq	&0, %d2			;;; clear last carry slice
	movq	&0, %d3			;;; use d3 as zero data reg

Lf1:	mov.l	(%a0)+, %d0		;;; next source slice -> d0
	muls.l	(%a6), %d1:%d0		;;; * multiplier, lo -> d0, hi -> d1
	;;; add carry
	tst.l	%d2			;;; carry negative?
	bpl.b	Lf2			;;; branch if not
	subq.l	&1, %d1			;;; else hi -1 to account for sign
Lf2:	add.l	%d2, %d0		;;; add last carry slice to lo
	addx.l	%d3, %d1		;;; add extend bit to result hi
	;;; add destination slice
	mov.l	(%a1), %d2		;;; dest slice
	bpl.b	Lf3			;;; branch if not negative
	subq.l	&1, %d1			;;; else hi -1 to account for sign
Lf3:	add.l	%d2, %d0		;;; add dest slice to lo
	addx.l	%d3, %d1		;;; add extend bit to result hi

	asl.l	&1, %d1			;;; shift up hi
	bclr	&31, %d0		;;; clear bit 31 in lo part
	beq.b	Lf4			;;; branch if wasn't set
	addq.l	&1, %d1			;;; else transfer up to hi part

Lf4:	mov.l	%d0, (%a1)+		;;; store lo at next destination
	mov.l	%d1, %d2		;;; hi becomes next carry
	cmp.l	%a0, %d4		;;; reached source limit?
	bcs.b	Lf1			;;; next if not

	mov.l	%d2, (%a6)		;;; return carry slice
	mov.l	%a1, -(%a6)		;;; and next destination
	mov.l	&C_LAB(false), %d4	;;; restore d4 to false
	rts


	;;; divide a biginteger by a signed value into a destination bigint
	;;; _bgi_div(divisor, saddr, slim, dlim) -> remainder
DEF_C_LAB (_bgi_div)
	mov.l	(%a6)+, %a1		;;; dest limit addr
	mov.l	(%a6)+, %a0		;;; source limit
	mov.l	(%a6)+, %d3		;;; source start addr

	movq	&0, %d1			;;; zero hi
	mov.l	-(%a0), %d0		;;; ms (signed) slice of source into lo
	bpl.b	Lg2			;;; do first divide
	movq	&-1, %d1		;;; sign extension in hi part
	bra.b	Lg2			;;; do first divide

Lg1:	mov.l	-(%a0), %d0		;;; next (+ve) source slice in lo part
	asr.l	&1, %d1			;;; shift down remainder, now hi part
	bcc.b	Lg2			;;; branch if bit 0 wasn't set
	bset	&31, %d0		;;; else set bit 31 in lo
Lg2:	divs.l	(%a6), %d1:%d0		;;; div by divisor quot->d0, rem->d1
	mov.l	%d0, -(%a1)		;;; store quot in dest (can be -ve)
	cmp.l	%a0, %d3		;;; reached source start?
	bhi.b	Lg1			;;; next if not

	mov.l	%d1, (%a6)		;;; return last remainder
	rts


;;; --- COMPUTE ARRAY SUBSCRIPTS -----------------------------------------

	;;; compute an array total subscript
DEF_C_LAB (_array_sub)
	mov.l	4(%sp), %a0		;;; array procedure address
	lea	_PD_ARRAY_TABLE(%a0), %a0	;;; start of params
	mov.l	(%a0)+, %d4		;;; init total subscript from 1st word
	bra.b	Lh3

Lh1:	mov.l	(%a6)+, %d1		;;; next dimension subscript
	btst	&1, %d1			;;; pop integer?
	beq.b	Lh4			;;; error if not
	sub.l	(%a0)+, %d1		;;; subtract lower bound
	cmp.l	%d1, %d0		;;; compare with length
	bcc.b	Lh4			;;; error if subscript >= length
	mov.l	(%a0)+, %d0		;;; dimension scaling factor
	beq.b	Lh2			;;; zero means 1, so no multiply needed
	mulu.l	%d0, %d1		;;; times subscript
Lh2:	add.l	%d1, %d4		;;; add to total
Lh3:	mov.l	(%a0)+, %d0		;;; length in next dimension
	bne.b	Lh1			;;; continue unless zero

	;;; finished -- push total subscript to stack, push array vector
	;;; to stack, and then chain subscripting procedure
	mov.l	%d4, -(%a6)		;;; subscript
	mov.l	&C_LAB(false), %d4	;;; restore d4 to false
	mov.l	4(%sp), %a0		;;; array procedure again
	mov.l	_PD_ARRAY_VECTOR(%a0), -(%a6)	;;; array vector
	mov.l	_PD_ARRAY_SUBSCR_PDR(%a0), %a0	;;; subscr procedure
	mov.l	(%a0), %a0			;;; execute address
	jmp	(%a0)			;;; chain it

	;;; subscript not popint or too big/small
Lh4:	tst.l	-(%a6)			;;; get bad subscript on top of stack
	mov.l	&C_LAB(false), %d4	;;; restore d4 to false
	jmp	XC_LAB(weakref Sys$-Array$-Sub_error)	;;; error procedure


/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 30 1994
	Changes to _array_sub
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Dec  2 1988
	Added _divq
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Apr 20 1988
	New version using 68020 multiply/divide instructions.
 */
