/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:	    S.hpbob/src/aextern.s
 * Purpose:	    Calling external routines
 * Author:	    John Gibson & Sak Wathansin (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */


#_<

#_INCLUDE 'declare.ph'
#_INCLUDE 'external.ph'
#_INCLUDE 'numbers.ph'

vars
	Sys$- _curbrk
	;

lconstant macro (
	_CURBRK		= [I_LAB(Sys$- _curbrk)],
	_SAVED_SP	= [I_LAB(Sys$-Extern$- _saved_sp)],
	_SAVED_USP	= [I_LAB(Sys$-Extern$- _saved_usp)],

	_KEY		= @@KEY,
	_K_EXTERN_TYPE	= @@K_EXTERN_TYPE,
	_XP_PTR  	= @@XP_PTR,
	_DD_1		= @@DD_1,
	_DD_2		= @@DD_2,
	_BGI_LENGTH	= @@BGI_LENGTH,
	_BGI_SLICES	= @@BGI_SLICES,
	_EFC_FUNC	= @@EFC_FUNC,
	_EFC_ARG	= @@EFC_ARG,
	_EFC_ARG_DEST	= @@EFC_ARG_DEST,
	);

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/


	text

	;;;    _call_external(____arg1, ..., ____argN, _N, _______routine, _________fltsingle)
	;;;
	;;; Call an external procedure, moving args from userstack
	;;; to stack and converting -- for users. Must be capable of
	;;; dealing with callback.
	;;;    Bit N set in the _________fltsingle arg says pass the (N+1)th arg as a
	;;; single float if it's a (d)decimal (otherwise pass (d)decimals
	;;; as doubles). Note that bit 31 governs all args from 32nd onwards.

DEF_C_LAB (_call_external)

	mov.l	_CURBRK, save_curbrk ;;; save current break

#_IF DEF STACK_PROBES
	tst.b	-256(%sp)
#_ENDIF

	lea	4(%sp), %a0		;;; ptr to caller's stack frame
	mov.l	%a0, _SAVED_SP 		;;; save for callback/exceptions

	mov.l	(%a6)+, %d5		;;; _________fltsingle arg in d5
	mov.l	(%a6)+, %d3		;;; _______routine in d3
	mov.l	(%a6)+, %d2		;;; argument count _N in d2
	beq.w	Lb9			;;; no args
	movq.l	&32, %d0
	sub.l	%d2, %d0		;;; 32 - _N
	ble.b	Lb1f			;;; br if _N >= 32
	asl.l	%d0, %d5		;;; shift _________fltsingle bit for last arg
	bra.b	Lb1f			;;; up to sign bit

Lb1:	cmp.l	%d2, &32		;;; still on or after 32nd arg?
	bge.b	Lb1f			;;; if so, don't shift bits
	asl.l	&1, %d5			;;; next _________fltsingle bit up to sign bit

Lb1f:	mov.l	(%a6)+, %d0		;;; next arg
	;;; the following instruction tests AND CLEARS bit 0
	bclr	&0, %d0			;;; structure pointer? (clear bit 0)
	beq.b	Lb3			;;; br if so

	;;; integer or single decimal
	btst	&1, %d0			;;; integer?
	beq.b	Lb2			;;; br if decimal
	;;; integer
	asr.l	&2, %d0			;;; cvt integer to m/c int
	mov.l	%d0, -(%sp)
	bra.b	Lb8

Lb2:	;;; decimal -- pass as double float unless _________fltsingle bit set
	tst.l	%d5			;;; _________fltsingle bit (sign bit) set?
	bmi.b	Lb25			;;; yes -- pass as single
	;;; convert to double
	mov.l	%d0, -(%sp)
	jsr	_ftod
	mov.l	%d1, (%sp)
Lb25:	mov.l	%d0, -(%sp)
	bra.b	Lb8

	;;; structure pointer -- get K_EXTERN_TYPE field
Lb3:	mov.l	%d0, %a0
	mov.l	_KEY(%a0), %a1			;;; key
	mov.b	_K_EXTERN_TYPE(%a1), %d0	;;; type
	bne.b	Lb4				;;; br if nonzero
	;;; EXTERN_TYPE_NORMAL (0) -- just pass pointer
	mov.l	%a0, -(%sp)
	bra.b	Lb8

Lb4:	subq.b	&_:EXTERN_TYPE_DEREF, %d0
	bne.b	Lb5
	;;; pass word field at pointer (e.g. external pointer)
	mov.l	(%a0), -(%sp)		;;; pass dereferenced word
	bra.b	Lb8

Lb5:	subq.b	&_:EXTERN_TYPE_DDEC-_:EXTERN_TYPE_DEREF, %d0
	bne.b	Lb6

	;;; ddecimal -- pass as double unless _________fltsingle bit set
	mov.l	_DD_2(%a0), -(%sp)	;;; push ls half
	mov.l	_DD_1(%a0), -(%sp)	;;; and ms half
	tst.l	%d5			;;; _________fltsingle bit (sign bit) set?
	bpl.b	Lb8			;;; no -- leave as double
	;;; convert to single
	jsr	_dtof			;;; convert to single in d0
	addq.l	&4, %sp
	mov.l	%d0, (%sp)		;;; replace with single
	bra.b	Lb8

Lb6:	;;; else must be biginteger (EXTERN_TYPE_BIGINT)
	;;; pass least significant 32 bits
	mov.l	_BGI_SLICES(%a0), -(%sp)	;;; ls slice to stack
	movq	&1, %d0
	cmp.l	%d0, _BGI_LENGTH(%a0)	;;; only 1 slice?
	beq.b	Lb8			;;; OK if so
	mov.b	_BGI_SLICES+7(%a0), %d0	;;; bottom byte of 2nd slice
	lsl.b	&7, %d0			;;; ls bit to top of byte
	add.b	%d0, (%sp)		;;; add to top byte
	;;; drop thru to Lb8

	;;; test more args
Lb8:	subq.l	&1, %d2
	bne.w	Lb1			;;; more to come

	;;; call the procedure
Lb9:	mov.l	%a6, _SAVED_USP		;;; save user sp for callback

	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	mov.l	%sp, ___pop_in_user_extern ;;; any nonzero value will do
	jsr	0(%a2,%d3.l)		;;; over to the procedure
	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clr.l	___pop_in_user_extern

	mov.l	_SAVED_USP, %a6 	;;; regain user sp

	;;; set result_struct with possible float result from
	;;; d0,d1 in first 2 words and possible word result from d0 in last
	lea	C_LAB(Sys$-Extern$-result_struct), %a0
	mov.l	%d0, (%a0)+		;;; float result
	mov.l	%d1, (%a0)+
	mov.l	%d0, (%a0)		;;; word result

	mov.l	_SAVED_SP, %a0
	lea	-4(%a0), %sp		;;; reset sp to return addr
	clr.l	_SAVED_SP		;;; says no longer in extern call

	mov.l	save_curbrk, %d0
	cmp.l	%d0, _CURBRK
	beq.b	Lb99
	mov.l	%d4, %d5		;;; ensure pop lvars set to
	mov.l	%d4, %d6		;;; sensible pop values
	jmp	XC_LAB(Sys$-Mem_break_changed) ;;; break changed -- chain this
Lb99:	rts				;;; return


;;; --- EXTERNAL FUNCTION CLOSURES --------------------------------------

	;;; (exfunc closure address) + 6 on top of stack
	;;; assign EFC_ARG to EFC_ARG_DEST and chain EFC_FUNC

DEF_C_LAB(Sys$- _exfunc_clos_action)

	mov.l	(%sp)+, %a0		;;; addr of after jsr
	mov.l	_EFC_ARG_DEST-6(%a0), %a1 ;;; -6 gives address of rec
	mov.l	_EFC_ARG-6(%a0), (%a1)	;;; assign arg to destination
	mov.l	_EFC_FUNC-6(%a0), %a0	;;; funct exptr to chain to
	mov.l	(%a0), %a0		;;; deref
	jmp	(%a0)			;;; chain to func


;;; --- INTERFACE ROUTINE FOR EXTERNAL CALLBACK ------------------------------

	;;; C Synopsis:
	;;;
	;;; 	int _pop_external_callback(argp)
	;;; 	unsigned argp[];
	;;;
	;;; (where argp[0] is the function code for -Callback-)

global __pop_external_callback
__pop_external_callback:
	;;; for indirect weak reference
DEF_C_LAB(Sys$- _external_callback_func)
	movm.l  &0x7ffe, -(%sp)		;;; save all regs except sp,d0 (14 words)

	;;; 3 word dummy stack frame to hold SF_NEXT_SEG_SP and SF_NEXT_SEG_HI
	lea	-3*4(%sp), %sp
	mov.l	___pop_in_user_extern, %d7 ;;; save this and restore at end

	;;; NEXT INSTRUCTION DISABLES ASYNC CALLBACK
	clr.l	___pop_in_user_extern

	;;; set registers
	sub.l	%a2, %a2		;;; a2 always zero
	mov.l	&C_LAB(false), %d4	;;; d4 always false
	mov.l	%d4, %d5		;;; pop lvar to false
	mov.l	%d4, %d6		;;; and the other one

	mov.l	_SAVED_USP, %a6		;;; regain saved user sp
	mov.l	(3+14+1)*4(%sp), -(%a6)	;;; push argp

	mov.l	save_curbrk, %d0
	sub.l	_CURBRK, %d0		;;; non-zero if break changed
	mov.l	%d0, -(%a6)		;;; -- pass this as arg to Callback

	jsr	XC_LAB(Sys$-Extern$-Callback)

	mov.l	_CURBRK, save_curbrk	;;; resave current break

	mov.l	(%a6)+, %d0		;;; return status
	mov.l	%a6, _SAVED_USP		;;; resave user sp for _call_external

	;;; NEXT INSTRUCTION ENABLES ASYNC CALLBACK
	mov.l	%d7, ___pop_in_user_extern ;;; set back to value on entry

	lea	3*4(%sp), %sp		;;; erase dummy stack frame
	movm.l  (%sp)+, &0x7ffe		;;; restore all registers except sp,d0
	rts				;;; return into external code


;;; ------------------------------------------------------------------------

	data

	;;; saved value of Sys$- _curbrk
save_curbrk:
	long	0



/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 17 1995
	Moved definition of Extern$- _r*esult_struct to extern_ptr.p as
	Extern$-result_struct
--- John Gibson, Oct 20 1994
	No longer necessary for _call_external to save the pop registers
	(d5, d6), or for callback to do anything other than set them to
	false.
--- John Gibson, Nov 10 1993
	Made _pop_external_callback set __pop_in_user_extern back to the same
	value it had on entry
--- John Gibson, May 19 1993
	Template part of exfunc closures now generated by POPC, which
	jumps to the _exfunc_clos_action code in this file.
--- John Gibson, Dec 18 1992
	Moved pop_ex*func_arg to c_core.c (otherwise it's undefined if this
	file is not extracted)
--- John Gibson, Aug  7 1992
	Changed _call_external to take _________fltsingle arg whose Nth bit
	specifies the treatment of (d)decimals for the Nth arg
--- John Gibson, Jan 19 1991
	Added setting and clearing of ___pop_in_user_extern (tested nonzero
	by signal handler in c_core.c to determine whether asynchronous
	callback is allowed)
--- John Gibson, Nov 19 1990
	Added pop label for _pop_external_callback.
	Removed functions for getting interrupt/disable flag info
	(replaced by pointer constants in asignals.s)
--- John Gibson, Nov 13 1990
	_call_external now doesn't return the result structure on the
	stack, so the procedures calling it have to push
	Sys$-Extern$- _r*esult_struct explicitly (this is so the result isn't
	left on the stack when the return address from _call_external is
	changed for abnormal exit).
	_pop_external_callback now receives and passes on a status return
	from Callback.
--- John Gibson, Sep  5 1990
	Added exfunc closure stuff
--- Roger Evans, Jul  3 1990 added pop_interrupt_disabled
--- John Gibson, May 20 1990
	Removed _pop_mishap
--- John Gibson, May 14 1990
	_call_external now returns pointer to 3-word array, first
	2 words of which are possible single/double float result, 3rd word
	is possible result of any other kind.
--- John Gibson, Apr 29 1990
	Added callback routine.
	Moved _call_sys to asignals.s (so this file is purely 'optional'
	external stuff).
--- John Gibson, Mar 14 1990
	_call_external rewritten to use K_EXTERN_TYPE field, including
	coping with biginteger args.
--- Ian Rogers, Jan 17 1990
	Added pop_mishap for XPOP
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- Roger Evans, Nov 24 1988
	Corrected erroneous 'fix' for single decimals
--- John Gibson, Nov 21 1988
	Corrected some typos in last change.
--- Roger Evans, Oct 10 1988
	External data classes now dereference the E_PTR field, other
	structures pass E_DATA field (third longword).
	Single decimals: bottom bit now cleared before passing out
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Feb 11 1988
	ddecimal_key now in section Sys
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Aug 17 1987
	For segmented system, changed -_call_external- to chain
	-Mem_break_changed- if -_curbrk- changes during the external
	call
 */
