/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:            S.hpbob/src/afloat.s
 * Purpose:	    Floating-point routines for HP machines
 * Author:          John Gibson & Sak Wathanasin (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */


#_<

#_INCLUDE 'declare.ph'

constant	procedure Sys$-Float_qrem
	;

lconstant macro (
	_DD_1	= @@DD_1,
	_DD_2	= @@DD_2,

	FPE_FLAG = '___pop_fpe_flag+3',
	);

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/

	text

	;;; copy a double float from one address to another
DEF_C_LAB (_pfcopy)
	mov.l	(%a6)+,%a0		;;; source addr
	mov.l	(%a6)+,%a1		;;; dest addr
	mov.l	(%a0)+,(%a1)+
	mov.l	(%a0),(%a1)
	rts


	;;; routine to single-float decimal
DEF_C_LAB(_pf_sfloat_dec)
	mov.l	(%a6)+,%d0		;;; fetch decimal
	subq.l	&1,%d0			;;; convert to float
	mov.l	%d0,-(%a6)		;;; push result
	rts

	;;; routines to float sysints, decimals and ddecimals
DEF_C_LAB (_pf_dfloat_int)
	mov.l	(%a6)+,%d2		;;; address for result
	mov.l	(%a6)+,-(%sp)		;;; stack the integer
	jsr	_float			;;; float it into d0,d1
	addq.l	&4,%sp			;;; clean the stack
	mov.l	%d2,%a0
	mov.l	%d0,(%a0)+		;;; mslw of result
	mov.l	%d1,(%a0)		;;; lslw of result
	rts

DEF_C_LAB (_pf_dfloat_dec)
	mov.l	(%a6)+,%a0		;;; address for result
	mov.l	(%a6)+,%d0		;;; the decimal
	subq.l	&1,%d0			;;; clear low bit
	clr.l	-(%sp)
	mov.l	%d0,-(%sp)
	jsr	_ftod
	addq.l	&8,%sp
	mov.l	%d0,(%a0)+		;;; mslw of result
	mov.l	%d1,(%a0) 		;;; lslw of result
	rts

DEF_C_LAB (_pf_dfloat_ddec)
	mov.l	(%a6)+,%a0		;;; address for result
	mov.l	(%a6)+,%a1		;;; the ddecimal
	mov.l	_DD_1(%a1),(%a0)+	;;; move fields to result
	mov.l	_DD_2(%a1),(%a0)	;;; and the next one
	rts


	;;; -----------------------------------------------------------------
	;;; _PFABS, _PFNEGATE -- monadic double floating arith
	;;; uses:
	;;; 		top ->	operand address
	;;; results:	in memory
	;;; 		operand contains result
	;;; registers blown:
	;;; 		D0		(loading bay)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_pfabs)
	mov.l	(%a6)+,%a0		;;; operand address
	bclr	&7,(%a0)		;;; clear the sign bit in ms byte
	rts

DEF_C_LAB (_pfnegate)
	mov.l	(%a6)+,%a0		;;; operand address
	bchg	&7,(%a0)		;;; change the sign bit
	rts


DEF_C_LAB (_pfadd)
	mov.l	&_fadd,%a0
	bra.b	pfarith2

DEF_C_LAB (_pfsub)
	mov.l	&_fsub,%a0
	bra.b	pfarith2

DEF_C_LAB (_pfmult)
	mov.l	&_fmul,%a0
	bra.b	pfarith2

DEF_C_LAB (_pfdiv)
	mov.l	&_fdiv,%a0

pfarith2:
	mov.l	(%a6)+,%a1		;;; source address (2nd arg)
	mov.l	4(%a1),-(%sp)		;;; second arg ls word
	mov.l	(%a1),-(%sp)		;;; second arg ms word
	mov.l	(%a6),%a1		;;; dest address (1st arg)
	mov.l	4(%a1),-(%sp)		;;; first arg lslw
	mov.l	(%a1),-(%sp)		;;; first arg mslw
	clr.b	FPE_FLAG		;;; gets set if floating-point exception
	jsr	(%a0)			;;; do the operation
	lea	16(%sp),%sp		;;; clean the stack
	tst.b	FPE_FLAG		;;; fpe?
	bne.b	Ld1			;;; br if so
	mov.l	(%a6),%a1		;;; 1st arg (dest addr) again
	mov.l	%d1,4(%a1)		;;; result ls into destination
	mov.l	%d0,(%a1)		;;; result ms into destination
	mov.l	&C_LAB(true), (%a6)	;;; return true
	rts
Ld1:	mov.l	%d4,(%a6)		;;; return false for fpe
	rts


DEF_C_LAB (_pfqrem)
	jmp	XC_LAB(Sys$-Float_qrem)	;;; just chain to Float_qrem



	;;; -----------------------------------------------------------------
	;;; FALSE1, TRUE1 -- stack a boolean and return
	;;; uses:		--
	;;; used by:	??
	;;; arguments:	none
	;;; results:	on pop stack
	;;; 		top ->  true or false
	;;; registers blown: none
	;;; -----------------------------------------------------------------
false1:
	mov.l	%d4, -(%a6)		;;; stack a false
	rts

true1:
	mov.l	&C_LAB(true),-(%a6)	;;; stack a true
	rts


	;;; -----------------------------------------------------------------
	;;; _PFSGR, _PFSGEQ, _PFEQ -- double floating compares
	;;; uses:		C library function fcmp, boolean returns
	;;; arguments:	on user stack
	;;; 		top -> arg2 address
	;;; 				arg1 address
	;;; results:	on pop stack
	;;; 		top ->  true or false
	;;; registers blown: none
	;;; -----------------------------------------------------------------
pfcmp:
	mov.l	(%a6)+,%a1		;;; 2nd arg address
	mov.l	4(%a1),-(%sp)		;;; second arg ls lword
	mov.l	(%a1),-(%sp)		;;; second arg ms lword
	mov.l	(%a6)+,%a1		;;; 1st arg address
	mov.l	4(%a1),-(%sp)		;;; first arg lslw
	mov.l	(%a1),-(%sp)		;;; first arg mslw
	jsr	_fcmp			;;; compare (cleans stack)
	add.l	&16,%sp			;;; pop the stack
	tst.l	%d0			;;; result of the comparison
	rts

DEF_C_LAB (_pfsgr)
	bsr.b	pfcmp
	bgt.b	true1			;;; result in flags
	bra.b	false1

DEF_C_LAB (_pfsgreq)
	bsr.b	pfcmp
	bge.b	true1			;;; result in flags
	bra.b	false1

DEF_C_LAB (_pfeq)
	mov.l	(%a6)+,%a1		;;; arg2 address
	mov.l	(%a6)+,%a0		;;; arg1 address
	cmpm.l	(%a1)+,(%a0)+		;;; first longword same?
	bne.b	false1			;;; no,return false
	cmpm.l	(%a1)+,(%a0)+		;;; second longword same?
	bne.b	false1			;;; nope
	bra.b	true1			;;; yep


	;;; ;;; test double float negative (genuinely, i.e. not -0.0)
DEF_C_LAB (_pfneg)
	mov.l	(%a6)+,%a0		;;; arg address
	mov.l	(%a0)+,%d0		;;; ms part
	bpl.b	false1			;;; false if sign bit not 1
	asl.l	&1,%d0			;;; remove sign bit
	bne.b	true1			;;; else neg if ms non-zero
	tst.l	(%a0)			;;; else neg if ls part non-zero
	bne.b	true1
	bra.b	false1

	;;; ;;; test double float zero (i.e. including -0.0)
DEF_C_LAB (_pfzero)
	mov.l	(%a6)+,%a0		;;; arg address
	mov.l	(%a0)+,%d0
	asl.l	&1,%d0			;;; remove sign bit
	bne.b	false1
	tst.l	(%a0)			;;; else neg if ls part non-zero
	bne.b	false1
	bra.b	true1


	;;; _pf_cvt_to_dec(_dfaddr) -> decimal or -> <false>
	;;; convert double to decimal (rounded to 21 bit mantissa)
DEF_C_LAB (_pf_cvt_to_dec)
	mov.l	(%a6), %a0		;;; source address
	mov.l	4(%a0), %d1		;;; ls part
	;;; set bits to force rounding of 22nd bit of mantissa in all
	;;; cases except where tied and 21st bit is 0 (even)
	cmp.l	%d1, &0x40000000
	beq.b	Le1			;;; tied and even, won't round
	or.l	&0x38000000, %d1	;;; else set 23rd, 24th, 25th bits
Le1:	mov.l	%d1, -(%sp)		;;; ls part
	mov.l	(%a0), -(%sp)		;;; ms part
	clr.b	FPE_FLAG		;;; gets set if floating-point exception
	jsr	_dtof			;;; cvt to single in d0
	addq.l	&8, %sp
	tst.b	FPE_FLAG
	bne.w	false2s			;;; overflow if fpe
	mov.l	%d0, %d1
	swap	%d1
	and.w	&0x7f80, %d1		;;; exponent
	beq.b	Le2			;;; br if 0.0
	and.b	&0xfc, %d0		;;; clear tag bits
	addq.l	&1, %d0			;;; make into pop decimal
	mov.l	%d0, (%a6)		;;; return result
	rts
Le2:	mov.l	&1, (%a6)		;;; return 0.0
	rts


DEF_C_LAB (_pf_cvt_to_ddec)
	mov.l  (%a6)+,%a1		;;; the result ddecimal
	mov.l	(%a6)+,%a0		;;; source double float address
	mov.w	(%a0),%d0
	and.w	&0x7ff0,%d0		;;; exponent
	bne.b	Lb1			;;; leave alone if non-zero
	clr.l	_DD_1(%a1)		;;; make truly 0 if zero exponent
	clr.l	_DD_2(%a1)
	rts
Lb1:	mov.l  (%a0)+,_DD_1(%a1)	;;; move fields to result
	mov.l	(%a0),_DD_2(%a1)
	rts

;;; ---- Routines to extract/update sfloat and dfloat field values

	;;; _pf_extend_s_to_d(_dfaddr) -> _dfaddr or <false>
	;;; extend single at _dfaddr into double (where single could
	;;; be Inf or NaN)
DEF_C_LAB (_pf_extend_s_to_d)
	mov.l	(%a6), %a0		;;; _dfaddr
	mov.w	(%a0), %d0		;;; word containing exponent
	and.w	&0x7f80, %d0		;;; 8 bit exponent
	cmp.w	%d0, &0x7f80		;;; all ones (Inf or NaN)?
	beq.b	false2s			;;; return false if so
	clr.l	-(%sp)
	mov.l	(%a0), -(%sp)		;;; the single
	jsr	_ftod			;;; cvt to double in d0,d1
	addq.l	&8, %sp
	mov.l	(%a6), %a0		;;; source address again
	mov.l	%d0, (%a0)+		;;; move result in
	mov.l	%d1, (%a0)
	rts

	;;; _pf_check_d(_dfaddr) -> _dfaddr or <false>
	;;; check double at _dfaddr (where double could be Inf or NaN)
DEF_C_LAB (_pf_check_d)
	mov.l	(%a6), %a0		;;; _dfaddr
	mov.w	(%a0), %d0		;;; word with exponent
	and.w	&0x7ff0, %d0		;;; mask out 11 bit exponent
	cmp.w	%d0, &0x7ff0		;;; all ones (Inf or NaN)?
	beq.b	false2s			;;; return false if so
	rts				;;; else OK

	;;; _pf_round_d_to_s(_dfaddr) -> _dfaddr or <false>
	;;; round double to single back into _dfaddr
DEF_C_LAB (_pf_round_d_to_s)
	mov.l	(%a6), %a0		;;; source address
	mov.l	4(%a0), -(%sp)		;;; ls part
	mov.l	(%a0), -(%sp)		;;; ms part
	clr.b	FPE_FLAG		;;; gets set if floating-point exception
	jsr	_dtof			;;; cvt to single in d0
	addq.l	&8, %sp
	tst.b	FPE_FLAG
	bne.b	false2s			;;; overflow if fpe
	mov.l	(%a6), %a0		;;; source address now dest addr
	mov.l	%d0, (%a0)		;;; move top longword
	rts				;;; return


	;;; -----------------------------------------------------------------
	;;; _PF_INTOF -- return integer part of double floating number
	;;; gives either an integer and true, or false if too big
	;;; uses:		fix (from C library)
	;;; used by:	intof
	;;; arguments:	on stack
	;;; 		top -> arg address
	;;; results:	on pop stack
	;;; 		top ->  pop integer and true, or false
	;;; registers blown:
	;;; 		D0		mslw of number
	;;; 		D1		lslw
	;;; 		D2		storage for mslw
	;;; 		D3		storage for lslw
	;;; 		D4		exponent of number
	;;; -----------------------------------------------------------------
DEF_C_LAB (_pf_intof)
	mov.l	(%a6),%a0		;;; address of double float arg
	mov.l	4(%a0),-(%sp)		;;; stack double float
	mov.l	(%a0),-(%sp)
	clr.b	FPE_FLAG		;;; gets set if floating-point exception
	jsr	_fix			;;; get truncated int
	addq.l	&8,%sp			;;; clean stack
	tst.b	FPE_FLAG
	bne.b	false2s			;;; overflow if fpe
	mov.l	%d0,(%a6)		;;; stack result
	bra.b	true2			;;; and return true


	;;; -----------------------------------------------------------------
	;;; FALSE2, TRUE2 -- stack a boolean and return
	;;; uses:	    --
	;;; used by:	 ??
	;;; arguments:    none
	;;; results:	 on pop stack
	;;;       top ->  true or false
	;;; registers blown: none
	;;; -----------------------------------------------------------------
false2:
	mov.l	%d4, -(%a6)		;;; stack a false
	rts

false2s:
	mov.l	%d4, (%a6)		;;; replace top with false
	rts

true2:
	mov.l	&C_LAB(true), -(%a6)	;;; stack a true
	rts

true2s:
	mov.l	&C_LAB(true), (%a6)	;;; replace top with true
	rts

	;;; -----------------------------------------------------------------
	;;; _PFMODF -- get frac and int parts of double float
	;;; uses:	 C library - _modf
	;;; arguments:	on stack
	;;; 		top -> address of source
	;;; 			address for frac part
	;;; results:	int part back in arg
	;;; 				frac at given address
	;;; registers blown:
	;;; 		D0		(most significant part of operand)
	;;; 		D1		(least significant part of operand)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_pfmodf)
	mov.l	(%a6)+,%a0		;;; address of source arg
	mov.l	%a0,-(%sp)		;;; also to receive int part
	mov.l	4(%a0),-(%sp)		;;; stack double float arg
	mov.l	(%a0),-(%sp)
	jsr	_modf			;;; get frac part as double float
	lea	12(%sp),%sp		;;; clear stack
	mov.l	(%a6)+,%a0		;;; address for frac
	mov.l	%d0,(%a0)+		;;; high part
	mov.l	%d1,(%a0)		;;; low part
	rts

	;;; -----------------------------------------------------------------
	;;; get and set exponent E of a double float, where E is
	;;; the number of bits needed for the integer part, e.g. 1 for 1.0,
	;;; 0 for 0.5, -1 for 0.05, etc.

DEF_C_LAB (_pf_expof)
	mov.l	(%a6),%a0		;;; address of dfloat
	mov.w	(%a0),%d0		;;; first word of it
	lsr.w	&4,%d0			;;; IEEE exponent at bottom
	and.l	&0x7ff,%d0		;;; mask it out as long
	sub.l	&1022,%d0		;;; get E
	mov.l	%d0,(%a6)		;;; return it
	rts

DEF_C_LAB (-> _pf_expof)
	mov.l	(%a6)+,%a0		;;; address of dfloat
	mov.l	(%a6),%d0		;;; E value
	add.l	&1022,%d0		;;; get IEEE expoenent
	ble.b	false2s			;;; underflow if 0 or neg
	cmp.l	%d0,&0x7ff		;;; overflow (>	equ 2047) ?
	bge.b	false2s			;;; return false if so
	lsl.w	&4,%d0			;;; left 4
	mov.w	(%a0),%d1		;;; first word of dfloat
	and.w	&0x800f,%d1		;;; mask all but exponent
	or.w	%d1,%d0			;;; or to new exponent
	mov.w	%d0,(%a0)		;;; put back
	bra.b	true2s			;;; return true



/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 25 1995
	Removed _m*ath1/2 subroutines (library math functions now called
	via _extern)
--- Robert John Duncan, May 31 1991
	Fixed order of arguments to cmp.w
--- John Gibson, Mar 25 1991
	_pf_extend_s_to_d changed to check for externally-generated Infs/NaNs
	and return boolean result; _pf_check_d added to do same for doubles.
--- John Gibson, Jan  3 1991
	Replaced fpe_flag with FPE_FLAG macro
--- Ian Rogers, Dec 15 1989
	Moved in RogerE's code for _pf_sfloat_dec
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
--- John Gibson, Aug 26 1988
	Made _pf_cvt_to_dec do rounding correctly (i.e. according to IEEE
	standard of rounding the 'tie' case to make the next bit even).
		Rewrote routines to use floating-point exception flag now
	set in asignals.s, so that overflow is handled properly.
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Feb 11 1988
	-Ddec_qrem- now -Sys$-Float_qrem-
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Sep 21 1987
	Added _pf_cvt_to_ddec, which absorbs the function of _pf_normalise
	(also renamed _pf_cvt_to_decimal as _pf_cvt_to_dec for compatibility).
 */
