/* --- Copyright University of Sussex 1989. All rights reserved. ----------
 * File:            S.hpbob/src/alisp.s
 * Purpose:
 * Author:          John Williams (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */

#_<

#_INCLUDE 'declare.ph'

constant	_setstklen_diff
	;

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/


	text

DEF_C_LAB (_setstklen)
	mov.l	(%a6)+,%d1		;;; d1 = nresults
	add.l	(%a6)+,%d1		;;; d1 = saved stklen + nresults + 6
	subq.l	&6,%d1			;;; d1 = desired stacklength (bytes)
	mov.l	I_LAB(_userhi),%d0	;;; d0 = value of _userhi
	sub.l	%d1,%d0			;;; d0 = desired a6 = _userhi - d1
	cmp.l	%d0,%a6			;;; compare d0 - a6
	bne.b	C_LAB(_setstklen_diff)	;;; carry on if different
	rts				;;; otherwise return

DEF_C_LAB (_setstklen_diff)
	bgt.b	L_ERAS			;;; erase if d0 > a6
L_PUSH:
	mov.l	&C_LAB(nil),-(%a6)	;;; push NIL
	cmp.l	%d0,%a6			;;; compare
	bne.b	L_PUSH			;;; loop again unless same
	rts

L_ERAS:
	mov.l	%d0,%a6			;;; set a6 to desired stacklength
	rts


/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
