/* --- Copyright University of Sussex 1997. All rights reserved. ----------
 * File:	    S.hpbob/src/amisc.s
 * Purpose:	    Miscellaneous assembler support routines
 * Author:	    John Gibson & Sak Wathansin (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */


#_<

#_INCLUDE 'declare.ph'

vars
	_call_stack_lim, _plog_trail_sp, _plog_trail_lim
	;

section $-Sys;

constant
	procedure (Call_overflow, User_overflow, Callstack_reset,
	Conspair, Plog$-Area_overflow, Async_raise_signal)
	;

endsection;	/* $-Sys */


lconstant macro (
	_KEY		= @@KEY,
	_K_APPLY	= @@K_APPLY,
	_RF_CONT	= @@RF_CONT,
	_PD_EXECUTE	= @@PD_EXECUTE,
	_PD_EXIT	= @@PD_EXIT,
	_PD_FRAME_LEN	= @@PD_FRAME_LEN,
	_PD_UPDATER	= @@PD_UPDATER,
	_P_BACK		= @@P_BACK,
	_P_FRONT	= @@P_FRONT,
	_SF_OWNER	= @@SF_OWNER,
	_V_BYTES	= @@V_BYTES,
	);

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/


	text

	;;; -----------------------------------------------------------------
	;;; _POPENTER -- call a pop procedure
	;;; normal checking entry
	;;; assumptions:
	;;;	A2 must be zero
	;;; arguments:
	;;;	D0		pop object to apply
	;;; results:
	;;; registers blown:
	;;;	D0		(object)
	;;;	A0		(various addresses)
	;;; -----------------------------------------------------------------

	;;; normal checking entry
DEF_C_LAB (_popenter)
	btst	&0,%d0				;;; isnumber?
	bne.b	appnum				;;; branch if so
	mov.l	%d0,%a0
	cmp.l	_KEY(%a0),&C_LAB(procedure_key)	;;; object has procedure key?
	bne.b	appstruct			;;; nope,so jump
	mov.l	(%a0),%a0			;;; get execute address
	jmp	(%a0)				;;; ... and run it

	;;; applying a number! run key apply proc
appnum:
	mov.l	%d0,-(%a6)			;;; stack num
	mov.l	C_LAB(integer_key)+_K_APPLY,%a0	;;; ref of integer key apply
	btst	&1,%d0				;;; isinteger?
	bne.b	La1				;;; branch if so
	mov.l	C_LAB(weakref decimal_key)+_K_APPLY,%a0 ;;; ref of decimal key apply
La1:	mov.l	_RF_CONT(%a0),%a0		;;; key apply proc
	mov.l	(%a0),%a0			;;; execute address
	jmp	(%a0)				;;; run it

	;;; applying a structure -- run key apply proc
appstruct:
	mov.l	%d0,-(%a6)			;;; stack structure
	mov.l	_KEY(%a0),%a0			;;; get key of structure
	mov.l	_K_APPLY(%a0),%a0		;;; get ref of key_apply proc
	mov.l	_RF_CONT(%a0),%a0		;;; proc
	mov.l	(%a0),%a0			;;; execute address
	jmp	(%a0)				;;; execute it


	;;; -----------------------------------------------------------------
	;;; _CHECKPLOGALL -- check prolog stacks
	;;; _CHECKALL		-- check normal stacks
	;;; _CHECKINTERRUPT -- check for interrupt flag set
	;;; used by:	??
	;;; arguments:	none
	;;; results:	none
	;;; registers blown:
	;;;		A0
	;;; -----------------------------------------------------------------

DEF_C_LAB (_checkplogall)
	lea	C_LAB(_special_var_block), %a0
	mov.l	_SVB_OFFS(_plog_trail_sp)(%a0), %d0
	cmp.l	%d0, _SVB_OFFS(_plog_trail_lim)(%a0)	;;; trail overflow?
	bcs.b	checkall_cmp			;;; nope,its okay
	jmp	XC_LAB(weakref[prologvar_key] Sys$-Plog$-Area_overflow)

DEF_C_LAB (_checkall)
	lea	C_LAB(_special_var_block), %a0
checkall_cmp:
	cmp.l	%sp, _SVB_OFFS(_call_stack_lim)(%a0)	;;; system stack okay?
	bcs.b	Lb3				;;; branch if too long
	cmp.l	%a6, _SVB_OFFS(_userlim)(%a0)	;;; user stack okay?
	bcs.b	Lb4				;;; branch if too long
Lb1:	tst.l	_SVB_OFFS(_trap)(%a0)		;;; signals pending?
	bne.b	Lb5				;;; branch if so
Lb2:	rts					;;; everything okay - return

Lb3:	btst	&1, I_LAB(_disable)+3		;;; stack checks disabled?
	bne.b	Lb1				;;; continue if so
	jmp	XC_LAB(Sys$-Call_overflow)	;;; else fix it up
Lb4:	btst	&1, I_LAB(_disable)+3		;;; stack checks disabled?
	bne.b	Lb1				;;; continue if so
	jmp	XC_LAB(Sys$-User_overflow)	;;; else fix it up
Lb5:	btst	&0, I_LAB(_disable)+3		;;; signals disabled?
	bne.b	Lb2				;;; return if so
	jmp	XC_LAB(Sys$-Async_raise_signal)	;;; chain this to handle signal

DEF_C_LAB (_checkinterrupt)
	tst.l	I_LAB(_trap)			;;; signals pending?
	bne.b	C_LAB(_checkall)		;;; jump if so
	rts					;;; else return



	;;; -----------------------------------------------------------------
	;;; Unwind the current stack frame, by jumping into the procedure's
	;;; exit code. This subroutine is called immediately after executing
	;;; an M_UNWIND operation, so that the (unwanted) return address into
	;;; the procedure being unwound is above this subroutine's return
	;;; address on the call stack.
	;;;	The procedure's exit code finishes with an "rts", and we
	;;; replace the return address into the NEXT caller with the return from
	;;; this subroutine, but saving the former in CHAIN_REG (= %d0) from
	;;; whence it can be restored with an M_CALL_WITH_RETURN operation.
DEF_C_LAB (_unwind_frame)
	mov.l	8(%sp), %a0		;;; caller procedure
	movq	&0, %d0
	mov.b	_PD_FRAME_LEN(%a0), %d0	;;; stack frame length in words
	asl.w	&2, %d0			;;; now in bytes
	lea	4(%sp,%d0.w), %a1	;;; addr of return addr into NEXT caller
	mov.l	(%a1), %d0		;;; save in CHAIN_REG
	mov.l	(%sp), (%a1)		;;; replace with my return
	addq.l	&8, %sp			;;; erase my return and unwanted return
	mov.l	_PD_EXIT(%a0), %a0	;;; PD_EXIT addr of procedure
	jmp	(%a0)			;;; go into procedure exit code

	;;; -------------------------------------------------------------------
	;;; Routines to chain a procedure,either directly or out of the
	;;; current caller. These are executed as a result of displacing a stack
	;;; frame return address with their address and then returning with an
	;;; "rts"; in the case of _syschain,the displaced return is saved in
	;;; CHAIN_REG.
DEF_C_LAB (_syschain_caller)
	subq.l	&4,%sp		;;; need dummy return address for _unwind_frame
	bsr.b	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_syschain)
	mov.l	%d0,-(%sp)	;;; reinstate return address from CHAIN_REG
	mov.l	(%a6)+,%d0	;;; procedure to chain on user stack
	bra.w	C_LAB(_popenter)	;;; run it

	;;; ;;; The same,but with no check for procedure
DEF_C_LAB (_sysncchain_caller)
	subq.l	&4,%sp		;;; need dummy return address for _unwind_frame
	bsr.b	C_LAB(_unwind_frame)	;;; pop frame for caller
DEF_C_LAB (_sysncchain)
	mov.l	%d0,-(%sp)	;;; reinstate return address from CHAIN_REG
	mov.l	(%a6)+,%a0	;;; address of procedure
	mov.l	(%a0),%a0	;;; PD_EXECUTE address
	jmp	(%a0)		;;; do it


	;;; -----------------------------------------------------------------
	;;; _POPUENTER,_POPUNCENTER -- run updater of item
	;;; can be a procedure,or an arbitrary object,which is updated.
	;;; integers and decimals are checked for specially,because they aren't
	;;; pointers.  _popuncenter only checks that the updater exists,
	;;; _popuenter checks for the type of the object.
	;;; assumptions:  %a2 zero
	;;; arguments:
	;;;		D0		pop object to be applied as updater
	;;; results:	none
	;;; registers blown:
	;;;		D0		(unchanged throughout)
	;;;		A0		(various addresses during mass indirection)
	;;; -----------------------------------------------------------------

DEF_C_LAB (_popuenter)
	btst	&0,%d0				;;; isnumber
	bne.b	upnum				;;; yes -- update number
	cmp.l	_KEY(%a2,%d0.l),&C_LAB(procedure_key)	;;; a procedure
	bne.b	upstr				;;; no -- update structure

	;;; fall through if procedure
DEF_C_LAB (_popuncenter)
	mov.l	_PD_UPDATER(%a2,%d0.l),%a0	;;; get updater
	cmp.l	%a0, %d4			;;; is it false?
	beq.b	upexc				;;; yes,complain
	mov.l	(%a0),%a0			;;; fetch the execute address
	jmp	(%a0)				;;; and hope to it

	;;; updater was false
upexc:	mov.l	%d0,-(%a6)			;;; stack object
	jmp	XC_LAB(-> Sys$-Exec_nonpd)	;;; run exception procedure

	;;; applying number as updater
upnum:	mov.l	C_LAB(integer_key)+_K_APPLY,%a0 ;;; integer key apply in ref
	btst	&1,%d0				;;; test for integer/decimal
	bne.b	upkapp				;;; branch if integer
	mov.l	C_LAB(weakref decimal_key)+_K_APPLY,%a0 ;;; decimal key apply in ref
	bra.b	upkapp				;;; do it

	;;; updating a structure
upstr:	mov.l	_KEY(%a2,%d0.l),%a0		;;; key of object -> a0
	mov.l	_K_APPLY(%a0),%a0		;;; app part in ref -> a0

upkapp:
	mov.l	_RF_CONT(%a0),%a0		;;; cont -> a0
	mov.l	_PD_UPDATER(%a0),%a0		;;; fetch the updater
	cmp.l	%a0, %d4			;;; is there one?
	beq.b	upexc				;;; nope -- jump
	mov.l	%d0,-(%a6)			;;; give as arg to key apply proc
	mov.l	(%a0),%a0			;;; get the execute field
	jmp	(%a0)				;;; and hop to it

	;;; erase 1 longword from the call stack and chain Callstack_reset
	;;; (used by Callstack_reset in cleaning up)
DEF_C_LAB (_erase_sp_1)
	mov.l	(%sp)+,(%sp)			;;; push return addr up one
	jmp	XC_LAB(Sys$-Callstack_reset)	;;; try again

	;;; -----------------------------------------------------------------
	;;; _NEXTFRAME -- get next stack frame
	;;; pointer assumed to aim at owner
	;;; uses:		--
	;;; arguments:	on pop stack
	;;;		top ->	frame pointer
	;;; results:	on pop stack
	;;;		top ->	pointer to next frame's owner
	;;; registers blown:
	;;;		D0		(this frame)
	;;;		D1		(frame length -- byte)
	;;;		A0		(address of owner)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_nextframe)
	mov.l	(%a6),%a0		;;; frame pointer
	mov.l	_SF_OWNER(%a0),%a1	;;; owner address
	movq	&0,%d0			;;; clean rest of longword
	mov.b	_PD_FRAME_LEN(%a1),%d0	;;; frame size in longwords
	asl.w	&2,%d0			;;; now bytes
	add.l	%a0,%d0			;;; + pointer = pointer to next
	mov.l	%d0,(%a6)		;;; and put on stack
	rts

	;;; -----------------------------------------------------------------
	;;; _SUBSS -- fast routines for subscripting string
	;;; uses:		--
	;;; used by:	fast_subscrs
	;;; arguments: on pop stack
	;;;		top ->	address of string
	;;;				pop integer subscript
	;;; results: on pop stack
	;;;		top ->	character,as a pop integer
	;;; registers blown:
	;;;		D0		popint subscript/character
	;;;		A0		string
	;;; -----------------------------------------------------------------
DEF_C_LAB (_subss)
	mov.l	(%a6)+,%a0		;;; address of string
	mov.l	(%a6),%d0		;;; pop int subscript
	asr.l	&2,%d0			;;; now a machine integer
	movq	&0,%d1			;;; make the top part zeros
	mov.b	_V_BYTES-1(%a0,%d0.l),%d1	;;; fish out the char
	asl.w	&2,%d1			;;; convert to popint
	addq.w	&3,%d1
	mov.l	%d1,(%a6)		;;; on the stack
	rts

	;;; -----------------------------------------------------------------
	;;; _U_SUBSS -- fast update for subscrs
	;;; uses:		---
	;;; used by:	fast_subscrs updater
	;;; arguments:	on pop stack
	;;;		top ->	address of string
	;;;				subscript as pop integer
	;;;				character as pop integer
	;;; results:	none
	;;; registers blown:
	;;;		D0		(pop integer subscript)
	;;;		D1		(character)
	;;;		A0		(string address)
	;;; -----------------------------------------------------------------
DEF_C_LAB (-> _subss)
DEF_C_LAB (_u_subss)
	mov.l	(%a6)+,%a0		;;; address of string
	mov.l	(%a6)+,%d0		;;; pop integer subscript
	asr.l	&2,%d0			;;; now a machine integer
	mov.l	(%a6)+,%d1		;;; the character
	asr.l	&2,%d1			;;; now a machine integer
	mov.b	%d1,_V_BYTES-1(%a0,%d0.l)	;;; whack it in there
	rts

	;;; =================================================================
	;;;		P R E D I C A T E S
	;;; each performs given function,returns true or false.	 one argument
	;;; is left on the pop stack afterwards.
	;;;
	;;; _ISPOINTER	item is a pop pointer
	;;; _ISNONPOINTER item isn't a pop pointer
	;;; _ISPINT		item is a pop integer
	;;; _HASKEY		given key is key of given object
	;;; _BITST		mask bits of two items with AND
	;;; _GR			unsigned integer >
	;;; _GREQ			unsigned integer >=
	;;; _LT			unsigned integer <
	;;; _LTEQ			unsigned integer <=
	;;; _SGR			signed integer >
	;;; _SGREQ		signed integer >=
	;;; _SLT			signed integer <
	;;; _SLTEQ		signed integer <=
	;;; _NT			item is false
	;;; _NEQ			two items are equal
	;;; _EQ			two items aren't equal
	;;; _ZERO			item is zero
	;;; _NEG			integer is negative
	;;;
	;;; assumptions:
	;;;		%a2 is zero
	;;; arguments: on pop stack
	;;;		top ->	one item
	;;;				another item	(possibly missing)
	;;; results: on pop stack
	;;;		top ->	<boolean>
	;;;				one argument
	;;; registers blown:
	;;;		D0
	;;;		D1
	;;; -----------------------------------------------------------------

DEF_C_LAB (_iscompound)
	btst	&0,3(%a6)	;;; bottom bit clear means pointer
	beq.b	true1
	bra.b	false1

DEF_C_LAB (_issimple)
	btst	&0,3(%a6)	;;; bottom bit set means nonpointer
	bne.b	true1
	bra.b	false1

DEF_C_LAB (_isinteger)
	btst	&1,3(%a6)	;;; bit1 set means pop integer
	bne.b	true1
	bra.b	false1

	;;; item has given key ----------------------------------------------
	;;; top item on stack is the key of second item?
DEF_C_LAB (_haskey)
	mov.l	(%a6)+,%d0		;;; the key
	mov.l	(%a6),%d1		;;; the object
	btst	&0,%d1			;;; branch if popnum
	bne.b	false1
	cmp.l	%d0,_KEY(%a2,%d1.l)	;;; key = keyof(object)?
	beq.b	true1
	bra.b	false1

	;;; bitwise AND two items -------------------------------------------
DEF_C_LAB 4 (_bitst)
	mov.l	(%a6)+,%d0		;;; get first object
	and.l	(%a6),%d0		;;; AND them
	bne.b	true1			;;; true if any bits set in both
	bra.b	false1

	;;; stops the last bra.b having a 0 displacement!
	nop

	;;; -----------------------------------------------------------------
	;;; TRUE1,FALSE1 -- replace top of stack with a boolean; return
	;;; uses:		--
	;;; used by:	booleans
	;;; arguments:	none
	;;; results:	on pop stack
	;;;		top ->	<true> or <false>
	;;; registers blown:	none
	;;; -----------------------------------------------------------------

	;;; return false ----------------------------------------------------
false1:
	mov.l	%d4, (%a6)
	rts
false1s:
	mov.l	%d4, -(%a6)		;;; stack it
	rts

	;;; return true -----------------------------------------------------
true1:
	mov.l	&C_LAB(true), (%a6)
	rts
true1s:
	mov.l	&C_LAB(true), -(%a6)		;;; stack it
	rts

	;;; unsigned greater than -------------------------------------------
DEF_C_LAB 6 (_gr)
	cmpm.l	(%a6)+,(%a6)+
	bhi.b	true1s
	bra.b	false1s

	;;; unsigned greater than or equal ----------------------------------
DEF_C_LAB 6 (_greq)
	cmpm.l	(%a6)+,(%a6)+
	bcc.b	true1s
	bra.b	false1s

	;;; unsigned less than ----------------------------------------------
DEF_C_LAB 6 (_lt)
	cmpm.l	(%a6)+,(%a6)+
	bcs.b	true1s
	bra.b	false1s

	;;; unsigned less than or equal -------------------------------------
DEF_C_LAB 6 (_lteq)
	cmpm.l	(%a6)+,(%a6)+
	bls.b	true1s
	bra.b	false1s

	;;; signed greater than ---------------------------------------------
DEF_C_LAB 6 (_sgr)
	cmpm.l	(%a6)+,(%a6)+
	bgt.b	true1s
	bra.b	false1s

	;;; signed greater than or equal ------------------------------------
DEF_C_LAB 6 (_sgreq)
	cmpm.l	(%a6)+,(%a6)+
	bge.b	true1s
	bra.b	false1s

	;;; signed less than ------------------------------------------------
DEF_C_LAB 6 (_slt)
	cmpm.l	(%a6)+,(%a6)+
	blt.b	true1s
	bra.b	false1s

	;;; signed less than or equal ---------------------------------------
DEF_C_LAB 6 (_slteq)
	cmpm.l	(%a6)+,(%a6)+
	ble.b	true1s
	bra.b	false1s

	;;; boolean NOT -----------------------------------------------------
DEF_C_LAB (_not)
	cmp.l	%d4, (%a6)
	beq.b	true1
	bra.b	false1

	;;; not equal (pop identity) ----------------------------------------
DEF_C_LAB 7 (_neq)
	cmpm.l	(%a6)+,(%a6)+
	bne.b	true1s
	bra.b	false1s

	;;; equal (pop identity) --------------------------------------------
DEF_C_LAB 7 (_eq)
	cmpm.l	(%a6)+,(%a6)+
	beq.b	true1s
	bra.b	false1s

	;;; machine zero ----------------------------------------------------
DEF_C_LAB (_zero)
	tst.l	(%a6)
	beq.b	true1
	bra.b	false1

	;;; negative --------------------------------------------------------
DEF_C_LAB (_neg)
	tst.l	(%a6)
	bmi.b	true1
	bra.b	false1

	;;; -----------------------------------------------------------------
	;;; _DATAKEY -- get key of any pop object
	;;; bottom bits of pop objects: pointer 00,integer 11,decimal 01
	;;; uses:		--
	;;; used by:	??
	;;; arguments: on pop stack
	;;;		top ->	pop object
	;;; results: on pop stack
	;;;		top ->	the key
	;;; registers blown:
	;;;		A0
	;;; -----------------------------------------------------------------
DEF_C_LAB (_datakey)
	mov.l	(%a6),%d0		;;; the object from the stack
	btst	&0,%d0			;;; bottom bit
	bne.b	Lc1			;;; branch if it isn't pointer
	;;; bottom bit is zero
	mov.l	_KEY(%a2,%d0.l),(%a6)	;;; stack its key
	rts
	;;; bottom bit is 1
Lc1:	btst	&1,%d0
	beq.b	Lc2			;;; branch if decimal
	;;; bit 1 is 1
	mov.l	&C_LAB(integer_key),(%a6)	;;; put integer key
	rts
	;;; bit 1 is zero
Lc2:	mov.l	&C_LAB(weakref decimal_key),(%a6) ;;; decimal key
	rts



	;;; ----------------------------------------------------------------
	;;; optimise subroutine for "conspair"
DEF_C_LAB (_conspair)
	lea	I_LAB(Sys$- _free_pairs),%a1
	mov.l	(%a1),%d0		;;; get free pair list
	btst	&0,%d0			;;; if simple,then none left
	bne.b	Ld1
	mov.l	%d0,%a0
	mov.l	_P_BACK(%a0),(%a1)	;;; move the next back to _free_pairs
	mov.l	(%a6)+,_P_BACK(%a0)	;;; init back
	mov.l	(%a6),_P_FRONT(%a0)	;;; init front
	mov.l	%a0,(%a6)		;;; return the pair
	rts
Ld1:	jmp	XC_LAB(Sys$-Conspair)	;;; none left,chain to Conspair


	;;; -----------------------------------------------------------------
	;;; _LOCC -- search string for character
	;;; uses:		--
	;;; used by:	(possibly will be used where VAX locc is used)
	;;; arguments:	on pop stack
	;;;		top ->	character
	;;;				length of string
	;;;				address of string
	;;; results: on pop stack
	;;;		top ->	offset to character in string,or -1
	;;; registers blown:
	;;;		D0
	;;;		D1
	;;;		D2
	;;;		A0
	;;; -----------------------------------------------------------------
DEF_C_LAB (_locc)
	mov.l	(%a6)+,%d0		;;; character
	mov.l	(%a6)+,%d1		;;; length of string
	mov.l	(%a6),%a0		;;; address of string
	mov.l	%a0,%d2			;;; copy of address
Lf1:	subq.l	&1,%d1			;;; one less to look at
	blt.b	Lf3			;;; found end of string?
	cmp.b	%d0,(%a0)+		;;; look for character
	bne.b	Lf1			;;; loop if not found
Lf2:
	;;; found it
	;;; %a0 -> matched char + 1
	;;; %d2 is original address
	subq.l	&1,%a0			;;; address of char
	sub.l	%d2,%a0			;;; offset to char
	mov.l	%a0,(%a6)
	rts
Lf3:
	;;; didn't find it
	mov.l	&-1,(%a6)		;;; minus 1 overwrites start address
	rts

	;;; -----------------------------------------------------------------
	;;; _SKPC -- skip string for character
	;;; uses:		--
	;;; used by:	(possibly will be used where VAX skpc is used)
	;;; arguments:	on pop stack
	;;;		top ->	character
	;;;				length of string
	;;;				address of string
	;;; results: on pop stack
	;;;		top ->	offset to different character in string,or -1
	;;; registers blown:
	;;;		D0
	;;;		D1
	;;;		D2
	;;;		A0
	;;; -----------------------------------------------------------------
DEF_C_LAB (_skpc)
	mov.l	(%a6)+,%d0		;;; character
	mov.l	(%a6)+,%d1		;;; length of string
	mov.l	(%a6),%a0		;;; address of string
	mov.l	%a0,%d2			;;; copy of address
Lg1:	subq.l	&1,%d1			;;; one less to look at
	blt.b	Lg3			;;; found end of string?
	cmp.b	%d0,(%a0)+		;;; look for character
	beq.b	Lg1			;;; loop if found
Lg2:
	;;; found something else
	;;; %a0 -> matched char + 1
	;;; %d2 is original address
	subq.l	&1,%a0			;;; address of char
	sub.l	%d2,%a0			;;; offset to char
	mov.l	%a0,(%a6)
	rts
Lg3:
	;;; didn't find anything else
	mov.l	&-1,(%a6)		;;; minus 1 overwrites start address
	rts


	;;; ------------------------------------------------------------------
	;;; move the user stack up or down
DEF_C_LAB (_move_userstack)
	mov.l	(%a6)+,%d2		;;; amount to shift in bytes
	mov.l	I_LAB(_userhi),%d0	;;; old userhi
	sub.l	%a6,%d0			;;; length of userstack to move in %d0
	mov.l	%a6,%a0			;;; u/s top in a0 - moving from here
	add.l	%d2,I_LAB(_userhi)	;;; new userhi
	mov.l	%a6,%a1
	add.l	%d2,%a1			;;; where moving to in %a1
	mov.l	%a1,%a6			;;; is new userstack pointer
	jmp	movchars_la		;;; move the user stack and return


	;;; Set registers for pop environment
global reset_pop_reg_environ
reset_pop_reg_environ:
	;;; set constant registers
	mov.l	&0, %a2			;;; a2 must always be zero
	mov.l	&C_LAB(false), %d4	;;; d4 must always be false
	;;; set pop lvar registers to sensible values (false)
	mov.l	%d4, %d5		;;; pop lvar
	mov.l	%d4, %d6		;;; and the other one
	rts


/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Feb 10 1997
	Removed _mt*chc subroutine
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Nov 10 1993
	Renamed amisc.s and moved the main routine to amain.s
--- John Gibson, Oct  2 1992
	Got rid of _c*mpc_order
--- John Gibson, Sep 25 1990
	Fixed bug in _unwind_frame where sp was being incremented over 2
	words on the stack and then relying on accessing the first of those
	at -ve offset. This failed if a signal interrupted, since signal
	handler stack frame overwrote anything below sp.
--- John Gibson, May 15 1990
	Changed _checkall so that -Async_raise_signal- not called
	when _disable interrupt bit set (also now doesn't clear _trap
	if it is called).
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit offsets for RF_CONT,P_FRONT)
--- John Gibson, Nov 29 1989
	Added reset_pop_reg_environ
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Jan 15 1989
	Replaced use of UC_LAB etc for updater with -> before pathname
--- John Gibson, Sep  4 1988
	Replaced _SVB macros with _SVB_OFFS(identifier name)
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jun  3 1988
	Added name Sys$-_entry_point to _main (used by poplink to force
	inclusion of this routine).
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Feb 11 1988
	integer_key and decimal_key now in section Sys.
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Oct 31 1987
	Made _main initialise _system_stack_base rather than _call_stack_hi,
	and removed pushing of <false> owner address to start (no longer
	needed).
--- John Gibson, Aug 17 1987
	For segmented system, changed _main to set up initial userstack
	in a temporary area.
 */
