/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:	    S.hpbob/src/amove.s
 * Purpose:	    Move subroutines
 * Author:	    Sak Wathanasin, John Gibson (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */

#_<

#_INCLUDE 'declare.ph'

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/


	text

	;;; -----------------------------------------------------------------
	;;; compare two byte regions of the same length
DEF_C_LAB (_bcmp)
	mov.l	(%a6)+,%a1		;;; region2 address
	mov.l	(%a6)+,%a0		;;; region1 address
	mov.l	(%a6),%d0		;;; length in bytes
La1:	subq.l	&1,%d0			;;; one less to do
	blt.b	La2			;;; true if done
	cmpm.b	(%a1)+,(%a0)+		;;; compare a byte
	beq.b	La1			;;; loop if same
	mov.l	&C_LAB(false),(%a6)	;;; false for different
	rts
La2:	mov.l	&C_LAB(true),(%a6)	;;; true for same
	rts

	;;; -----------------------------------------------------------------
	;;; compare two word regions of the same length
DEF_C_LAB (_scmp)
	mov.l	(%a6)+,%a1		;;; region2 address
	mov.l	(%a6)+,%a0		;;; region1 address
	mov.l	(%a6),%d0		;;; length in bytes
Lb1:	subq.l	&2,%d0			;;; one less to do
	blt.b	Lb2			;;; true if done
	cmpm.w	(%a1)+,(%a0)+		;;; compare a word
	beq.b	Lb1			;;; loop if same
	mov.l	&C_LAB(false),(%a6)	;;; false for different
	rts
Lb2:	mov.l	&C_LAB(true),(%a6)	;;; true for same
	rts

	;;; -----------------------------------------------------------------
	;;; compare two longword regions of the same length
DEF_C_LAB (_icmp)
DEF_C_LAB (_cmp)
	mov.l	(%a6)+,%a1		;;; region2 address
	mov.l	(%a6)+,%a0		;;; region1 address
	mov.l	(%a6),%d0		;;; length in bytes
Lc1:	subq.l	&4,%d0			;;; one less to do
	blt.b	Lc2			;;; true if done
	cmpm.l	(%a1)+,(%a0)+		;;; compare a longword
	beq.b	Lc1			;;; loop if same
	mov.l	&C_LAB(false),(%a6)	;;; false for different
	rts
Lc2:	mov.l	&C_LAB(true),(%a6)	;;; true for same
	rts


	;;; -----------------------------------------------------------------
	;;; move longwords, quick version
	;;; if source and destination blocks overlap, this routine only works
	;;; when moving downwards.  only copies whole longwords, and can
	;;; assume that they are word aligned.
DEF_C_LAB (_moveq)
	mov.l	(%a6)+,%a1		;;; there
	mov.l	(%a6)+,%a0		;;; here
	mov.l	(%a6),%d0		;;; byte count
	beq.b	Ld999			;;; done if zero count
	add.l	%a1,%d0			;;; d0 is one longword past last dest
	cmp.l	%a1,%a0			;;; no offset?
	bne.b	Ld1			;;; beam up if so
	mov.l	%d0,(%a6)		;;; stack next dest
	rts				;;; byee

Ld1:	mov.l	(%a0)+,(%a1)+		;;; move one longword
	cmp.l	%d0,%a1			;;; done?
	bne.b	Ld1			;;; loop onwards
Ld999:	mov.l	%a1,(%a6)		;;; new 'there'
	rts

	;;; -----------------------------------------------------------------
	;;; _BMOVE -- general copy memory
	;;; this is just movchars, but with the arguments on the stack:
	;;; uses:	  movchars
	;;; used by:
	;;; arguments:	  on pop stack
	;;;	  top ->  destination address
	;;;		  source address
	;;;		  length in bytes
	;;; results:	  on pop stack
	;;;	  top ->  next destination address
	;;; registers blown: (all by movchars)
	;;;	  D0
	;;;	  D1
	;;;	  D2
	;;;	  A0
	;;;	  A1
	;;; -----------------------------------------------------------------
DEF_C_LAB (_bmove)
DEF_C_LAB (_smove)
	mov.l	(%a6)+,%a1		;;; there
	mov.l	(%a6)+,%a0		;;; here
	mov.l	(%a6),%d0		;;; length
	mov.l	%d0,%d1			;;; calculate next destination
	add.l	%a1,%d1
	mov.l	%d1,(%a6)		;;; leave on pop stack
	bra.w	movchars		;;; do the move

	;;; -----------------------------------------------------------------
	;;; longword version
DEF_C_LAB (_imove)
DEF_C_LAB (_dmove)
DEF_C_LAB (_move)
	mov.l	(%a6)+,%a1		;;; there
	mov.l	(%a6)+,%a0		;;; here
	mov.l	(%a6),%d0		;;; length in bytes
	mov.l	%d0,%d1			;;; calculate next destination
	add.l	%a1,%d1
	mov.l	%d1,(%a6)		;;; leave on pop stack
	bra.b	movchars_la		;;; do the move

	;;; -----------------------------------------------------------------
	;;; MOVCHARS -- general purpose memory move
	;;; handles any size of move in any direction.
	;;; used by: _moveanyblock, other friends
	;;; arguments:
	;;;	  D0	  length in bytes
	;;;	  A0	  source address
	;;;	  A1	  destination address
	;;; results: none
	;;; registers blown:
	;;;	  D0	  (length, in longwords)
	;;;	  D1	  (extra length, 0, 1, 2, or 3 bytes)
	;;;	  D2	  (bottom byte of source, for alignment check)
	;;;	  D3	  (bottom byte of dest, for bit tests)
	;;;	  A0	  (source)
	;;;	  A1	  (dest address)
	;;; -----------------------------------------------------------------
global movchars
movchars:
	mov.w	%a0,%d2			;;; source pointer
	mov.w	%a1,%d3			;;; dest pointer
	or.b	%d3,%d2			;;; or together all bits 0,1
	or.b	%d0,%d2
	and.b	&3,%d2			;;; any non longword aligned?
	bne.b	movbbb			;;; misaligned -> byte by byte
	;;; longword aligned
global movchars_la
movchars_la:
	tst.l	%d0			;;; zero chars to move?
	beq.b	Le999			;;; beam up if none
	cmp.l	%a1,%a0			;;; going up or down?
	beq.b	Le999			;;; home now if no offset
	bhi.b	Le10			;;; branch if a1 > a0
	;;; going down
Le1:	mov.l	(%a0)+,(%a1)+		;;; move one lw
	subq.l	&4,%d0			;;; 4 bytes less to go
	bne.b	Le1			;;; and again
	rts				;;; back to vienna
	;;; going up
Le10:	lea	0(%a0,%d0.l),%a0	;;; point to one past last source char
	lea	0(%a1,%d0.l),%a1	;;; point to one past last dest char
Le20:	mov.l	-(%a0),-(%a1)		;;; move one lw
	subq.l	&4,%d0			;;; 4 bytes less
	bne.b	Le20			;;; around we go
Le999:	rts				;;; back to vienna

	;;; -----------------------------------------------------------------
	;;; MOVBBB -- move memory byte by byte
	;;; this is for when a block move has source and destination pointers
	;;; do not have the same word alignment, that is, one is word aligned
	;;; and one isn't.
	;;; uses:
	;;; used by:	  movchars
	;;; arguments:
	;;;	  D0	  length
	;;;	  A0	  source
	;;;	  A1	  dest
	;;; results:	  none
	;;; registers blown:
	;;;	  D0	  (length, zero on exit)
	;;;	  A0	  (source)
	;;;	  A1	  (dest)
	;;; -----------------------------------------------------------------
movbbb:
	tst.l	%d0			;;; no characters?
	beq.b	Lf999			;;; home now if none
	cmp.l	%a1,%a0			;;; going up or down?
	beq.b	Lf999			;;; home now if no offset
	bhi.b	Lf10			;;; branch if a1 > a0
	;;; going down
Lf1:	mov.b	(%a0)+,(%a1)+		;;; move one sob
	subq.l	&1,%d0			;;; one less to go
	bne.b	Lf1			;;; and again
	rts				;;; back to vienna
	;;; going up
Lf10:	lea	0(%a0,%d0.l),%a0	;;; point to one past last source char
	lea	0(%a1,%d0.l),%a1	;;; point to one past last dest char
Lf20:	mov.b	-(%a0),-(%a1)		;;; move one of the sobs
	subq.l	&1,%d0			;;; one less
	bne.b	Lf20			;;; around we go
Lf999:	rts				;;; back to vienna


	;;; -----------------------------------------------------------------
	;;; fill a region of bytes with a given byte
DEF_C_LAB (_bfill)
	mov.l	(%a6)+,%a0		;;; there
	mov.l	(%a6)+,%d0		;;; length in bytes
	mov.l	(%a6)+,%d1		;;; the byte
	bra.b	Lg2
Lg1:	mov.b	%d1,(%a0)+		;;; move one sob
Lg2:	subq.l	&1,%d0			;;; one less to go
	bge.b	Lg1			;;; and again
	rts

	;;; -----------------------------------------------------------------
	;;; fill a region of longwords with a given longword
DEF_C_LAB (_ifill)
DEF_C_LAB (_fill)
	mov.l	(%a6)+,%a0		;;; there
	mov.l	(%a6)+,%d0		;;; length in bytes
	mov.l	(%a6)+,%d1		;;; the longword
	bra.b	Lh2
Lh1:	mov.l	%d1,(%a0)+		;;; move one sob
Lh2:	subq.l	&4,%d0			;;; one less to go
	bge.b	Lh1			;;; and again
	rts


;;; -----------------------------------------------------------------------

	;;; _move_callstack(_woffs, _limaddr)
DEF_C_LAB(_move_callstack)
	mov.l	(%a6)+,%d0	;;; limit address for part to move
	sub.l	%sp,%d0		;;; number of bytes to move in d0
	mov.l	(%a6)+,%d1	;;; number of bytes to shift UP by
	lea	0(%sp,%d1.l),%a1 ;;; + sp = destination address in a1
	mov.l	%sp,%a0		;;; source address in a0
	mov.l	%a1,%sp		;;; new sp after move
#_IF DEF STACK_PROBES
	tst.b	-64(%sp)
#_ENDIF
	bra.w	movchars_la	;;; sp points to return address after


	;;; -----------------------------------------------------------------
	;;; _SHIFT -- shift a register left by signed number
	;;; uses:	  --
	;;; used by:	  ??
	;;; arguments:	  on pop stack
	;;;	  top ->  number
	;;;		  item
	;;; results:	  on pop stack
	;;;	  top ->  result
	;;; registers blown:
	;;;	  D0	  (amount to shift)
	;;;	  D1	  (item being shifted)
	;;; -----------------------------------------------------------------
DEF_C_LAB (_shift)
	mov.l	(%a6)+,%d0		;;; amount to shift by
	mov.l	(%a6),%d1		;;; item to shift
	tst.l	%d0
	bpl.b	Lj1			;;; shifting left
	neg.l	%d0			;;; absolute value
	asr.l	%d0,%d1			;;; shift it right
	mov.l	%d1,(%a6)		;;; put it back
	rts
Lj1:	asl.l	%d0,%d1			;;; shift it left,zeroes in
	mov.l	%d1,(%a6)		;;; put it back
	rts

	;;; access an unsigned bit field
DEF_C_LAB (_bfield)
	movq	&32, %d2
	sub.b	%d1, %d2		;;; 32-W = field shift down in %d2
	movq	&31, %d1
	and.b	%d0, %d1		;;; get bitoffs within start word
	asr.l	&5, %d0			;;; get offset
	lsl.l	&2, %d0			;;; to start word
	add.l	%d0, %a0		;;; add to struct addr in a0
	mov.l	(%a0), %d0		;;; first word into %d0
	lsl.l	%d1, %d0		;;; shift 1st word bits to top
	cmp.b	%d2, %d1		;;; bits below field >= 0?
	bge.b	Lm1			;;; br if so
	movq	&32, %d3
	sub.b	%d1, %d3		;;; 32-bitoffs (no of bits in 1st word)
	mov.l	4(%a0), %d1		;;; get 2nd longword
	lsr.l	%d3, %d1		;;; 2nd word down by that
	or.l	%d1, %d0		;;; or in rest of field
Lm1:	lsr.l	%d2, %d0		;;; bring down to bottom (32-W)
	rts

	;;; access a signed bit field (same except for last shift down)
DEF_C_LAB (_sbfield)
	movq	&32, %d2
	sub.b	%d1, %d2		;;; 32-W = field shift down in %d2
	movq	&31, %d1
	and.b	%d0, %d1		;;; get bitoffs within start word
	asr.l	&5, %d0			;;; get offset
	lsl.l	&2, %d0			;;; to start word
	add.l	%d0, %a0		;;; add to struct addr in a0
	mov.l	(%a0), %d0		;;; first word into %d0
	lsl.l	%d1, %d0		;;; shift 1st word bits to top
	cmp.b	%d2, %d1		;;; bits below field >= 0?
	bge.b	Ln1			;;; br if so
	movq	&32, %d3
	sub.b	%d1, %d3		;;; 32-bitoffs (no of bits in 1st word)
	mov.l	4(%a0), %d1		;;; get 2nd longword
	lsr.l	%d3, %d1		;;; 2nd word down by that
	or.l	%d1, %d0		;;; or in rest of field
Ln1:	asr.l	%d2, %d0		;;; sign extend to bottom (32-W)
	rts

	;;; update a bit field
DEF_C_LAB (_ubfield)
	movq	&32, %d2
	sub.b	%d1, %d2		;;; 32-W = field shift down in %d2
	movq	&31, %d1
	and.b	%d0, %d1		;;; get bitoffs within start word
	asr.l	&5, %d0			;;; get offset
	lsl.l	&2, %d0			;;; to start word
	add.l	%d0, %a0		;;; add to struct addr in a0
	movq	&-1, %d4
	lsl.l	%d2, %d4		;;; left by 32-W = W bits at top
	lsr.l	%d1, %d4		;;; right by bitoffs = field mask
	mov.l	(%a6)+, %d3		;;; new value for field
	sub.b	%d1, %d2		;;; 32-W-bitoffs (bits below field)
	bmi.b	Lp1			;;; br if not all in 1st word
	lsl.l	%d2, %d3		;;; if so, shift up new value
	bra.b	Lp2

	;;; field occupies second longword
Lp1:	movq	&32, %d0
	add.b	%d2, %d0		;;; 32 - num of overshoot bits
	mov.l	%d3, %d1
	lsl.l	%d0, %d1		;;; get new value bits at top
	mov.l	4(%a0), %d0		;;; get 2nd word
	neg.b	%d2			;;; number of overshoot bits
	lsl.l	%d2, %d0		;;; clear those
	lsr.l	%d2, %d0		;;; at top of old value
	or.l	%d1, %d0		;;; or in new top bits
	mov.l	%d0, 4(%a0)		;;; update in 2nd word
	lsr.l	%d2, %d3		;;; remove overshoot from new value

Lp2:	mov.l	(%a0), %d0		;;; first word into %d0
	and.l	%d4, %d3		;;; mask new field
	not.l	%d4			;;; complement mask
	and.l	%d4, %d0		;;; remove old field
	or.l	%d3, %d0		;;; insert new field
	mov.l	%d0, (%a0)		;;; store it
	mov.l	&C_LAB(false), %d4
	rts

	;;; multiply vector subscript by element size to get offset
	;;; popint subscript in d0, fieldsize in d1
	;;; result in d0
DEF_C_LAB (_vecsub_mult)
	lsr.l	&2,%d0			;;; convert subscript to m/c int
	subq.l	&1,%d0			;;; correct base
	cmp.b	%d1,&1			;;; fieldsize is 1?
	beq.b	Lq1			;;; done if so
	mov.l	%d0,%d2
	mulu	%d1,%d0			;;; ls of subscript times size in d0
	swap	%d2			;;; ms part in bottom
	tst.w	%d2			;;; zero?
	beq.b	Lq1			;;; finished if so
	mulu	%d1,%d2
	swap	%d2			;;; assume ms part of this is zero
	add.l	%d2,%d0
Lq1:	rts


/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Apr  6 1995
	Added _icmp, _imove, _dmove, _ifill as equivalent to word versions
--- John Gibson, Dec 12 1989
	_vecsub_mult no longer adds vector base offset
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Aug  2 1988
	_movebits removed (replaced by Sys$-Move_bits in movebits.p)
--- John Gibson, Aug  2 1988
	Rewrote _bfield, _sbfield and _ubfield so that they only
	need the field size as argument (instead of the field shift
	and mask).
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Feb 14 1988
	Subroutines _movetabtrans_in/out no longer needed (replaced with
	sysPOP procedures in vdfileio.p).
--- Aled Morris, Feb  4 1988
	Added missing underscores to a couple of variables
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
--- John Gibson, Jul 26 1987
	Removed _vedscanline (-vedrefreshtail- rewritten to do without it).
 */
