/* --- Copyright University of Sussex 1991. All rights reserved. ----------
 * File:            S.hpbob/src/aprocess.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */

;;; --- ROUTINES TO HANDLE PROCESS CALL STACK SWAPPING --------------------

#_<

#_INCLUDE 'declare.ph'
#_INCLUDE 'process.ph'

lconstant macro (
	_ID_VALOF		= @@ID_VALOF,
	_PD_EXIT		= @@PD_EXIT,
	_PD_FLAGS		= @@PD_FLAGS,
	_PD_NLOCALS		= @@PD_NLOCALS,
	_PD_NUM_STK_VARS	= @@PD_NUM_STK_VARS,
	_PD_FRAME_LEN		= @@PD_FRAME_LEN,
	_PD_REGMASK		= @@PD_REGMASK,
	_PD_TABLE		= @@PD_TABLE,
	_PS_CALLSTACK_LIM	= @@PS_CALLSTACK_LIM,
	_PS_CALLSTACK_PARTIAL	= @@PS_CALLSTACK_PARTIAL,
	_PS_FLAGS		= @@PS_FLAGS,
	_PS_PARTIAL_RETURN	= @@PS_PARTIAL_RETURN,
	_PS_STATE		= @@PS_STATE,
	);

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/

	/***************************************************
	*  N.B. Because signals can interrupt on any       *
	*  instruction, -sp- must never be `out of phase', *
	*  i.e. pointing above data that's still wanted.   *
	****************************************************/


	text

	;;; size of an I_BRANCH_std instruction,i.e. a "bra"
set BRANCH_std, 4

	;;; swap out the callstack for a process
DEF_C_LAB (_swap_out_callstack)
	mov.l	(%a6)+, %a0		;;; the process
	mov.l	%a0, process		;;; save it here
	mov.l	_PS_CALLSTACK_LIM(%a0), %a2  ;;; limit of saved callstack
	mov.l	_PS_STATE(%a0), %d3	;;; start of saved callstack
	mov.l	%a6, sav_a6		;;; save a6
	bra.w	sotest

soloop: mov.l	(%sp)+, %d2		;;; return address
	mov.l	(%sp)+, %a1		;;; owner procedure address
	sub.l	%a1, %d2		;;; make return address relative

	;;; test if has dlocal expression code to run
	movq	&_:M_PD_PROC_DLEXPR_CODE, %d0
	and.b	_PD_FLAGS(%a1), %d0
	bne.w	sobrk			;;; yes -- break out to run code

	;;; (continue here after break)
socont:
	movq	&0, %d0
	mov.b	_PD_FRAME_LEN(%a1), %d0	;;; length of stack frame in words
	subq.b	&2, %d0			;;; -2 for owner and return addr
	asl.w	&2, %d0			;;; offset in bytes
	mov.l	%a2, %a0		;;; save end for saving registers
	sub.l	%d0, %a2		;;; a2 = start of saved values

	;;; save registers
	mov.w	_PD_REGMASK(%a1), %d1	;;; 6-byte code section offset
	jmp	2(%pc, %d1.w)		;;; jump to it
					;;;  pop	nonpop
	bra.b	La1			;;; -- --	-- -- -- --
	nop
	nop
	mov.l	%d5, -(%a0)		;;; d5 --	-- -- -- --
	bra.b	La1
	nop
	movm.l  &0x0600,-(%a0)		;;; d5 d6	-- -- -- --
	bra.b	La1
	mov.l	%a3, -(%a0)		;;; -- --	a3 -- -- --
	bra.b	La1
	nop
	movm.l  &0x0410,-(%a0)		;;; d5 --	a3 -- -- --
	bra.b	La1
	movm.l  &0x0610,-(%a0)		;;; d5 d6	a3 -- -- --
	bra.b	La1
	movm.l  &0x0018,-(%a0)		;;; -- --	a3 a4 -- --
	bra.b	La1
	movm.l  &0x0418,-(%a0)		;;; d5 --	a3 a4 -- --
	bra.b	La1
	movm.l  &0x0618,-(%a0)		;;; d5 d6	a3 a4 -- --
	bra.b	La1
	movm.l  &0x001c,-(%a0)		;;; -- --	a3 a4 a5 --
	bra.b	La1
	movm.l  &0x041c,-(%a0)		;;; d5 --	a3 a4 a5 --
	bra.b	La1
	movm.l  &0x061c,-(%a0)		;;; d5 d6	a3 a4 a5 --
	bra.b	La1
	movm.l  &0x011c,-(%a0)		;;; -- --	a3 a4 a5 d7
	bra.b	La1
	movm.l  &0x051c,-(%a0)		;;; d5		a3 a4 a5 d7
	bra.b	La1
	movm.l  &0x071c,-(%a0)		;;; d5 d6	a3 a4 a5 d7

La1:	mov.l	%a0, %d0		;;; limit for stack vars/dlocals
	mov.l	%a2, %a0		;;; where those start into a0
	mov.l	%a1, -(%a2)		;;; stack owner in process
	mov.l	%d2, -(%a2)		;;; and relative return address

	mov.b	_PD_NUM_STK_VARS(%a1), %d2 ;;; number of on_stack vars
	beq.b	La3
La2:	mov.l	(%sp)+, (%a0)+		;;; copy stack var values
	subq.b	&1, %d2
	bne.b	La2			;;; br if more stack vars

La3:	sub.l	%a0, %d0		;;; diff between a0 and limit
	beq.b	La5			;;; no dlocals if zero
	lea	_PD_TABLE(%a1), %a1	;;; identifier table address
	add.l	%d0, %a1		;;; + offset of number of dlocals
La4:	mov.l	-(%a1), %a6		;;; next identifier backwards
	mov.l	_ID_VALOF(%a6), (%a0)+	;;; stack idval in process
	mov.l	(%sp)+, _ID_VALOF(%a6)	;;; restore valof from stack
	subq.w	&4, %d0			;;; more to go?
	bne.b	La4			;;; loop if so

	;;; restore registers (PD_REGMASK still in d1)
La5:	jmp	2(%pc, %d1.w)		;;; jump to 6-byte code section
					;;;  pop		nonpop
	bra.b	sotest			;;; -- --	-- -- -- --
	nop
	nop
	mov.l	(%sp)+, %d5		;;; d5 --	-- -- -- --
	bra.b	sotest
	nop
	movm.l  (%sp)+,&0x0060		;;; d5 d6	-- -- -- --
	bra.b	sotest
	mov.l	(%sp)+, %a3		;;; -- --	a3 -- -- --
	bra.b	sotest
	nop
	movm.l  (%sp)+,&0x0820		;;; d5 --	a3 -- -- --
	bra.b	sotest
	movm.l  (%sp)+,&0x0860		;;; d5 d6	a3 -- -- --
	bra.b	sotest
	movm.l  (%sp)+,&0x1800		;;; -- --	a3 a4 -- --
	bra.b	sotest
	movm.l  (%sp)+,&0x1820		;;; d5 --	a3 a4 -- --
	bra.b	sotest
	movm.l  (%sp)+,&0x1860		;;; d5 d6	a3 a4 -- --
	bra.b	sotest
	movm.l  (%sp)+,&0x3800		;;; -- --	a3 a4 a5 --
	bra.b	sotest
	movm.l  (%sp)+,&0x3820		;;; d5 --	a3 a4 a5 --
	bra.b	sotest
	movm.l  (%sp)+,&0x3860		;;; d5 d6	a3 a4 a5 --
	bra.b	sotest
	movm.l  (%sp)+,&0x3880		;;; -- --	a3 a4 a5 d7
	bra.b	sotest
	movm.l  (%sp)+,&0x38a0		;;; d5 --	a3 a4 a5 d7
	bra.b	sotest
	movm.l  (%sp)+,&0x38e0		;;; d5 d6	a3 a4 a5 d7

sotest: cmp.l	%a2, %d3		;;; reached the beginning?
	bhi.w	soloop			;;; next frame if not

	;;; finished -- chain procedure on stack
	mov.l	process, %a0
	clr.l	_PS_CALLSTACK_PARTIAL(%a0)  ;;; ensure PARTIAL reset to NULL
	clr.w	_PS_FLAGS(%a0)		;;; 0 process flags = suspended
	sub.l	%a2, %a2		;;; restore a2 (always 0)
	mov.l	sav_a6, %a6		;;; restore a6
	mov.l	(%a6)+, %a0		;;; procedure
	mov.l	(%a0), %a0		;;; PD_EXECUTE address
	jmp	(%a0)			;;; chain it

	;;; come here to run dlocal expression code, by jumping into the
	;;; owner procedure. owner is in a1 and relative return address in d2
sobrk:  mov.l	%a1, -(%sp)		;;; push owner back on stack
	mov.l	process, %a0
	mov.l	%d2, _PS_PARTIAL_RETURN(%a0) ;;; save return addr in PARTIAL_RETURN
	mov.l	%a2, _PS_CALLSTACK_PARTIAL(%a0)  ;;; save a2 in CALLSTACK_PARTIAL
	sub.l	%a2, %a2		;;; restore a2 to 0
	mov.l	sav_a6, %a6		;;; restore a6
	mov.l	%a0, %d0		;;; pass process in CHAIN_REG
	mov.l	_PD_EXIT(%a1), %a1	;;; exit code base address
	jmp	-BRANCH_std*2(%a1)  	;;; go into procedure's suspend code

	;;; then return from procedure's suspend code is to here
	;;; (process in CHAIN_REG)
DEF_C_LAB (_swap_out_continue)
	mov.l	%d0, %a0		;;; regain the process
	mov.l	%a6, sav_a6		;;; re-save a6
	mov.l	%a0, process		;;; re-save process
	mov.l	_PS_CALLSTACK_PARTIAL(%a0), %a2  ;;; restore a2
	mov.l	_PS_STATE(%a0), %d3	;;; restore limit
	mov.l	_PS_PARTIAL_RETURN(%a0), %d2 ;;; and rel return in PARTIAL_RETURN
	mov.l	(%sp)+, %a1		;;; restore owner to a1
	bra.w	socont			;;; continue swap-out



	;;; swap in the callstack for a process
DEF_C_LAB (_swap_in_callstack)
	mov.l	(%a6)+, %a0		;;; the process
	mov.l	%a0, process		;;; save it here
	mov.l	%a6, sav_a6		;;; save a6
	mov.l	_PS_CALLSTACK_LIM(%a0), limit	;;; limit of saved callstack
	mov.l	_PS_STATE(%a0), %a2	;;; start of saved callstack
	bra.w	sitest

siloop:	mov.l	(%a2)+, %d2		;;; relative return address
	mov.l	(%a2)+, %d3		;;; owner procedure address
	mov.l	%d3, %a1		;;; in an address reg

	;;; save registers on stack
	mov.w	_PD_REGMASK(%a1), %d4	;;; 6-byte code section offset
	jmp	2(%pc, %d4.w)		;;; jump to it
					;;;  pop	nonpop
	bra.b	Lb1			;;; -- --   	-- -- -- --
	nop
	nop
	mov.l	%d5,-(%sp) 		;;; d5 --	-- -- -- --
	bra.b	Lb1
	nop
	movm.l	&0x0600,-(%sp)		;;; d5 d6	-- -- -- --
	bra.b	Lb1
	mov.l	%a3,-(%sp)		;;; -- --	a3 -- -- --
	bra.b	Lb1
	nop
	movm.l	&0x0410,-(%sp)		;;; d5 --	a3 -- -- --
	bra.b	Lb1
	movm.l	&0x0610,-(%sp)		;;; d5 d6   	a3 -- -- --
	bra.b	Lb1
	movm.l	&0x0018,-(%sp)		;;; -- --	a3 a4 -- --
	bra.b	Lb1
	movm.l	&0x0418,-(%sp)		;;; d5 --	a3 a4 -- --
	bra.b	Lb1
	movm.l	&0x0618,-(%sp)		;;; d5 d6   	a3 a4 -- --
	bra.b	Lb1
	movm.l	&0x001c,-(%sp)		;;; -- --	a3 a4 a5 --
	bra.b	Lb1
	movm.l	&0x041c,-(%sp)		;;; d5 --	a3 a4 a5 --
	bra.b	Lb1
	movm.l	&0x061c,-(%sp)		;;; d5 d6   	a3 a4 a5 --
	bra.b	Lb1
	movm.l	&0x011c,-(%sp)		;;; -- --	a3 a4 a5 d7
	bra.b	Lb1
	movm.l	&0x051c,-(%sp)		;;; d5 	    	a3 a4 a5 d7
	bra.b	Lb1
	movm.l	&0x071c,-(%sp)		;;; d5 d6   	a3 a4 a5 d7

Lb1:	movq	&0, %d1
	mov.b	_PD_NUM_STK_VARS(%a1), %d1	;;; no of on_stack vars
	asl.w	&2, %d1			;;; offset in bytes
	add.l	%d1, %a2		;;; addr of after last var
	mov.l	%a2, %a0		;;; use in a0 to scan backwards

	movq	&0, %d0
	mov.b	_PD_NLOCALS(%a1), %d0	;;; no of locals
	beq.b	Lb4			;;; br if none
	asl.w	&2, %d0			;;; offset in bytes
	add.l	%d0, %a2		;;; addr of after last local
	mov.l	%a2, %a0		;;; use in a0 to scan backwards
	lea	_PD_TABLE(%a1), %a1	;;; identifier table address
Lb2:	mov.l	(%a1)+, %a6		;;; next identifier
	mov.l	_ID_VALOF(%a6), -(%sp)	;;; stack idval
	mov.l	-(%a0), _ID_VALOF(%a6)	;;; restore process idval
	subq.w	&4, %d0			;;; more to go?
	bne.b	Lb2			;;; loop if so
	bra.b	Lb4

Lb3:	mov.l	-(%a0), -(%sp)		;;; copy stack var values
Lb4:	subq.w	&4, %d1
	bge.b	Lb3			;;; br if more stack vars

	;;; restore registers from process
	jmp	2(%pc, %d4.w)		;;; jump to 6-byte code section
					;;;  pop	nonpop
	bra.b	Lb5			;;; -- --   	-- -- -- --
	nop
	nop
	mov.l	(%a2)+,%d5		;;; d5 --   	-- -- -- --
	bra.b	Lb5
	nop
	movm.l	(%a2)+,&0x0060		;;; d5 d6   	-- -- -- --
	bra.b	Lb5
	mov.l	(%a2)+,%a3		;;; -- --   	a3 -- -- --
	bra.b	Lb5
	nop
	movm.l	(%a2)+,&0x0820		;;; d5 --   	a3 -- -- --
	bra.b	Lb5
	movm.l	(%a2)+,&0x0860		;;; d5 d6   	a3 -- -- --
	bra.b	Lb5
	movm.l	(%a2)+,&0x1800		;;; -- --   	a3 a4 -- --
	bra.b	Lb5
	movm.l	(%a2)+,&0x1820		;;; d5 --   	a3 a4 -- --
	bra.b	Lb5
	movm.l	(%a2)+,&0x1860		;;; d5 d6   	a3 a4 -- --
	bra.b	Lb5
	movm.l	(%a2)+,&0x3800		;;; -- --   	a3 a4 a5 --
	bra.b	Lb5
	movm.l	(%a2)+,&0x3820		;;; d5 --   	a3 a4 a5 --
	bra.b	Lb5
	movm.l	(%a2)+,&0x3860		;;; d5 d6   	a3 a4 a5 --
	bra.b	Lb5
	movm.l	(%a2)+,&0x3880		;;; -- --   	a3 a4 a5 d7
	bra.b	Lb5
	movm.l	(%a2)+,&0x38a0		;;; d5 --   	a3 a4 a5 d7
	bra.b	Lb5
	movm.l	(%a2)+,&0x38e0		;;; d5 d6   	a3 a4 a5 d7

Lb5:	mov.l	%d3, -(%sp)		;;; stack owner

	;;; test if has dlocal expression code to run
	mov.l	%d3, %a1
	movq	&_:M_PD_PROC_DLEXPR_CODE, %d0
	and.b	_PD_FLAGS(%a1), %d0
	bne.b	sibrk			;;; yes -- break out to run code

	;;; (continue here after break)
sicont:	add.l	%a1, %d2		;;; make return address absolute
	mov.l	%d2, -(%sp)		;;; stack it

sitest:	cmp.l	%a2, limit		;;; reached the end?
	bcs.w	siloop			;;; next frame if not

	;;; finished -- call procedure off stack
	mov.l	process, %a0
	clr.l	_PS_CALLSTACK_PARTIAL(%a0)	;;; ensure PARTIAL reset to NULL
	sub.l	%a2, %a2		;;; restore a2 to 0
	mov.l	&C_LAB(false), %d4	;;; restore d4 to false
	mov.l	sav_a6, %a6		;;; restore a6
	mov.l	(%a6)+, %a0		;;; procedure
	mov.l	(%a0), %a0		;;; PD_EXECUTE address
	jmp	(%a0)			;;; call it with existing return

	;;; come here to run dlocal expression code,by jumping into the
	;;; owner procedure. owner is in a1 and relative return address in d2
sibrk:	mov.l	process, %a0
	mov.l	%d2, _PS_PARTIAL_RETURN(%a0)	;;; save return addr in PARTIAL_RETURN
	mov.l	%a2, _PS_CALLSTACK_PARTIAL(%a0)	;;; save a2 in CALLSTACK_PARTIAL
	sub.l	%a2, %a2		;;; restore a2 to 0
	mov.l	&C_LAB(false), %d4	;;; restore d4 to false
	mov.l	sav_a6, %a6		;;; restore a6
	mov.l	%a0, %d0		;;; pass process in CHAIN_REG
	mov.l	_PD_EXIT(%a1), %a1	;;; exit code base address
	jmp	-BRANCH_std(%a1)	;;; go into procedure's resume code

	;;; then return from procedure's resume code is to here
	;;; (process in CHAIN_REG)
DEF_C_LAB (_swap_in_continue)
	mov.l	%d0, %a0		;;; regain the process
	mov.l	%a6, sav_a6		;;; re-save a6
	mov.l	%a0, process		;;; re-save process
	mov.l	_PS_CALLSTACK_PARTIAL(%a0), %a2	;;; restore a2
	mov.l	_PS_CALLSTACK_LIM(%a0), limit	;;; restore limit
	mov.l	_PS_PARTIAL_RETURN(%a0), %d2	;;; restore rel return in PARTIAL_RETURN
	mov.l	(%sp), %a1		;;; restore owner to a1
	bra.w	sicont			;;; continue swap-out


	data
sav_a6:
	long	0
process:
	long	0
limit:
	long	0


	text


;;; --- ROUTINES TO HANDLE USERSTACK SWAPPING --------------------------------

	;;; save and erase a given number of bytes at the end of the userstack
DEF_C_LAB (_ussave)
	mov.l	(%a6)+,%a1		;;; address to store saved part
	mov.l	(%a6)+,%d0		;;; length to save
	mov.l	I_LAB(_userhi),%a0	;;; stack base
	sub.l	%d0,%a0			;;; where moving from
	mov.l	%a0,%d4			;;; save for after move
	jsr	movchars_la		;;; move stuff into save area
	;;; now reposition the rest above
	mov.l	%d4,%d0			;;; start of saved part
	sub.l	%a6,%d0			;;; length of rest
	mov.l	%a6,%a0			;;; stack top is source
	mov.l	I_LAB(_userhi),%a6
	sub.l	%d0,%a6			;;; new stack top after move
	mov.l	%a6,%a1			;;; is dest for move
	jsr	movchars_la		;;; do the move
	mov.l	&C_LAB(false),%d4	;;; restore d4 to false
	rts

	;;; restore a given number of bytes at the end of the userstack
DEF_C_LAB (_usrestore)
	mov.l	(%a6)+,%d4		;;; address of part to restore
	mov.l	(%a6)+,%d3		;;; length of it
	mov.l	I_LAB(_userhi),%d0	;;; stack base
	sub.l	%a6,%d0			;;; length of current stack
	mov.l	%a6,%a0			;;; stack top is source
	sub.l	%d3,%a6			;;; will be new stack top
	mov.l	%a6,%a1			;;; and is dest for move
	jsr	movchars_la		;;; make room for restored stuff
	;;; move in the new part
	mov.l	%d3,%d0			;;; length to restore
	mov.l	%d4,%a0			;;; where coming from
	mov.l	I_LAB(_userhi),%a1	;;; stack base
	sub.l	%d0,%a1			;;; sub length to get dest for move
	jsr 	movchars_la		;;; move it in under
	mov.l	&C_LAB(false),%d4	;;; restore d4 to false
	rts

	;;; erase a given number of bytes at the end of the userstack
DEF_C_LAB (_userasund)
	mov.l	(%a6)+,%d1		;;; length in bytes to erase
	mov.l	%a6,%a0			;;; current stack is source for move
	add.l	%d1,%a6			;;; where stack will start after
	mov.l	%a6,%a1			;;; is dest for move
	mov.l	I_LAB(_userhi),%d0	;;; stack end
	sub.l	%a6,%d0			;;; length to move
	jsr	movchars_la		;;; do the move
	rts


/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Jun 15 1991
	Made _swap_in_callstack call a procedure off the stack when
	finished
--- John Gibson, Sep 27 1990
	Rewrote _swap_out_callstack so that -sp- never points above wanted
	data (otherwise, a signal handler stack frame can overwrite data
	below where -sp- points). (_swap_in_callstack already fulfilled
	this condition.)
--- John Gibson, Dec  6 1989
	Changes for new pop pointers (use explicit ID_VALOF offset)
--- John Gibson, Oct  5 1989
	_swap_out_callstack now clears the process' flags and chains the
	procedure on the stack when finished; the SWAP_BACK_IN flag is
	therefore unnecessary.
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Jul  5 1988
	Made all return addresses stored in process records relative.
--- John Gibson, Jul  3 1988
	Replaced double word field PS_PARTIAL_SAVE with single word field
	PS_PARTIAL_RETURN holding the relative return address (i.e.
	return address - owner procedure).
--- John Gibson, Jun 16 1988
	Corrected offsets (from 4 to 2) in pc-relative "jmp" instructions.
	(New assembler doesn't subtract 2 as old one did).
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
