/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 * File:            S.hpbob/src/aprolog.s
 * Purpose:
 * Author:          John Gibson (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */

;;; --------------------- ROUTINES FOR PROLOG -------------------------------

#_<

#_INCLUDE 'declare.ph'

constant
	procedure (Sys$-Plog$-Assign_pair, Sys$-Plog$-New_var), _checkplogall
	;

vars
	_plog_trail_sp, _plog_next_var, _plog_contn_sp, _plog_contn_top,
	_plog_save_contn_sp, _plog_trail_barrier, _plog_trail_lim,
	_call_stack_lim
	;


lconstant macro (
	_KEY		= @@KEY,
	_PGV_CONT	= @@PGV_CONT,
	_PGV_SIZE	= @@(struct PLOGVAR)++,
	_PGT_FUNCTOR	= @@PGT_FUNCTOR,
	_PGT_LENGTH	= @@PGT_LENGTH,
	_P_FRONT	= @@P_FRONT,
	_P_BACK		= @@P_BACK,
	_SF_PLGSV_CONTN_TOP	= @@SF_PLGSV_CONTN_TOP,
	_SF_PLGSV_NEXT_VAR	= @@SF_PLGSV_NEXT_VAR,
	_SF_PLGSV_TRAIL_SP	= @@SF_PLGSV_TRAIL_SP,
	);

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/

	text


;;; --- PROLOG SAVE AND RESTORE -------------------------------------------

	;;; Save the prolog continuation stack,trail and next free var
	;;; in the corresponding saved locations. Then do stack overflow and
	;;; interrupt checks.
DEF_C_LAB (_prolog_save_check)
	lea	C_LAB(_special_var_block),%a0
	;;; save next var
	mov.l	_SVB_OFFS(_plog_next_var)(%a0), 4+_SF_PLGSV_NEXT_VAR(%sp)
	;;; save trail end pointer,relative to trail barrier
	mov.l	_SVB_OFFS(_plog_trail_sp)(%a0), %d0
	mov.l	%d0, %d1				;;; save for later
	sub.l	_SVB_OFFS(_plog_trail_barrier)(%a0), %d0
	mov.l	%d0,4+_SF_PLGSV_TRAIL_SP(%sp)
	;;; save continuation stack top and pointer
	;;; save_contn_sp is a dynamic local (see plogcore.p)
	mov.l	_SVB_OFFS(_plog_contn_sp)(%a0), _SVB_OFFS(_plog_save_contn_sp)(%a0)
	mov.l	_SVB_OFFS(_plog_contn_top)(%a0), 4+_SF_PLGSV_CONTN_TOP(%sp)
	;;; do checks
	cmp.l	%d1, _SVB_OFFS(_plog_trail_lim)(%a0)	;;; trail overflow?
	bcc.b	La1				;;; branch if so
	cmp.l	%sp, _SVB_OFFS(_call_stack_lim)(%a0)	;;; system stack okay?
	bcs.b	La1				;;; branch if too long
	cmp.l	%a6, _SVB_OFFS(_userlim)(%a0)	;;; user stack okay?
	bcs.b	La1				;;; branch if too long
	btst    &0, _SVB_OFFS(_trap)+3(%a0)	;;; test interrupt bit
	bne.b	La1				;;; branch if set
	rts					;;; everything okay - return
La1:	jmp	C_LAB(_checkplogall)		;;; else redo checks


	;;; restore the contn stack and next free var from the current
	;;; saved values,and unwind the trail back to the saved position,
	;;; resetting vars to undef
DEF_C_LAB (_prolog_restore)
	lea	C_LAB(_special_var_block),%a1
	;;; restore next var
	mov.l	4+_SF_PLGSV_NEXT_VAR(%sp), _SVB_OFFS(_plog_next_var)(%a1)

	;;; restore contn top and pointer
	mov.l	_SVB_OFFS(_plog_save_contn_sp)(%a1), _SVB_OFFS(_plog_contn_sp)(%a1)
	mov.l	4+_SF_PLGSV_CONTN_TOP(%sp), _SVB_OFFS(_plog_contn_top)(%a1)

	;;; restore trail end pointer,setting plogvars back to undef
	mov.l	4+_SF_PLGSV_TRAIL_SP(%sp),%a0
	add.l	_SVB_OFFS(_plog_trail_barrier)(%a1), %a0
	mov.l	_SVB_OFFS(_plog_trail_sp)(%a1), %d0	;;; current end
	cmp.l	%a0, %d0				;;; reached end?
	bcc.b	Lb2					;;; br if so
	mov.l	%a0, _SVB_OFFS(_plog_trail_sp)(%a1)	;;; set new end
Lb1:	mov.l	(%a0)+,%a1			;;; the var
	mov.l	%a1,_PGV_CONT(%a1) 		;;; put var into its own PGV_CONT
	cmp.l	%a0,%d0				;;; reached end?
	bcs.b	Lb1				;;; br if not
Lb2:	rts


	;;; unify against atom. arg in d0, atom in d1
DEF_C_LAB (_prolog_unify_atom)
	mov.l	&C_LAB(prologvar_key),%d2 ;;; get the key into a reg
Lc1:	btst	&0,%d0			;;; item is simple?
	bne.b	Lc2			;;; go if so
	mov.l	%d0,%a0			;;; get to A reg
	cmp.l	%d2,_KEY(%a0)		;;; item is plogvar?
	bne.b	Lc2			;;; no: compare item
	mov.l	_PGV_CONT(%a0),%d0	;;; deref one link of plogvar
	cmp.l	%a0,%d0			;;; cont(item) == item? (end of chain)
	bne.b	Lc1			;;; not undef -- go for more
	mov.l	%d1,_PGV_CONT(%a0)	;;; assign atom to cont
	lea	I_LAB(_plog_trail_sp),%a0
	mov.l	(%a0),%a1		;;; get trail pointer
	mov.l	%d0,(%a1)+		;;; push variable
	mov.l	%a1,(%a0)		;;; put trail pointer back
	movq	&0,%d0			;;; leave flags set equal
	rts
	;;; item is nonvar (in %d0)
Lc2:	cmp.l	%d1,%d0			;;; leave flags set for equal/not equal
	rts


	;;; prolog pair switch
	;;; arg is in d0
DEF_C_LAB (_prolog_pair_switch)
	mov.l	&C_LAB(prologvar_key),%d1 ;;; get the key into a reg
Ld1:	btst	&0,%d0			;;; item is simple?
	bne.b	Ld3			;;; go if so
	mov.l	%d0,%a0			;;; get to A reg
	cmp.l	%d1,_KEY(%a0)		;;; item is plogvar?
	bne.b	Ld2			;;; go if no: dereffed to non-variable
	mov.l	_PGV_CONT(%a0),%d0	;;; deref one link of plogvar
	cmp.l	%a0,%d0			;;; cont(item) == item? (end of chain)
	bne.b	Ld1			;;; not undef,go for more
	;;; undef var - push it and return flags set to greater than
	mov.l	%d0,-(%a6)		;;; sets flags (addr is > 0)
	rts
	;;; compound item
Ld2:	cmp.l	_KEY(%a0),&C_LAB(pair_key)	;;; is pair?
	bne.b	Ld3			;;; no
	;;; pair - return flags set to equal (already are)
	rts
	;;; anything else - return flags set to less than
Ld3:	movq	&-1,%d1			;;; set less than
	rts

	;;; just like pair_switch but checks functor and length (== arity + 1)
	;;; arg is in d0, functor in d1, popint length in d2
DEF_C_LAB (_prolog_term_switch)
	mov.l	&C_LAB(prologvar_key),%d3 ;;; get the key into a reg
Le1:	btst	&0,%d0			;;; item is simple?
	bne.b	Le3			;;; go if so,return notvar,notfunc
	mov.l	%d0,%a0			;;; get to A reg
	cmp.l	%d3,_KEY(%a0)		;;; item is plogvar?
	bne.b	Le2			;;; go if no: dereffed to non variable
	mov.l	_PGV_CONT(%a0),%d0	;;; deref one link of plogvar
	cmp.l	%a0,%d0			;;; cont(item) == item? (end of chain)
	bne.b	Le1			;;; not undef,go for more
	;;; undef var - push it and return flags set to greater than
	mov.l	%d0,-(%a6)		;;; sets flags (addr is > 0)
	rts
	;;; compound item
Le2:	cmp.l	_KEY(%a0),&C_LAB(prologterm_key) ;;; isprologterm?
	bne.b	Le3			;;; if not go return notfunctor,notvar
	cmp.l	%d1,_PGT_FUNCTOR(%a0)	;;; is right functor?
	bne.b	Le3			;;; if not go return notfunctor,notvar
	asr.l	&2,%d2			;;; convert length to sysint
	cmp.l	%d2,_PGT_LENGTH(%a0)	;;; right length?
	bne.b	Le3			;;; if not go return notfunctor,notvar
	;;; correct term - return flags set to equal (already are)
	rts
	;;; anything else - return flags set to less than
Le3:	movq	&-1,%d1			;;; set less than
	rts


	;;; assign to a prolog variable
DEF_C_LAB (_prolog_assign)
	mov.l	(%a6)+,%d0		;;; item into d0
	bra.b	plog_assign

DEF_C_LAB (_prolog_assign_pair)
	lea	I_LAB(Sys$- _free_pairs),%a1
	mov.l	(%a1),%d0		;;; get free pair list
	btst	&0,%d0			;;; if simple,then none left
	bne.b	nopair
	mov.l	%d0,%a0
	mov.l	_P_BACK(%a0),(%a1)	;;; move the next back to _free_pairs
	mov.l	(%a6)+,_P_BACK(%a0)	;;; init back
	mov.l	(%a6)+,_P_FRONT(%a0)	;;; init front
	;;; assign item in d0 to var and push on trail
plog_assign:
	mov.l	(%a6)+,%a0		;;; prolog var into %a0
	mov.l	%d0,_PGV_CONT(%a0)	;;; do the assign
	mov.l	I_LAB(_plog_trail_sp),%a1 ;;; trail stack pointer
	mov.l	%a0,(%a1)+		;;; push var on stack
	mov.l	%a1,I_LAB(_plog_trail_sp) ;;; update pointer
	rts

nopair:	jmp	XC_LAB(Sys$-Plog$-Assign_pair) ;;; none left,chain to Assign_pair


;;; --- OPTIONAL ASSEMBLER CODE ----------------------------------------------
	;;; optional assembler optimised stuff, for code normally in pop.
	;;; see bottom of syscomp/sysdefs.p for when this is used
	;;; and plogcore.p, plogterms.p for equivalent pop code

	;;; dereference a chain of prolog variables
DEF_C_LAB (_prolog_deref)
	mov.l	(%a6),%d0		;;; get item
	mov.l	&C_LAB(prologvar_key),%d1 ;;; get the key into a reg
Lf1:	btst	&0,%d0			;;; item is simple?
	bne.b	Lf3			;;; go if so
	mov.l	%d0,%a0			;;; get to A reg
	cmp.l	%d1,_KEY(%a0)		;;; item is plogvar?
	bne.b	Lf3			;;; no return item
	mov.l	_PGV_CONT(%a0),%d0	;;; deref one link of plogvar
	cmp.l	%a0,%d0			;;; cont(item) == item? (end of chain)
	bne.b	Lf1			;;; no -- go back for more
Lf3:	mov.l	%d0,(%a6)		;;; return dereffed item
	rts

	;;; return a new prolog variable from the free block,unless no
	;;; more space -- then use pop New_var,which allocates space.
DEF_C_LAB (_prolog_newvar)
	lea	I_LAB(_plog_next_var),%a1
	mov.l	(%a1),%a0		;;; next var in block
	cmp.l	_KEY(%a0),&C_LAB(ref_key) ;;; end-of-block reference?
	beq.b	Lg1			;;; branch if so
	mov.l	%a0,_PGV_CONT(%a0)	;;; make this one undef
	mov.l	%a0,-(%a6)		;;; and return it
	addq.l	&_PGV_SIZE,%a0		;;; address of next var
	mov.l	%a0,(%a1)		;;; move on to next
	rts
Lg1:	jmp	XC_LAB(Sys$-Plog$-New_var)	;;; call this for some more


/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Oct 18 1994
	free*pairs -> _free_pairs
--- John Gibson, Dec  7 1989
	Changes for new pop pointers (explicit use of PGV_CONT)
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Apr  9 1989
	Prolog_newvar, Prolog_assign_pair renamed into section Sys$-Plog
--- John Gibson, Sep  4 1988
	Replaced _SVB macros with _SVB_OFFS(identifier name)
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
