/* --- Copyright University of Sussex 1995. All rights reserved. ----------
 * File:		S.hpbob/src/asignals.s
 * Purpose:
 * Author:		John Gibson (see revisions)
 */

/* =========================================================================
	!!! N.B. cmp INSTRUCTIONS HAVE THEIR ARGS REVERSED !!!
=========================================================================== */

;;; ---------------- SIGNAL HANDLER (HP SYSTEMS) -----------------------------

#_<

#_INCLUDE 'declare.ph'

section $-Sys;

constant
	procedure (Callstack_reset, Error_signal, Vfork_parent)
	;

vars
	Extern$- _saved_sp,
	_curbrk = _extern end
	;

endsection;

lconstant macro (
	_CURBRK		= [I_LAB(Sys$- _curbrk)],
	_SAVED_SP	= [I_LAB(Sys$-Extern$- _saved_sp)],
	);

>_#

/********************* wrapping structures ***********************************/

	text
	long	Ltext_end-Ltext_start,C_LAB(Sys$-objmod_pad_key)
set Ltext_start,.
	data
	long	Ldata_end-Ldata_start,C_LAB(Sys$-objmod_pad_key)
set Ldata_start,.

/**************************************************************************/

	text


;;; --- ROUTINES TO CLEAN UP AND CALL A POP ERROR HANDLER -----------------

reset_pop_environ:
	clr.l	___pop_in_user_extern	;;; clear this just in case
	jsr	reset_pop_reg_environ
	mov.l	I_LAB(_userhi), %a6	;;; reset user stack
	mov.l	(%sp)+, %a0		;;; save return
	tst.l	_SAVED_SP		;;; in an external call?
	beq.b	Le1			;;; branch if not
	mov.l	_SAVED_SP, %sp		;;; if so, reset sp to saved value
	clr.l	_SAVED_SP
Le1:	jmp	(%a0)			;;; return to caller

	;;; Error signals (e.g. SEGV) call this, passing the saved
	;;; stack pointer value from the signal context structure.
global ___pop_errsig
___pop_errsig:
	mov.l	4(%sp), %sp			;;; set sp from arg
	bsr.b	reset_pop_environ
	jsr	XC_LAB(Sys$-Error_signal)	;;; never returns


;;; ------------------------------------------------------------------------

DEF_C_LAB (Sys$- _do_vfork)
set VFORK, 66
	mov.l	(%sp)+, %a0
	movq	&VFORK, %d0
	trap	&0
	bcc.b	Lf1
	mov.l	%d0, EXTERN_NAME(errno)
	mov.l	&-1, -(%a6)
	jmp	(%a0)

Lf1: 	tst.l	%d1			;;; the child?
	beq.b	Lf2			;;; no, the parent
	clr.l	-(%a6)			;;; return 0 for child
	jmp	(%a0)

Lf2:	clr.l	_SAVED_SP		;;; in case in extern calls in child
	mov.l	%d0, -(%a6)		;;; child ID
	mov.l	&C_LAB(weakref Sys$-Vfork_parent), -(%a6)
	jmp 	XC_LAB(Sys$-Callstack_reset)


;;; ---------------------------------------------------------------------

	;;; The sbrk.o library module on the HP uses a local variable to
	;;; store the value of the current break. We therefore have to have
	;;; our own definitions of -brk- and -sbrk- so we can access the value
	;;; in _call_external (aextern.s). These definitions are otherwise
	;;; identical to those in sbrk.o.

	;;; NOTE that the location holding the current break cannot be
	;;; defined in the data seg of this file, because then its value
	;;; would be saved and restored.

	text
set BRK, 17		;;; number of brk system call

global _sbrk
_sbrk:
	mov.l	4(%sp), %d0
	add.l	_CURBRK, %d0
	mov.l	%d0, -(%sp)
	subq.l	&4, %sp
	mov.l	&BRK, %d0
	trap	&0
	addq.l	&8, %sp
	bcc.b	Lx1
	jmp	__cerror
Lx1:	mov.l	_CURBRK, %d0
	mov.l	4(%sp), %d1
	add.l	%d1, _CURBRK
	rts

global _brk
_brk:
	mov.l	&BRK, %d0
	trap	&0
	bcc.b	Lz1
	jmp	__cerror
Lz1:	mov.l	4(%sp), _CURBRK
	clr.l	%d0
	rts


;;; -------------------------------------------------------------------------

	;;; Make a system call, moving args from userstack
	;;; to system stack -- for internal use only (calls to this
	;;; are generated by the _extern syntax form).
	;;; (User external calls are done in aextern.s)

DEF_C_LAB (_call_sys)
	lea	4(%sp), %a0		;;; caller's stack frame
	mov.l	%a0, _SAVED_SP 		;;; save for exception conditions

#_IF DEF STACK_PROBES
	tst.b	-256(%sp)
#_ENDIF
	mov.l	(%a6)+, %a0		;;; system proc addr from pop stack
	mov.l	(%a6)+, %d0		;;; argument count from pop stack
	beq.b	Lg2			;;; no args
Lg1:	mov.l	(%a6)+, -(%sp)		;;; stack an arg on system stack
	subq.l	&1, %d0
	bne.b	Lg1

Lg2:	jsr	(%a0)			;;; hop to it
	mov.l	%d0, -(%a6)		;;; stack the result on pop stack
	mov.l	_SAVED_SP, %a0
	lea	-4(%a0), %sp		;;; reset sp
	clr.l	_SAVED_SP		;;; says no longer in extern calls
	rts


;;; -------------------------------------------------------------------------

	data

global ___pop_fpe_flag
___pop_fpe_flag:
	long 0		;;; tested in afloat.s

save_val:
	long 0



/*************** end labels for wrapping structures **************************/

	text
set Ltext_end,.
	data
set Ldata_end,.

/**************************************************************************/



/* --- Revision History ---------------------------------------------------
--- John Gibson, Mar 14 1995
	Removed _pop_m*alloc_exhausted (no longer needed)
--- John Gibson, Oct 24 1994
	Removed the C pointers to pop vars (now set up in initial.p)
--- John Gibson, May 24 1994
	errno now used directly for syscall error codes -- got rid of
	code transferring it to _sys*error.
--- Simon Nichols, Nov 12 1993
	Changed ___pop_errsig to take as an argument saved SP value from
	the sigcontext structure. Note that ___pop_errsig is now called,
	as updating the PC field of the sigcontext structure doesn't work
	for HP9000 400 series machines.
--- John Gibson, Mar 14 1991
	Added __pop_in_X_call
--- John Gibson, Jan 19 1991
	Added clearing of ___pop_in_user_extern in reset_pop_environ
--- John Gibson, Jan  3 1991
	Actual signal handlers rewritten in C and moved to c_core.c
--- John Gibson, Dec  3 1990
	Replaced _pop_a*dd_sig with _pop_add_ast taking ast type as 1st arg
--- Roger Evans, Nov 22 1990 added __pop_xt_dummy_fd
--- John Gibson, Nov 19 1990
	Grouped all C-accessible pointers and added
	__WEAK_pop_external_callback etc.
--- John Gibson, Nov 15 1990
	Changed "jsr" to Callstack_reset in _do_vfork to "jmp", and made
	it clear _SAVED_SP.
--- John Gibson, Nov 13 1990
	Replaced _m*alloc_use_external by _external_flags and
	_pop_malloc_use_external by pop_external_flags, etc.
--- John Gibson, Aug 21 1990
	Signal queue routines rewritten in C and put into malloc.c.
	These access the pop variable _trap via the constant pointer
	_pop_signals_pending.
--- John Gibson, May 15 1990
	a*ddsig now sets _trap to 1, and _remsig sets it to 0 when signal
	queue is empty. _remsig also now returns signal on stack.
		Fixed incorrect "lea" in _call_sys (had 4 instead of -4).
--- John Gibson, May 13 1990
	Added __pop_malloc_use_external to enable malloc to get at
	Sys$-_malloc_use_external.
	Changed name of routine called by malloc when internal dynamic
	memory exhausted to __pop_m*alloc_exhausted, and error pop procedure
	called to Sys$-M*alloc_exhausted.
--- John Gibson, Apr 29 1990
	Moved _call_sys to this file from aextern.s (so core routine
	_call_sys doesn't pull in 'optional' external stuff).
	Also now uses signals.ph for signal numbers.
	_saved_sp now in $-Sys$-Extern
--- John Gibson, Mar 23 1990
	Removed call of reset_pop_environ from do_vfork (mustn't be
	there now, because it resets the pop registers).
--- Ian Rogers, Jan 16 1990
	Made reset_pop_environ globally accessable. Added call to it
	in 	_do_fork
--- John Gibson, Aug 22 1989
	Added _do_vfork
--- John Gibson, Aug 17 1989
	Replaced # EXEC ... # ENDEXEC with #_< ... >_#
--- John Gibson, Aug 26 1988
	Made SIGFPE set fpe_flag so that overflow can be tested for in
	afloat.s.
--- John Gibson, Aug 23 1988
	Wrapping structures now use -objmod_pad_key-
--- Roger Evans, Jun 17 1988
	added SIGILL and SEGEMT to immediately handled signals
--- John Gibson, Apr 22 1988
	Changed for new assembler
--- Roger Evans, Apr 20 1988
	installed in masters superceding old handler.
	moved _signal_handler _remsig and_-trapto to section Sys
--- John Gibson, Jan 17 1988
	Added 'wrapping' strings to enable object files from .s files to
	be mixed in with those from .p source.
		Replaced all references to 'poplog' labels with macros
	C_LAB, I_LAB, etc applied to identifier names, and added appropriate
	declarations between #_< ... >_#, etc.
 */
