/* --- Copyright University of Sussex 1990. All rights reserved. ----------
 > File:            C.68000/src/ass.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

;;;----------------- RUN-TIME ASSEMBLER (MC68000) -----------------------------

#_INCLUDE 'declare.ph'
#_INCLUDE 'vmdefs.ph'

global constant
		_popenter, _popuenter, _popuncenter, _checkall,
		_bfield, _sbfield, _ubfield, _vecsub_mult,
		_setstklen, _setstklen_diff
	;

global vars
		pop_debugging, _trap
	;

section $-Sys$-Vm;

constant
		procedure (Trans_structure, Get_procedure, Structab_offset,
		Is_register, Drop_I_code, Code_pass)
	;

vars
		asm_clist, asm_instr, asm_struct_list,
		_asm_pass, _asm_drop_ptr, _asm_code_offset, _asm_offset_diff,
		_Nlocals, _Nreg, _Npopreg, _Nstkvars, _Npopstkvars
	;

endsection;


;;; -----------------------------------------------------------------------

section $-Sys$-Vm;

lvars		_rest_regmask, _save_regmask, _strsize, _big_procedure
	;

lconstant

	;;; opnd modes for Get_instr
	_Rn			= _0,
	_Dn			= _0,
	_An			= _1,
	_An_@		= _2,
	_An_+		= _3,
	_An_-		= _4,
	_An_d		= _5,
	_An_dix		= _6,
	_IMM		= _7,
	_PC_d		= _7,
	_PC_dix		= _7,
	_ABS		= _7,

	;;; pseudo registers for Get_instr
	_reg_ABS	= _1,
	_reg_PC_d	= _2,
	_reg_PC_dix	= _3,
	_reg_IMM	= _4,

	;;; Some commonly used instructions
	_MOVL		= _16:2000,
	_MOVW		= _16:3000,
	_MOVB		= _16:1000,
	_CMPL		= _16:B080,

	;



	;;; register identifiers
	;;; value is popint reg number shifted left 1, plus bit 0 if pop reg
protected register constant
	pop_reg_A		=  5<<1 || 1,	;;; d5
	pop_reg_B		=  6<<1 || 1,	;;; d6
	nonpop_reg_A	= 11<<1,		;;; a3
	nonpop_reg_B	= 12<<1,		;;; a4
	nonpop_reg_C	= 13<<1,		;;; a5
	nonpop_reg_D	=  7<<1,		;;; d7

	arg_reg_0		= 0<<1,			;;; d0 = ARG_REG_0
	arg_reg_1		= 1<<1,			;;; d1
	arg_reg_2		= 2<<1,			;;; d2

	chain_reg		= 0<<1,			;;; CHAIN_REG = d0
	;


	;;; Lists of pop and nonpop registers for local vars, in order of
	;;; allocation. These lists start with a list of registers that should be
	;;; local to every procedure.
constant
	asm_pop_registers	= [%[], ident pop_reg_A, ident pop_reg_B%],
	asm_nonpop_registers= [%[], ident nonpop_reg_A, ident nonpop_reg_B,
								ident nonpop_reg_C, ident nonpop_reg_D%];


	;;; is item an address register? if so return integer value for reg
define Is_address_reg(item);
	lvars item;
	if (Is_register(item) ->> item) and item fi_>= 8 then item
	else false
	endif
enddefine;


	;;; working address register used by Get_rel_addr_efa and Get_structure_efa
lvars _tmp_An = _0;		;;; i.e. a0 by default


	;;; is item a data register? if so return integer value for reg
define lconstant Is_data_reg(item);
	lvars item;
	if (Is_register(item) ->> item) and item fi_< 8 then item
	else false
	endif
enddefine;


	;;; put a longword in the procedure record
define Drop_l(_longword);
	lvars _longword;
	unless _asm_pass then       ;;; just increment _asm_code_offset on _asm_pass
		_longword -> _asm_drop_ptr!(l)++ -> _asm_drop_ptr;
	endunless;
	@@(l){_asm_code_offset}++ -> _asm_code_offset;
enddefine;

	;;; put a word in the procedure record
define Drop_w(_word);
	lvars _word;
	unless _asm_pass then       ;;; just increment _asm_code_offset on _asm_pass
		_word -> _asm_drop_ptr!(s)++ -> _asm_drop_ptr;
	endunless;
	@@(s){_asm_code_offset}++ -> _asm_code_offset;
enddefine;

define lconstant Drop_+-_to(_efa, _num, _plus);
	lvars _num, _efa, _plus;
	if _1 _slteq _num and _num _slteq _8 then
		;;; use quick version
		if _plus then _16:5080 else _16:5180 endif _add _efa -> _efa;
		if _num == _8 then _0 -> _num endif;
		Drop_w(_shift(_num, _9) _add _efa)		;;; add/subql #_num, ?
	else
		;;; use long immediate version addil or subil
		Drop_w(if _plus then _16:0680 else _16:0480 endif _add _efa);
		Drop_l(_num)
	endif
enddefine;

	;;; set relevant (effective address) bits of _OPCODE,
	;;; MODE == _0 indicates register direct _REG will then be >= _0 <= _15
	;;; otherwise to be used as is
	;;; DEST indicates whether we're dealing with a destination operand in a
	;;; move instruction
define lconstant Get_instr(_mode, _reg, _code, todest);
	lvars _code, _mode, _reg, todest;
	if _reg _gr _7 then
		;;; address register
		_reg _sub _8 -> _reg;
		if _zero(_mode) then _1 -> _mode endif		;;; An direct
	endif;
	if todest then
		;;; efa is in movl dest position - _reg and _mode must be shifted left
		_shift(_reg, _9) -> _reg;
		_shift(_mode, _6) -> _mode;
	else
		_shift(_mode, _3) -> _mode
	endif;
	_code _add _reg _add _mode;
enddefine;

define lconstant Drop_lit_src(_destefa, _num);
	lvars _num, _destefa;
	if _-128 _slteq _num and _num _slteq _127 then
		;;; can use moveq
		_num _bimask _16:FF -> _num;
		if _destefa _bimask _16:F1C0 == _MOVL then
			;;; moving num to a data reg
			;;; moveq #_num, Dn
			Drop_w((_destefa _bimask _16:0E00) _add _num _add _16:7000)
		else
			Drop_w(_num _add _16:7600);		;;; moveq #_num, d3
			Drop_w(_destefa _add _16:03)	;;; op d3, efa
		endif
	else
		Drop_w(_destefa _add _16:3C);		;;; op #num, efa
		Drop_l(_num)
	endif
enddefine;

define lconstant Drop_Areg_offs_acc(_areg, _offs, _instr, todest);
	lvars _areg, _offs, _instr, todest;
	Drop_w(Get_instr(if _zero(_offs) then _An_@ else _An_d endif,
											_areg, _instr, todest));
	if _nonzero(_offs) then Drop_w(_offs) endif
enddefine;

	;;; move, etc, to or from immediate or abs address relative via struct table
	;;; _taboffs is the offset into the structure table
	;;; uses - _tmp_An - as a working address reg
define lconstant Get_rel_addr_efa(_taboffs, defer_offs);
	lvars defer_offs, _offs, _code, _index, _taboffs;
	_shift(_tmp_An, _9) _add _16:2040 -> _code;		;;; movl ?, _tmp_An
	;;; calculate offset for word offset to slot in table
	_taboffs _sub _strsize _sub _asm_code_offset _sub _2 -> _offs;
	if _big_procedure and _offs _slt _-16:7FFC then
		;;; if we can, use offset from start of procedure
		if (@@PD_TABLE{_taboffs} ->> _taboffs) _slt _16:8000 then
			;;; get procedure address from SF_OWNER
			Drop_w(_code _add _16:17);				;;; movl sp@, _tmp_An
			if defer_offs then
				;;; movl _tmp_An@(_taboffs), _tmp_An
				Drop_Areg_offs_acc(_tmp_An, _taboffs, _code, false);
				;;; drop thru for defer_offs efa
			else
				;;; efa is _tmp_An@(_taboffs)
				return(_taboffs, Drop_w, _An_d, _tmp_An)
			endif;
		else
			;;; use PC-relative longword offset
			Drop_w(_code _add _16:3C);				;;; movl #offset, _tmp_An
			Drop_l(_offs _sub _6);
			_shift(_tmp_An, _12) _add _16:8800 -> _index;	;;; long index _tmp_An
			if defer_offs then
				Drop_w(_code _add _16:3B);			;;; movl pc@(0, _tmp_An:L), _tmp_An
				Drop_w(_index)						;;; index _tmp_An, disp 0
				;;; drop thru for defer_offs efa
			else
				;;; efa is pc@(0, _tmp_An:L)
				return(_index, Drop_w, _PC_dix, _reg_PC_dix)
			endif
		endif
	else
		;;; word offset will be enough
		;;; mode = relative deferred / relative
		if defer_offs then
			Drop_w(_code _add _16:3A);			;;; movl pc@(d), _tmp_An
			Drop_w(_offs)						;;; offset
			;;; drop thru for defer_offs efa
		else
			;;; efa is pc@(offs), but offset needs recomputing when dropped
			return(_taboffs _sub _strsize,
						procedure(); Drop_w(() _sub _asm_code_offset) endprocedure,
						_PC_d, _reg_PC_d)
		endif
	endif;

	;;; reach here for defer_offs case -- efa is _tmp_An@(defer_offs)
	if defer_offs == 0 then
		(_0, erase, _An_@, _tmp_An)
	else
		(_int(defer_offs), Drop_w, _An_d, _tmp_An)
	endif
enddefine;

	;;; move, etc, to or from immediate or abs address
define lconstant Get_abs_addr_efa(_addr, defer_offs);
	lvars defer_offs, _addr;
#_IF DEF APOLLO_RELOC
	;;; all absolute addresses must go in structure table, so
	;;; as to be relocatable
	Get_rel_addr_efa(Structab_offset(_addr), defer_offs);
#_ELSE
	;;; efa is #_addr or _addr+defer_offs abs
	if defer_offs then
		(_addr@(b){_int(defer_offs)}, Drop_l, _ABS, _reg_ABS)
	else
		(_addr, Drop_l, _IMM, _reg_IMM)
	endif;
#_ENDIF
enddefine;

	;;; move, etc, to or from immediate or abs address
define lconstant Drop_abs_addr_instr(_code, todest) with_nargs 4;
	lvars todest, _code;
	Drop_w(Get_instr(Get_abs_addr_efa(/* _addr, defer_offs */), _code, todest));
	fast_apply()		;;; drop_pdr(_extn)
enddefine;

	;;; call subroutine
define lconstant Drop_jsr_abs() with_nargs 1;
	Drop_abs_addr_instr( (/* _routine */), 0, _16:4E80, false)
enddefine;

	;;; get effective address for a structure - relative to structure
	;;; address at start of code if in heap or absolute if not
	;;; uses - _tmp_An - as a working address register
	;;; MUST NOT USE any of arg_reg_0, 1, 2 (= d0, d1, d2)
define lconstant Get_structure_efa(_argnum, defer);
	lvars argstruct, defer, _argnum;
	lconstant macro IDVAL_OFFS = _pint(@@ID_VALOF);
	;;; replace structure with offset or reg ident on first pass (nonop
	;;; on subsequent passes)
	Trans_structure(asm_instr!INST_ARGS[_argnum])
							->> argstruct -> asm_instr!INST_ARGS[_argnum];
	if issimple(argstruct) then
		_int(argstruct) -> argstruct;		;;; offset as a sysint
		if _neg(argstruct) then
			;;; negated offset for on-stack var, shifted left 1
			;;; if bit 0 is set, access is via a run-time ident, i.e.
			;;; another indirection -- this is disabled by defer being false
			unless argstruct _bitst _1 then false -> defer endunless;
			_negate(_shift(argstruct, _-1)) -> argstruct;
			if defer then
				Drop_w(_shift(_tmp_An, _9) _add _16:206F); ;;; movl sp@(d), _tmp_An
				Drop_w(argstruct);
				;;; efa is _tmp_An@(IDVAL_OFFS)
#_IF IDVAL_OFFS == 0
				(_0, erase, _An_@, _tmp_An)
#_ELSE
				(_:IDVAL_OFFS, Drop_w, _An_d, _tmp_An)
#_ENDIF
			else
				;;; efa is sp@(offs)
				(argstruct, Drop_w, _An_d, _7)
			endif
		else
			;;; else via argstruct address in table
			Get_rel_addr_efa(argstruct,
								if defer then IDVAL_OFFS else false endif)
		endif
	else
		;;; absolute or literal
		if (Is_register(argstruct) ->> _argnum) then
			unless defer then
				mishap(0, 'REGISTER USED AS IMMEDIATE OPERAND')
			endunless;
			;;; efa is Dn or An
			(_0, erase, _Rn, _int(_argnum))
		else
			;;; absolute on idval or literal structure address
			Get_abs_addr_efa(argstruct,
								if defer then IDVAL_OFFS else false endif)
		endif
	endif;
enddefine;

	;;; plant operand for a structure
define lconstant Drop_structure(_code, todest) with_nargs 4;
	lvars todest, _code;
	Drop_w(Get_instr(Get_structure_efa(/* _argnum, defer */), _code, todest));
	fast_apply()		;;; drop_pdr(_extn)
enddefine;

define lconstant Code_structure(_argnum) -> argstruct;
	lvars argstruct, _argnum;
	;;; replace structure with offset or reg ident on first pass (nonop
	;;; on subsequent passes)
	Trans_structure(asm_instr!INST_ARGS[_argnum])
							->> argstruct -> asm_instr!INST_ARGS[_argnum]
enddefine;

define lconstant Code_structure_instr(asm_instr) with_nargs 2;
	dlocal asm_instr;
	Code_structure()
enddefine;


;;; --- FIELD ACCESS INSTRUCTIONS (used by "conskey") --------------------


lconstant
	t_SGN_BYTE	= t_BYTE||t_SIGNED,
	t_SGN_SHORT	= t_SHORT||t_SIGNED,
	t_SGN_WORD	= t_WORD||t_SIGNED,
	;


lconstant

	field_ops	= list_assoc_val(% [%
					t_BYTE,			_pint(_MOVB),
					t_SHORT,		_pint(_MOVW),
					t_WORD,			_pint(_MOVL),
					t_SGN_BYTE,		_pint(_MOVB),
					t_SGN_SHORT,	_pint(_MOVW),
					t_SGN_WORD,		_pint(_MOVL)
					%] %),

	field_shift	= list_assoc_val(% [%
					t_BYTE,			-2,
					t_SHORT,		-1,
					t_WORD,			 0,
					t_DOUBLE,		 1,
					t_SGN_BYTE,		-2,
					t_SGN_SHORT,	-1,
					t_SGN_WORD,		 0
					%] %),

	;

lconstant _GET_ADDR = _16:41C0;		;;; lea ?, a0

define lconstant Drop_exptr_deref(exptr, _areg) -> _areg;
	lvars exptr, _areg;
	fast_repeat exptr times
		;;; movl a?@, a0
		Drop_Areg_offs_acc(_areg, _0, Get_instr(_An, _8, _MOVL, true), false);
		_8 -> _areg			;;; a0
	endrepeat
enddefine;

define lconstant Call_vecsub_mult(_size);
	lvars _size;
	Drop_lit_src(_16:2200, _size);		;;; mov #_size, d1
	Drop_jsr_abs(_vecsub_mult)			;;; subscript converter to d0
enddefine;

define lconstant Do_field(_instr, type, _size, opnd, offset, todest, exptr);
	lvars	type, todest, opnd, offset, _offs, _reg, _areg, _n, _instr,
			_size, exptr;

	;;; move structure address to address reg
	unless opnd then
		;;; operand on the stack
		if _instr /== _GET_ADDR or exptr or offset /== 0 then
			;;; get operand from stack
			Drop_w(_16:205E);					;;; movl a6@+, a0
			_8 -> _areg							;;; a0
		else
			;;; pushing address of pop struct at 0 offset -- nothing to do
			return
		endif
	elseif Is_register(Trans_structure(opnd)) ->> _areg then
		_int(_areg) -> _areg;
		if _areg _lteq _7 then
			;;; data reg
			Drop_w(_16:2040 _add _areg);	;;; movl dn, a0
			_8 -> _areg						;;; a0
		endif
	else
		mishap(0, 'SYSTEM ERROR 1 IN Do_field')
	endunless;

	if exptr then
		;;; deref exptr times (to a0)
		Drop_exptr_deref(exptr, _areg) -> _areg
	endif;

	unless offset then
		;;; vector subscript on stack - move it to d1 or d0
		;;; movl a6@+, d0 or d1
		Drop_w(if _size /== 1 then _16:201E else _16:221E endif)
	endunless;

	if todest then
		;;; unless longword field, move new value from userstack to d0
		if type == t_WORD then
			_An_+ -> _instr, _14 -> _reg	;;; a6+
		else
			Drop_w(_16:201E);				;;; movl a6@+, d0
			_Dn -> _instr, _0 -> _reg
		endif;
		Get_instr(_instr, _reg, _int(field_ops(type)), false) -> _instr
	endif;

	if isinteger(offset) then
		;;; fixed field
		_shift(_int(offset), _-3) -> _offs; ;;; convert bit offset to bytes
		if _zero(_offs) and _instr == _GET_ADDR then
			;;; pushing addr at 0 offset -- just stack _areg
			Drop_w(_16:2D00 _add _areg);			;;; movl an, a6@-
			return
		endif;
		Drop_Areg_offs_acc(_areg, _offs, _instr, todest)
	else
		;;; vector field -- offset must be a register or false
		if offset then
			unless Is_register(Trans_structure(offset)) ->> _reg then
				mishap(0, 'SYSTEM ERROR 2 IN Do_field')
			endunless;
			_int(_reg) -> _reg
		else
			;;; if false, subscript was on stack, now in d0 or d1
			if _size /== 1 then _0 else _1 endif -> _reg
		endif;
		field_shift(type) -> _n;

		if _size == 1 then
			;;; normal case
			1 -> _offs;			;;; popint 1 for base 1 and popint bits
			_int(_n) -> _n;
			unless _zero(_n) then
				if _reg _gr _7 then
					;;; addr reg -- move to d1
					Drop_w(_reg _sub _8 _add _16:2208);		;;; movl An, d1
					_1 -> _reg
				endif;
				_shift(_offs, _n) -> _offs;
				if _neg(_n) then
					_negate(_n) -> _n;
					_16:E080
				else
					_16:E180
				endif;
				;;; asl/rl #n, dn
				Drop_w(() _add _shift(_n,_9) _add _reg)
			endunless;
			@@V_WORDS-{_offs} _bimask _16:FF -> _offs
		else
			;;; pushing addr of array of compound external fields
			;;; shifting no good, need to multiply
			if offset then
				Drop_w(_16:2000 _add _reg);		;;; movl rn, d0
				_0 -> _reg
			endif;
			Call_vecsub_mult(_int(_size fi_<< (_n fi_+ 2)));
			_0 -> _offs
		endif;

		Drop_w(Get_instr(_An_dix, _areg, _instr, todest));
		;;; if _reg is an addr reg then bit 15 will be set...
		Drop_w(_shift(_reg,_12) _add _16:0800 _add _offs)
	endif;

	if _instr == _GET_ADDR then
		;;; stack address
		Drop_w(_16:2D08)			;;; movl a0, a6@-
	endif
enddefine;

define lconstant Do_bitfield(type, _size, opnd, offset, todest, exptr);
	lvars type, todest, opnd, offset, _size, _reg, exptr, _offs;

	;;; move structure address to a0
	unless opnd then
		;;; structure is on top of user stack
		Drop_w(_16:205E)						;;; movl a6@+, a0
	elseif Is_register(Trans_structure(opnd)) ->> _reg then
		Drop_w(_16:2040 _add _int(_reg))		;;; movl rn, a0
	else
		mishap(0, 'SYSTEM ERROR 1 IN Do_bitfield')
	endunless;

	if exptr then
		;;; deref exptr times (to a0)
		Drop_exptr_deref(exptr, _8) ->
	endif;

	_int(_size) -> _size;
	if isinteger(offset) then
		;;; record field
		Drop_lit_src(_16:2000, _int(offset))	;;; mov #offset, d0
	else
		;;; vector field
		if offset then
			unless Is_register(Trans_structure(offset)) ->> _reg then
				mishap(0, 'SYSTEM ERROR 2 IN Do_bitfield')
			endunless;
			_int(_reg) -> _reg;
			Drop_w(Get_instr(_Rn, _reg, _MOVL, false))	;;; movl rn, d0
		else
			;;; subscript on user stack - move to d0
			Drop_w(_16:201E)					;;; movl a6@+, d0
		endif;
		Call_vecsub_mult(_size)
	endif;

	;;; field size to d1
	Drop_lit_src(_16:2200, _size);			;;; mov #size, d1

	;;; signed/unsigned/updater routine
	Drop_jsr_abs(	if todest then _ubfield
					elseif type == t_BIT then _bfield
					else _sbfield
					endif)
enddefine;

define I_PUSH_FIELD();
	lvars type, cvtpint, size, opnd, offset, _opcode,  exptr;
	explode(asm_instr) -> exptr -> cvtpint -> offset -> opnd -> size -> type
																	-> ;

	if type fi_&& t_BASE_TYPE == t_BIT then
		;;; bitfield
		Do_bitfield(type, size, opnd, offset, false, exptr)
	else
		;;; size = 1 always
		_int(field_ops(type)) -> _opcode;
		if type == t_WORD and not(cvtpint) then
			;;; stack it directly
			Do_field(Get_instr(_An_-, _14, _opcode, true), type, 1, opnd,
													offset, false, exptr);
			return
		elseif type == t_BYTE or type == t_SHORT then
			;;; unsigned byte, short
			Drop_w(_16:7000)				;;; moveq #0, d0
		endif;
		;;; move field to d0
		Do_field(Get_instr(_Dn, _0, _opcode, true), type, 1, opnd,
													offset, false, exptr);
		if type = t_SGN_BYTE then
			;;; signed byte
			Drop_w(_16:4880);				;;; extw d0
			t_SGN_SHORT  -> type			;;; extend that to long
		endif;
		if type = t_SGN_SHORT then
			;;; signed short
			Drop_w(_16:48C0)				;;; extl d0
		endif
	endif;

	if cvtpint then
		;;; convert to popint
		Drop_w(_16:E580);					;;; asll #2, d0
		Drop_w(_16:5680)					;;; addql #3, d0
	endif;
	;;; stack result
	Drop_w(_16:2D00)						;;; movl d0, a6@-
enddefine;

define I_POP_FIELD();
	lvars type, size, opnd, offset, _mode, _reg, exptr;
	explode(asm_instr) -> exptr -> offset -> opnd -> size -> type -> ;

	if type fi_&& t_BASE_TYPE == t_BIT then
		Do_bitfield(type, size, opnd, offset, true, exptr)
	else
		;;; size = 1 always
		Do_field(_0, type, 1, opnd, offset, true, exptr)
	endif
enddefine;

define I_PUSH_FIELD_ADDR();
	lvars offset, type, opnd, size, exptr;
	explode(asm_instr) -> exptr -> offset -> opnd -> size -> type -> ;
	;;; move the field address to stack
	Do_field(_GET_ADDR, type, size, opnd, offset, false, exptr)
enddefine;


;;; --- PROCEDURES FOR INDIVIDUAL INSTRUCTIONS ------------------------------

define lconstant Get_destin_efa();
	if asm_instr!V_LENGTH == _2 then
		_0, erase, _16:2D00		;;; movl ?, a6@-
	else
		;;; destination id specified
		_1 -> _tmp_An;			;;; use a1 (if necessary) for destination efa
		Get_instr(Get_structure_efa(_1, true), _MOVL, true);
		_0 -> _tmp_An			;;; back to a0 (if necessary) for source efa
	endif;
enddefine;

	;;; move instructions
define lconstant Drop_move(defer);
	lvars defer, _efa;
	Get_destin_efa() -> _efa;
	Drop_w(Get_instr(Get_structure_efa(_0, defer), _efa, false));
	fast_apply();			;;; drop source extension (if any)
	fast_apply()			;;; drop destination extension (if any)
enddefine;

define I_MOVE	= Drop_move(%true%)  enddefine;
define I_MOVEQ	= Drop_move(%false%) enddefine;

define I_MOVENUM();
	Drop_lit_src(Get_destin_efa(), asm_instr!INST_ARGS[_0]);
	fast_apply()			;;; drop destination extension if any
enddefine;

#_IF DEF APOLLO_RELOC

define I_MOVEADDR();
	lvars _efa;
	Get_destin_efa() -> _efa;
	Drop_abs_addr_instr(asm_instr!INST_ARGS[_0], false, _efa, false);
	fast_apply()			;;; drop destination extension if any
enddefine;

#_ELSE

constant procedure I_MOVEADDR = I_MOVENUM;

#_ENDIF


define I_MOVES();				;;; move stack, i.e. dup
	Drop_w(_16:2D16);			;;; movl a6@, a6@-
enddefine;

define I_MOVE_CALLER_RETURN();
	fast_chain(asm_instr!INST_ARGS[_2])		;;; I_MOVE or I_MOVEADDR
enddefine;

	;;; push an unsigned sysint, represented as a pop (big)integer
define I_PUSH_UINT();
	;;; movl #xxx, a6@-
	Drop_lit_src(_16:2D00, Pint_->_uint(asm_instr!INST_ARGS[_0], _-1))
enddefine;

define I_POP();
	Drop_structure(_0, true, _16:201E, true);	;;; movl a6@+, ?
enddefine;

	;;; pop into quoted variable
	;;; only meaningful with an lvar containing a run-time id
define I_POPQ();
	Drop_structure(_0, false, _16:201E, true);	;;; movl a6@+, ?
enddefine;

define I_STORE();
	Drop_structure(_0, true, _16:2016, true);	;;; movl a6@, ?
enddefine;

define I_ERASE();
	Drop_w(_16:4A9E);				;;; tstl a6@+
enddefine;

define I_SWAP();
	lvars _i _j;
	@@(w)[_int(asm_instr!INST_ARGS[_0])] -> _i;
	@@(w)[_int(asm_instr!INST_ARGS[_1])] -> _j;
	Drop_w(_16:202E); Drop_w(_i);				;;; movl a6@(i), d0
	Drop_w(_16:2D6E); Drop_w(_j); Drop_w(_i);	;;; movl a6@(j), a6@(i)
	Drop_w(_16:2D40); Drop_w(_j);				;;; movl d0, a6@(j)
enddefine;


define lconstant Drop_fsource(_sourcearg) with_nargs 4;
	lvars instr, op, _sourcearg, _destefa;
	dlocal asm_instr;
	Get_instr(/* _mode, _reg, _opcode, */ true) -> _destefa;
	if (asm_instr!INST_ARGS[_sourcearg] ->> instr) then
		;;; specified by move instruction
		if (instr!INST_OP ->> op) == I_MOVENUM then
			Drop_lit_src(_destefa, instr!INST_ARGS[_0])	;;; op #num, efa
#_IF DEF APOLLO_RELOC
		elseif op == I_MOVEADDR then
			Drop_abs_addr_instr(instr!INST_ARGS[_0], false, _destefa, false)
#_ENDIF
		else
			instr -> asm_instr;
			;;; op ?, efa
			Drop_structure(_0, op==I_MOVE, _destefa, false)
		endif
	else
		;;; from stack
		Drop_w(_destefa _add _16:1E)		;;; op a6@+, efa
	endif
enddefine;

define lconstant Drop_fdestin(_offs);
	lvars instr, _offs, _efa;
	dlocal asm_instr;
	;;; plant destination operand for fast field access from a1
	;;; see if can optimise a following pop
	fast_front(fast_back(asm_clist)) -> instr;
	if isvector(instr) and instr!INST_OP == I_POP then
		fast_back(asm_clist) -> asm_clist;			;;; erase the I_POP
		instr -> asm_instr;
		Get_instr(Get_structure_efa(_0, true), _0, true)
	else
		_0, erase, _16:0D00					;;; dest efa for a6@-
	endif -> _efa;
	if _zero(_offs) then
		Drop_w(_efa _add _16:2011)			;;; movl a1@, efa
	else
		Drop_w(_efa _add _16:2029);			;;; movl a1@(_offs), efa
		Drop_w(_offs)
	endif;
	fast_apply(/* drop_pdr(_extn) */)		;;; extn for structure
enddefine;

define I_FASTFIELD();
	lvars _offs;
	asm_instr!INST_ARGS[_0] -> _offs;	;;; false if fast_destpair
	Drop_fsource(_An, _1, _MOVL, _1);	;;; movl ?, a1
	unless _offs then
		;;; fast_destpair
		Drop_w(_16:2D29);				;;; movl a1@(P_FRONT), a6@-
		Drop_w(@@P_FRONT);
		_pint(@@P_BACK) -> _offs
	endunless;
	Drop_fdestin(_int(_offs))			;;; movl a1@(offset), ?
enddefine;

define I_UFASTFIELD();
	lvars _offs;
	_int(asm_instr!INST_ARGS[_0]) -> _offs;
	Drop_fsource(_An, _1, _MOVL, _1);	;;; movl ?, a1
	if _zero(_offs) then
		Drop_w(_16:229E)				;;; movl a6@+, a1@
	else
		Drop_w(_16:235E);				;;; movl a6@+, a1@(offset)
		Drop_w(_offs)
	endif
enddefine;

define I_FASTSUBV();
	Drop_fsource(_An, _1, _MOVL, _1);	;;; movl ?, a1
	Drop_w(_16:D3DE);					;;; addl a6@+, a1
	;;; arg 0 is offset to vector elements as popint -- subtract popint 1
	;;; to account for base 1 subscript and popint bits
	Drop_fdestin(_int(asm_instr!INST_ARGS[_0]) _sub 1)	;;; movl a1@(offs), ?
enddefine;

define I_UFASTSUBV();
	Drop_fsource(_An, _1, _MOVL, _1);	;;; movl ?, a1
	Drop_w(_16:D3DE);					;;; addl a6@+, a1
	Drop_w(_16:235E);					;;; movl a6@+, a1@(base)
	;;; arg 0 is offset to vector elements as popint -- subtract popint 1
	;;; to account for base 1 subscript and popint bits
	Drop_w(_int(asm_instr!INST_ARGS[_0]) _sub 1)	;;; base offset
enddefine;


;;; --- FAST INTEGER + AND - -------------------------------------------

	;;; {I_FAST_+-_2 <plusflag> <operand 1> <operand 2/destination>}
define I_FAST_+-_2();
	lvars instr = asm_instr, opnd, _efa, _plus;
	dlocal asm_instr;
	instr!INST_ARGS[_0] -> _plus;
	if instr!INST_ARGS[_2] ->> asm_instr then
		_1 -> _tmp_An;				;;; use a1 if necessary
		Get_instr(Get_structure_efa(_0, true), _0, false) -> _efa;
		_0 -> _tmp_An;				;;; back to a0
	else
		_0, erase, _16:16 -> _efa	;;; efa for a6@
	endif;
	instr -> asm_instr;
	if (instr!INST_ARGS[_1] ->> opnd) and opnd!INST_OP == I_MOVENUM then
		;;; add/subl #num, efa
		Drop_+-_to(_efa, opnd!INST_ARGS[_0] _biclear _3, _plus);
	else
		Drop_fsource(_Dn, _0, _MOVL, _1);	;;; movl num, d0
		Drop_w(_16:5780);					;;; subql #3, d0
		;;; addl/subl d0, ?
		if _zero(_efa _bimask _16:38) then
			;;; dest a data reg
			_shift(_efa _bimask _16:07, _9) -> _efa;
			if _plus then _16:D080 else _16:9080 endif
		else
			if _plus then _16:D180 else _16:9180 endif
		endif;
		Drop_w(() _add _efa)
	endif;
	fast_apply(/* drop_pdr(extn) */)
enddefine;

	;;; {I_FAST_+-_3 <plusflag> <operand 1> <operand 2> <destination>}
define I_FAST_+-_3();
	lvars instr = asm_instr, opnd, _plus;
	instr!INST_ARGS[_0] -> _plus;
	if (instr!INST_ARGS[_1] ->> opnd) and opnd!INST_OP == I_MOVENUM then
		Drop_fsource(_Dn, _1, _MOVL, _2);		;;; movl arg2, d1
		;;; add/subl #num, d1
		Drop_+-_to(_16:01, opnd!INST_ARGS[_0] _biclear _3, _plus);
	else
		Drop_fsource(_Dn, _0, _MOVL, _1);		;;; movl num, d0
		Drop_w(_16:5780);						;;; subql #3, d0
		Drop_fsource(_Dn, _1, _MOVL, _2);		;;; movl arg2, d1
		;;; addl/subl d0, d1
		Drop_w(if _plus then _16:D280 else _16:9280 endif)
	endif;
	;;; result now in d1
	if instr!INST_ARGS[_3] then
		Drop_structure(_3, true, _16:2001, true)	;;; movl d1, dest
	else
		Drop_w(_16:2D01)						;;; movl d1, a6@-
	endif
enddefine;


;;; --- CALL INSTRUCTIONS -----------------------------------------------

lconstant macro USER = 0; 		;;; indicates userstack is arg

	;;; for call instructions
define lconstant Drop_call(defer, _routine);
	lvars defer, _routine, _instr;
	if _routine then _16:2000 else _16:2040 endif -> _instr; ;;; movl ?, d0/a0
	if defer == USER then
		Drop_w(_instr _biset _16:1E)				;;; movl a6@+, d0/a0
	else
		Drop_structure(_0, defer, _instr, false)	;;; movl ?, d0/a0
	endif;
	if _routine then
		;;; call via check routine
		Drop_jsr_abs(_routine)						;;; jsr to _routine
	else
		;;; call direct
		;;;  a0@(PD_EXECUTE) -- relies on PD_EXECUTE field having 0 offset
		Drop_l(_16:20504E90)						;;; movl a0@, a0; jsr a0@
	endif
enddefine;

define I_CALL	= Drop_call(%true,  _popenter%) enddefine;
define I_CALLQ	= Drop_call(%false, _popenter%) enddefine;
define I_CALLP	= Drop_call(%true,  false%)		enddefine;
define I_CALLS	= Drop_call(%USER,  _popenter%) enddefine;
define I_CALLPS	= Drop_call(%USER,  false%)		enddefine;

define I_CALLPQ();
	lvars p, _xoffs;

	define lconstant cpq_xoffs();
		Drop_structure(_0, false, _16:2040, false);		;;; movl ?, a0
		Drop_w(_16:4EA8);								;;; jsr a0@(_xoffs)
		Drop_w(_int(asm_instr!INST_ARGS[_1]))
	enddefine;

	if _asm_pass == 0 then
		asm_instr!INST_ARGS[_0] -> p;
		@@(code){p!PD_EXECUTE, p} -> _xoffs;		;;; offset to code start
		if _zero(_xoffs _biclear _16:7FFF) then
			;;; within 16-bit displacement -- call as jsr a0@(_xoffs)
			;;; with a0 containing the procedure directly (i.e. don't
			;;; need to bother with PD_EXECUTE)
			Cons_inst(cpq_xoffs, p, _pint(_xoffs), 3)
								->> asm_instr -> fast_front(asm_clist);
			chain(cpq_xoffs)
		endif
	endif;

	Drop_call(false, false)
enddefine;


	;;; long jump to offset _offs
define lconstant Drop_long_jump(_offs);
	lvars _offs;
	Drop_w(_16:207C);				;;; movl #offset, a0
	Drop_l(_offs _sub _asm_code_offset _sub _6);
	Drop_w(_16:4EFB);				;;; jmp pc@(0,a0:L)
	Drop_w(_16:8800);				;;; d=0, longword index in a0
enddefine;

	;;; call system procedure
define I_CALLABS();
	Drop_jsr_abs(asm_instr!INST_ARGS[_0]!PD_EXECUTE)	;;; jsr to entry address
enddefine;

	;;; {I_CHAIN_REG <reg ident>}
	;;; chain procedure in reg
define I_CHAIN_REG();
	Drop_structure(_0, true, _16:2040, false);	;;; movl reg, a0
	Drop_l(_16:20504ED0)						;;; movl a0@, a0; jmp a0@
enddefine;

	;;; call subroutine
define I_CALLSUB();
	Drop_jsr_abs(asm_instr!INST_ARGS[_0])	;;; jsr to entry address
enddefine;

	;;; chain subroutine
define I_CHAINSUB();
	;;; jmp _routine
	Drop_abs_addr_instr(asm_instr!INST_ARGS[_0], 0, _16:4EC0, false)
enddefine;

	;;; call subroutine via reg or address
define I_CALLSUB_REG();
	lvars _addr, _reg;
	fast_front(asm_instr!INST_ARGS[_0]) -> _addr;
	if Is_register(_addr) ->> _reg then
		;;; jsr An@ (-8 to get An)
		Drop_w(_int(_reg) _add (_16:4E90 _sub _8))
	else
		;;; jsr to entry address
		Drop_jsr_abs(_addr)
	endif
enddefine;

define I_UCALL	= Drop_call(%true,  _popuenter%)	enddefine;
define I_UCALLQ	= Drop_call(%false, _popuenter%)	enddefine;
define I_UCALLP	= Drop_call(%true,  _popuncenter%)	enddefine;
define I_UCALLPQ= Drop_call(%false, _popuncenter%)	enddefine;
define I_UCALLS	= Drop_call(%USER,  _popuenter%)	enddefine;
define I_UCALLPS= Drop_call(%USER,  _popuncenter%)	enddefine;


define I_BRCOND(_ifso, _ifnot, is_so, _broffset, _argnum);
	lvars is_so, _argnum, _br, _pass = _asm_pass, _broffset, _ifso, _ifnot;

	define lconstant Brcond_byte(_ifso, _ifnot, is_so, _broffset, _argnum);
		lvars is_so, _broffset, _ifso, _ifnot, _argnum;
		(_broffset _sub _asm_code_offset _sub _2) _bimask _16:FF -> _broffset;
		if _zero(_broffset) then
			;;; just in case -- no-op it out
			Drop_w(_16:4E71)		;;; nop
		else
			Drop_w(	if is_so then
						_ifso				;;; opcode for ifnot, or etc
					else
						_ifnot				;;; opcode for ifso, and etc
					endif _add _broffset);
		endif
	enddefine;

	define lconstant Brcond_long(_ifso, _ifnot, is_so, _broffset, _argnum);
		lvars is_so, _broffset, _ifso, _ifnot, _argnum;
		;;; branch round a relative jmp, so swop ifso/ifnot opcodes
		;;; long jump occupies 10 bytes
		Drop_w(	if is_so then
					_ifnot				;;; br ifnot +10
				else
					_ifso				;;; br ifso +10
				endif _add _10);
		Drop_long_jump(_broffset)
	enddefine;

	_broffset _sub _asm_code_offset _sub _2 -> _br;
	if not(_pass) then
		;;; last pass -- plant default code (word branch)
		Drop_w(	if is_so then
					_ifso					;;; opcode for ifnot, or etc
				else
					_ifnot					;;; opcode for ifso, and etc
				endif);
		Drop_w(_br)
	elseif _pass == 0 then
		;;; first pass -- just increment offset by default code space
		_asm_code_offset _add _4 -> _asm_code_offset
	elseif _pass == 2 then
		;;; extra optimising -- see if branch offset fits in a byte
		if _br _sgr _0 then
			;;; forward -- correct for previous savings
			_br _add _asm_offset_diff -> _br
		endif;
		if _-16:80 _slteq _br and _br _slt _16:80 then
			;;; change branch routine for next pass
			Brcond_byte -> asm_instr!INST_ARGS[_argnum];
			_asm_offset_diff _sub _2 -> _asm_offset_diff;	;;; saved 2 bytes
			_asm_code_offset _add _2 -> _asm_code_offset
		else
			_asm_code_offset _add _4 -> _asm_code_offset
		endif
	else
		;;; extra pass (= 1) for big procedure
		if _br _slt _-16:8000 or _br _sgreq _16:4000 then
			;;; need a br round a relative jmp with longword offset
			;;; change branch routine for next pass
			Brcond_long -> asm_instr!INST_ARGS[_argnum];
			_asm_code_offset _add _12 -> _asm_code_offset	;;; long jump
		else
			_asm_code_offset _add _4 -> _asm_code_offset
		endif
	endif
enddefine;

	;;; call the I_BRCOND routine for an I_IF_opt, I_BOOL_opt or I_IF_CMP
	;;; apply the conditional branch routine in arg2
	;;; (initial branch routine is I_BRCOND)
define lconstant Drop_if(instr) with_nargs 3;		;;; ifso/ifnot codes on stack
	lvars instr;
	dlocal asm_instr = instr;
	fast_apply(/* ifso, ifnot */
				instr!INST_ARGS[_1],
				_int(fast_front(instr!INST_ARGS[_0])),
				_2,
				instr!INST_ARGS[_2]);
enddefine;

define I_IF_opt();
	lvars instr = asm_instr;
	;;; d4 always contains false
	;;; drop cmpl input operand or stack pop with d4
	Drop_fsource(_Dn, _4, _CMPL, _3);			;;; cmpl ?, d4
	Drop_if(_16:6600, _16:6700,	asm_instr)		;;; IFSO/bne, IFNOT/beq
enddefine;

define I_BOOL_opt();
	lvars instr = asm_instr, opnd;
	;;; if there's an explicit operand, we have to push it
	if (instr!INST_ARGS[_3] ->> opnd) then
		Drop_I_code(opnd)
	endif;
	;;; d4 always contains false
	Drop_w(_16:B896);				;;; cmpl a6@, d4
	Drop_if(_16:6600, _16:6700,	asm_instr);		;;; OR/bne, AND/beq
	;;; erase it when branch not taken
	Drop_w(_16:588E)				;;; addql #4, a6
enddefine;


	;;; {I_IF_CMP <_routine> <operand 1> <operand 2> <I_IF_opt instr>}
define I_IF_CMP();
	lvars instr = asm_instr, opnd, _reg, _type;

	lconstant compare_ops =
			[%	nonop _eq,    16:6700, 16:6600,
				nonop _neq,   16:6600, 16:6700,
				nonop _sgr,   16:6E00, 16:6F00,
				nonop _slteq, 16:6F00, 16:6E00,
				nonop _slt,   16:6D00, 16:6C00,
				nonop _sgreq, 16:6C00, 16:6D00
			%];

	;;; plant compare instruction for operands
	if instr!INST_ARGS[_1] then
		if (instr!INST_ARGS[_2] ->> opnd) and opnd!INST_OP == I_MOVE
		and (Is_data_reg(Code_structure_instr(_0, opnd)) ->> _reg) then
			_int(_reg) -> _reg
		else
			Drop_fsource(_Dn, _1, _MOVL, _2);	;;; movl arg2, d1
			_1 -> _reg
		endif;
		Drop_fsource(_Dn, _reg, _CMPL, _1)		;;; cmpl arg1, reg or d1
	else
		;;; both from stack
		Drop_w(_16:BD8E)						;;; cmpml a6@+, a6@+
	endif;

	;;; get ifso/ifnot br opcodes for compare subroutine
	fast_back(lmember(instr!INST_ARGS[_0], compare_ops)) -> _type;
	;;; do the I_IF_opt
	Drop_if(_int(fast_front(_type)),			;;; opcode for SO
			_int(fast_front(fast_back(_type))),	;;; opcode for NOT
			instr!INST_ARGS[_3])
enddefine;

	;;; branch with default (word) offset
define I_BR_std(_broffset, _argnum);
	lvars _broffset, _argnum;
	Drop_w(_16:6000);						;;; bra
	Drop_w(_broffset _sub _asm_code_offset)	;;; word displacement
enddefine;

define I_BR(_broffset, _argnum);
	lvars _br, _argnum, _broffset, _pass = _asm_pass;

	;;; branch with byte offset
	define lconstant Br_byte(_broffset, _argnum);
		lvars _broffset, _argnum;
		(_broffset _sub _asm_code_offset _sub _2) _bimask _16:FF -> _broffset;
		if _zero(_broffset) then
			;;; just in case -- no-op it out
			Drop_w(_16:4E71)		;;; nop
		else
			Drop_w(_broffset _add _16:6000)
		endif
	enddefine;

		;;; branch with long offset
	define lconstant Br_long(_broffset, _argnum);
		lvars _broffset, _argnum;
		;;; give target offset to Drop_long_jump
		Drop_long_jump(_broffset)
	enddefine;

	_broffset _sub _asm_code_offset _sub _2 -> _br;
	if not(_pass) then
		;;; last pass -- drop code for default bra
		Drop_w(_16:6000);				;;; bra
		Drop_w(_br)						;;; word displacement
	elseif _pass == 0 then
		;;; first pass -- just increment offset for default bra
		_asm_code_offset _add _4 -> _asm_code_offset
	elseif _pass == 2 then
		;;; extra optimising -- see if br offset fits in a byte
		if _br _sgr _0 then
			;;; forward -- correct for previous savings
			_br _add _asm_offset_diff -> _br
		endif;
		if _br == _2 then
			;;; don't need it at all
			#_< erasenum(%2%) >_# -> asm_instr!INST_ARGS[_argnum];
			_asm_offset_diff _sub _4 -> _asm_offset_diff	;;; saved 4 bytes
		elseif _-16:80 _slteq _br and _br _slt _16:80 then
			;;; bras with byte offset will do
			Br_byte -> asm_instr!INST_ARGS[_argnum];
			_asm_offset_diff _sub _2 -> _asm_offset_diff;	;;; saved 2 bytes
			_asm_code_offset _add _2 -> _asm_code_offset
		else
			_asm_code_offset _add _4 -> _asm_code_offset
		endif
	else
		;;; extra pass (= 1) for big procedure
		if _br _slt _-16:8000 or _br _sgreq _16:4000 then
			;;; need long offset -- change for next pass
			Br_long -> asm_instr!INST_ARGS[_argnum];
			_asm_code_offset _add _10 -> _asm_code_offset	;;; rel jmp
		else
			_asm_code_offset _add _4 -> _asm_code_offset
		endif
	endif
enddefine;

	;;; {I_SWITCH <label list> <else label> <operand>}
define I_SWITCH();
	lvars lablist, _laboffset, _base;
	asm_instr!INST_ARGS[_0] -> lablist;
	listlength(lablist) -> _laboffset;	;;; no of entries in switch table

	Drop_fsource(_Dn, _0, _MOVL, _2);	;;; movl operand, d0
	Drop_w(_16:0C80);					;;; cmpi #limit, d0
	Drop_l(_laboffset);  				;;; #limit  - POP integers
	Drop_w(_16:6200);					;;; bhi after switch table
	Drop_w(_int(_laboffset*4 + 10));
	Drop_w(_16:4EFB);					;;; jmp pc@(d,ix)
	Drop_w(_16:08FF);					;;; -1 index d0:l
	;;; the branch to trap 0
	Drop_w(_16:6000);					;;; bra
	Drop_w(_int(_laboffset*4 + 2));		;;; offset to after switch table
	;;; switch table
	until lablist == [] do
		fast_front(destpair(lablist) -> lablist) -> _laboffset;
		Drop_w(_16:6000);				;;; bra
		Drop_w(_int(_laboffset) _sub _asm_code_offset);	;;; offset to label
	enduntil;
	unless asm_instr!INST_ARGS[_1] then
		;;; no else label, so put arg back on stack
		Drop_w(_16:2D00);				;;; movl d0, a6@-
	endunless;
enddefine;

	;;; {I_PLOG_IFNOT_ATOM <ifnot_label} I_BRCOND}
define I_PLOG_IFNOT_ATOM();
	lvars instr = asm_instr;
	lconstant _FLAB = _0, _FBR = _1;
	;;; apply the conditional branch routine in arg1
	;;; (initial branch routine is I_BRCOND)
	fast_apply(_16:6600, _16:6700,			;;; bne, beq
				true,						;;; select bne
				_int(fast_front(instr!INST_ARGS[_FLAB])),
				_FBR,
				instr!INST_ARGS[_FBR])
enddefine;

	;;; {I_PLOG_TERM_SWITCH <fail_label} I_BRCOND <var_label> I_BRCOND}
	;;; after call to plog switch routine, switch afterwards to var_label,
	;;; fail_label or drop thru.
define I_PLOG_TERM_SWITCH();
	lvars instr = asm_instr;
	lconstant _FLAB = _0, _FBR = _1, _VLAB = _2, _VBR = _3;
	;;; branch if greater than set to var_label
	fast_apply(_16:6E00, _16:6F00,			;;; SO/bgt, NOT/ble
				true,
				_int(fast_front(instr!INST_ARGS[_VLAB])),
				_VBR,
				instr!INST_ARGS[_VBR]);
	;;; branch if less than set to fail_label
	fast_apply(_16:6D00, _16:6C00,			;;; SO/blt, NOT/bge
				true,
				_int(fast_front(instr!INST_ARGS[_FLAB])),
				_FBR,
				instr!INST_ARGS[_FBR]);
	;;; else fall thru for pair/term case (push on arg_reg_0 follows)
enddefine;


	;;; plant checks on backward jumps
define I_CHECK();
	lvars _save;
	Drop_abs_addr_instr(ident _trap, 0, _16:4A80, false);	;;; tstl _trap
	Drop_w(_16:6600);				;;; bnes to the jsr _checkall
	_asm_drop_ptr -> _save;			;;; addr of byte after offset

	;;; test for user stack overflow
	;;; cmpl _userlim, a6
	Drop_abs_addr_instr(ident _userlim, 0, _16:BDC0, false);
	Drop_w(_16:6400);				;;; bccs round the jsr _checkall

	unless _asm_pass then
		;;; put the branch offset into the bnes instruction
		##(b){_asm_drop_ptr, _save} -> _save!(b)[_-1]
	endunless;

	_asm_drop_ptr -> _save;			;;; addr of byte after bccs offset

	Drop_jsr_abs(_checkall);		;;; jsr _checkall

	unless _asm_pass then
		;;; put the branch offset into the bccs instruction
		##(b){_asm_drop_ptr, _save} -> _save!(b)[_-1]
	endunless
enddefine;

define I_LISP_TRUE();
	lvars _save;
	;;; d4 always contains false
	Drop_w(_16:B896);				;;; cmpl a6@, d4
	Drop_w(_16:6600);				;;; bnes +?
	_asm_drop_ptr -> _save;			;;; addr of byte after offset
	Drop_abs_addr_instr([], false, _16:2C80, false);	;;; movl #nil, a6@
	unless _asm_pass then
		##(b){_asm_drop_ptr, _save} -> _save!(b)[_-1]
	endunless;
enddefine;

define I_STACKLENGTH();
	Drop_abs_addr_instr(ident _userhi, 0, _16:2000, false);	;;; movl _userhi, d0
	Drop_w(_16:908E);				;;; subl  a6, d0
	Drop_l(_16:56802D00);			;;; addql #3, d0;  movl d0, a6@-
enddefine;


	;;; I_SETSTKLEN    <saved stklen>          <nresults>
	;;; 			   false or MOVE instr     false or MOVENUM instr
	;;; 	see ALISP.S for _setstklen and _setstklen_diff

define I_SETSTACKLENGTH();
	lvars sl offs _save;
	asm_instr!INST_ARGS[_0] -> sl;
	asm_instr!INST_ARGS[_1] -> offs;
	if offs then
		Drop_fsource(_Dn, _1, _MOVL, _0);           ;;; movl <sl>, d1
		Drop_+-_to(_16:01,                          ;;; addl <offs>, d1
				_int((offs fi_* 4) fi_- 3), true);
		Drop_abs_addr_instr(ident _userhi, 0,		;;; movl v_userhi, d0
						_16:2000, false);
		Drop_w(_16:9081);							;;; subl d1,d0
		Drop_w(_16:B08E);                           ;;; cmpl a6,d0
		Drop_w(_16:6700);                           ;;; beqs +?
		_asm_drop_ptr -> _save;
		Drop_jsr_abs(_setstklen_diff);              ;;; jsr c_setstklen_diff
		unless _asm_pass then
			;;; put the branch offset into the beqs instruction
			##(b){_asm_drop_ptr, _save} -> _save!(b)[_-1]
		endunless
	else
		Drop_jsr_abs(_setstklen)                    ;;; jsr c_setstklen
	endif
enddefine;


	;;; generate code to unwind stack frame, without returning
	;;; musn't use CHAIN_REG (=d0)
define I_UNWIND_SF();
	lvars _offs, _n;

	;;; remove owner address and on-stack vars
	@@(w)[_Nstkvars _add _1] -> _offs;	;;; +1 for owner
	if _offs _gr _8 then
		Drop_w(_16:4FEF);				;;; lea sp@(offs), sp
		Drop_w(_offs);
	else
		Drop_+-_to(_16:0F, _offs, true)	;;; addql #offs, sp
	endif;

	;;; restore dynamic locals
	unless _zero(_Nlocals ->> _n) then
		@@(w)[_n] _sub _strsize _sub _asm_code_offset -> _offs;
		if _big_procedure then
			Drop_w(_16:207C);			;;; movl #offs, a0
			Drop_l(_offs _sub _8);
			Drop_w(_16:41FB);			;;; lea pc@(0, a0:L), a0
			Drop_w(_16:8800)			;;; index a0, disp 0
		elseif _n == _1 then
			Drop_w(_16:207A);			;;; movl pc@(d), a0
			Drop_w(_offs _sub _6);		;;; offset
			;;; movl sp@+, a0@(ID_VALOF)
			Drop_Areg_offs_acc(_0, @@ID_VALOF, _16:201F, true);
			_0 -> _n
		else
			Drop_w(_16:41FA);			;;; lea pc@(offset), a0
			Drop_w(_offs _sub _2)		;;; offset
		endif;
		until _zero(_n) do
			Drop_w(_16:2260);			;;; movl a0@-, a1
			;;; movl sp@+, a1@(ID_VALOF)
			Drop_Areg_offs_acc(_1, @@ID_VALOF, _16:201F, true);
			_n _sub _1 -> _n
		enduntil
	endunless;

	;;; restore registers
	unless _zero(_rest_regmask) then
		Drop_w(_16:4CDF);				;;; moveml sp@+, _rest_regmask
		Drop_w(_rest_regmask)			;;; mask set up in Consprocedure
	endunless
enddefine;

	;;; return from procedure
define I_RETURN();
	Drop_w(_16:4E75)					;;; rts
enddefine;

	;;; generate code to construct stack frame
define I_CREATE_SF();
	lvars _num, _offs;

#_IF DEF STACK_PROBES
	;;; plant tstb instruction to make sure stack extended
	;;; - unless procedure has no locals or stack vars
	unless _zero(_Nstkvars _add _Nlocals _add _Nreg ->> _num) then
		Drop_w(_16:4A2F);			;;; tstb sp@(-(n+64) words)
		Drop_w(_negate( @@(w)[_num _add _64] ));
	endunless;
#_ENDIF

	;;; save registers
	unless _zero(_rest_regmask) then
		Drop_w(_16:48E7);			;;; moveml _save_regmask sp@-
		Drop_w(_save_regmask);		;;; mask is set up in Consprocedure
	endunless;

	;;; save dynamic locals
	if _Nlocals == _1 then
		Drop_w(_16:207A);				;;; movl pc@(d), a0
		Drop_w(_negate(_strsize _add _asm_code_offset));
		;;; movl a0@(ID_VALOF), sp@-
		Drop_Areg_offs_acc(_0, @@ID_VALOF, _16:2F00, false)
	elseunless _zero(_Nlocals) then
		Drop_w(_16:41FA);				;;; lea pc@(d), a0
		Drop_w(_negate(_strsize _add _asm_code_offset));
		fast_repeat _pint(_Nlocals) times
			Drop_w(_16:2258);			;;; movl a0@+, a1
			;;; movl a1@(ID_VALOF), sp@-
			Drop_Areg_offs_acc(_1, @@ID_VALOF, _16:2F00, false)
		endrepeat;
	endif;

	;;; create on-stack vars
	_Npopstkvars -> _num;
	unless _zero(_num) then
		;;; pop ones - must be initialised to pacify the garbage collector
		Drop_w(_16:7003);				;;; moveq #3, d0 (popint 0)
		until _zero(_num) do
			Drop_w(_16:2F00);			;;; movl d0, sp@-
			_num _sub _1 -> _num;
		enduntil;
	endunless;
	_Nstkvars _sub _Npopstkvars -> _num;
	if _num _sgr _0 then
		;;; nonpop ones - just decrement sp
		@@(w)[_num] -> _offs;
		if _offs _gr _8 then
			Drop_w(_16:4FEF);			;;; lea sp@(-offs), sp
			Drop_w(_negate(_offs));
		else
			Drop_+-_to(_16:0F, _offs, false)	;;; subql #offs, sp
		endif;
	endif;

	;;; owner address
	Drop_w(_16:487A);					;;; pea pc@(d)
	Drop_w(_negate(@@PD_TABLE) _sub _strsize _sub _asm_code_offset)
enddefine;

define I_LABEL();
	;;; set front of label pair to popint offset from code start PD_EXECUTE
	_pint(_asm_code_offset) -> fast_front(asm_clist)
enddefine;


	;;; assembler to produce machine code in procedure record from
	;;; pop assembler input

define Do_consprocedure(codelist, reg_locals) -> pdr;
	lvars pdr, reg, reg_locals, codelist, _code_offset, _size, _reg_spec
		;

	dlocal _rest_regmask, _save_regmask, _asm_drop_ptr, _asm_pass, _strsize
		;

	;;; construct reg masks from reg_locals
	_0 ->> _rest_regmask -> _save_regmask;
	for reg in reg_locals do
		Is_register(reg) -> reg;
		_rest_regmask _biset _shift(_1, _int(reg)) -> _rest_regmask;
		_save_regmask _biset _shift(_1, _int(15 - reg)) -> _save_regmask;
	endfor;

	;;; first pass - calculate instruction offsets
	_0 -> _strsize;
	false -> _big_procedure;
	Code_pass(0, codelist) -> _code_offset;
	@@(w)[_int(listlength(asm_struct_list))] -> _strsize;
	_strsize _add _code_offset -> _size;
	if _size _greq _16:8000 then
		;;; big procedure - needs an extra pass to
		;;; cope with longword displacements etc
		true -> _big_procedure;
		Code_pass(1, codelist) -> _code_offset;
	endif;
	unless pop_debugging then
		Code_pass(2, codelist) -> _code_offset
	endunless;

	;;; can now calculate total size of procedure and allocate store for it
	@@PD_TABLE{_strsize _add _code_offset | b.r} _sub @@POPBASE -> _size;

	;;; register spec is switch offset to 6-byte code section (see aprocess.s)
	( (_Nreg _sub _Npopreg) _mult #_< _int(length(asm_pop_registers)) >_#
					 _add _Npopreg) _mult _6 -> _reg_spec;

	;;; get the procedure record with header filled in and struct table
	;;; generated (sets up _asm_drop_ptr)
	Get_procedure(_size, _reg_spec) -> pdr;

	;;; final pass - generate code
	Code_pass(false, codelist) -> 		;;; generate code
enddefine;

endsection;		/* $-Sys$-Vm */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov 27 1990
		Optimised I_PUSH_FIELD_ADDR to save code with 0 offset.
--- John Gibson, Aug 18 1990
		-size- argument to field instructions now in units of type size;
		changed -Do_field- to detect size/==1 case for subscripting
		external array of structures/arrays etc.
--- John Gibson, Mar 21 1990
		Changed field access procedures so that when -exptr- argument
		is true, it's an integer specifying deref first that many times.
--- John Gibson, Dec 10 1989
		Changes for new pop pointers: (1) use ID_VALOF offset
		for deferred accesses in -Get_structure_efa-, and for
		saving/restoring dynamic locals in I_CREATE/UNWIND_SF;
		(2) I_(U)FASTSUBV changed to take offset to vector elements
		start in structure (rather than offset from V_WORDS).
--- John Gibson, Nov 29 1989
		Removed optional code for F*ALSE_AT_0 (no longer possible
		when pop pointers address 3rd word).
--- John Gibson, Jun 30 1989
		Added I_CALLPS and I_UCALLPS (for -fast_apply-)
--- John Gibson, Jun  4 1989
		Replaced pop_optimise with not(pop_debugging)
--- John Gibson, Apr 30 1989
		Put into ection $-Sys$-Vm.
--- Roger Evans, Oct 10 1988
		Modified Do_field and Do_bitfield to accept -offset- <false> to
		mean vector subscript on stack, and have a new arg -ext- meaning
		plant code for external field access (ie indirect on E_PTR field
		and do 3rd longword correction on offset). I_PUSH_FIELD,
		I_PUSH_FIELD_ADDR and I_POP_FIELD take this -ext- arg an pass it on
--- John Gibson, Aug  4 1988
		Allowed field instructions to take structure in an address reg
		as well as a data reg
--- John Gibson, Aug  2 1988
		Changed Do_bitfield to accomodate new _bfield subroutines.
--- John Gibson, Jul 29 1988
		Improved calling of constant procedures in I_CALLPQ
--- John Gibson, Jul 27 1988
		Added I_MOVE_CALLER_RETURN
--- John Gibson, Jun  7 1988
		Introduced -I_LABEL- (called by -Code_pass- directly)
--- John Gibson, May 22 1988
		Fields in I_PUSH/POP_FIELD specifying operands now contain lexical
		identifier tokens (which get allocated to registers) rather than
		register identifiers directly (thus these procedure now call
		-Trans_structure- on them).
--- John Gibson, Mar 27 1988
		-list_assoc_val- into section Sys
--- John Gibson, Feb 10 1988
		Pint_->_uint now in section Sys
--- John Gibson, Jan 15 1988
		Undid last change
 */
