/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:			S.hpbob/src/syscomp/asmout.p
 > Purpose:
 > Author:			John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				  OUTPUT CODE PROCEDURES MC68000 SYSTEMS
							(HP9000/200)

--------------------------------------------------------------------------*/

#_INCLUDE 'common.ph'

section $-Popas;

vars	nextlabel;

define global popint(n); lvars n; (n<<2) || 3 enddefine;

define global mcint(n); lvars n; n >> 2 enddefine;

define nextlab();
	dlocal pop_pr_radix = 36;
	'L' >< nextlabel;
	nextlabel fi_+ 1 -> nextlabel
enddefine;

define lconstant asm_label(word, prefix_char);
	lvars n, len, string, q, r, prefix_char, word;
	if isstring(word) then word else fast_word_string(word) endif -> string;
	datalength(string) -> len;
	cons_with consstring {%
		prefix_char, `_`, `_`;
		fast_for n to len do
			go_on dup(fast_subscrs(n, string)) to
			;;; 1 2 3 4 5 6 7 8 9 0 1 2 3 4 5 6
				c c c c c c c c c c c c c c c c		;;; Ctrl-A -- Ctrl-P
				c c c c c c c c c c c c c c c c		;;; Ctrl-Q -- SPACE
				s s s $ s s s s s s s s s s s d		;;;   !    --   0
				d d d d d d d d d s s s s s s s		;;;   1    --   @
				A A A A A A A A A A A A A A A A		;;;   A    --   P
				A A A A A A A A A A s s s s u s		;;;   Q    --   `
				a a a a a a a a a a a a a a a a		;;;   a    --   p
				a a a a a a a a a a s s s s c c		;;;   q    -- \(128)
			else c;

			A: a: d: u :		;;; alpha, digit, underscore
				nextloop;

			$ :
				if n /== len and fast_subscrs(n fi_+ 1, string) == `-`
				and (n /== 1 or len fi_> 2) then
					;;; replace section separator $- with __
					-> ;			;;; erase $
					unless n == 1 then `_`, `_` endunless;
					n fi_+ 1 -> n;	;;; skip -
					nextloop
				;;; else drop thru to "s"
				endif;

			s: c:				;;; other sign, control etc
				;;; represent as 3 decimal digits
				() fi_// 100 -> q -> r;
				q fi_+ `0`;
				r fi_// 10 -> q -> r;
				q fi_+ `0`, r fi_+ `0`;

		endfast_for
	%}
enddefine;

constant procedure (
	asm_symlabel	= asm_label(%`c`%),
	asm_identlabel	= asm_label(%`i`%),
	asm_wordlabel	= asm_label(%`w`%),
	asm_wordidlabel	= asm_label(%`z`%),
	asm_pdpropslabel= asm_label(%`p`%),
	asm_testdeflabel= asm_label(%`t`%),
	);


	;;; list of pop symbol prefixes for use by -Extern_make_base-
	;;; see unixextern.p
global constant macro (
	$- POP_SYMBOL_PREFIXES =
		[['c__' 'xc__' 'uc__' 'xuc__' 'i__' 'w__' 'z__'
										'p__' 't__' '_end\^@']],

	$- ASM_TEXT_STR	= '\ttext',
	$- ASM_DATA_STR	= '\tdata',
	$- ASM_BYTE_STR	= '\tbyte\t',
	$- ASM_SHORT_STR= '\tshort\t',
	$- ASM_INT_STR	= '\tlong\t',
	$- ASM_WORD_STR	= ASM_INT_STR,
	);


vars file_total_bytecount;
;;;
define asm_startfile(a_name);
	lvars a_name;
	0 -> file_total_bytecount
enddefine;

constant procedure (
	asm_endfile		= identfn,

	asm_startcode	= outcode(%'\n'<>ASM_TEXT_STR%),
	asm_startdata	= outcode(%'\n'<>ASM_DATA_STR%),
	);

	/*	We use 'set <label>,.' to plant labels rather than '<label> :'
		because the stupid assembler doesn't treat the two as equivalent;
		it ties the latter form to the statement following it, e.g. the
		sequence

			foo:
				data

		is illegal.
	*/
define asm_outlab(lab);
	lvars lab;
	asmf_printf(lab, 'set\s%p,.\n')
enddefine;

define asm_outglab(lab);
	lvars lab;
	asmf_printf(lab, lab, 'global\s%p\nset\s%p,.\n')
enddefine;

define asm_outlabset(lab, val);
	lvars lab val;
	asmf_printf(val, lab, 'set\s%p,\s%p\n')
enddefine;

define asm_outglabset(lab, val);
	lvars lab val;
	asmf_printf(val, lab, lab, 'global\s%p\nset\s%p,\s%p\n')
enddefine;

define lconstant outdatum(n, string);
	lvars m, n, string;
	if n == 0 then return endif;
	asmf_charout(string);
	fast_for m from n by -1 to 2 do
		asmf_pr(subscr_stack(m)), asmf_charout(`,`)
	endfast_for;
	asmf_pr();
	erasenum(n-1);
	asmf_charout(`\n`)
enddefine;

global constant procedure (
	asm_outbyte		= outdatum(% ASM_BYTE_STR %),
	asm_outshort	= outdatum(% ASM_SHORT_STR%),
	asm_outint		= outdatum(% ASM_INT_STR %),
	asm_outword		= outdatum(% ASM_WORD_STR %),

	;;; asm_align_double() -- output alignment for double (e.g. double float)
	asm_align_double = identfn,
	;;; asm_out_dfloat(hi_part, lo_part) -- output double float
	asm_out_dfloat	= asm_outword(%2%),

	;;; asm_align_file() -- output end-of-file alignment
	;;; (don't define if no alignment necessary)
;;;	asm_align_file	= identfn,
	);

	/*	-asm_addbits- is used to accumulate a sequence of bitfields into
		a (big)integer which -asm_outbits- is then called to output when the
		total number of bits accumulated occupies an exact number of bytes.
			-val- is the currently accumulated (big)integer, containing
		-nbits- bits so far; -new_val- is the field to be added, containing
		-new_nbits- bits.
			The value returned will be the -val- input for the next field
		(with -nbits- incremented by -new_nbits-), and so on. Other than
		initialising -val- to 0 at the start, nothing is assumed about how
		the fields are added to it, so it is the responsibility of this
		procedure and -asm_outbits- to output the bitfields correctly.
	*/
	;;; 68K ('big endian') version adds the fields at the bottom and
	;;; outputs the bytes from the top down
define asm_addbits(new_val, new_nbits, val, nbits);
	lvars new_val, new_nbits, val, nbits;
	(val << new_nbits) || new_val	;;; add the new field at the bottom
enddefine;

	/*	In this, -nbits- is a multiple of BYTE_BITS, and -val- has been
		produced by repeated calls of -asm_addbits-
	*/
define asm_outbits(val, nbits);
	lvars val, nbits, count = 0;
	lconstant BYTE_MASK = (1<<BYTE_BITS)-1;
	until nbits == 0 do
		nbits-BYTE_BITS -> nbits;
		(val >> nbits) && BYTE_MASK;	;;; output bytes from the top down
		;;; this just saves putting each byte on a separate line
		if (count+1 ->> count) == 12 then asm_outbyte(count), 0 -> count endif;
	enduntil;
	if count /== 0 then asm_outbyte(count) endif
enddefine;


	;;; for closures generated by poplink for undef procedures
define asm_gen_poplink_code(outlabs, nfroz, jmplab);
	lvars offs, outlabs, nfroz, jmplab;
	;;; plant exec labels
	outlabs();
	;;; code to push nfroz frozvals (last nfroz longwords planted)
	nfroz*4+2 -> offs;
	fast_repeat nfroz times
		;;; offs stays the same each time (+4 for next froz, -4 for instr)
		asmf_printf(offs, '\tmov.l\t-%p(%%pc),-(%%a6)\n');	;;; 4 bytes each
	endfast_repeat;
	;;; jmp to -jmplab-
	asmf_printf(jmplab, '\tjmp\t%p\n');
	;;; align to longword boundary
	asmf_printf('\tshort\t0\n');
	;;; return number of longwords of code planted
	nfroz+2
enddefine;

/*
 *	Exfunc closure code -- jump to subroutine _exfunc_clos_action (aextern.s)
 *	with exfunc_closure record address in a reg, etc. This procedure is
 *	passed the label of _exfunc_clos_action. The code generated must be
 *	padded to exactly 4 words.
 */

define asm_gen_exfunc_clos_code(action_lab);
	lvars action_lab;
	;;; passes (exfunc_clos address)+6 on stack
	asmf_printf(action_lab, '\tjsr\t%p\n');		;;; 6 bytes
	repeat 5 times asmf_printf('\tshort\t0\n') endrepeat;	;;; pad
enddefine;


/*
 *	extern_name_translate:
 *		translate an external symbol, using the same conventions as the
 *		C compiler and linker (e.g. add a leading '_', truncate to N
 *		characters, etc.)
 */

define global extern_name_translate(lang, symbol, type) -> symbol;
	lvars lang, symbol, type;
	returnif(lang = 'ASM');
	'_' <> symbol -> symbol;
	if lang = 'FORTRAN' then uppertolower(symbol) <> '_' -> symbol endif
enddefine;


	/*	String for first line of Unix "ld" command -- used in os_comms.p
		(Image name is in the environment variable "IM")
	*/
constant unix_ld_command_header =
#_IF DEF SHARED_LIBRARIES
			'/bin/ld -x -o $IM -e start -X 9999 +s \\\n';
#_ELSEIF DEFV HPUX >= 8.0
			'/bin/ld -x -o $IM -e start -X 9999 -a archive \\\n';
#_ELSE
			'/bin/ld -x -o $IM -e start -X 9999 \\\n';
#_ENDIF


endsection;		/* $-Popas */


/* --- Revision History ---------------------------------------------------
--- John Gibson, Aug 15 1996
		New version of extern_name_translate.
--- John Gibson, Apr  3 1995
		Added asm_outint
--- Robert John Duncan, Mar 22 1994
		Changed asm_gen_poplink_code to plant the execute labels
--- John Gibson, Sep  1 1993
		New definition of asm_startfile
--- Robert John Duncan, Jun 30 1993
		Added '+s' option to ld command line when using shared libraries so
		that the pop external library can be located at run-time through
		SHLIB_PATH and removed the '-E', since all symbols which might be
		accessed from external loads should now be in the pop library.
--- John Gibson, May 19 1993
		Added asm_gen_exfunc_clos_code
--- Simon Nichols, Jan 29 1993
		Added support for shared libraries.
--- Robert John Duncan, Jul 27 1992
		Added -extern_name_translate-
--- Simon Nichols, Nov 11 1991
		Changes for HP-UX 8.0:
		-- added '-a archive' to -unix_ld_command_header- to get
		   non-shared libraries.
--- John Gibson, Jul 17 1989
		OS command procedures commoned in C.unix/src/syscomp/os_comms.p
		(but this file still defines the "ld" command string since this
		is different for nearly every system).
--- John Gibson, Jun  7 1989
		Included common.ph
--- John Gibson, Mar 23 1989
		Added -asm_addbits- and -asm_outbits-
--- John Gibson, Feb  2 1989
		Changed -asm_gen_poplink_code- to allow any number of frozvals to
		be pushed.
--- John Gibson, Nov 16 1988
		Added procedure -unix_archive- (used by poplibr)
--- John Gibson, Jun 24 1988
		Added assembling and linking procedures.
--- John Gibson, Apr 22 1988
		Changed for new assembler
--- John Gibson, Jan 17 1988
		Revised label formats to cope with sections, etc, and
		added new label procedures -asm_wordidlabel-, -asm_pdpropslabel-
		-asm_testdeflabel-.
			Also new procedures -asm_align_double-, -asm_out_dfloat-,
		-asm_gen_poplink_code-.
--- John Gibson, Aug 16 1987
		Replaced in-procedure -vars- with -dlocal-
		Added missing lvars declaration for -pre- in -asm_label-
 */
