/* --- Copyright University of Sussex 1996. All rights reserved. ----------
 > File:            S.hpbob/src/syscomp/sysdefs.p
 > Purpose:
 > Author:          John Gibson (see revisions)
 */

/* -------------------------------------------------------------------------

				DEFINITIONS FOR MACHINE/OPERATING SYSTEM

--------------------------------------------------------------------------*/

section;

global constant macro (

	POPC_SYSDEFS_LOADED = true,

;;; --- SYSTEM NAME ------------------------------------------------

	MACHINE			= [[hp9000 300]],
	HP9000			= true,
	HP9000_300		= true,
	BOBCAT			= true,


;;; --- MACHINE = MC 68000 -------------------------------------------

	PROCESSOR		= [[68020]],	;;; type of cpu
	M68K_VERSION	= 68020,		;;; 68000 version

	;;; Values for machine and C data types are defined in mcdata.p,
	;;; and can be overidden here if necessary

	INT_ALIGN_BITS	= 16,			;;; alignment in bits for int access
	DOUBLE_ALIGN_BITS= 16,			;;; alignment in bits for double access

	CODE_POINTER_TYPE = "int",		;;; type of pointer to machine code
	BIT_POINTER_TYPE  = "byte",		;;; type of pointer for bitfield access
	BIG_ENDIAN		= true,


;;; --- OPERATING SYSTEM = HP-UX --------------------------------------

	HPUX			= 9.0,
	POSIX1			= 199009,
	POSIX2			= 199209,
	OPERATING_SYSTEM = [[unix hpux ^HPUX posix {^POSIX1 ^POSIX2}]],
	UNIX			= true,
	BERKELEY		= 4.2,			;;; in quite a lot of respects ...
	SHARED_LIBRARIES = true,		;;; dynamically linked against shared libraries

	VPAGE_OFFS		= 4096,			;;; word address offset of a virtual page
	LOWEST_ADDRESS	= 0,			;;; lowest pop structure address
	UNIX_USRSTACK	= 16:FFF00000,	;;; end of stack (as USRSTACK in <sys/vmparam.h> etc)
	UNIX_USRSTACK_SIZE = 16:200000,	;;; max size (required if no BSD -getrlimit-)

	;;; Procedures to get and set the memory break and return the REAL end of
	;;; memory. (We always need the real end to ensure that the end of the
	;;; user stack is always at the true end of memory, so that user stack
	;;; underflow produces a memory access violation.)

	GET_REAL_BREAK =
		[procedure(); _extern sbrk(_0)@(b.r->vpage) endprocedure],

	SET_REAL_BREAK =
		[procedure(_break) -> _break;
			lvars _break = _break@(w.r->vpage);
			if _extern brk(_break@(w->b)) == _-1 then
				_-1 -> _break
			endif
		endprocedure],


;;; --- OTHER ------------------------------------------------------------

	;;; Says single float results from C functions are returned as
	;;; singles not doubles.
	C_FLOAT_RESULT_SINGLE = true,

	;;; list of procedures to be optimised as subroutine calls
	;;; format of entries is
	;;;		[<pdr name> <nargs> <nresults> <subroutine name>]

	SUBROUTINE_OPTIMISE_LIST =
		[[
			[prolog_newvar			0 1 _prolog_newvar]
			[datakey				1 1 _datakey]
			[prolog_deref			1 1 _prolog_deref]
			[conspair				2 1 _conspair]
		]],

	;;; Old-style I_PUSH/POP_FIELD(_ADDR) instructions in ass.p
	OLD_FIELD_INSTRUCTIONS = true,

);


;;; --- CACHEFLUSH -------------------------------------------------------

#_IF DEFV HPUX >= 8.0
global constant macro (

	CACHEFLUSH = [
		procedure(_ptr, _nbytes);
			lvars _ptr, _nbytes;
			;;; CC_IPURGE = 4
			_extern cachectl(_4, _0, _0) -> ;
		endprocedure
	],

);
#_ENDIF


endsection;		/* $- */



/* --- Revision History ---------------------------------------------------
--- John Gibson, Nov  4 1996
		Added OLD_FIELD_INSTRUCTIONS. Removed is* procedures from
		SUBROUTINE_OPTIMISE_LIST (no longer required).
--- Robert John Duncan, May 22 1995
		Updated POSIX definitions (from HP-UX 9.0 release notes)
--- John Gibson, Mar 30 1995
		Added BIG_ENDIAN
--- John Gibson, Mar 21 1995
		Standard machine data type definitions are now in mcdata.p
--- John Gibson, Feb 28 1995
		Added POSIX1 and "posix" entry in OPERATING_SYSTEM, removed H*ERTZ
--- Simon Nichols, Jun 29 1993
		Increased UNIX_USRSTACK_SIZE from 16:80000 to 16:200000 for HP-UX
		9.0 (in line with value of maxssiz as displayed by sam(1M)).
--- Robert John Duncan, Jun 29 1993
		HP-UX version 9.0 with dynamic linking (shared libraries)
--- Robert Duncan, Apr 19 1993
		Distinguished from HP 9000/700
--- Simon Nichols, Oct 26 1992
		HPUX version 8.0
--- John Gibson, Oct 22 1992
		Changed P*OPC to POPC_SYSDEFS_LOADED
--- Robert John Duncan, Jun  1 1992
		Removed TERM*INFO flag
--- Simon Nichols, Dec  3 1991
		Added CACHEFLUSH for HP-UX 8.0. This has to be a separate
		declaration because of the #_IF ... #_ENDIF.
--- John Gibson, Apr  3 1991
		Renamed E*XTERN_SFLOAT_RESULT_SINGLE as C_FLOAT_RESULT_SINGLE.
--- John Gibson, Dec 11 1990
		HPUX version 7.0
--- Rob Duncan, Dec  6 1989
		Added TERM*INFO
--- John Gibson, Nov 29 1989
		Removed F*ALSE_AT_0 (no longer possible when pop pointers
		address 3rd word).
--- John Gibson, Oct 18 1989
		Changed HPUX version to 6.5
--- John Gibson, Aug 31 1989
		Added EXTERN_SFLOAT_RESULT_SINGLE (Only for Bobcat)
--- John Gibson, Aug 31 1989
		Added UNIX_USRSTACK and UNIX_USRSTACK_SIZE
--- John Gibson, Aug 24 1989
		Removed S*IGNALS
--- John Gibson, Aug 22 1989
		Added definition for BERKELEY = 4.2 and removed defs for
		SYSTEM_V, BSD_SOCKETS and BSD_SYMLINKS (which are no longer required
		because Bobcat is now like 4.2 in most respects).
--- Rob Duncan, Apr  3 1989
		Added MACHINE & HPUX definitions; changed OPERATING_SYSTEM to
		include "hpux" and changed SYSTEM_V to have value 5.0
--- Roger Evans, Sep 26 1988
		Added POPC definition
--- John Gibson, Aug  5 1988
		Added DOUBLE definitions
--- John Gibson, Jun  5 1988
		Added BSD_SYMLINKS = true (definition of -syssymlink- is dependent on
		either BERKELEY or BSD_SYMLINKS).
--- John Gibson, Jun  3 1988
		Changed BIGINT_SPEC to "int"
--- Roger Evans, Apr 20 1988
		added S*IGNALS = true to activate new signals code
--- John Gibson, Mar 31 1988
		Added BSD_SOCKETS = true (definition of -syssocket- is dependent on
		either BERKELEY or BSD_SOCKETS).
--- John Gibson, Jan 15 1988
		Undid last change!
 */
